/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql;

import adalid.commons.util.StrUtils;
import adalid.util.sql.SqlArtifact;
import adalid.util.sql.SqlCheckConstraint;
import adalid.util.sql.SqlColumn;
import adalid.util.sql.SqlTable;
import adalid.util.sql.SqlUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MetaCheckConstraint
extends SqlArtifact {
    private static final Logger logger = Logger.getLogger(SqlUtil.class);
    private final SqlCheckConstraint _check;
    private SqlColumn sqlColumn1;
    private SqlColumn sqlColumn2;
    private final List<String> _expressions = new ArrayList<String>();
    private final List<String> _messages = new ArrayList<String>();
    private String _type;
    private static final String b7 = "/";
    private static final String simpleRegex1 = "CHECK \\(\\(\\((\\w+) (.*) (.*)\\) (AND|OR) \\((\\w+) (.*) (.*)\\)\\)\\)";
    private static final String simpleRegex2 = "CHECK \\(\\((\\w+) (.*) (.*)\\)\\)";
    private static final String simpleComparisonRegex = "(.+?)\\s+(=|<>|>|>=|<|<=|IS NOT|IS)\\s+(.+)";
    private static final String logicalOperatorRegex = "\\s+AND\\s+|\\s+OR\\s+";
    private static final String splitExpressionRegex = "\\s+(AND|OR)\\s+";
    private static final String integerRegex = "^[-]?\\d+$";
    private static final String decimalRegex = "^[-]?\\d+(\\.\\d+)?$";
    private static final String uncastRegex = "(\\(+|')?([^)':]+)(\\)+|')?::\\w+";
    private static final Pattern simplePattern1 = Pattern.compile("CHECK \\(\\(\\((\\w+) (.*) (.*)\\) (AND|OR) \\((\\w+) (.*) (.*)\\)\\)\\)");
    private static final Pattern simplePattern2 = Pattern.compile("CHECK \\(\\((\\w+) (.*) (.*)\\)\\)");
    private static final Pattern simpleComparisonPattern = Pattern.compile("(.+?)\\s+(=|<>|>|>=|<|<=|IS NOT|IS)\\s+(.+)");
    private static final Pattern logicalOperatorPattern = Pattern.compile("\\s+AND\\s+|\\s+OR\\s+");
    private static final Pattern splitExpressionPattern = Pattern.compile("\\s+(AND|OR)\\s+");
    private static final Pattern integerPattern = Pattern.compile("^[-]?\\d+$");
    private static final Pattern decimalPattern = Pattern.compile("^[-]?\\d+(\\.\\d+)?$");
    private static final Pattern uncastPattern = Pattern.compile("(\\(+|')?([^)':]+)(\\)+|')?::\\w+");

    public MetaCheckConstraint(SqlCheckConstraint check) {
        this._check = check;
        this.parse();
    }

    public SqlCheckConstraint getCheck() {
        return this._check;
    }

    public SqlColumn getSqlColumn1() {
        return this.sqlColumn1;
    }

    public SqlColumn getSqlColumn2() {
        return this.sqlColumn2;
    }

    public List<String> getExpressions() {
        return this._expressions;
    }

    public List<String> getMessages() {
        return this._messages;
    }

    private void addMetaExpressions(String column1, String comparisonOperator1, String value1, String logicalOperator, String column2, String comparisonOperator2, String value2) {
        this.sqlColumn1 = this._check.getTable().getColumn(column1);
        this.sqlColumn2 = this._check.getTable().getColumn(column2);
        this.setType(this.sqlColumn1, comparisonOperator1, logicalOperator, this.sqlColumn2, comparisonOperator2);
        if (!this._type.startsWith("COMPLEX")) {
            if (this._type.equals(this.b7("MAX", "MIN"))) {
                this._expressions.add(this.camelCase(column1) + ".setMaxValue(" + this.valueOf(this.sqlColumn1, value1) + ");");
                this._expressions.add(this.camelCase(column2) + ".setMinValue(" + this.valueOf(this.sqlColumn2, value2) + ");");
            } else if (this._type.equals(this.b7("MIN", "MAX"))) {
                this._expressions.add(this.camelCase(column1) + ".setMinValue(" + this.valueOf(this.sqlColumn1, value1) + ");");
                this._expressions.add(this.camelCase(column2) + ".setMaxValue(" + this.valueOf(this.sqlColumn2, value2) + ");");
            } else if (this._type.equals("AND/OR")) {
                String expression1 = this.expressionOf(this.sqlColumn1, comparisonOperator1, value1);
                String expression2 = this.expressionOf(this.sqlColumn2, comparisonOperator2, value2);
                this._expressions.add(this.getName() + " = " + expression1 + "." + logicalOperator.toLowerCase() + "(" + expression2 + ");");
            }
        }
    }

    private void addMetaExpressions(String column, String comparisonOperator, String value) {
        this.sqlColumn2 = this.sqlColumn1 = this._check.getTable().getColumn(column);
        this.setType(this.sqlColumn1, comparisonOperator);
        if (!this._type.startsWith("COMPLEX")) {
            if (this._type.equals("MAX")) {
                this._expressions.add(this.camelCase(column) + ".setMaxValue(" + this.valueOf(this.sqlColumn1, value) + ");");
            } else if (this._type.equals("MIN")) {
                this._expressions.add(this.camelCase(column) + ".setMinValue(" + this.valueOf(this.sqlColumn1, value) + ");");
            } else if (this._type.equals("SIMPLE")) {
                this._expressions.add(this.getName() + " = " + this.expressionOf(this.sqlColumn1, comparisonOperator, value) + ";");
            }
        }
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    private void setType(SqlColumn sqlColumn1, String comparisonOperator1, String logicalOperator, SqlColumn sqlColumn2, String comparisonOperator2) {
        if (sqlColumn1 != null && comparisonOperator1 != null && logicalOperator != null && sqlColumn2 != null && comparisonOperator2 != null && (logicalOperator.equalsIgnoreCase("AND") || logicalOperator.equalsIgnoreCase("OR"))) {
            this._type = "AND/OR";
            if (sqlColumn1 == sqlColumn2 && logicalOperator.equalsIgnoreCase("AND")) {
                this._type = switch (this.b7(comparisonOperator1, comparisonOperator2)) {
                    case "<=/>=" -> this.b7("MAX", "MIN");
                    case ">=/<=" -> this.b7("MIN", "MAX");
                    default -> "AND/OR";
                };
            }
        }
    }

    private void setType(SqlColumn sqlColumn, String comparisonOperator) {
        if (sqlColumn != null && comparisonOperator != null) {
            this._type = switch (comparisonOperator) {
                case "<=" -> "MAX";
                case ">=" -> "MIN";
                default -> "SIMPLE";
            };
        }
    }

    private boolean containsWord(String input, String word) {
        Pattern pattern = Pattern.compile("\\b" + Pattern.quote(word) + "\\b", 2);
        return pattern.matcher(input).find();
    }

    private int countMatches(String input, String word) {
        Pattern pattern = Pattern.compile("\\b" + Pattern.quote(word) + "\\b", 2);
        Matcher matcher = pattern.matcher(input);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public boolean isCheck() {
        return this._type.equals("AND/OR") || this._type.equals("SIMPLE");
    }

    public boolean isMaxMin() {
        return this._type.startsWith("MAX") || this._type.startsWith("MIN");
    }

    public boolean isComplex() {
        return this._type.equals("COMPLEX");
    }

    private boolean parse() {
        this.setName(this._check.getName());
        this.setType("COMPLEX");
        String input = this._check.getConstraintDefinition();
        logger.trace((Object)input);
        if (!this.containsWord(StringUtils.replace((String)input.toUpperCase(), (String)"IS NOT", (String)"ISN'T"), "NOT")) {
            Matcher matcher;
            int lops = this.countMatches(input, "AND") + this.countMatches(input, "OR");
            if (lops == 1) {
                matcher = simplePattern1.matcher(input);
                if (matcher.matches()) {
                    String column1 = matcher.group(1);
                    String comparisonOperator1 = matcher.group(2);
                    String value1 = this.uncast(matcher.group(3));
                    String logicalOperator = matcher.group(4);
                    String column2 = matcher.group(5);
                    String comparisonOperator2 = matcher.group(6);
                    String value2 = this.uncast(matcher.group(7));
                    this.addMetaExpressions(column1, comparisonOperator1, value1, logicalOperator, column2, comparisonOperator2, value2);
                    logger.trace((Object)("\tcol1: " + column1));
                    logger.trace((Object)("\tcop1: " + comparisonOperator1));
                    logger.trace((Object)("\tval1: " + value1));
                    logger.trace((Object)("\tlop1: " + logicalOperator));
                    logger.trace((Object)("\tcol2: " + column2));
                    logger.trace((Object)("\tcop2: " + comparisonOperator2));
                    logger.trace((Object)("\tval2: " + value2));
                    return true;
                }
            } else if (lops == 0 && (matcher = simplePattern2.matcher(input)).matches()) {
                String column = matcher.group(1);
                String comparisonOperator = matcher.group(2);
                String value = this.uncast(matcher.group(3));
                this.addMetaExpressions(column, comparisonOperator, value);
                logger.trace((Object)("\tcol1: " + column));
                logger.trace((Object)("\tcop1: " + comparisonOperator));
                logger.trace((Object)("\tval1: " + value));
                return true;
            }
        }
        String sqlExpression = StringUtils.removeStartIgnoreCase((String)input, (String)"CHECK");
        String translation = this.translate(sqlExpression);
        String metaExpression = this.getName() + " = " + translation + ";";
        this._expressions.add(metaExpression);
        return false;
    }

    private String uncast(String value) {
        Matcher matcher = uncastPattern.matcher(value);
        if (matcher.find()) {
            String group2 = matcher.group(2);
            return this.uncast(group2);
        }
        return value;
    }

    private String nameOf(SqlColumn sqlColumn, String value) {
        String metajavaName = this.camelCase(sqlColumn.getName());
        SqlTable foreignTable = sqlColumn.getForeignTable();
        if (foreignTable != null) {
            if (integerPattern.matcher(value).matches()) {
                return metajavaName + "." + this.camelCase(foreignTable.getPrimaryKey().getName());
            }
            SqlColumn column = sqlColumn.getTable().getColumn(value);
            if (column != null && column.getForeignTable() == null) {
                return metajavaName + "." + this.camelCase(foreignTable.getPrimaryKey().getName());
            }
        }
        return metajavaName;
    }

    private String valueOf(SqlColumn sqlColumn, String value) {
        if (value.startsWith("'") && value.endsWith("'")) {
            return "\"" + value.substring(1, value.length() - 1).replace("''", "'") + "\"";
        }
        if (integerPattern.matcher(value).matches()) {
            Long longValue;
            String metajavaType = sqlColumn.getMetajavaType();
            if (sqlColumn.isBooleanish() && metajavaType.equals("IntegerProperty")) {
                if (value.equals("1")) {
                    return "true";
                }
                if (value.equals("0")) {
                    return "false";
                }
            }
            return longValue + ((longValue = Long.valueOf(value)) >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE ? "" : "L");
        }
        if (decimalPattern.matcher(value).matches()) {
            BigDecimal big = new BigDecimal(value);
            return "new java.math.BigDecimal(\"" + String.valueOf(big) + "\")";
        }
        SqlColumn column = sqlColumn.getTable().getColumn(value);
        if (column != null) {
            return this.camelCase(column.getName());
        }
        return value;
    }

    private String expressionOf(SqlColumn sqlColumn, String comparisonOperator, String value) {
        String method;
        String metajavaName = this.nameOf(sqlColumn, value);
        String metajavaType = sqlColumn.getMetajavaType();
        if (comparisonOperator.equalsIgnoreCase("IS")) {
            return metajavaName + ".is" + this.capitalize(value) + "()";
        }
        if (comparisonOperator.equalsIgnoreCase("IS NOT")) {
            return metajavaName + ".isNot" + this.capitalize(value) + "()";
        }
        switch (comparisonOperator) {
            case ">": {
                String string = "isGreaterThan";
                break;
            }
            case ">=": {
                String string = "isGreaterOrEqualTo";
                break;
            }
            case "<": {
                String string = "isLessThan";
                break;
            }
            case "<=": {
                String string = "isLessOrEqualTo";
                break;
            }
            case "<>": 
            case "!=": {
                String string = "isNotEqualTo";
                break;
            }
            default: {
                String string = method = "isEqualTo";
            }
        }
        if (sqlColumn.isBooleanish() && metajavaType.equals("IntegerProperty")) {
            if (method.equals("isEqualTo")) {
                if (value.equals("1")) {
                    return metajavaName + ".isTrue()";
                }
                if (value.equals("0")) {
                    return metajavaName + ".isFalse()";
                }
            }
            if (method.equals("isNotEqualTo")) {
                if (value.equals("1")) {
                    return metajavaName + ".isNotTrue()";
                }
                if (value.equals("0")) {
                    return metajavaName + ".isNotFalse()";
                }
            }
        }
        return metajavaName + "." + method + "(" + this.valueOf(sqlColumn, value) + ")";
    }

    private String translate(String sqlExpression) {
        String expression = sqlExpression.trim();
        return logicalOperatorPattern.matcher(expression).find() ? this.translateLogicalExpression(expression) : this.translateSimpleComparison(expression);
    }

    private String translateLogicalExpression(String expression) {
        String[] components = this.splitExpression(expression);
        if (components.length == 0) {
            return expression;
        }
        String result = this.translateSimpleComparison(components[0]);
        for (int i = 1; i < components.length; i += 2) {
            String operator = components[i].trim();
            String nextSimpleExpression = this.translateSimpleComparison(components[i + 1].trim());
            result = this.applyLogicalOperator(result, operator, nextSimpleExpression);
        }
        return result;
    }

    private String[] splitExpression(String expression) {
        ArrayList<String> parts = new ArrayList<String>();
        int depth = 0;
        int lastIndex = 0;
        int length = expression.length();
        Matcher matcher = splitExpressionPattern.matcher(expression);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String between = expression.substring(lastIndex, start);
            if ((depth += this.countParentheses(between)) != 0) continue;
            if (start > lastIndex) {
                parts.add(expression.substring(lastIndex, start).trim());
            }
            parts.add(matcher.group(1).trim());
            lastIndex = end;
        }
        if (lastIndex < length) {
            parts.add(expression.substring(lastIndex).trim());
        }
        String[] components = (String[])parts.toArray(String[]::new);
        logger.trace((Object)(components.length + "\t" + ArrayUtils.toString((Object)components)));
        return components;
    }

    private int countParentheses(String substring) {
        int count = 0;
        for (char ch : substring.toCharArray()) {
            if (ch == '(') {
                ++count;
                continue;
            }
            if (ch != ')') continue;
            --count;
        }
        return count;
    }

    private String applyLogicalOperator(String result, String operator, String nextSimpleExpression) {
        return switch (operator.toUpperCase()) {
            case "AND" -> result + ".and(" + nextSimpleExpression + ")";
            case "OR" -> result + ".or(" + nextSimpleExpression + ")";
            default -> result;
        };
    }

    private String translateSimpleComparison(String expression) {
        String substring;
        boolean delimited;
        int last = expression.length() - 1;
        boolean bl = delimited = last > 1 && expression.charAt(0) == '(' && expression.charAt(last) == ')';
        if (delimited && this.areParenthesesBalanced(substring = expression.substring(1, expression.length() - 1))) {
            expression = substring;
        }
        if (logicalOperatorPattern.matcher(expression).find()) {
            return this.translate(expression);
        }
        Matcher matcher = simpleComparisonPattern.matcher(expression);
        if (matcher.matches()) {
            String operando2;
            String operando1;
            String operand1 = this.uncast(matcher.group(1).trim());
            String operator = matcher.group(2).trim();
            String operand2 = this.uncast(matcher.group(3).trim());
            SqlColumn column1 = this._check.getTable().getColumn(operand1);
            SqlColumn column2 = this._check.getTable().getColumn(operand2);
            if (column1 != null && column2 != null) {
                operando1 = this.nameOf(column1, operand2);
                operando2 = this.nameOf(column2, operand1);
            } else if (column1 != null && column2 == null) {
                operando1 = this.nameOf(column1, operand2);
                operando2 = this.valueOf(column1, operand2);
            } else if (column1 == null && column2 != null) {
                operando1 = this.valueOf(column2, operand1);
                operando2 = this.nameOf(column2, operand1);
            } else {
                operando1 = operand1;
                operando2 = operand2;
            }
            return this.translateComparison(operando1, operator, operando2);
        }
        return this.translate(expression);
    }

    private String translateComparison(String operand1, String operator, String operand2) {
        return switch (operator.toUpperCase()) {
            case "=" -> operand1 + ".isEqualTo(" + operand2 + ")";
            case "<>" -> operand1 + ".isNotEqualTo(" + operand2 + ")";
            case ">" -> operand1 + ".isGreaterThan(" + operand2 + ")";
            case ">=" -> operand1 + ".isGreaterOrEqualTo(" + operand2 + ")";
            case "<" -> operand1 + ".isLessThan(" + operand2 + ")";
            case "<=" -> operand1 + ".isLessOrEqualTo(" + operand2 + ")";
            case "IS" -> this.handleIsOperator(operand1, operand2);
            case "IS NOT" -> this.handleIsNotOperator(operand1, operand2);
            default -> operand1 + " " + operator + " " + operand2;
        };
    }

    private String handleIsOperator(String operand1, String operand2) {
        return switch (operand2.toUpperCase()) {
            case "TRUE" -> operand1 + ".isTrue()";
            case "FALSE" -> operand1 + ".isFalse()";
            case "NULL" -> operand1 + ".isNull()";
            default -> operand1 + ".isNotNull()";
        };
    }

    private String handleIsNotOperator(String operand1, String operand2) {
        return switch (operand2.toUpperCase()) {
            case "TRUE" -> operand1 + ".isNotTrue()";
            case "FALSE" -> operand1 + ".isNotFalse()";
            case "NULL" -> operand1 + ".isNotNull()";
            default -> operand1 + ".isNotNull()";
        };
    }

    private boolean areParenthesesBalanced(String expression) {
        int open = 0;
        char quote = '\u0000';
        for (char c : expression.toCharArray()) {
            if (c == '\'' || c == '\"') {
                if (quote == '\u0000') {
                    quote = c;
                } else if (quote == c) {
                    quote = '\u0000';
                }
            }
            if (quote != '\u0000') continue;
            if (c == '(') {
                ++open;
                continue;
            }
            if (c != ')') continue;
            if (open == 0) {
                return false;
            }
            --open;
        }
        return open == 0;
    }

    private String b7(String ... strings) {
        return StringUtils.join((Object[])strings, (String)b7);
    }

    private String camelCase(String snakeCase) {
        return StrUtils.getCamelCase(snakeCase);
    }

    private String capitalize(String word) {
        return word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase();
    }
}

