/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql;

import adalid.commons.util.BitUtils;
import adalid.commons.util.IntUtils;
import adalid.commons.util.NumUtils;
import adalid.commons.util.StrUtils;
import adalid.commons.util.ThrowableUtils;
import adalid.commons.util.TimeUtils;
import adalid.commons.velocity.VelocityEngineer;
import adalid.util.sql.SqlCheckConstraint;
import adalid.util.sql.SqlColumn;
import adalid.util.sql.SqlConstraintIndex;
import adalid.util.sql.SqlIndex;
import adalid.util.sql.SqlIndexColumn;
import adalid.util.sql.SqlRoutine;
import adalid.util.sql.SqlRoutineParameter;
import adalid.util.sql.SqlRow;
import adalid.util.sql.SqlRowValue;
import adalid.util.sql.SqlTab;
import adalid.util.sql.SqlTabColumn;
import adalid.util.sql.SqlTable;
import adalid.util.sql.SqlUtil;
import java.io.File;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;

public class SqlReader
extends SqlUtil {
    private static final Logger logger = Logger.getLogger(SqlReader.class);
    private static final boolean INFO = true;
    private static final boolean DETAIL = false;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final int ROW_LIMIT = 30000;
    private final Map<String, SqlTable> _tables = new LinkedHashMap<String, SqlTable>();
    private Set<String> _tablesExcludeSet = new LinkedHashSet<String>();
    private Map<String, String> _tablesInheritMap = new LinkedHashMap<String, String>();
    private Map<String, String> _tablesLoadMap = new LinkedHashMap<String, String>();
    private Map<String, String> _catalogTablesMap = new LinkedHashMap<String, String>();
    private List<String> _updatableColumns;
    private boolean _checkUpdatableColumns;
    private boolean _loadConfigurationTables;
    private boolean _loadOperationTables;
    private boolean _coverConstraintIndexes = true;
    private boolean _coverIndexes;
    private boolean _coverTabs;
    private boolean _coverRoutines;
    private String _selectTemplatesPath = "templates/meta/sql";
    private SqlAid _sqlAid;

    public SqlReader() {
    }

    public SqlReader(String[] args) {
        super(args);
    }

    protected SqlAid getSqlAid() {
        if (this._sqlAid == null) {
            this._sqlAid = switch (this._dbms) {
                case "oracle" -> new OracleAid();
                case "postgresql" -> new PostgreSqlAid();
                default -> null;
            };
        }
        return this._sqlAid;
    }

    public Map<String, SqlTable> getTablesMap() {
        return this._tables;
    }

    public Collection<SqlTable> getTables() {
        return this._tables.values();
    }

    public Set<String> getTablesExcludeSet() {
        return this._tablesExcludeSet;
    }

    public void setTablesExcludeSet(Set<String> set) {
        this._tablesExcludeSet = set;
    }

    public void setTablesExcludeSet(String[] set) {
        this._tablesExcludeSet = set == null ? null : new LinkedHashSet<String>(Arrays.asList(set));
    }

    public Set<String> getTablesInheritSet() {
        return this._tablesInheritMap.keySet();
    }

    public Map<String, String> getTablesInheritMap() {
        return this._tablesInheritMap;
    }

    public void setTablesInheritMap(Map<String, String> map) {
        this._tablesInheritMap = map;
    }

    public Set<String> getTablesLoadSet() {
        return this._tablesLoadMap.keySet();
    }

    public Map<String, String> getTablesLoadMap() {
        return this._tablesLoadMap;
    }

    public void setTablesLoadMap(Map<String, String> map) {
        this._tablesLoadMap = map;
    }

    public Set<String> getCatalogTablesSet() {
        return this._catalogTablesMap.keySet();
    }

    public Map<String, String> getCatalogTablesMap() {
        return this._catalogTablesMap;
    }

    public void setCatalogTablesMap(Map<String, String> map) {
        this._catalogTablesMap = map;
    }

    public boolean isLoadConfigurationTables() {
        return this._loadConfigurationTables;
    }

    public void setLoadConfigurationTables(boolean loadConfigurationTables) {
        this._loadConfigurationTables = loadConfigurationTables;
    }

    public boolean isLoadOperationTables() {
        return this._loadOperationTables;
    }

    public void setLoadOperationTables(boolean loadOperationTables) {
        this._loadOperationTables = loadOperationTables;
    }

    public boolean isCoverConstraintIndexes() {
        return this._coverConstraintIndexes;
    }

    public void setCoverConstraintIndexes(boolean b) {
        this._coverConstraintIndexes = b;
    }

    public boolean isCoverIndexes() {
        return this._coverIndexes;
    }

    public void setCoverIndexes(boolean b) {
        this._coverIndexes = b;
    }

    public boolean isCoverTabs() {
        return this._coverTabs;
    }

    public void setCoverTabs(boolean b) {
        this._coverTabs = b;
    }

    public boolean isCoverRoutines() {
        return this._coverRoutines;
    }

    public void setCoverRoutines(boolean b) {
        this._coverRoutines = b;
    }

    public String getSelectTemplatesPath() {
        return this._selectTemplatesPath;
    }

    public void setSelectTemplatesPath(String selectTemplatesPath) {
        this._selectTemplatesPath = selectTemplatesPath;
    }

    public boolean read(boolean close) {
        boolean read = this._initialised;
        read = read && this.connect();
        read = read && this.beforeReadBuild();
        read = read && this.build();
        boolean bl = read = read && this.beforeReadClose();
        if (close) {
            this.close();
        }
        return read;
    }

    protected boolean beforeReadBuild() {
        return true;
    }

    protected boolean beforeReadClose() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean build() {
        Iterator<SqlTable> iterator;
        SqlTable sqlTable3;
        int columns;
        SqlAid aid;
        block55: {
            boolean bl;
            SqlUtil.PreparedStatementWrapper selectRows;
            SqlUtil.PreparedStatementWrapper selectIXs;
            SqlUtil.PreparedStatementWrapper selectFKs;
            SqlUtil.PreparedStatementWrapper selectUKs;
            SqlUtil.PreparedStatementWrapper selectPKs;
            SqlUtil.PreparedStatementWrapper selectColumns;
            SqlUtil.PreparedStatementWrapper selectTables;
            block53: {
                boolean bl2;
                block52: {
                    logger.info((Object)"build");
                    aid = this.getSqlAid();
                    if (aid == null) {
                        return false;
                    }
                    SqlUtil.PreparedStatementWrapper select = null;
                    selectTables = null;
                    selectColumns = null;
                    selectPKs = null;
                    selectUKs = null;
                    selectFKs = null;
                    selectIXs = null;
                    selectRows = null;
                    int tables = 0;
                    columns = 0;
                    int indexes = 0;
                    int tabs = 0;
                    int rows = 0;
                    int routines = 0;
                    int cks = 0;
                    int pks = 0;
                    int uks = 0;
                    int fks = 0;
                    int ixs = 0;
                    int enum2 = 0;
                    int enum3 = 0;
                    int load2 = 0;
                    try {
                        selectTables = aid.getSelectTablesStatement();
                        if (selectTables == null) {
                            logger.error((Object)"select tables statement is invalid");
                            this.close(selectTables);
                            boolean bl3 = false;
                            return bl3;
                        }
                        select = selectTables;
                        logger.trace((Object)select);
                        ResultSet tablesResultSet = selectTables.executeQuery();
                        boolean next = tablesResultSet.next();
                        if (!next) {
                            logger.error((Object)"tables=0");
                            this.close(selectTables);
                            bl2 = false;
                            this.close(selectTables);
                            break block52;
                        }
                        selectColumns = aid.getSelectColumnsStatement();
                        if (selectColumns == null) {
                            logger.error((Object)"select columns statement is invalid");
                            this.close(selectTables);
                            this.close(selectColumns);
                            bl = false;
                            this.close(selectTables);
                            break block53;
                        }
                        this.setUpdatableColumns(aid);
                        SqlUtil.PreparedStatementWrapper selectCKs = aid.getSelectCKsStatement();
                        if (this._coverConstraintIndexes) {
                            selectPKs = aid.getSelectPKsStatement();
                            selectUKs = aid.getSelectUKsStatement();
                            selectFKs = aid.getSelectFKsStatement();
                            selectIXs = aid.getSelectIXsStatement();
                        }
                        logger.info((Object)("excluded-tables=" + String.valueOf(this._tablesExcludeSet)));
                        do {
                            if (this.foul(sqlTable3 = aid.getSqlTable(tablesResultSet)) || !this.add(sqlTable3)) continue;
                            ++tables;
                            String tableName = sqlTable3.getName();
                            select = selectTables;
                        } while (tablesResultSet.next());
                        if (!this._tables.isEmpty()) {
                            SqlConstraintIndex sqlConstraintIndex;
                            ResultSet constraintResultSet;
                            String key2;
                            select = selectColumns;
                            logger.info((Object)"read columns");
                            ResultSet columnsResultSet = selectColumns.executeQuery();
                            if (columnsResultSet.next()) {
                                do {
                                    if ((sqlTable3 = this._tables.get(key2 = aid.getSqlColumnTableName(columnsResultSet))) == null) continue;
                                    ++columns;
                                    SqlColumn sqlColumn = aid.getSqlColumn(columnsResultSet, sqlTable3);
                                    sqlTable3.add(sqlColumn);
                                } while (columnsResultSet.next());
                            }
                            if (selectCKs != null) {
                                select = selectCKs;
                                logger.info((Object)"read check constraints");
                                constraintResultSet = selectCKs.executeQuery();
                                if (constraintResultSet.next()) {
                                    do {
                                        if ((sqlTable3 = this._tables.get(key2 = aid.getSqlCheckConstraintTableName(constraintResultSet))) == null) continue;
                                        ++cks;
                                        SqlCheckConstraint sqlCheckConstraint = aid.getSqlCheckConstraint(constraintResultSet, sqlTable3);
                                        sqlTable3.addCK(sqlCheckConstraint);
                                    } while (constraintResultSet.next());
                                }
                            }
                            if (selectPKs != null) {
                                select = selectPKs;
                                logger.info((Object)"read primary keys");
                                constraintResultSet = selectPKs.executeQuery();
                                if (constraintResultSet.next()) {
                                    do {
                                        if ((sqlTable3 = this._tables.get(key2 = aid.getSqlConstraintIndexTableName(constraintResultSet))) == null) continue;
                                        ++pks;
                                        sqlConstraintIndex = aid.getSqlConstraintIndex(constraintResultSet, sqlTable3);
                                        sqlTable3.addPK(sqlConstraintIndex);
                                    } while (constraintResultSet.next());
                                }
                            }
                            if (selectUKs != null) {
                                select = selectUKs;
                                logger.info((Object)"read unique keys");
                                constraintResultSet = selectUKs.executeQuery();
                                if (constraintResultSet.next()) {
                                    do {
                                        if ((sqlTable3 = this._tables.get(key2 = aid.getSqlConstraintIndexTableName(constraintResultSet))) == null) continue;
                                        ++uks;
                                        sqlConstraintIndex = aid.getSqlConstraintIndex(constraintResultSet, sqlTable3);
                                        sqlTable3.addUK(sqlConstraintIndex);
                                    } while (constraintResultSet.next());
                                }
                            }
                            if (selectFKs != null) {
                                select = selectFKs;
                                logger.info((Object)"read foreign keys");
                                constraintResultSet = selectFKs.executeQuery();
                                if (constraintResultSet.next()) {
                                    do {
                                        if ((sqlTable3 = this._tables.get(key2 = aid.getSqlConstraintIndexTableName(constraintResultSet))) == null) continue;
                                        ++fks;
                                        sqlConstraintIndex = aid.getSqlConstraintIndex(constraintResultSet, sqlTable3);
                                        sqlTable3.addFK(sqlConstraintIndex);
                                    } while (constraintResultSet.next());
                                }
                            }
                            if (selectIXs != null) {
                                select = selectIXs;
                                logger.info((Object)"read non-unique indexes");
                                constraintResultSet = selectIXs.executeQuery();
                                if (constraintResultSet.next()) {
                                    do {
                                        if ((sqlTable3 = this._tables.get(key2 = aid.getSqlConstraintIndexTableName(constraintResultSet))) == null) continue;
                                        ++ixs;
                                        sqlConstraintIndex = aid.getSqlConstraintIndex(constraintResultSet, sqlTable3);
                                        sqlTable3.addIX(sqlConstraintIndex);
                                    } while (constraintResultSet.next());
                                }
                            }
                            logger.info((Object)"read rows");
                            for (String key2 : this._tables.keySet()) {
                                sqlTable3 = this._tables.get(key2);
                                if ((sqlTable3.isEnumeration() || sqlTable3.isLoadable()) && (selectRows = aid.getSelectRowsStatement(sqlTable3)) != null) {
                                    select = selectRows;
                                    try {
                                        int n = 0;
                                        ResultSet rowsResultSet = selectRows.executeQuery();
                                        if (rowsResultSet.next()) {
                                            do {
                                                SqlRow sqlRow;
                                                if ((sqlRow = aid.getSqlRow(rowsResultSet, sqlTable3)) == null) continue;
                                                ++n;
                                                ++rows;
                                                sqlTable3.add(sqlRow);
                                            } while (rowsResultSet.next());
                                            if (n >= 30000) {
                                                this.warnRowLimit(sqlTable3);
                                            }
                                        }
                                        sqlTable3.setLoaded(true);
                                    }
                                    catch (SQLException ex) {
                                        logger.info((Object)(String.valueOf(select) + " / " + ThrowableUtils.getString(ex)));
                                    }
                                    finally {
                                        this.close(selectRows);
                                        selectRows = null;
                                    }
                                }
                                if (sqlTable3.isEnumeration()) {
                                    ++enum2;
                                }
                                if (sqlTable3.isUpdatableEnumeration()) {
                                    ++enum3;
                                }
                                if (!sqlTable3.isLoaded()) continue;
                                ++load2;
                            }
                        }
                        logger.info((Object)("tables=" + tables));
                        logger.info((Object)("enumeration-tables=" + enum2));
                        logger.info((Object)("updatable-enumeration-tables=" + enum3));
                        logger.info((Object)("loaded-tables=" + load2));
                        logger.info((Object)("columns=" + columns));
                        if (this._coverIndexes) {
                            logger.info((Object)("indexes=" + indexes));
                        }
                        if (this._coverTabs) {
                            logger.info((Object)("tabs=" + tabs));
                        }
                        if (this._coverRoutines) {
                            logger.info((Object)("routines=" + routines));
                        }
                        logger.info((Object)("check-constraints=" + cks));
                        if (this._coverConstraintIndexes) {
                            logger.info((Object)("primary-keys=" + pks));
                            logger.info((Object)("unique-keys=" + uks));
                            logger.info((Object)("foreign-keys=" + fks));
                            logger.info((Object)("non-unique-indexes=" + ixs));
                        }
                        logger.info((Object)("rows=" + rows));
                        this.close(selectTables);
                    }
                    catch (SQLException ex) {
                        logger.fatal((Object)(select == null ? this._url : select.toString()), (Throwable)ex);
                        boolean sqlTable2 = false;
                        return sqlTable2;
                    }
                }
                this.close(selectColumns);
                this.close(selectPKs);
                this.close(selectUKs);
                this.close(selectFKs);
                this.close(selectIXs);
                this.close(selectRows);
                return bl2;
            }
            this.close(selectColumns);
            this.close(selectPKs);
            this.close(selectUKs);
            this.close(selectFKs);
            this.close(selectIXs);
            this.close(selectRows);
            return bl;
            this.close(selectColumns);
            this.close(selectPKs);
            this.close(selectUKs);
            this.close(selectFKs);
            this.close(selectIXs);
            this.close(selectRows);
            iterator = this._tables.values().iterator();
            break block55;
            finally {
                this.close(selectTables);
                this.close(selectColumns);
                this.close(selectPKs);
                this.close(selectUKs);
                this.close(selectFKs);
                this.close(selectIXs);
                this.close(selectRows);
            }
        }
        while (iterator.hasNext()) {
            sqlTable3 = iterator.next();
            aid.finalize(sqlTable3);
        }
        for (SqlTable sqlTable3 : this._tables.values()) {
            sqlTable3.settleColumns();
        }
        for (SqlTable sqlTable3 : this._tables.values()) {
            for (SqlTable extension : this._tables.values()) {
                if (!sqlTable3.equals(extension.getRootTable())) continue;
                sqlTable3.add(extension);
            }
        }
        if (columns <= 0) return false;
        return true;
    }

    private boolean add(SqlTable sqlTable) {
        String name = sqlTable.getName();
        if (StringUtils.isBlank((String)name)) {
            String text = "a null name table will not be added ";
            logger.error((Object)SqlUtil.highlight(text));
            return false;
        }
        if (this._tables.containsKey(name)) {
            String text = "table " + name + " already added ";
            logger.error((Object)SqlUtil.highlight(text));
            return false;
        }
        this._tables.put(name, sqlTable);
        return true;
    }

    private void warnRowLimit(SqlTable sqlTable) {
        String name = sqlTable.getName();
        String text = name + " reached 30000 rows limit";
        logger.warn((Object)SqlUtil.highlight(text));
    }

    private boolean foul(SqlTable sqlTable) {
        if (sqlTable == null) {
            return true;
        }
        if (this._tablesExcludeSet == null) {
            return false;
        }
        String name = sqlTable.getName();
        return this._tablesExcludeSet.contains(name) || this._tablesExcludeSet.contains(name.toLowerCase()) || this._tablesExcludeSet.contains(name.toUpperCase());
    }

    private String merge(String template, VelocityContext context) {
        String message = "failed to merge \"" + template + "\"";
        try {
            return VelocityEngineer.merge(context, template).toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(message, ex);
        }
    }

    private void setUpdatableColumns(SqlAid aid) {
        this._updatableColumns = null;
        this._checkUpdatableColumns = false;
        SqlUtil.PreparedStatementWrapper selectUpdatableColumns = aid.getSelectUpdatableColumnsStatement();
        if (selectUpdatableColumns != null) {
            try {
                ResultSet resultSet = selectUpdatableColumns.executeQuery();
                boolean next = resultSet.next();
                if (next) {
                    this._updatableColumns = new ArrayList<String>();
                    this._checkUpdatableColumns = true;
                    do {
                        String table_name = resultSet.getString(1);
                        String column_name = resultSet.getString(2);
                        this._updatableColumns.add(this.updatableColumnName(table_name, column_name));
                    } while (resultSet.next());
                }
            }
            catch (SQLException ex) {
                this._updatableColumns = null;
                this._checkUpdatableColumns = false;
                logger.warn((Object)(ThrowableUtils.getString(ex) + "\n" + String.valueOf(selectUpdatableColumns)));
                logger.warn((Object)"all columns will be considered updatable");
            }
        }
    }

    private boolean isUpdatableColumn(String table, String column) {
        return this._updatableColumns == null || this._checkUpdatableColumns && this._updatableColumns.contains(this.updatableColumnName(table, column));
    }

    private String updatableColumnName(String table, String column) {
        return table + "." + column;
    }

    protected abstract class SqlAid {
        protected SqlAid() {
        }

        protected abstract boolean createDefaults() throws SQLException;

        protected abstract boolean dropDefaults() throws SQLException;

        protected SqlUtil.PreparedStatementWrapper getSelectTablesStatement() {
            String template = this.getTemplateName("tables");
            return this.getSelectStatement(template);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectColumnsStatement() {
            String template = this.getTemplateName("columns-v5r3");
            return this.getSelectStatement(template);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectCKsStatement() {
            String template = this.getTemplateName("checks");
            return this.getSelectStatement(template);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectPKsStatement() {
            String template = this.getTemplateName("PK-constraints");
            return this.getSelectStatement(template);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectUKsStatement() {
            String template = this.getTemplateName("UK-constraints");
            return this.getSelectStatement(template);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectFKsStatement() {
            String template = this.getTemplateName("FK-constraints");
            return this.getSelectStatement(template);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectIXsStatement() {
            String template = this.getTemplateName("IX-constraints");
            return this.getSelectStatement(template);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectIndexesStatement() {
            String template = this.getTemplateName("indexes");
            return this.getSelectStatement(template);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectRoutinesStatement() {
            String template = this.getTemplateName("routines");
            return this.getSelectStatement(template);
        }

        protected abstract SqlUtil.PreparedStatementWrapper getSelectRowsStatement(SqlTable var1);

        protected SqlUtil.PreparedStatementWrapper getSelectUpdatableColumnsStatement() {
            String template = this.getTemplateName("updatable-columns");
            return this.getSelectStatement(template);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectStatement(String template) {
            VelocityContext context = new VelocityContext();
            return this.getSelectStatement(template, context);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectStatement(String template, SqlTable sqlTable) {
            VelocityContext context = new VelocityContext();
            String name = sqlTable.getName();
            context.put("table", (Object)name);
            return this.getSelectStatement(template, context);
        }

        protected SqlUtil.PreparedStatementWrapper getSelectStatement(String template, VelocityContext context) {
            String[] fileResourceLoaderPathArray;
            context.put("database", (Object)SqlReader.this._database);
            context.put("schema", (Object)SqlReader.this._schema);
            for (String path : fileResourceLoaderPathArray = VelocityEngineer.getFileResourceLoaderPathArray()) {
                String templatePath = path + FILE_SEPARATOR + template.replaceAll("/", "\\" + FILE_SEPARATOR);
                File templateFile = new File(templatePath);
                if (!templateFile.exists()) continue;
                logger.info((Object)("select-template=" + templatePath));
                String string = SqlReader.this.merge(template, context);
                if (StringUtils.startsWithIgnoreCase((String)string, (String)"select")) {
                    String sql = string.replace("\r\n", " ");
                    return this.prepareSelectStatement(sql);
                }
                logger.info((Object)("template file \"" + template + "\" does not contain a SQL select statement"));
                return null;
            }
            logger.warn((Object)("template file \"" + template + "\" is missing"));
            return null;
        }

        protected SqlUtil.PreparedStatementWrapper prepareSelectStatement(String statement) {
            return new SqlUtil.PreparedStatementWrapper(SqlReader.this, statement);
        }

        protected String getTemplateName(String type) {
            return SqlReader.this._selectTemplatesPath + "/" + SqlReader.this._dbms + "/select-" + type + ".vm";
        }

        protected String getSqlTableName(ResultSet resultSet) throws SQLException {
            return resultSet.getString(1);
        }

        protected SqlTable getSqlTable(ResultSet resultSet) throws SQLException {
            SqlTable sqlTable = new SqlTable(SqlReader.this);
            sqlTable.setName(resultSet.getString(1));
            return sqlTable;
        }

        protected String getSqlColumnTableName(ResultSet resultSet) throws SQLException {
            return resultSet.getString(15);
        }

        protected String getSqlColumnName(ResultSet resultSet) throws SQLException {
            return resultSet.getString(1);
        }

        protected SqlColumn getSqlColumn(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            SqlColumn sqlColumn = new SqlColumn(sqlTable);
            sqlColumn.setName(resultSet.getString(1));
            return sqlColumn;
        }

        protected String getSqlIndexName(ResultSet resultSet) throws SQLException {
            return resultSet.getString(1);
        }

        protected SqlIndex getSqlIndex(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            SqlIndex sqlIndex = new SqlIndex(sqlTable);
            sqlIndex.setName(resultSet.getString(1));
            return sqlIndex;
        }

        protected SqlIndex getSqlIndex(ResultSet resultSet, SqlIndex sqlIndex) throws SQLException {
            return sqlIndex;
        }

        protected String getSqlTabName(ResultSet resultSet) throws SQLException {
            return resultSet.getString(1);
        }

        protected SqlTab getSqlTab(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            SqlTab sqlTab = new SqlTab(sqlTable);
            sqlTab.setName(resultSet.getString(1));
            return sqlTab;
        }

        protected SqlTab getSqlTab(ResultSet resultSet, SqlTab sqlTab) throws SQLException {
            return sqlTab;
        }

        protected String getSqlRowName(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            int position = sqlTable.getBusinessKey().getPosition();
            return resultSet.getString(position);
        }

        protected SqlRow getSqlRow(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            int position = sqlTable.getBusinessKey().getPosition();
            String name = resultSet.getString(position);
            SqlRow sqlRow = new SqlRow(sqlTable);
            sqlRow.setName(name);
            for (SqlColumn sqlColumn : sqlTable.getColumns()) {
                Object object;
                String type;
                String column = sqlColumn.getName();
                if ((object = (switch (type = sqlColumn.getType()) {
                    case "boolean", "char", "string", "byte", "short", "integer", "long", "decimal", "float", "double" -> resultSet.getObject(sqlColumn.getPosition());
                    case "clob" -> resultSet.getClob(sqlColumn.getPosition());
                    case "date" -> resultSet.getDate(sqlColumn.getPosition());
                    case "time" -> resultSet.getTime(sqlColumn.getPosition());
                    case "timestamp" -> resultSet.getTimestamp(sqlColumn.getPosition());
                    default -> null;
                })) == null) continue;
                String string = StrUtils.getString(object);
                SqlRowValue sqlRowValue = new SqlRowValue(sqlRow, sqlColumn);
                sqlRowValue.setName(column);
                sqlRowValue.setObject(object);
                sqlRowValue.setValue(string);
                sqlRow.add(sqlRowValue);
            }
            return sqlRow;
        }

        protected String getSqlRoutineName(ResultSet resultSet) throws SQLException {
            return resultSet.getString(1);
        }

        protected SqlRoutine getSqlRoutine(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            SqlRoutine sqlRoutine = new SqlRoutine(sqlTable);
            sqlRoutine.setName(resultSet.getString(1));
            return sqlRoutine;
        }

        protected SqlRoutine getSqlRoutine(ResultSet resultSet, SqlRoutine sqlRoutine) throws SQLException {
            return sqlRoutine;
        }

        protected String getSqlCheckConstraintTableName(ResultSet resultSet) throws SQLException {
            return resultSet.getString(1);
        }

        protected SqlCheckConstraint getSqlCheckConstraint(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            SqlCheckConstraint sqlCheckConstraint = new SqlCheckConstraint(sqlTable);
            sqlCheckConstraint.setTableName(resultSet.getString(1));
            sqlCheckConstraint.setName(resultSet.getString(2));
            sqlCheckConstraint.setType(resultSet.getString(3));
            sqlCheckConstraint.setConstraintDefinition(resultSet.getString(4));
            return sqlCheckConstraint;
        }

        protected String getSqlConstraintIndexTableName(ResultSet resultSet) throws SQLException {
            return resultSet.getString(1);
        }

        protected SqlConstraintIndex getSqlConstraintIndex(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            SqlConstraintIndex sqlConstraintIndex = new SqlConstraintIndex(sqlTable);
            sqlConstraintIndex.setTableName(resultSet.getString(1));
            sqlConstraintIndex.setName(resultSet.getString(2));
            sqlConstraintIndex.setType(resultSet.getString(3));
            sqlConstraintIndex.setCreateStatement(resultSet.getString(4));
            sqlConstraintIndex.setDropStatement(resultSet.getString(5));
            return sqlConstraintIndex;
        }

        protected void finalize(SqlTable sqlTable) {
            for (SqlColumn sqlColumn : sqlTable.getColumns()) {
                this.finalizeColumn(sqlColumn);
            }
            for (SqlRow sqlRow : sqlTable.getRows()) {
                for (SqlRowValue sqlRowValue : sqlRow.getValues()) {
                    this.finalizeRowValue(sqlRowValue);
                }
            }
            for (SqlRoutine sqlRoutine : sqlTable.getRoutines()) {
                for (SqlRoutineParameter sqlRoutineParameter : sqlRoutine.getParameters()) {
                    this.finalizeParameter(sqlRoutineParameter);
                }
            }
        }

        protected void finalizeColumn(SqlColumn sqlColumn) {
            String foreignTableName = sqlColumn.getForeignTableName();
            if (foreignTableName != null && SqlReader.this._tables.containsKey(foreignTableName)) {
                sqlColumn.setForeignTable(SqlReader.this._tables.get(foreignTableName));
            }
            sqlColumn.setDefault(this.stringValueOf(sqlColumn, sqlColumn.getDefault()));
        }

        protected void finalizeRowValue(SqlRowValue sqlRowValue) {
            sqlRowValue.setValue(this.stringValueOf(sqlRowValue.getColumn(), sqlRowValue.getValue()));
            sqlRowValue.setLiteral(this.literalOf(sqlRowValue.getObject()));
        }

        protected void finalizeParameter(SqlRoutineParameter sqlRoutineParameter) {
            sqlRoutineParameter.setDefault(this.stringValueOf(sqlRoutineParameter, sqlRoutineParameter.getDefault()));
        }

        protected int intValueOf(Object object) {
            return IntUtils.valueOf(NumUtils.newInteger(object));
        }

        protected boolean booleanValueOf(Object object) {
            return BitUtils.valueOf(object);
        }

        protected abstract String literalOf(Object var1);

        protected abstract String literalOf(SqlColumn var1, String var2);

        protected abstract String defaultOf(SqlColumn var1);

        protected String stringValueOf(SqlColumn sqlColumn, String string) {
            String ctype = sqlColumn.getType();
            String value = StringUtils.trimToNull((String)string);
            return value == null ? null : (sqlColumn.getForeignTable() != null ? this.instanceValueOf(sqlColumn, string) : (sqlColumn.isForeign() ? null : (ctype.equals("date") ? null : (ctype.equals("time") ? null : (ctype.equals("timestamp") ? null : value)))));
        }

        protected String stringValueOf(SqlRoutineParameter sqlRoutineParameter, String string) {
            String ctype = sqlRoutineParameter.getType();
            SqlColumn namesake = sqlRoutineParameter.getNamesakeColumn();
            String value = StringUtils.trimToNull((String)string);
            return value == null ? null : (sqlRoutineParameter.getForeignTable() != null ? this.instanceValueOf(namesake, string) : (sqlRoutineParameter.isForeign() ? null : (ctype.equals("date") ? null : (ctype.equals("time") ? null : (ctype.equals("timestamp") ? null : value)))));
        }

        protected String instanceValueOf(SqlColumn sqlColumn, String string) {
            SqlColumn primaryKey;
            SqlTable foreignTable;
            String value = StringUtils.trimToNull((String)string);
            if (value != null && (foreignTable = sqlColumn.getForeignTable()) != null && (primaryKey = foreignTable.getPrimaryKey()) != null) {
                for (SqlRow sqlRow : foreignTable.getRows()) {
                    for (SqlRowValue sqlRowValue : sqlRow.getValues()) {
                        if (!primaryKey.equals(sqlRowValue.getColumn()) || !value.equals(sqlRowValue.getValue())) continue;
                        return sqlColumn.getDecapitalizedJavaName() + "." + sqlRow.getJavaConstantName();
                    }
                }
            }
            return null;
        }
    }

    class OracleAid
    extends SqlAid {
        OracleAid() {
        }

        @Override
        protected boolean createDefaults() throws SQLException {
            String statement = "call " + SqlReader.this._schema + ".create_defaults()";
            return SqlReader.this.executeStatement(statement, false);
        }

        @Override
        protected boolean dropDefaults() throws SQLException {
            String statement = "call " + SqlReader.this._schema + ".drop_defaults()";
            return SqlReader.this.executeStatement(statement, false);
        }

        @Override
        protected SqlUtil.PreparedStatementWrapper getSelectRowsStatement(SqlTable sqlTable) {
            String name = sqlTable.getName();
            String pk = sqlTable.getPrimaryKey().getName();
            String sql = "select * from " + SqlReader.this._schema + "." + name + " where ROWNUM<=30000 order by " + pk;
            logger.debug((Object)sql);
            return this.prepareSelectStatement(sql);
        }

        @Override
        protected SqlTable getSqlTable(ResultSet resultSet) throws SQLException {
            String table_name = resultSet.getString(1);
            String default_label = resultSet.getString(2);
            String default_collection_label = resultSet.getString(3);
            String resource_type = resultSet.getString(4);
            boolean is_enumerable = this.booleanValueOf(resultSet.getObject(5));
            boolean is_insertable = this.booleanValueOf(resultSet.getObject(6));
            boolean is_updatable = this.booleanValueOf(resultSet.getObject(7));
            boolean is_deletable = this.booleanValueOf(resultSet.getObject(8));
            boolean is_independent = this.booleanValueOf(resultSet.getObject(9));
            SqlTable sqlTable = new SqlTable(SqlReader.this);
            sqlTable.setName(table_name);
            sqlTable.setDefaultLabel(default_label);
            sqlTable.setDefaultCollectionLabel(default_collection_label);
            sqlTable.setResourceType(resource_type);
            sqlTable.setEnumerable(is_enumerable);
            sqlTable.setInsertable(is_insertable);
            sqlTable.setUpdatable(is_updatable);
            sqlTable.setDeletable(is_deletable);
            sqlTable.setIndependent(is_independent);
            return sqlTable;
        }

        @Override
        protected SqlColumn getSqlColumn(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            String table_name = sqlTable.getName();
            String column_name = resultSet.getString(1);
            int ordinal_position = this.intValueOf(resultSet.getObject(2));
            String data_type = StringUtils.trimToEmpty((String)resultSet.getString(3));
            int character_maximum_length = this.intValueOf(resultSet.getObject(4));
            int numeric_precision = this.intValueOf(resultSet.getObject(5));
            int numeric_scale = this.intValueOf(resultSet.getObject(6));
            int datetime_precision = this.intValueOf(resultSet.getObject(7));
            String column_default = StrUtils.disclose(StringUtils.trimToNull((String)resultSet.getString(8)), '(', ')');
            String string_default = this.stringValueOf(column_default);
            boolean is_updatable = SqlReader.this.isUpdatableColumn(table_name, column_name);
            boolean is_nullable = this.booleanValueOf(resultSet.getObject(9));
            boolean is_primary_key = this.booleanValueOf(resultSet.getObject(10));
            boolean is_unique_key = this.booleanValueOf(resultSet.getObject(11));
            boolean is_booleanish = this.booleanValueOf(resultSet.getObject(12));
            String foreign_table_name = StringUtils.trimToNull((String)resultSet.getString(13));
            String default_label = resultSet.getString(14);
            SqlColumn sqlColumn = new SqlColumn(sqlTable);
            sqlColumn.setName(column_name);
            sqlColumn.setPosition(ordinal_position);
            sqlColumn.setDefaultLabel(default_label);
            data_type = data_type.replaceAll("\\(.*\\)", "");
            sqlColumn.setSqlDataType(data_type);
            sqlColumn.setSqlType(data_type);
            sqlColumn.setType(data_type);
            switch (data_type) {
                case "number": {
                    if (numeric_precision <= 0) break;
                    if (numeric_scale == 0) {
                        if (numeric_precision <= 3) {
                            sqlColumn.setType("byte");
                            sqlColumn.setSqlType(data_type + "(" + numeric_precision + ")");
                            break;
                        }
                        if (numeric_precision <= 5) {
                            sqlColumn.setType("short");
                            sqlColumn.setSqlType(data_type + "(" + numeric_precision + ")");
                            break;
                        }
                        if (numeric_precision <= 10) {
                            sqlColumn.setType("integer");
                            sqlColumn.setSqlType(data_type + "(" + numeric_precision + ")");
                            break;
                        }
                        if (numeric_precision <= 19) {
                            sqlColumn.setType("long");
                            sqlColumn.setSqlType(data_type + "(" + numeric_precision + ")");
                            break;
                        }
                        sqlColumn.setType("decimal");
                        sqlColumn.setPrecision(numeric_precision);
                        sqlColumn.setScale(numeric_scale);
                        if (numeric_precision <= 0) break;
                        if (numeric_scale > 0) {
                            sqlColumn.setSqlType(data_type + "(" + numeric_precision + ", " + numeric_scale + ")");
                            break;
                        }
                        sqlColumn.setSqlType(data_type + "(" + numeric_precision + ")");
                        break;
                    }
                    sqlColumn.setType("decimal");
                    sqlColumn.setPrecision(numeric_precision);
                    sqlColumn.setScale(numeric_scale);
                    if (numeric_scale > 0) {
                        sqlColumn.setSqlType(data_type + "(" + numeric_precision + ", " + numeric_scale + ")");
                        break;
                    }
                    sqlColumn.setSqlType(data_type + "(" + numeric_precision + ")");
                    break;
                }
                case "blob": 
                case "bytea": {
                    sqlColumn.setType("blob");
                    break;
                }
                case "\"char\"": {
                    sqlColumn.setType("char");
                    sqlColumn.setSqlType("char(1)");
                    break;
                }
                case "char": 
                case "character": 
                case "character varying": 
                case "nchar": 
                case "nvarchar": 
                case "nvarchar2": 
                case "varchar": 
                case "varchar2": 
                case "text": {
                    sqlColumn.setType("string");
                    sqlColumn.setLength(character_maximum_length);
                    if (character_maximum_length <= 0) break;
                    sqlColumn.setSqlType(data_type + "(" + character_maximum_length + ")");
                    break;
                }
                case "smallint": 
                case "smallserial": {
                    sqlColumn.setType("short");
                    break;
                }
                case "integer": 
                case "serial": {
                    sqlColumn.setType("integer");
                    break;
                }
                case "bigint": 
                case "bigserial": {
                    sqlColumn.setType("long");
                    break;
                }
                case "decimal": 
                case "numeric": 
                case "money": {
                    sqlColumn.setType("decimal");
                    sqlColumn.setPrecision(numeric_precision);
                    sqlColumn.setScale(numeric_scale);
                    if (numeric_precision <= 0) break;
                    if (numeric_scale > 0) {
                        sqlColumn.setSqlType(data_type + "(" + numeric_precision + ", " + numeric_scale + ")");
                        break;
                    }
                    sqlColumn.setSqlType(data_type + "(" + numeric_precision + ")");
                    break;
                }
                case "real": {
                    sqlColumn.setType("float");
                    break;
                }
                case "double precision": {
                    sqlColumn.setType("double");
                    break;
                }
                case "date": {
                    sqlColumn.setType("date");
                    break;
                }
                case "timestamp": 
                case "timestamp with time zone": 
                case "timestamp without time zone": {
                    sqlColumn.setType("timestamp");
                    sqlColumn.setPrecision(datetime_precision);
                    if (datetime_precision <= 0) break;
                    int i = data_type.indexOf(" ");
                    if (i < 0) {
                        sqlColumn.setSqlType(data_type + "(" + datetime_precision + ")");
                        break;
                    }
                    sqlColumn.setSqlType(data_type.substring(0, i) + "(" + datetime_precision + ")" + data_type.substring(i));
                }
            }
            sqlColumn.setDefault(string_default);
            sqlColumn.setSqlDefaultValue(column_default);
            sqlColumn.setSqlDefaultValueLiteral(this.literalOf(sqlColumn, string_default));
            sqlColumn.setSqlPrimalDefaultValue(this.defaultOf(sqlColumn));
            sqlColumn.setUpdatable(is_updatable);
            sqlColumn.setNullable(is_nullable);
            sqlColumn.setPrimary(is_primary_key);
            sqlColumn.setUnique(is_unique_key);
            sqlColumn.setBooleanish(is_booleanish);
            if (foreign_table_name != null) {
                sqlColumn.setForeign(true);
                sqlColumn.setForeignTableName(foreign_table_name);
            }
            return sqlColumn;
        }

        @Override
        protected String literalOf(Object obj) {
            String string = this.unquotedLiteralOf(obj);
            if (string == null) {
                return "null";
            }
            if (obj instanceof Number) {
                return string;
            }
            if (obj instanceof Date) {
                return "date" + StrUtils.enclose(string, '\'');
            }
            if (obj instanceof Time) {
                return "timestamp" + StrUtils.enclose(string, '\'');
            }
            if (obj instanceof java.util.Date) {
                return "timestamp" + StrUtils.enclose(string, '\'');
            }
            return StrUtils.enclose(string, '\'');
        }

        @Override
        protected String literalOf(SqlColumn sqlColumn, String string) {
            String type = sqlColumn.getType();
            if (type == null || string == null) {
                return "null";
            }
            return switch (type) {
                case "byte", "short", "integer", "long", "decimal", "float", "double" -> string;
                case "boolean", "char", "string" -> StrUtils.enclose(string, '\'');
                case "date" -> "date" + StrUtils.enclose(string, '\'');
                case "time" -> "timestamp" + StrUtils.enclose(string, '\'');
                case "timestamp" -> "timestamp" + StrUtils.enclose(string, '\'');
                default -> "null";
            };
        }

        @Override
        protected String defaultOf(SqlColumn sqlColumn) {
            String type = sqlColumn.getType();
            if (type == null) {
                return "null";
            }
            return switch (type) {
                case "byte", "short", "integer", "long", "decimal", "float", "double" -> "0";
                case "boolean", "char", "string" -> "'?'";
                case "date" -> "current_date";
                case "time" -> "localtimestamp";
                case "timestamp" -> "localtimestamp";
                default -> "null";
            };
        }

        protected String unquotedLiteralOf(Object obj) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof Clob) {
                Clob clob = (Clob)obj;
                return StrUtils.getSubString(clob);
            }
            if (obj instanceof Date) {
                return TimeUtils.jdbcDateString(obj);
            }
            if (obj instanceof Time) {
                return TimeUtils.jdbcTimestampString(obj);
            }
            if (obj instanceof java.util.Date) {
                return TimeUtils.jdbcTimestampString(obj);
            }
            return obj.toString();
        }

        protected String stringValueOf(String string) {
            String trimmed = StringUtils.trimToNull((String)string);
            if (trimmed == null) {
                return null;
            }
            if (StringUtils.startsWithIgnoreCase((String)(trimmed = StrUtils.disclose(trimmed, '(', ')')), (String)"null")) {
                return null;
            }
            if (StringUtils.startsWithIgnoreCase((String)trimmed, (String)"nextval")) {
                return null;
            }
            if (StringUtils.containsIgnoreCase((String)trimmed, (String)"'now'")) {
                return "now()";
            }
            int i = trimmed.indexOf("::");
            if (i > 0) {
                trimmed = trimmed.substring(0, i);
            }
            return StrUtils.disclose(trimmed, '\'');
        }

        @Override
        protected String stringValueOf(SqlColumn sqlColumn, String string) {
            String trimmed = sqlColumn.isForeign() ? null : StringUtils.trimToNull((String)string);
            String value = trimmed == null ? null : this.stringValueOf(trimmed.toLowerCase(), sqlColumn.getTrueType());
            return value == null ? super.stringValueOf(sqlColumn, string) : value;
        }

        @Override
        protected SqlIndex getSqlIndex(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            String index_name = resultSet.getString(1);
            boolean is_unique = this.booleanValueOf(resultSet.getObject(2));
            SqlIndex sqlIndex = new SqlIndex(sqlTable);
            sqlIndex.setName(index_name);
            sqlIndex.setUnique(is_unique);
            return this.getSqlIndex(resultSet, sqlIndex);
        }

        @Override
        protected SqlIndex getSqlIndex(ResultSet resultSet, SqlIndex sqlIndex) throws SQLException {
            int ordinal_position = this.intValueOf(resultSet.getObject(3));
            String column_name = resultSet.getString(4);
            String column_option = resultSet.getString(5);
            SqlIndexColumn sqlIndexColumn = new SqlIndexColumn(sqlIndex, sqlIndex.getTable().getSqlColumn(column_name));
            sqlIndexColumn.setName(column_name);
            sqlIndexColumn.setPosition(ordinal_position);
            sqlIndexColumn.setOption(column_option);
            sqlIndex.add(sqlIndexColumn);
            return sqlIndex;
        }

        @Override
        protected SqlTab getSqlTab(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            String tab_name = resultSet.getString(1);
            String default_label = resultSet.getString(2);
            SqlTab sqlTab = new SqlTab(sqlTable);
            sqlTab.setName(tab_name);
            sqlTab.setDefaultLabel(default_label);
            return this.getSqlTab(resultSet, sqlTab);
        }

        @Override
        protected SqlTab getSqlTab(ResultSet resultSet, SqlTab sqlTab) throws SQLException {
            String column_name = resultSet.getString(3);
            SqlTabColumn sqlTabColumn = new SqlTabColumn(sqlTab, sqlTab.getTable().getSqlColumn(column_name));
            sqlTabColumn.setName(column_name);
            sqlTab.add(sqlTabColumn);
            return sqlTab;
        }

        @Override
        protected SqlRoutine getSqlRoutine(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            String routine_name = resultSet.getString(1);
            String routine_type = resultSet.getString(2);
            SqlRoutine sqlRoutine = new SqlRoutine(sqlTable);
            sqlRoutine.setName(routine_name);
            sqlRoutine.setOperationType(routine_type);
            return this.getSqlRoutine(resultSet, sqlRoutine);
        }

        @Override
        protected SqlRoutine getSqlRoutine(ResultSet resultSet, SqlRoutine sqlRoutine) throws SQLException {
            String parameter_name = resultSet.getString(3);
            if (StringUtils.isBlank((String)parameter_name)) {
                return sqlRoutine;
            }
            String data_type = StringUtils.trimToEmpty((String)resultSet.getString(4));
            boolean is_required = this.booleanValueOf(resultSet.getObject(5));
            boolean is_hidden = this.booleanValueOf(resultSet.getObject(6));
            Object parameter_default = StringUtils.trimToNull((String)resultSet.getString(7));
            SqlRoutineParameter sqlRoutineParameter = new SqlRoutineParameter(sqlRoutine);
            sqlRoutineParameter.setName(parameter_name);
            switch (data_type) {
                case "boolean": {
                    sqlRoutineParameter.setType("boolean");
                    break;
                }
                case "\"char\"": {
                    sqlRoutineParameter.setType("char");
                    break;
                }
                case "char": 
                case "character": 
                case "character varying": 
                case "nchar": 
                case "nvarchar": 
                case "nvarchar2": 
                case "varchar": 
                case "varchar2": 
                case "text": {
                    sqlRoutineParameter.setType("string");
                    break;
                }
                case "smallint": 
                case "smallserial": {
                    sqlRoutineParameter.setType("short");
                    break;
                }
                case "integer": {
                    if (StringUtils.startsWithIgnoreCase((String)parameter_name, (String)"es_")) {
                        sqlRoutineParameter.setType("boolean");
                        parameter_default = "" + this.booleanValueOf(parameter_default);
                        break;
                    }
                    sqlRoutineParameter.setType("integer");
                    break;
                }
                case "serial": {
                    sqlRoutineParameter.setType("integer");
                    break;
                }
                case "bigint": 
                case "bigserial": {
                    sqlRoutineParameter.setType("long");
                    break;
                }
                case "decimal": 
                case "numeric": 
                case "money": {
                    sqlRoutineParameter.setType("decimal");
                    break;
                }
                case "real": {
                    sqlRoutineParameter.setType("float");
                    break;
                }
                case "double precision": {
                    sqlRoutineParameter.setType("double");
                    break;
                }
                case "date": {
                    sqlRoutineParameter.setType("date");
                    break;
                }
                case "time": 
                case "time with time zone": 
                case "time without time zone": {
                    sqlRoutineParameter.setType("time");
                    break;
                }
                case "timestamp": 
                case "timestamp with time zone": 
                case "timestamp without time zone": {
                    sqlRoutineParameter.setType("timestamp");
                    break;
                }
                default: {
                    sqlRoutineParameter.setType("string");
                }
            }
            sqlRoutineParameter.setSqlDataType(data_type);
            sqlRoutineParameter.setRequired(is_required);
            sqlRoutineParameter.setHidden(is_hidden);
            sqlRoutineParameter.setDefault((String)parameter_default);
            sqlRoutineParameter.setSqlDefaultValue((String)parameter_default);
            sqlRoutine.add(sqlRoutineParameter);
            return sqlRoutine;
        }

        @Override
        protected String stringValueOf(SqlRoutineParameter sqlRoutineParameter, String string) {
            String trimmed = sqlRoutineParameter.isForeign() ? null : StringUtils.trimToNull((String)string);
            String value = trimmed == null ? null : this.stringValueOf(trimmed.toLowerCase(), sqlRoutineParameter.getTrueType());
            return value == null ? super.stringValueOf(sqlRoutineParameter, string) : value;
        }

        protected String stringValueOf(String string, String type) {
            return string == null || type == null ? null : (string.equals("current_date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("current_time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("current_timestamp") && type.equals("date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("current_timestamp") && type.equals("time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("current_timestamp") && type.equals("timestamp") ? "SpecialTemporalValue.CURRENT_TIMESTAMP" : (string.equals("localtime") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("localtimestamp") && type.equals("date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("localtimestamp") && type.equals("time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("localtimestamp") && type.equals("timestamp") ? "SpecialTemporalValue.CURRENT_TIMESTAMP" : (string.equals("now()") && type.equals("date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("now()") && type.equals("time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("now()") && type.equals("timestamp") ? "SpecialTemporalValue.CURRENT_TIMESTAMP" : (string.equals("getdate()") && type.equals("date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("getdate()") && type.equals("time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("getdate()") && type.equals("timestamp") ? "SpecialTemporalValue.CURRENT_TIMESTAMP" : (string.equals("getuser()") && type.equals("long") ? "SpecialNumericValue.CURRENT_USER_ID" : (string.equals("getuser()") && type.equals("string") ? "SpecialCharacterValue.CURRENT_USER" : null)))))))))))))))));
        }
    }

    class PostgreSqlAid
    extends SqlAid {
        PostgreSqlAid() {
        }

        @Override
        protected boolean createDefaults() throws SQLException {
            String statement = "select " + SqlReader.this._schema + ".create_defaults();";
            return SqlReader.this.executeStatement(statement, false);
        }

        @Override
        protected boolean dropDefaults() throws SQLException {
            String statement = "select " + SqlReader.this._schema + ".drop_defaults();";
            return SqlReader.this.executeStatement(statement, false);
        }

        @Override
        protected SqlUtil.PreparedStatementWrapper getSelectRowsStatement(SqlTable sqlTable) {
            String name = sqlTable.getName();
            String pk = sqlTable.getPrimaryKey().getName();
            String sql = "select * from " + SqlReader.this._schema + "." + name + " order by " + pk + " limit 30000";
            logger.debug((Object)sql);
            return this.prepareSelectStatement(sql);
        }

        @Override
        protected SqlTable getSqlTable(ResultSet resultSet) throws SQLException {
            String table_name = resultSet.getString(1);
            String default_label = resultSet.getString(2);
            String default_collection_label = resultSet.getString(3);
            String resource_type = resultSet.getString(4);
            boolean is_enumerable = this.booleanValueOf(resultSet.getObject(5));
            boolean is_insertable = this.booleanValueOf(resultSet.getObject(6));
            boolean is_updatable = this.booleanValueOf(resultSet.getObject(7));
            boolean is_deletable = this.booleanValueOf(resultSet.getObject(8));
            boolean is_independent = this.booleanValueOf(resultSet.getObject(9));
            SqlTable sqlTable = new SqlTable(SqlReader.this);
            sqlTable.setName(table_name);
            sqlTable.setDefaultLabel(default_label);
            sqlTable.setDefaultCollectionLabel(default_collection_label);
            sqlTable.setResourceType(resource_type);
            sqlTable.setEnumerable(is_enumerable);
            sqlTable.setInsertable(is_insertable);
            sqlTable.setUpdatable(is_updatable);
            sqlTable.setDeletable(is_deletable);
            sqlTable.setIndependent(is_independent);
            return sqlTable;
        }

        @Override
        protected SqlColumn getSqlColumn(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            String table_name = sqlTable.getName();
            String column_name = resultSet.getString(1);
            int ordinal_position = this.intValueOf(resultSet.getObject(2));
            String data_type = StringUtils.trimToEmpty((String)resultSet.getString(3));
            int character_maximum_length = this.intValueOf(resultSet.getObject(4));
            int numeric_precision = this.intValueOf(resultSet.getObject(5));
            int numeric_scale = this.intValueOf(resultSet.getObject(6));
            int datetime_precision = this.intValueOf(resultSet.getObject(7));
            String column_default = StringUtils.trimToNull((String)resultSet.getString(8));
            String string_default = this.stringValueOf(column_default);
            boolean is_updatable = SqlReader.this.isUpdatableColumn(table_name, column_name);
            boolean is_nullable = this.booleanValueOf(resultSet.getObject(9));
            boolean is_primary_key = this.booleanValueOf(resultSet.getObject(10));
            boolean is_unique_key = this.booleanValueOf(resultSet.getObject(11));
            boolean is_booleanish = this.booleanValueOf(resultSet.getObject(12));
            String foreign_table_name = StringUtils.trimToNull((String)resultSet.getString(13));
            String default_label = resultSet.getString(14);
            SqlColumn sqlColumn = new SqlColumn(sqlTable);
            sqlColumn.setName(column_name);
            sqlColumn.setPosition(ordinal_position);
            sqlColumn.setDefaultLabel(default_label);
            data_type = data_type.replaceAll("\\(.*\\)", "");
            sqlColumn.setSqlDataType(data_type);
            sqlColumn.setSqlType(data_type);
            sqlColumn.setType(data_type);
            switch (data_type) {
                case "boolean": {
                    sqlColumn.setType("boolean");
                    break;
                }
                case "blob": 
                case "bytea": {
                    sqlColumn.setType("blob");
                    break;
                }
                case "\"char\"": {
                    sqlColumn.setType("char");
                    sqlColumn.setSqlType("char(1)");
                    break;
                }
                case "char": 
                case "character": 
                case "character varying": 
                case "varchar": 
                case "text": {
                    sqlColumn.setType("string");
                    sqlColumn.setLength(character_maximum_length);
                    if (character_maximum_length <= 0) break;
                    sqlColumn.setSqlType(data_type + "(" + character_maximum_length + ")");
                    break;
                }
                case "smallint": 
                case "smallserial": {
                    sqlColumn.setType("short");
                    break;
                }
                case "integer": 
                case "serial": {
                    sqlColumn.setType("integer");
                    break;
                }
                case "bigint": 
                case "bigserial": {
                    sqlColumn.setType("long");
                    break;
                }
                case "decimal": 
                case "numeric": 
                case "money": {
                    sqlColumn.setType("decimal");
                    sqlColumn.setPrecision(numeric_precision);
                    sqlColumn.setScale(numeric_scale);
                    if (numeric_precision <= 0) break;
                    if (numeric_scale > 0) {
                        sqlColumn.setSqlType(data_type + "(" + numeric_precision + ", " + numeric_scale + ")");
                        break;
                    }
                    sqlColumn.setSqlType(data_type + "(" + numeric_precision + ")");
                    break;
                }
                case "real": {
                    sqlColumn.setType("float");
                    break;
                }
                case "double precision": {
                    sqlColumn.setType("double");
                    break;
                }
                case "date": {
                    sqlColumn.setType("date");
                    break;
                }
                case "time": 
                case "time with time zone": 
                case "time without time zone": {
                    sqlColumn.setType("time");
                    sqlColumn.setPrecision(datetime_precision);
                    if (datetime_precision <= 0) break;
                    int i = data_type.indexOf(" ");
                    if (i < 0) {
                        sqlColumn.setSqlType(data_type + "(" + datetime_precision + ")");
                        break;
                    }
                    sqlColumn.setSqlType(data_type.substring(0, i) + "(" + datetime_precision + ")" + data_type.substring(i));
                    break;
                }
                case "timestamp": 
                case "timestamp with time zone": 
                case "timestamp without time zone": {
                    sqlColumn.setType("timestamp");
                    sqlColumn.setPrecision(datetime_precision);
                    if (datetime_precision <= 0) break;
                    int i = data_type.indexOf(" ");
                    if (i < 0) {
                        sqlColumn.setSqlType(data_type + "(" + datetime_precision + ")");
                        break;
                    }
                    sqlColumn.setSqlType(data_type.substring(0, i) + "(" + datetime_precision + ")" + data_type.substring(i));
                }
            }
            sqlColumn.setDefault(string_default);
            sqlColumn.setSqlDefaultValue(column_default);
            sqlColumn.setSqlDefaultValueLiteral(this.literalOf(sqlColumn, string_default));
            sqlColumn.setSqlPrimalDefaultValue(this.defaultOf(sqlColumn));
            sqlColumn.setUpdatable(is_updatable);
            sqlColumn.setNullable(is_nullable);
            sqlColumn.setPrimary(is_primary_key);
            sqlColumn.setUnique(is_unique_key);
            sqlColumn.setBooleanish(is_booleanish);
            if (foreign_table_name != null) {
                sqlColumn.setForeign(true);
                sqlColumn.setForeignTableName(foreign_table_name);
            }
            return sqlColumn;
        }

        @Override
        protected String literalOf(Object obj) {
            String string = this.unquotedLiteralOf(obj);
            if (string == null) {
                return "null";
            }
            if (obj instanceof Boolean) {
                return string;
            }
            if (obj instanceof Number) {
                return string;
            }
            if (obj instanceof Date) {
                return "date" + StrUtils.enclose(string, '\'');
            }
            if (obj instanceof Time) {
                return "time" + StrUtils.enclose(string, '\'');
            }
            if (obj instanceof java.util.Date) {
                return "timestamp" + StrUtils.enclose(string, '\'');
            }
            return StrUtils.enclose(string, '\'');
        }

        @Override
        protected String literalOf(SqlColumn sqlColumn, String string) {
            String type = sqlColumn.getType();
            if (type == null || string == null) {
                return "null";
            }
            return switch (type) {
                case "boolean", "byte", "short", "integer", "long", "decimal", "float", "double" -> string;
                case "char", "string" -> StrUtils.enclose(string, '\'');
                case "date" -> "date" + StrUtils.enclose(string, '\'');
                case "time" -> "time" + StrUtils.enclose(string, '\'');
                case "timestamp" -> "timestamp" + StrUtils.enclose(string, '\'');
                default -> "null";
            };
        }

        @Override
        protected String defaultOf(SqlColumn sqlColumn) {
            String type = sqlColumn.getType();
            if (type == null) {
                return "null";
            }
            return switch (type) {
                case "boolean" -> "false";
                case "byte", "short", "integer", "long", "decimal", "float", "double" -> "0";
                case "char", "string" -> "'?'";
                case "date" -> "current_date";
                case "time" -> "localtime";
                case "timestamp" -> "localtimestamp";
                default -> "null";
            };
        }

        protected String unquotedLiteralOf(Object obj) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof Clob) {
                Clob clob = (Clob)obj;
                return StrUtils.getSubString(clob);
            }
            if (obj instanceof Date) {
                return TimeUtils.jdbcDateString(obj);
            }
            if (obj instanceof Time) {
                return TimeUtils.jdbcTimeString(obj);
            }
            if (obj instanceof java.util.Date) {
                return TimeUtils.jdbcTimestampString(obj);
            }
            return obj.toString();
        }

        protected String stringValueOf(String string) {
            String trimmed = StringUtils.trimToNull((String)string);
            if (trimmed == null) {
                return null;
            }
            if (StringUtils.startsWithIgnoreCase((String)trimmed, (String)"null")) {
                return null;
            }
            if (StringUtils.startsWithIgnoreCase((String)trimmed, (String)"nextval")) {
                return null;
            }
            if (StringUtils.containsIgnoreCase((String)trimmed, (String)"'now'")) {
                return "now()";
            }
            int i = trimmed.indexOf("::");
            if (i > 0) {
                trimmed = trimmed.substring(0, i);
            }
            return StrUtils.disclose(trimmed, '\'');
        }

        @Override
        protected String stringValueOf(SqlColumn sqlColumn, String string) {
            String trimmed = sqlColumn.isForeign() ? null : StringUtils.trimToNull((String)string);
            String value = trimmed == null ? null : this.stringValueOf(trimmed.toLowerCase(), sqlColumn.getTrueType());
            return value == null ? super.stringValueOf(sqlColumn, string) : value;
        }

        @Override
        protected SqlIndex getSqlIndex(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            String index_name = resultSet.getString(1);
            boolean is_unique = this.booleanValueOf(resultSet.getObject(2));
            SqlIndex sqlIndex = new SqlIndex(sqlTable);
            sqlIndex.setName(index_name);
            sqlIndex.setUnique(is_unique);
            return this.getSqlIndex(resultSet, sqlIndex);
        }

        @Override
        protected SqlIndex getSqlIndex(ResultSet resultSet, SqlIndex sqlIndex) throws SQLException {
            int ordinal_position = this.intValueOf(resultSet.getObject(3));
            String column_name = resultSet.getString(4);
            String column_option = resultSet.getString(5);
            SqlIndexColumn sqlIndexColumn = new SqlIndexColumn(sqlIndex, sqlIndex.getTable().getSqlColumn(column_name));
            sqlIndexColumn.setName(column_name);
            sqlIndexColumn.setPosition(ordinal_position);
            sqlIndexColumn.setOption(column_option);
            sqlIndex.add(sqlIndexColumn);
            return sqlIndex;
        }

        @Override
        protected SqlTab getSqlTab(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            String tab_name = resultSet.getString(1);
            String default_label = resultSet.getString(2);
            SqlTab sqlTab = new SqlTab(sqlTable);
            sqlTab.setName(tab_name);
            sqlTab.setDefaultLabel(default_label);
            return this.getSqlTab(resultSet, sqlTab);
        }

        @Override
        protected SqlTab getSqlTab(ResultSet resultSet, SqlTab sqlTab) throws SQLException {
            String column_name = resultSet.getString(3);
            SqlTabColumn sqlTabColumn = new SqlTabColumn(sqlTab, sqlTab.getTable().getSqlColumn(column_name));
            sqlTabColumn.setName(column_name);
            sqlTab.add(sqlTabColumn);
            return sqlTab;
        }

        @Override
        protected SqlRoutine getSqlRoutine(ResultSet resultSet, SqlTable sqlTable) throws SQLException {
            String routine_name = resultSet.getString(1);
            String routine_type = resultSet.getString(2);
            SqlRoutine sqlRoutine = new SqlRoutine(sqlTable);
            sqlRoutine.setName(routine_name);
            sqlRoutine.setOperationType(routine_type);
            return this.getSqlRoutine(resultSet, sqlRoutine);
        }

        @Override
        protected SqlRoutine getSqlRoutine(ResultSet resultSet, SqlRoutine sqlRoutine) throws SQLException {
            String parameter_name = resultSet.getString(3);
            if (StringUtils.isBlank((String)parameter_name)) {
                return sqlRoutine;
            }
            String data_type = StringUtils.trimToEmpty((String)resultSet.getString(4));
            boolean is_required = this.booleanValueOf(resultSet.getObject(5));
            boolean is_hidden = this.booleanValueOf(resultSet.getObject(6));
            String parameter_default = StringUtils.trimToNull((String)resultSet.getString(7));
            SqlRoutineParameter sqlRoutineParameter = new SqlRoutineParameter(sqlRoutine);
            sqlRoutineParameter.setName(parameter_name);
            switch (data_type) {
                case "boolean": {
                    sqlRoutineParameter.setType("boolean");
                    break;
                }
                case "\"char\"": {
                    sqlRoutineParameter.setType("char");
                    break;
                }
                case "char": 
                case "character": 
                case "character varying": 
                case "varchar": 
                case "text": {
                    sqlRoutineParameter.setType("string");
                    break;
                }
                case "smallint": 
                case "smallserial": {
                    sqlRoutineParameter.setType("short");
                    break;
                }
                case "integer": 
                case "serial": {
                    sqlRoutineParameter.setType("integer");
                    break;
                }
                case "bigint": 
                case "bigserial": {
                    sqlRoutineParameter.setType("long");
                    break;
                }
                case "decimal": 
                case "numeric": 
                case "money": {
                    sqlRoutineParameter.setType("decimal");
                    break;
                }
                case "real": {
                    sqlRoutineParameter.setType("float");
                    break;
                }
                case "double precision": {
                    sqlRoutineParameter.setType("double");
                    break;
                }
                case "date": {
                    sqlRoutineParameter.setType("date");
                    break;
                }
                case "time": 
                case "time with time zone": 
                case "time without time zone": {
                    sqlRoutineParameter.setType("time");
                    break;
                }
                case "timestamp": 
                case "timestamp with time zone": 
                case "timestamp without time zone": {
                    sqlRoutineParameter.setType("timestamp");
                    break;
                }
                default: {
                    sqlRoutineParameter.setType("string");
                }
            }
            sqlRoutineParameter.setSqlDataType(data_type);
            sqlRoutineParameter.setRequired(is_required);
            sqlRoutineParameter.setHidden(is_hidden);
            sqlRoutineParameter.setDefault(parameter_default);
            sqlRoutineParameter.setSqlDefaultValue(parameter_default);
            sqlRoutine.add(sqlRoutineParameter);
            return sqlRoutine;
        }

        @Override
        protected String stringValueOf(SqlRoutineParameter sqlRoutineParameter, String string) {
            String trimmed = sqlRoutineParameter.isForeign() ? null : StringUtils.trimToNull((String)string);
            String value = trimmed == null ? null : this.stringValueOf(trimmed.toLowerCase(), sqlRoutineParameter.getTrueType());
            return value == null ? super.stringValueOf(sqlRoutineParameter, string) : value;
        }

        protected String stringValueOf(String string, String type) {
            return string == null || type == null ? null : (string.equals("current_date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("current_time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("current_timestamp") && type.equals("date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("current_timestamp") && type.equals("time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("current_timestamp") && type.equals("timestamp") ? "SpecialTemporalValue.CURRENT_TIMESTAMP" : (string.equals("localtime") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("localtimestamp") && type.equals("date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("localtimestamp") && type.equals("time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("localtimestamp") && type.equals("timestamp") ? "SpecialTemporalValue.CURRENT_TIMESTAMP" : (string.equals("now()") && type.equals("date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("now()") && type.equals("time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("now()") && type.equals("timestamp") ? "SpecialTemporalValue.CURRENT_TIMESTAMP" : (string.equals("getdate()") && type.equals("date") ? "SpecialTemporalValue.CURRENT_DATE" : (string.equals("getdate()") && type.equals("time") ? "SpecialTemporalValue.CURRENT_TIME" : (string.equals("getdate()") && type.equals("timestamp") ? "SpecialTemporalValue.CURRENT_TIMESTAMP" : (string.equals("getuser()") && type.equals("long") ? "SpecialNumericValue.CURRENT_USER_ID" : (string.equals("getuser()") && type.equals("string") ? "SpecialCharacterValue.CURRENT_USER" : null)))))))))))))))));
        }
    }
}

