/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql;

import adalid.commons.util.StrUtils;
import adalid.util.sql.SqlArtifact;
import adalid.util.sql.SqlColumn;
import adalid.util.sql.SqlRowValue;
import adalid.util.sql.SqlTable;
import adalid.util.sql.SqlUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SqlRow
extends SqlArtifact {
    private static final Logger logger = Logger.getLogger(SqlRow.class);
    private final SqlTable _table;
    private int _position;
    private final Map<String, SqlRowValue> _values = new LinkedHashMap<String, SqlRowValue>();
    private int values;

    public SqlRow(SqlTable table) {
        this._table = table;
    }

    public SqlTable getTable() {
        return this._table;
    }

    public int getPosition() {
        return this._position;
    }

    void setPosition(int position) {
        this._position = position;
    }

    public Map<String, SqlRowValue> getValuesMap() {
        return this._values;
    }

    public Collection<SqlRowValue> getValues() {
        return this._values.values();
    }

    public SqlRowValue getPrimaryKey() {
        SqlColumn primaryKey = this._table.getPrimaryKey();
        if (primaryKey != null) {
            for (SqlRowValue value : this._values.values()) {
                if (!primaryKey.equals(value.getColumn())) continue;
                return value;
            }
        }
        return null;
    }

    public String getPrimaryKeyValue() {
        SqlRowValue primaryKey = this.getPrimaryKey();
        return primaryKey == null ? null : primaryKey.getValue();
    }

    public SqlRowValue getBusinessKey() {
        SqlColumn businessKey = this._table.getBusinessKey();
        if (businessKey != null) {
            for (SqlRowValue value : this._values.values()) {
                if (!businessKey.equals(value.getColumn())) continue;
                return value;
            }
        }
        return null;
    }

    public String getBusinessKeyValue() {
        SqlRowValue businessKey = this.getBusinessKey();
        return businessKey == null ? null : businessKey.getValue();
    }

    public String getJavaConstantName() {
        String name = this.getName();
        String prefix = name != null && Character.isDigit(name.charAt(0)) ? "_" : "";
        return prefix + StrUtils.getIdentificadorSqlUpperCase(name);
    }

    public String getQualifiedName() {
        return this.getTable().getName() + "." + this.getName();
    }

    void add(SqlRowValue value) {
        value.setPosition(++this.values);
        String name = value.getName();
        if (StringUtils.isBlank((String)name)) {
            String text = "a null name value will not be added to row " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else if (this._values.containsKey(name)) {
            String text = "value " + name + " already added to row " + this.getQualifiedName();
            logger.error((Object)SqlUtil.highlight(text));
        } else {
            this._values.put(name, value);
        }
    }
}

