/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql;

import adalid.util.sql.SqlArtifact;
import adalid.util.sql.SqlColumn;
import adalid.util.sql.SqlRow;
import org.apache.commons.lang.StringUtils;

public class SqlRowValue
extends SqlArtifact {
    private final SqlRow _row;
    private final SqlColumn _column;
    private int _position;
    private Object _object;
    private String _value;
    private String _literal;

    public SqlRowValue(SqlRow row, SqlColumn column) {
        this._row = row;
        this._column = column;
        this.init();
    }

    private void init() {
        String name = this._row.getName() + "$" + this._column.getName();
        this.setName(name);
    }

    public SqlRow getRow() {
        return this._row;
    }

    public SqlColumn getColumn() {
        return this._column;
    }

    public int getPosition() {
        return this._position;
    }

    void setPosition(int position) {
        this._position = position;
    }

    public Object getObject() {
        return this._object;
    }

    void setObject(Object object) {
        this._object = object;
    }

    public String getValue() {
        return this._value;
    }

    void setValue(String value) {
        this._value = value;
    }

    public String getLiteral() {
        return this._literal == null ? "null" : this._literal;
    }

    void setLiteral(String literal) {
        this._literal = literal;
    }

    public boolean isDefaultValue() {
        return StringUtils.equals((String)this._literal, (String)this.getColumn().getSqlDefaultValueLiteral());
    }

    public boolean isPrimaryKeyValue() {
        return this.getColumn() == this.getColumn().getTable().getPrimaryKey();
    }

    public boolean isBusinessKeyValue() {
        return this.getColumn() == this.getColumn().getTable().getBusinessKey();
    }

    public String getQualifiedName() {
        return this.getRow().getName() + "." + this.getRow().getTable().getName() + "." + this.getName();
    }

    public String getUpdateStatement() {
        return "update " + this.getColumn().getTable().getName() + " set " + this.getColumn().getName() + " = " + this.getLiteral() + " where " + this.getColumn().getTable().getPrimaryKey().getName() + " = " + this.getRow().getPrimaryKeyValue() + ";";
    }
}

