/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql;

import adalid.util.sql.SqlColumn;
import adalid.util.sql.SqlColumnPair;
import adalid.util.sql.SqlColumnPairPositionComparator;
import adalid.util.sql.SqlMerger;
import adalid.util.sql.SqlTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SqlTableWrapper {
    private final SqlTable _table;
    private final SqlMerger _merger;
    private final List<SqlColumnPair> _columnPairs = new ArrayList<SqlColumnPair>();
    private boolean _addedColumns;
    private boolean _droppedColumns;
    private boolean _slightlyModifiedColumns;
    private boolean _heavilyModifiedColumns;

    public SqlTableWrapper(SqlTable table, SqlMerger merger) {
        this._table = table;
        this._merger = merger;
    }

    public SqlTable getTable() {
        return this._table;
    }

    public List<SqlColumnPair> getColumnPairs() {
        return this._columnPairs;
    }

    public List<SqlColumnPair> getOrderedPairs() {
        ArrayList<SqlColumnPair> list = new ArrayList<SqlColumnPair>(this._columnPairs);
        SqlColumnPairPositionComparator comparator = new SqlColumnPairPositionComparator();
        Collections.sort(list, comparator);
        return list;
    }

    SqlColumnPair addColumnPair(SqlColumn newColumn, SqlColumn oldColumn) {
        SqlColumnPair pair = new SqlColumnPair(newColumn, oldColumn);
        this._columnPairs.add(pair);
        return pair;
    }

    public boolean hasAddedColumns() {
        return this._addedColumns;
    }

    public void setAddedColumns(boolean b) {
        this._addedColumns = b;
    }

    public boolean hasDroppedColumns() {
        return this._droppedColumns;
    }

    public void setDroppedColumns(boolean b) {
        this._droppedColumns = b;
    }

    public boolean hasSlightlyModifiedColumns() {
        return this._slightlyModifiedColumns;
    }

    public void setSlightlyModifiedColumns(boolean b) {
        this._slightlyModifiedColumns = b;
    }

    public boolean hasHeavilyModifiedColumns() {
        return this._heavilyModifiedColumns;
    }

    public void setHeavilyModifiedColumns(boolean b) {
        this._heavilyModifiedColumns = b;
    }

    public boolean isMigrateable() {
        return !this._table.isCatalogTable() && !this._table.isEnumeration();
    }

    public boolean isCopyable() {
        if (this._addedColumns || this._droppedColumns || this._heavilyModifiedColumns) {
            return false;
        }
        Set<String> currentKeyTableNames = this._merger.getCurrentKeyTableNames();
        for (SqlColumnPair pair : this._columnPairs) {
            String foreignTableName = pair.getNewColumn().getForeignTableName();
            if (foreignTableName == null || !currentKeyTableNames.contains(foreignTableName)) continue;
            return false;
        }
        return true;
    }
}

