/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.uml;

import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.FilUtils;
import adalid.commons.util.PlantUML;
import adalid.commons.util.StrUtils;
import adalid.commons.util.ThrowableUtils;
import adalid.util.Utility;
import adalid.util.io.FileNameRegexFilter;
import adalid.util.io.SmallFile;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RunPlantUML
extends Utility {
    private static final Logger logger = Logger.getLogger(RunPlantUML.class);
    private static final String B = "^";
    private static final String E = "$";
    private static final String X = ".*";
    private static final String D = "\\.";
    private final File rootFolder = PropertiesHandler.getRootFolder();
    private final Path rootFolderPath;
    private final File resourcesFolder;
    private final Path resourcesFolderPath;
    private final File baseFolder;
    private final Path baseFolderPath;
    private final File chosenFile;
    private final Map<Path, SmallFile> files;
    private final Map<String, Integer> fileTypes;
    private boolean detailAll;
    private List<String> detailPatterns;
    private int filesRead;
    private int filesSkipped;
    private int filesWritten;
    private int readingErrors;
    private int writingErrors;
    private static final String at_start = "@start";
    private static final String at_end = "@end";
    private static final int start_length = "@start".length();
    private static final int end_length = "@end".length();
    private static final boolean printDetail = false;

    public static void main(String[] args) {
        RunPlantUML.run(USER_DIR);
    }

    public static boolean run(String path) {
        return RunPlantUML.run(path, false);
    }

    public static boolean run(String path, boolean detail) {
        logger.info((Object)("run(" + path + ")"));
        try {
            RunPlantUML runner = new RunPlantUML(path, detail);
            return runner.run();
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)ThrowableUtils.getString(e));
            return false;
        }
    }

    public static boolean run(String path, List<String> details) {
        logger.info((Object)("run(" + path + ", " + String.valueOf(details) + ")"));
        try {
            RunPlantUML runner = new RunPlantUML(path, details);
            return runner.run();
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)ThrowableUtils.getString(e));
            return false;
        }
    }

    private RunPlantUML(String path) {
        if (this.rootFolder == null) {
            throw new RuntimeException("root folder is missing or invalid");
        }
        this.rootFolderPath = Paths.get(this.rootFolder.getPath(), new String[0]);
        logger.info((Object)("root-folder=" + String.valueOf(this.rootFolderPath)));
        String from = StringUtils.defaultIfBlank((String)FilUtils.replaceSlashes(path), (String)this.rootFolder.getPath());
        logger.info((Object)("from-folder=" + from));
        from = RunPlantUML.chooseFileOrDirectory(from, false, new FileNameRegexFilter("directories or text files", "^.*\\.txt$", true));
        if (from == null) {
            throw new IllegalArgumentException("No file or directory selected, operation cancelled");
        }
        File file = new File(from);
        this.resourcesFolder = file.isAbsolute() ? file : new File(this.rootFolder.getAbsolutePath(), from);
        this.resourcesFolderPath = Paths.get(this.resourcesFolder.getPath(), new String[0]);
        if (this.resourcesFolder.isDirectory()) {
            this.chosenFile = null;
            logger.info((Object)("chosen-path=" + String.valueOf(this.resourcesFolderPath)));
            if (this.resourcesFolder.isHidden()) {
                throw new IllegalArgumentException(String.valueOf(this.resourcesFolderPath) + " is a hidden directory");
            }
        } else if (this.resourcesFolder.isFile()) {
            this.chosenFile = this.resourcesFolder;
            logger.info((Object)("chosen-file=" + this.chosenFile.getPath()));
        } else {
            throw new IllegalArgumentException(String.valueOf(this.resourcesFolderPath) + " is not a directory");
        }
        this.baseFolder = this.resourcesFolder.getParentFile();
        this.baseFolderPath = Paths.get(this.baseFolder.getPath(), new String[0]);
        logger.info((Object)("parent-path=" + String.valueOf(this.baseFolderPath)));
        this.files = new TreeMap<Path, SmallFile>();
        this.fileTypes = new TreeMap<String, Integer>();
    }

    private RunPlantUML(String path, boolean detail) {
        this(path);
        this.detailAll = detail;
    }

    private RunPlantUML(String path, List<String> details) {
        this(path);
        this.detailAll = false;
        this.detailPatterns = details;
    }

    private boolean run() {
        logger.info((Object)("RunPlantUML" + StrUtils.enclose(this.resourcesFolderPath.getFileName().toString())));
        this.init();
        this.readFiles();
        this.printSummary();
        RunPlantUML.updateProjectBuilderDictionary(RunPlantUML.class);
        return this.readingErrors == 0;
    }

    private void init() {
        this.filesRead = 0;
        this.filesSkipped = 0;
        this.filesWritten = 0;
        this.readingErrors = 0;
        this.writingErrors = 0;
    }

    private boolean readFiles() {
        Collection<File> list = this.files();
        for (File file : list) {
            SmallFile sf = new SmallFile(file.getPath());
            sf.read();
            String name = file.getName();
            List<String> lines = sf.getLines();
            Charset charset = sf.getCharset();
            String extension = StringUtils.defaultIfBlank((String)sf.getExtension().toLowerCase(), (String)"?");
            if (charset == null) {
                ++this.readingErrors;
                logger.error((Object)(name + " could not be read using any of the specified character sets "));
                continue;
            }
            if (sf.isEmpty()) {
                ++this.filesRead;
                ++this.filesSkipped;
                logger.warn((Object)(name + " was skipped, it is empty "));
                continue;
            }
            if (this.validFile(lines)) {
                ++this.filesRead;
                this.files.put(sf.getPath(), sf);
                this.updateFileTypes(String.valueOf(charset));
                this.updateFileTypes(String.valueOf(charset) + " / " + extension);
                File image = PlantUML.generateImage(file);
                if (image == null) {
                    ++this.writingErrors;
                    logger.error((Object)(name + " could not be generated "));
                    continue;
                }
                ++this.filesWritten;
                logger.info((Object)(image.getName() + " successfully generated "));
                continue;
            }
            ++this.filesRead;
            ++this.filesSkipped;
            logger.info((Object)(name + " was skipped, it is not a PlantUML file "));
        }
        return true;
    }

    private Collection<File> files() {
        return this.chosenFile != null ? Collections.singletonList(this.chosenFile) : FileUtils.listFiles((File)this.resourcesFolder, (IOFileFilter)this.fileFilter(), (IOFileFilter)this.dirFilter());
    }

    private boolean validFile(List<String> lines) {
        if (lines == null || lines.size() < 2) {
            return false;
        }
        String firstLine = lines.get(0);
        String lastLine = lines.get(lines.size() - 1);
        return firstLine.length() > start_length && lastLine.length() > end_length && firstLine.startsWith(at_start) && lastLine.startsWith(at_end) && firstLine.substring(start_length).equals(lastLine.substring(end_length));
    }

    private void updateFileTypes(String type) {
        if (this.fileTypes.containsKey(type)) {
            int count = this.fileTypes.get(type);
            this.fileTypes.put(type, ++count);
        } else {
            this.fileTypes.put(type, 1);
        }
    }

    private void printSummary() {
        logger.info((Object)(this.filesRead + " files read "));
        logger.info((Object)(this.filesSkipped + " files skipped "));
        logger.info((Object)(this.filesWritten + " files written "));
        logger.info((Object)(this.readingErrors + " reading errors "));
        logger.info((Object)(this.writingErrors + " writing errors "));
    }

    private void printDetail(String type) {
        if (this.detailAll || this.matches(type)) {
            String baseFolderPathString = this.baseFolderPath.toString();
            String tab = type.contains("/") ? "\t" : "";
            for (SmallFile sf : this.files.values()) {
                Charset charset = sf.getCharset();
                String extension = StringUtils.defaultIfBlank((String)sf.getExtension(), (String)"?");
                if (charset == null || !type.equals(String.valueOf(charset) + " / " + extension)) continue;
                logger.info((Object)(tab + "\t" + StringUtils.removeStartIgnoreCase((String)sf.getName(), (String)baseFolderPathString)));
            }
        }
    }

    private boolean matches(String type) {
        if (this.detailPatterns == null || this.detailPatterns.isEmpty()) {
            return false;
        }
        for (String regex : this.detailPatterns) {
            if (!type.matches(regex)) continue;
            return true;
        }
        return false;
    }

    private IOFileFilter fileFilter() {
        IOFileFilter fileFileFilter = FileFilterUtils.fileFileFilter();
        IOFileFilter[] ayes = new IOFileFilter[]{new RegexFileFilter("^.*\\.txt$")};
        IOFileFilter ayesFileFilter = FileFilterUtils.or((IOFileFilter[])ayes);
        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{fileFileFilter, ayesFileFilter});
        return filter;
    }

    private IOFileFilter dirFilter() {
        IOFileFilter[] noes = new IOFileFilter[]{new RegexFileFilter("^.*\\.git$"), new RegexFileFilter("^build$"), new RegexFileFilter("^dist$"), new RegexFileFilter("^target$")};
        return FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.or((IOFileFilter[])noes));
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public Path getRootFolderPath() {
        return this.rootFolderPath;
    }

    public File getResourcesFolder() {
        return this.resourcesFolder;
    }

    public Path getResourcesFolderPath() {
        return this.resourcesFolderPath;
    }

    public File getBaseFolder() {
        return this.baseFolder;
    }

    public Path getBaseFolderPath() {
        return this.baseFolderPath;
    }

    public int getReadingErrors() {
        return this.readingErrors;
    }

    public Map<Path, SmallFile> getFiles() {
        return this.files;
    }

    public Map<String, Integer> getFileTypes() {
        return this.fileTypes;
    }
}

