/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.control.acceso;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Key;
import adalid.core.annotations.BooleanField;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.BooleanDisplayType;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.QuickAddingFilter;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.TableResponsiveMode;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Segment;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.ext.CloakedStringProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.Aplicacion;
import meta.entidad.comun.control.acceso.Rol;

@EntityClass(independent=Kleenean.FALSE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.FEMININE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE)
@EntityInsertOperation(enabled=Kleenean.TRUE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.TRUE)
@EntityTableView(enabled=Kleenean.TRUE, responsiveMode=TableResponsiveMode.PRIORITY)
@EntityDetailView(enabled=Kleenean.FALSE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE)
public class RolAplicacion
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @NameProperty
    @ColumnField(calculable=Kleenean.TRUE)
    public CloakedStringProperty nombre;
    @ForeignKey(onDelete=OnDeleteAction.CASCADE, onUpdate=OnUpdateAction.CASCADE)
    @ManyToOne(navigability=Navigability.BIDIRECTIONAL, view=MasterDetailView.TABLE, viewSequence=30)
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(required=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public Rol rol;
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE, quickAdding=QuickAddingFilter.MISSING)
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(required=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public Aplicacion aplicacion;
    @ColumnField(nullable=Kleenean.FALSE)
    @BooleanField(displayType=BooleanDisplayType.TOGGLE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public BooleanProperty simple;
    protected Key uk_rol_aplicacion_0001;
    protected Segment rolOrdinario;

    public RolAplicacion(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings("rol.grupo");
    }

    @Override
    public boolean isSelectEnabled() {
        return super.isSelectEnabled() && this.isRoleWebAppDissociationAllowed();
    }

    @Override
    public boolean isInsertEnabled() {
        return super.isInsertEnabled() && this.isRoleWebAppDissociationAllowed();
    }

    @Override
    public boolean isUpdateEnabled() {
        return super.isUpdateEnabled() && this.isRoleWebAppDissociationAllowed();
    }

    @Override
    public boolean isDeleteEnabled() {
        return super.isDeleteEnabled() && this.isRoleWebAppDissociationAllowed();
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "role/application dissociation");
        this.setLocalizedLabel(SPANISH, "disociaci\u00f3n Rol/Aplicaci\u00f3n");
        this.setLocalizedCollectionLabel(ENGLISH, "Role/Application Dissociations");
        this.setLocalizedCollectionLabel(SPANISH, "Disociaciones Rol/Aplicaci\u00f3n");
        this.setLocalizedCollectionLabel(ENGLISH, this.rol, "Dissociations by Role");
        this.setLocalizedCollectionLabel(SPANISH, this.rol, "Disociaciones por Rol");
        this.setLocalizedCollectionShortLabel(ENGLISH, this.rol, "Dissociations");
        this.setLocalizedCollectionShortLabel(SPANISH, this.rol, "Disociaciones");
        this.setLocalizedDescription(ENGLISH, "By default, all roles are associated with all applications. Instances of " + this.b("Role/Application Dissociations") + " are used to remove default associations, as follows: a " + this.b("simple") + " dissociation removes the association between the role and the application; a multiple (non-simple) dissociation removes the associations between the role and all applications that do not have a multiple (non-simple) dissociation with the role. ");
        this.setLocalizedDescription(SPANISH, "De manera predeterminada, todos los roles est\u00e1n asociados con todas las aplicaciones. Las instancias de " + this.b("Disociaciones Rol/Aplicaci\u00f3n") + " sirven para eliminar asociaciones predefinidas, de la siguiente manera: una disociaci\u00f3n " + this.b("simple") + " elimina la asociaci\u00f3n entre el rol y la aplicaci\u00f3n; una disociaci\u00f3n m\u00faltiple (no simple) elimina las asociaciones entre el rol y todas las aplicaciones que no tengan una disociaci\u00f3n m\u00faltiple (no simple) con el rol. ");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.nombre.setCalculableValueExpression(RolAplicacion.concatenate(this.aplicacion.codigoAplicacion, SLASH, this.rol.codigoRol));
        this.simple.setDefaultValue(false);
        this.simple.setInitialValue(false);
        this.rol.setLocalizedLabel(ENGLISH, "role");
        this.rol.setLocalizedLabel(SPANISH, "rol");
        this.aplicacion.setLocalizedLabel(ENGLISH, "application");
        this.aplicacion.setLocalizedLabel(SPANISH, "aplicaci\u00f3n");
        this.simple.setLocalizedLabel(ENGLISH, "simple");
        this.simple.setLocalizedLabel(SPANISH, "simple");
        this.simple.setLocalizedDescription(ENGLISH, "a simple dissociation removes the association between the role and the application; a multiple (non-simple) dissociation removes the associations between the role and all applications that do not have a multiple (non-simple) dissociation with the role. ");
        this.simple.setLocalizedDescription(SPANISH, "una disociaci\u00f3n simple elimina la asociaci\u00f3n entre el rol y la aplicaci\u00f3n; una disociaci\u00f3n m\u00faltiple (no simple) elimina las asociaciones entre el rol y todas las aplicaciones que no tengan una disociaci\u00f3n m\u00faltiple (no simple) con el rol. ");
        this.simple.setLocalizedTooltip(ENGLISH, this.simple.getLocalizedTooltip(ENGLISH));
        this.simple.setLocalizedTooltip(SPANISH, this.simple.getLocalizedTooltip(SPANISH));
    }

    @Override
    protected void settleLinks() {
        super.settleLinks();
        this.linkForeignSegmentProperty(this.rol.grupo);
    }

    @Override
    protected void settleKeys() {
        super.settleKeys();
        this.uk_rol_aplicacion_0001.setUnique(true);
        this.uk_rol_aplicacion_0001.newKeyField(this.rol, this.aplicacion);
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.rolOrdinario = this.rol.esRolEspecial.isFalse();
        this.rolOrdinario.setLocalizedDescription(ENGLISH, "the role is not a special role");
        this.rolOrdinario.setLocalizedDescription(SPANISH, "el rol no es un rol especial");
        this.rolOrdinario.setLocalizedErrorMessage(ENGLISH, "the role is a special role");
        this.rolOrdinario.setLocalizedErrorMessage(SPANISH, "el rol es un rol especial");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.setMasterDetailFilter(this.rol.rolesOrdinarios);
        this.setInsertFilter(this.rol.rolesOrdinarios);
        this.setUpdateFilter(this.rolOrdinario);
        this.setDeleteFilter(this.rolOrdinario);
    }
}

