/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package build;

import adalid.core.annotations.*;
import meta.psm.ProjectAttributeKeys;

/**
 * @author Jorge Campins
 */
@MasterProject(acronym = showcase.meta.proyecto.Maestro.ACRONYM, alias = Maestro101.ALIAS, helpFile = Maestro101.ALIAS, runnable = false)
public class Maestro101 extends showcase.meta.proyecto.Maestro101 {

    public static void main(String[] args) throws Exception {
        newInstance(Maestro101.class).build(PLATAFORMA_MAVEN_POSTGRESQL_GLASSFISH);
    }

    @Override
    public void addAttributes() {
        super.addAttributes();
        addAttribute(ProjectAttributeKeys.URI_SCHEME, "http");
        addAttribute(ProjectAttributeKeys.URI_AUTHORITY, "192.168.0.100:8080");
    }

    @Override
    public void configureBuilder() {
        super.configureBuilder();
        loadKeyFeatures();
    }

    @Override
    public void configureGenerator() {
        super.configureGenerator();
        setPlantUMLEnabled(false);
        putEnvironmentVariable(JASPERREPORTS_VERSION, "7.0.1");
        putEnvironmentVariable(JASPERREPORTS_DATA_ADAPTER, "DataAdapter.jrdax");
        setVersion("1.0.0");
    }

}
