/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package build;

import adalid.commons.util.FilUtils;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.jee2.ProjectDependency;
import adalid.jee2.ProjectModuleType;
import meta.psm.ProjectAttributeKeys;
import showcase.meta.psm.MavenDependencies;

/**
 * @author Jorge Campins
 */
@MasterProject(acronym = showcase.meta.proyecto.Maestro.ACRONYM, alias = Maestro102.ALIAS, helpFile = Maestro102.ALIAS, runnable = true)
public class Maestro102 extends showcase.meta.proyecto.Maestro102 {

    public static void main(String[] args) throws Exception {
        newInstance(Maestro102.class).build(PLATAFORMA_MAVEN_POSTGRESQL_WILDFLY);
    }

    @Override
    public void addAttributes() {
        super.addAttributes();
        addAttribute(ProjectAttributeKeys.ALTERNATE_DOCUMENT_ROOT_SECURED, true);
        addAttribute(ProjectAttributeKeys.LOGIN_LOGGING, false);
        addAttribute(ProjectAttributeKeys.INVALID_LOGIN_LOGGING, true);
        addAttribute(ProjectAttributeKeys.LOGIN_NOTIFICATION, false);
        addAttribute(ProjectAttributeKeys.INVALID_LOGIN_NOTIFICATION, true);
        addAttribute(ProjectAttributeKeys.MEDIA_FILE_EXPOSURE_RISK_ACCEPTABLE, true);
        addAttribute(ProjectAttributeKeys.URI_SCHEME, "http");
        addAttribute(ProjectAttributeKeys.URI_AUTHORITY, "192.168.0.100:8080");
    }

    @Override
    public void configureBuilder() {
        super.configureBuilder();
        loadKeyFeatures();
    }

    @Override
    public void configureGenerator() {
        super.configureGenerator();
        setGoogleAuthenticatorEnabled(true);
        setGoogleCloudStorageEnabled(true);
        setGoogleCloudStorageBucket("pet-project-bucket-2");
        setGoogleSignInEnabled(true);
        setPlantUMLEnabled(true);
        setProjectTextingEnabled(true);
        setDefaultSMSProvider(ShortMessageServiceProvider.TELEMO_GROUP);
        setProjectRecaptchaEnabled(true);
        setProjectRecaptchaSiteVerificationEnabled(true);
        setGoogleRecaptchaSiteKey(FilUtils.scanTextFile(System.getenv("GoogleRecaptchaSiteKey")));
        putEnvironmentVariable(CONTENT_ROOT_DIR_LINUX, "/opt/content-root");
        putEnvironmentVariable(CONTENT_ROOT_DIR_WINDOWS, "%SystemDrive%/content-root");
//      putEnvironmentVariable(JASPERREPORTS_VERSION, "7.0.1");
//      putEnvironmentVariable(JASPERREPORTS_DATA_ADAPTER, "DataAdapter.jrdax");
        addProjectDependency(
            ProjectDependency.of(
                "org.apache.httpcomponents.core",
                "org-apache-httpcomponents-core",
                "main"
            ),
            ProjectModuleType.JDS
        );
        addProjectDependency(MavenDependencies.Apache.httpclient(), ProjectModuleType.WEB); // utilizado por la clase ServicioPersonas
        addProjectDependency(MavenDependencies.PrimeFaces.freya(), ProjectModuleType.WEB);
        addProjectDependency(MavenDependencies.PrimeFaces.serenity(), ProjectModuleType.WEB);
        setVersion("1.0.0");
        strongPasswordValidatorRules.prohibit(); // prohibe los substrings predefinidos
    }

    @Override
    public void addDirectives() {
        super.addDirectives();
//      addFilePreservationPattern("^.*/webapp/WEB-INF/faces-config\\.xml$"); // preserva los archivos .gitignore
    }

}
