/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.cliente;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import adalid.core.properties.ext.*;
import adalid.jee2.constants.*;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;
import meta.entidad.comun.control.acceso.Usuario;
import showcase.meta.entidad.configuracion.*;
import showcase.meta.entidad.configuracion.fija.*;
import showcase.meta.operacion.cliente.*;
import showcase.meta.propiedad.*;

@AbstractClass
@EntityCodeGen(bws = Kleenean.TRUE, fws = Kleenean.TRUE)
@EntityDataGen(start = 1, step = 1, stop = 100)
@EntitySelectOperation(onload = SelectOnloadOption.PROMPT)
@EntityTableView(inserts = Kleenean.FALSE, updates = Kleenean.FALSE, rows = 5)
@InheritanceMapping(strategy = InheritanceMappingStrategy.JOINED)
public class Cliente extends PersistentEntityBase {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public Cliente(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        addAllocationStrings(
            "global.paisSede",
            "jurisdiccion.superior",
            "municipio.distrito.departamento",
            "distrito.departamento",
            "direccionPrincipal.cliente"
        );
    }

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of Cliente's attributes">
        setLocalizedLabel(ENGLISH, "customer");
        setLocalizedCollectionLabel(ENGLISH, "Customers");
        // </editor-fold>
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of Cliente's properties">
        tipo.setLocalizedLabel(ENGLISH, "customer type");
        tipo.setLocalizedLabel(SPANISH, "tipo de cliente");
        /**/
        codigo.setLocalizedLabel(ENGLISH, "code");
        codigo.setLocalizedLabel(SPANISH, "código");
        codigo.setLocalizedRegexErrorMessage(ENGLISH, "client code does not conform to the specified pattern; It must be a sequence of characters of up to 3 capital letters followed by a sequence of up to 7 digits; for example, N1005323");
        codigo.setLocalizedRegexErrorMessage(SPANISH, "código de cliente no cumple con el patrón especificado;  debe ser una secuencia caracteres de hasta 3 letras mayúsculas seguida de una secuencia de hasta 7 digitos; por ejemplo, N1005323");
        /**/
        nombre.setLocalizedLabel(ENGLISH, "customer name");
        nombre.setLocalizedShortLabel(ENGLISH, "name");
        /**/
        imagen.setLocalizedLabel(ENGLISH, "image");
        imagen.setLocalizedTooltip(ENGLISH, "client's photo or logo");
        imagen.setLocalizedTooltip(SPANISH, "foto o logo del cliente");
        /**/
        archivoImagen.setLocalizedLabel(ENGLISH, "image file");
        archivoImagen.setLocalizedLabel(SPANISH, "archivo imagen");
        archivoImagen.setLocalizedTooltip(ENGLISH, "URL of the file that contains the image (photo or logo) of the client");
        archivoImagen.setLocalizedTooltip(SPANISH, "URL del archivo que contiene la imagen (foto o logo) del cliente");
        /**/
        actividadEconomica.setLocalizedLabel(ENGLISH, "economic activity");
        actividadEconomica.setLocalizedLabel(SPANISH, "actividad económica");
        /**/
        fechaInicioRelacion.setLocalizedLabel(ENGLISH, "relationship start date");
        fechaInicioRelacion.setLocalizedLabel(SPANISH, "fecha de inicio de la relación");
        fechaInicioRelacion.setLocalizedShortLabel(ENGLISH, "start");
        fechaInicioRelacion.setLocalizedShortLabel(SPANISH, "inicio");
        /**/
        ejecutivo.setLocalizedLabel(ENGLISH, "client executive");
        ejecutivo.setLocalizedShortLabel(ENGLISH, "executive");
        /**/
        global.setLocalizedLabel(ENGLISH, "global setting");
        global.setLocalizedLabel(SPANISH, "configuración global");
        global.setLocalizedShortLabel(ENGLISH, "setting");
        global.setLocalizedShortLabel(SPANISH, "configuración");
        /**/
        pais.setLocalizedLabel(ENGLISH, "country");
        pais.setLocalizedLabel(SPANISH, "país");
        /**/
        jurisdiccion.setLocalizedLabel(ENGLISH, "jurisdiction");
        jurisdiccion.setLocalizedLabel(SPANISH, "jurisdicción");
        /**/
        departamento.setLocalizedLabel(ENGLISH, "department");
        /**/
        distrito.setLocalizedLabel(ENGLISH, "district");
        /**/
        municipio.setLocalizedLabel(ENGLISH, "municipality");
        /**/
        telefonoFijo.setLocalizedLabel(ENGLISH, "landline");
        telefonoFijo.setLocalizedLabel(SPANISH, "teléfono fijo");
        /**/
        telefonoMovil.setLocalizedLabel(ENGLISH, "mobile phone");
        telefonoMovil.setLocalizedLabel(SPANISH, "teléfono móvil");
        /**/
        telefonoInteligente.setLocalizedLabel(ENGLISH, "WhatsApp phone number");
        telefonoInteligente.setLocalizedLabel(SPANISH, "número de teléfono WhatsApp");
        telefonoInteligente.setLocalizedDescription(ENGLISH, "mobile phone number capable of running WhatsApp; " + PHONE_REGEX_ENGLISH_DESCRIPTION);
        telefonoInteligente.setLocalizedDescription(SPANISH, "número de teléfono móvil capaz de ejecutar WhatsApp; " + PHONE_REGEX_SPANISH_DESCRIPTION);
        telefonoInteligente.setLocalizedShortDescription(ENGLISH, "mobile phone number capable of running WhatsApp; " + PHONE_REGEX_ENGLISH_DESCRIPTION);
        telefonoInteligente.setLocalizedShortDescription(SPANISH, "número de teléfono móvil capaz de ejecutar WhatsApp; " + PHONE_REGEX_SPANISH_DESCRIPTION);
        /*
        telefonoInteligente.setLocalizedRegexErrorMessage(ENGLISH, PHONE_REGEX_ENGLISH_ERROR_MESSAGE);
        telefonoInteligente.setLocalizedRegexErrorMessage(SPANISH, PHONE_REGEX_SPANISH_ERROR_MESSAGE);
        /**/
        correoElectronico.setLocalizedLabel(ENGLISH, "email");
        correoElectronico.setLocalizedLabel(SPANISH, "correo electrónico");
        correoElectronico.setLocalizedRegexErrorMessage(ENGLISH, "email does not meet the required pattern");
        correoElectronico.setLocalizedRegexErrorMessage(SPANISH, "correo electrónico no cumple con el patrón requerido");
        /**/
        paginaWeb.setLocalizedLabel(ENGLISH, "Web page");
        paginaWeb.setLocalizedLabel(SPANISH, "página web");
        /**/
        direccionPrincipal.setLocalizedLabel(ENGLISH, "Main address");
        /**/
        analizado.setLocalizedLabel(ENGLISH, "analyzed");
        analizado.setLocalizedTooltip(ENGLISH, "the client's credit analysis has already been carried out");
        analizado.setLocalizedTooltip(SPANISH, "el análisis de crédito del cliente ya se llevó a cabo");
        /**/
        aprobado.setLocalizedLabel(ENGLISH, "approved");
        aprobado.setLocalizedTooltip(ENGLISH, "the customer's credit limit has been approved");
        aprobado.setLocalizedTooltip(SPANISH, "el límite de crédito del cliente ha sido aprobado");
        /**/
        auditado.setLocalizedLabel(ENGLISH, "audited");
        auditado.setLocalizedTooltip(ENGLISH, "the analysis and/or approval of the client's credit limit has been audited");
        auditado.setLocalizedTooltip(SPANISH, "el análisis y/o la aprobación del límite de crédito del cliente han sido auditados");
        /**/
        ingresoPromedio.setLocalizedLabel(ENGLISH, "average income");
        ingresoPromedio.setLocalizedLabel(SPANISH, "ingreso promedio");
        /**/
        limiteCredito.setLocalizedLabel(ENGLISH, "credit limit");
        limiteCredito.setLocalizedLabel(SPANISH, "límite de crédito");
        /**/
        formaPago.setLocalizedLabel(ENGLISH, "payment method");
        formaPago.setLocalizedLabel(SPANISH, "forma de pago");
        formaPago.setLocalizedAnchoredLabel(ENGLISH, "method");
        formaPago.setLocalizedAnchoredLabel(SPANISH, "medio de pago");
        /**/
        banco.setLocalizedLabel(ENGLISH, "bank");
        banco.setLocalizedAnchoredLabel(ENGLISH, "bank");
        banco.setLocalizedDescription(ENGLISH, "bank to which the account or card corresponds; it is only necessary if the payment method is Check or Card");
        banco.setLocalizedDescription(SPANISH, "banco al que corresponde la cuenta o la tarjeta; solo es necesario si la forma de pago es Cheque o Tarjeta");
        /**/
        tarjeta.setLocalizedLabel(ENGLISH, "card number");
        tarjeta.setLocalizedAnchoredLabel(ENGLISH, "card");
        tarjeta.setLocalizedDescription(ENGLISH, "credit or debit card number used for payment; it is only necessary if the payment method is Card");
        tarjeta.setLocalizedDescription(SPANISH, "número de tarjeta de crédito o débito utilizada para el pago; solo es necesaria si la forma de pago es Tarjeta");
        // </editor-fold>
    }

    @Override
    protected void localizeSteps() {
        super.localizeSteps();
        // <editor-fold defaultstate="collapsed" desc="localization of Cliente's steps">
        step001.setLocalizedLabel(ENGLISH, "Basic customer information");
        step001.setLocalizedLabel(SPANISH, "Datos básicos del cliente");
        step001.setLocalizedShortLabel(ENGLISH, "customer");
        step001.setLocalizedShortLabel(SPANISH, "cliente");
        /**/
        step002.setLocalizedLabel(ENGLISH, "Contact information");
        step002.setLocalizedLabel(SPANISH, "Información de contacto");
        step002.setLocalizedShortLabel(ENGLISH, "contact");
        step002.setLocalizedShortLabel(SPANISH, "contacto");
        /**/
        step003.setLocalizedLabel(ENGLISH, "Credit information and payment method");
        step003.setLocalizedLabel(SPANISH, "Información de crédito y forma de pago");
        step003.setLocalizedShortLabel(ENGLISH, "credit and payment method");
        step003.setLocalizedShortLabel(SPANISH, "crédito y forma de pago");
        // </editor-fold>
    }

    @Override
    protected void localizeTabs() {
        super.localizeTabs();
        // <editor-fold defaultstate="collapsed" desc="localization of Cliente's tabs">
        tab001.setLocalizedLabel(ENGLISH, "Basic customer information");
        tab001.setLocalizedLabel(SPANISH, "Datos básicos del cliente");
        tab001.setLocalizedShortLabel(ENGLISH, "customer");
        tab001.setLocalizedShortLabel(SPANISH, "cliente");
        /**/
        tab002.setLocalizedLabel(ENGLISH, "Contact information");
        tab002.setLocalizedLabel(SPANISH, "Información de contacto");
        tab002.setLocalizedShortLabel(ENGLISH, "contact");
        tab002.setLocalizedShortLabel(SPANISH, "contacto");
        /**/
        tab003.setLocalizedLabel(ENGLISH, "Credit information and payment method");
        tab003.setLocalizedLabel(SPANISH, "Información de crédito y forma de pago");
        tab003.setLocalizedShortLabel(ENGLISH, "credit and payment method");
        tab003.setLocalizedShortLabel(SPANISH, "crédito y forma de pago");
        // </editor-fold>
    }

    @Override
    protected void localizeViews() {
        super.localizeViews();
        // <editor-fold defaultstate="collapsed" desc="localization of Cliente's views">
        v1.setLocalizedLabel(ENGLISH, "Clients by Jurisdiction, Economic Activity and Client Type");
        v1.setLocalizedLabel(SPANISH, "Clientes por Jurisdicción, Actividad Económica y Tipo de Cliente");
        ViewField vf0001 = v1.getField(jurisdiccion.codigo);
        if (vf0001 != null) {
            vf0001.setLocalizedLabel(ENGLISH, "jurisdiction");
            vf0001.setLocalizedLabel(SPANISH, "jurisdicción");
        }
        ViewField vf0002 = v1.getField(jurisdiccion.nombre);
        if (vf0002 != null) {
            vf0002.setLocalizedLabel(ENGLISH, "name");
        }
        ViewField vf0003 = v1.getField(jurisdiccion.superior.codigo);
        if (vf0003 != null) {
            vf0003.setLocalizedLabel(ENGLISH, "higher jurisdiction");
            vf0003.setLocalizedLabel(SPANISH, "jurisdicción superior");
        }
        ViewField vf0004 = v1.getField(jurisdiccion.superior.nombre);
        if (vf0004 != null) {
            vf0004.setLocalizedLabel(ENGLISH, "top jurisdiction name");
            vf0004.setLocalizedLabel(SPANISH, "nombre de jurisdicción superior");
        }
        ViewField vf0005 = v1.getField(actividadEconomica.codigo);
        if (vf0005 != null) {
            vf0005.setLocalizedLabel(ENGLISH, "economic activity");
            vf0005.setLocalizedLabel(SPANISH, "actividad económica");
        }
        ViewField vf0006 = v1.getField(actividadEconomica.nombre);
        if (vf0006 != null) {
            vf0006.setLocalizedLabel(ENGLISH, "name");
        }
        ViewField vf0007 = v1.getField(tipo.codigo);
        if (vf0007 != null) {
            vf0007.setLocalizedLabel(ENGLISH, "customer type");
            vf0007.setLocalizedLabel(SPANISH, "tipo de cliente");
        }
        ViewField vf0008 = v1.getField(codigo);
        if (vf0008 != null) {
            vf0008.setLocalizedLabel(ENGLISH, "code");
        }
        ViewField vf0009 = v1.getField(nombre);
        if (vf0009 != null) {
            vf0009.setLocalizedLabel(ENGLISH, "name");
        }
        ViewField vf0010 = v1.getField(fechaInicioRelacion);
        if (vf0010 != null) {
            vf0010.setLocalizedLabel(ENGLISH, "beginning of the relationship");
            vf0010.setLocalizedLabel(SPANISH, "inicio de la relación");
            vf0010.setLocalizedShortLabel(ENGLISH, "client since");
            vf0010.setLocalizedShortLabel(SPANISH, "cliente desde");
        }
        ViewField vf0011 = v1.getField(analizado);
        if (vf0011 != null) {
            vf0011.setLocalizedLabel(ENGLISH, "analyzed");
        }
        ViewField vf0012 = v1.getField(aprobado);
        if (vf0012 != null) {
            vf0012.setLocalizedLabel(ENGLISH, "approved");
        }
        ViewField vf0013 = v1.getField(auditado);
        if (vf0013 != null) {
            vf0013.setLocalizedLabel(ENGLISH, "audited");
        }
        ViewField vf0014 = v1.getField(limiteCredito);
        if (vf0014 != null) {
            vf0014.setLocalizedLabel(ENGLISH, "credit limit");
        }
        // </editor-fold>
    }

    @Override
    protected void localizeExpressions() {
        super.localizeExpressions();
        // <editor-fold defaultstate="collapsed" desc="localization of Cliente's expressions">
        clientesAAA.setLocalizedCollectionLabel(ENGLISH, "all clients with credit analyzed, approved and audited");
        clientesAAA.setLocalizedCollectionLabel(SPANISH, "todos los clientes con crédito analizado, aprobado y auditado");
        clientesAAA.setLocalizedCollectionShortLabel(ENGLISH, "AAA clients");
        clientesAAA.setLocalizedCollectionShortLabel(SPANISH, "Clientes AAA");
        clientesAAA.setLocalizedDescription(ENGLISH, "the client's credit is analyzed, approved and audited");
        clientesAAA.setLocalizedDescription(SPANISH, "el crédito del cliente está analizado, aprobado y auditado");
        clientesAAA.setLocalizedErrorMessage(ENGLISH, "the client's credit is not analyzed, approved and audited");
        clientesAAA.setLocalizedErrorMessage(SPANISH, "el crédito del cliente no está analizado, aprobado y auditado");
        /**/
        misClientes.setLocalizedCollectionLabel(ENGLISH, "all clients whose executive is the current user");
        misClientes.setLocalizedCollectionLabel(SPANISH, "todos los clientes cuyo ejecutivo es el usuario actual");
        misClientes.setLocalizedCollectionShortLabel(ENGLISH, "My clients");
        misClientes.setLocalizedCollectionShortLabel(SPANISH, "Mis clientes");
        misClientes.setLocalizedDescription(ENGLISH, "the current user is the client's executive");
        misClientes.setLocalizedDescription(SPANISH, "el usuario actual es el ejecutivo del cliente");
        misClientes.setLocalizedErrorMessage(ENGLISH, "the current user is not the client's executive");
        misClientes.setLocalizedErrorMessage(SPANISH, "el usuario actual no es el ejecutivo del cliente");
        /**/
        pagoConEfectivo.setLocalizedDescription(ENGLISH, "the payment method is cash");
        pagoConEfectivo.setLocalizedDescription(SPANISH, "la forma de pago es efectivo");
        pagoConEfectivo.setLocalizedErrorMessage(ENGLISH, "the payment method is not cash");
        pagoConEfectivo.setLocalizedErrorMessage(SPANISH, "la forma de pago no es efectivo");
        /**/
        pagoConCheque.setLocalizedDescription(ENGLISH, "the payment method is check");
        pagoConCheque.setLocalizedDescription(SPANISH, "la forma de pago es cheque");
        pagoConCheque.setLocalizedErrorMessage(ENGLISH, "the payment method is not check");
        pagoConCheque.setLocalizedErrorMessage(SPANISH, "la forma de pago no es cheque");
        /**/
        pagoConTarjeta.setLocalizedDescription(ENGLISH, "the payment method is card");
        pagoConTarjeta.setLocalizedDescription(SPANISH, "la forma de pago es tarjeta");
        pagoConTarjeta.setLocalizedErrorMessage(ENGLISH, "the payment method is not card");
        pagoConTarjeta.setLocalizedErrorMessage(SPANISH, "la forma de pago no es tarjeta");
        /**/
        check101.setLocalizedErrorMessage(ENGLISH, "If the payment is in cash then the bank cannot be specified");
        check101.setLocalizedErrorMessage(SPANISH, "si el pago es en efectivo entonces no se puede especificar el banco");
        /**/
        check103.setLocalizedErrorMessage(ENGLISH, "If the payment is in cash then the card cannot be specified");
        check103.setLocalizedErrorMessage(SPANISH, "si el pago es en efectivo entonces no se puede especificar la tarjeta");
        /**/
        check111.setLocalizedErrorMessage(ENGLISH, "If payment is by check then the bank must be specified");
        check111.setLocalizedErrorMessage(SPANISH, "si el pago es con cheque entonces se tiene que especificar el banco");
        /**/
        check113.setLocalizedErrorMessage(ENGLISH, "If payment is by check then the card cannot be specified");
        check113.setLocalizedErrorMessage(SPANISH, "si el pago es con cheque entonces no se puede especificar la tarjeta");
        /**/
        check121.setLocalizedErrorMessage(ENGLISH, "If the payment is by card then the bank must be specified");
        check121.setLocalizedErrorMessage(SPANISH, "si el pago es con tarjeta entonces se tiene que especificar el banco");
        /**/
        check123.setLocalizedErrorMessage(ENGLISH, "If the payment is by card then the card must be specified");
        check123.setLocalizedErrorMessage(SPANISH, "si el pago es con tarjeta entonces se tiene que especificar la tarjeta");
        // </editor-fold>
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
    }

    @DiscriminatorColumn
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    public TipoCliente tipo;

    @BusinessKey
    @StringField(maxLength = 10, regex = "^[A-Za-z]{1,3}[0-9]{1,7}$", letterCase = LetterCase.UPPER, allowDiacritics = Kleenean.FALSE)
    public StringProperty codigo;

    @NameProperty
    public StringProperty nombre;

    @ImageProperty(displayWidth = {144, 96, 72}, displayHeight = {192, 128, 96}, avatarShape = AvatarShape.CIRCLE)
    @PropertyField(table = Kleenean.TRUE, overlay = Kleenean.TRUE)
    public BinaryProperty imagen;

    @ColumnField(calculable = Kleenean.TRUE)
    @FileReference(types = MimeType.IMAGE, blobField = "imagen")
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.FALSE, report = Kleenean.FALSE)
    public StringProperty archivoImagen;

    @ColumnField(nullable = Kleenean.FALSE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.TRUE, search = Kleenean.TRUE, table = Kleenean.FALSE)
    @EntityReferenceSearch(searchType = SearchType.DISPLAY, displayMode = DisplayMode.WRITING)
    public ActividadEconomica actividadEconomica;

    @DateField(disabledWeekends = Kleenean.TRUE, disabledHolidays = Kleenean.TRUE, yearRange = 5)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, search = Kleenean.TRUE, table = Kleenean.TRUE, report = Kleenean.FALSE, overlay = Kleenean.TRUE)
    @TemporalDataGen(type = DataGenType.RANDOM, min = "-10Y", max = "0")
    public DateProperty fechaInicioRelacion;

    @OwnerProperty
    @SegmentProperty
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, table = Kleenean.TRUE, overlay = Kleenean.TRUE, prominent = Kleenean.TRUE, defaultCheckpoint = Checkpoint.USER_INTERFACE)
    public Usuario ejecutivo;

    @ColumnField(calculable = Kleenean.TRUE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(hidden = Kleenean.TRUE)
    public ConfiguracionGlobal global;

    @ColumnField(nullable = Kleenean.FALSE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.TRUE, table = Kleenean.TRUE, overlay = Kleenean.TRUE, required = Kleenean.TRUE, defaultCheckpoint = Checkpoint.USER_INTERFACE)
    public Pais pais;

    @ColumnField(nullable = Kleenean.TRUE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.TRUE, search = Kleenean.TRUE, table = Kleenean.FALSE)
//  @EntityReferenceDisplay(style = EntityReferenceStyle.CHARACTER_KEY_AND_NAME)
    @EntityReferenceSearch(searchType = SearchType.DISPLAY, displayFormat = SearchDisplayFormat.TREE, displayMode = DisplayMode.WRITING)
    @EntityReferenceDataGen(nullable = 0, type = DataGenType.RANDOM)
    public Jurisdiccion jurisdiccion;

    @ColumnField(calculable = Kleenean.TRUE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.FALSE)
    @EntityReferenceSearch(searchType = SearchType.LIST)
    public Departamento departamento;

    @ColumnField(calculable = Kleenean.TRUE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.FALSE)
    @EntityReferenceSearch(searchType = SearchType.LIST)
    public Distrito distrito;

    @ColumnField(nullable = Kleenean.TRUE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.TABLE_AND_DETAIL)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.FALSE)
    @EntityReferenceSearch(searchType = SearchType.LIST)
    @EntityReferenceDataGen(nullable = 0, type = DataGenType.RANDOM)
    public Municipio municipio;

    @ColumnField(nullable = Kleenean.TRUE)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.FALSE)
//  @StringField(maxLength = 20, regex = "^\\d{1,5}\\-\\d{1,7}$")
    @StringField(maxLength = 20, mask = "(999) 999-9999[ x9999]", autoComplete = AutoComplete.OFF)
    @CharacterDataGen(type = DataGenType.RANDOM, pattern = "(000) 000-0000 \\x0000")
    public StringProperty telefonoFijo;

    @ColumnField(nullable = Kleenean.TRUE)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.FALSE)
//  @StringField(maxLength = 20, regex = "^\\d{1,5}\\-\\d{1,7}$")
    @StringField(maxLength = 20, mask = "(999) 999-9999", autoComplete = AutoComplete.OFF)
    @CharacterDataGen(type = DataGenType.RANDOM, pattern = "(000) 000-0000")
    public StringProperty telefonoMovil;

    @PropertyField(create = Kleenean.TRUE, table = Kleenean.FALSE, report = Kleenean.FALSE)
    public LocalSmartphoneNumberProperty telefonoInteligente;

    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.FALSE)
    public EmailAddressProperty correoElectronico;

    @UrlProperty(urlDisplayType = UrlDisplayType.BUTTON, urlType = UrlType.EXTERNAL)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.FALSE)
    @CharacterDataGen(type = DataGenType.DEFAULT)
    public StringProperty paginaWeb;

    @ColumnField(nullable = Kleenean.TRUE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @OneToOne()
    @EntityReferenceDisplay(style = EntityReferenceStyle.NAME)
    @EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME, displayMode = DisplayMode.WRITING)
    @CharacterDataGen(type = DataGenType.DEFAULT)
//  @PropertyField(create = Kleenean.TRUE)
    public DireccionCliente direccionPrincipal;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, search = Kleenean.TRUE, table = Kleenean.FALSE, report = Kleenean.FALSE, overlay = Kleenean.TRUE)
    public BooleanProperty analizado;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, search = Kleenean.TRUE, table = Kleenean.TRUE, report = Kleenean.FALSE, overlay = Kleenean.TRUE)
    public BooleanProperty aprobado;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, search = Kleenean.TRUE, table = Kleenean.FALSE, report = Kleenean.FALSE, overlay = Kleenean.TRUE)
    @BooleanDataGen(nullable = 50)
    public BooleanProperty auditado;

    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, search = Kleenean.TRUE, table = Kleenean.TRUE, access = PropertyAccess.RESTRICTED_READING)
    @NumericDataGen(type = DataGenType.RANDOM, nullable = 0, min = "100", max = "200", action = DataGenNumericAction.TRUNCATE, factor = "100")
    public PropiedadDinero ingresoPromedio;

    @PropertyAggregation(function = AggregateFunction.AVERAGE)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, search = Kleenean.TRUE, table = Kleenean.TRUE, access = PropertyAccess.RESTRICTED_WRITING, overlay = Kleenean.TRUE)
    @NumericDataGen(type = DataGenType.RANDOM, nullable = 0, min = "100", max = "200", action = DataGenNumericAction.TRUNCATE, factor = "100")
    public PropiedadDinero limiteCredito;

    @ColumnField(nullable = Kleenean.FALSE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.FALSE, required = Kleenean.TRUE)
    @EntityReferenceDataGen(type = DataGenType.DEFAULT)
    public FormaPago formaPago;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.FALSE, anchor = "formaPago", anchorType = AnchorType.INLINE)
    @EntityReferenceDataGen(type = DataGenType.DEFAULT)
    @EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME, displayMode = DisplayMode.WRITING)
    public Banco banco;

    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.FALSE, anchor = "banco", anchorType = AnchorType.INLINE)
    @StringField(maxLength = 20)
    @CharacterDataGen(type = DataGenType.DEFAULT)
    public StringProperty tarjeta;

    /*
    @OneToMany(targetEntity = DireccionCliente.class, mappedBy = "cliente", cascade = {CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH})
    @EntityCollectionField(format = DataEntryFormat.DETAIL_OR_TABLE)
    public EntityCollection direcciones;

    /**/
    @Override
    protected void settleProperties() {
        super.settleProperties();
        /**/
        codigo.setDefaultLabel("código");
        codigo.setDefaultRegexErrorMessage("código de cliente no cumple con el patrón especificado;  "
            + "debe ser una secuencia caracteres de hasta 3 letras mayúsculas seguida de una secuencia de hasta 7 digitos; "
            + "por ejemplo, N1005323");
        /**/
        imagen.setDefaultLabel("imagen");
        imagen.setDefaultTooltip("foto o logo del cliente");
        /**/
        imagen.setAvatarDefault(AvatarDefault.UNSEEN);
        /**/
        archivoImagen.setDefaultLabel("archivo imagen");
        archivoImagen.setDefaultTooltip("URL del archivo que contiene la imagen (foto o logo) del cliente");
        /**/
        archivoImagen.setCalculableValueExpression(imagen.fileReferenceCalculableValueExpression());
        /**/
        fechaInicioRelacion.setDefaultLabel("fecha de inicio de la relación");
        fechaInicioRelacion.setDefaultShortLabel("inicio");
        /**/
        global.setInitialValue(global.GLOBAL);
//      global.setDefaultValue(global.GLOBAL);
        global.setCalculableValueExpression(global.GLOBAL.toEntityExpression());
        /**/
        pais.setInitialValue(global.paisSede);
        pais.setDefaultValue(global.paisSede);
        /**/
        distrito.setMasterDependentProperties(departamento);
        /**/
        telefonoFijo.setDefaultLabel("teléfono fijo");
        /*
        telefonoFijo.setDefaultRegexErrorMessage("número de teléfono fijo no cumple con el patrón especificado; "
            + "debe ser un grupo de 1 a 5 digitos seguido por un grupo de 1 a 7 digitos; "
            + "los grupos se deben separar con un guión; "
            + "por ejemplo, 021-491841");
        /**/
        telefonoMovil.setDefaultLabel("teléfono móvil");
        /*
        telefonoMovil.setDefaultRegexErrorMessage("número de teléfono móvil no cumple con el patrón especificado;  "
            + "debe ser un grupo de 1 a 5 digitos seguido por un grupo de 1 a 7 digitos; "
            + "los grupos se deben separar con un guión; "
            + "por ejemplo, 0992-920115");
        /**/
        telefonoInteligente.setDefaultLabel("número de teléfono inteligente");
        /**/
        correoElectronico.setDefaultLabel("correo electrónico");
        correoElectronico.setDefaultRegexErrorMessage("correo electrónico no cumple con el patrón requerido");
        /**/
        paginaWeb.setDefaultLabel("página web");
        /**/
        analizado.setDefaultLabel("analizado");
        aprobado.setDefaultLabel("aprobado");
        auditado.setDefaultLabel("auditado");
        /**/
        analizado.setDefaultTooltip("el análisis de crédito del cliente ya se llevó a cabo");
        aprobado.setDefaultTooltip("el límite de crédito del cliente ha sido aprobado");
        auditado.setDefaultTooltip("el análisis y/o la aprobación del límite de crédito del cliente han sido auditados");
        /**/
        ingresoPromedio.setDefaultLabel("ingreso promedio");
        /**/
        ingresoPromedio.setMaxValue(10000000);
        /**/
        limiteCredito.setDefaultLabel("límite de crédito");
        /**/
        limiteCredito.setMaxValue(50000);
        /**/
        // <editor-fold defaultstate="collapsed" desc="limiteCredito">
        /**/
//      String imagenLimiteCredito1 = xs(XS.codePointClass(0x2205) + XS.WITH_SIZE_LG);
        String imagenLimiteCredito1 = fa(FA.NULL_VALUE + FA.WITH_SIZE_LG);
        String imagenLimiteCredito2 = fa(W3.TEXT_INDIGO + FA.CHECK_CIRCLE + FA.WITH_SIZE_LG);
        String imagenLimiteCredito3 = fa(W3.TEXT_BLUE + FA.CHECK_CIRCLE + FA.WITH_SIZE_LG);
        String imagenLimiteCredito4 = fa(W3.TEXT_TEAL + FA.CHECK_CIRCLE + FA.WITH_SIZE_LG);
        String imagenLimiteCredito5 = fa(W3.TEXT_GREEN + FA.CHECK_CIRCLE + FA.WITH_SIZE_LG);
        String imagenLimiteCredito6 = fa(W3.TEXT_DEEP_ORANGE + FA.EXCLAMATION_CIRCLE + FA.WITH_SIZE_LG);
        String imagenLimiteCredito7 = fa(W3.TEXT_PINK + FA.EXCLAMATION_CIRCLE + FA.WITH_SIZE_LG);
        /**/
        CharacterExpression imagenLimiteCreditoX = limiteCredito.isNull().then(imagenLimiteCredito1).
            otherwise(limiteCredito.isLessThan(500).then(imagenLimiteCredito2).
                otherwise(limiteCredito.isLessThan(1000).then(imagenLimiteCredito3).
                    otherwise(limiteCredito.isLessThan(2000).then(imagenLimiteCredito4).
                        otherwise(limiteCredito.isLessThan(5000).then(imagenLimiteCredito5).
                            otherwise(limiteCredito.isLessThan(10000).then(imagenLimiteCredito6).
                                otherwise(imagenLimiteCredito7))))));

        /**/
        limiteCredito.setGraphicImageFontAwesomeClassNameExpression(imagenLimiteCreditoX);
        limiteCredito.setMissingValueGraphicImageName(fa(FA.MISSING_VALUE + FA.WITH_SIZE_LG));
        limiteCredito.setNullValueGraphicImageName(fa(FA.NULL_VALUE + FA.WITH_SIZE_LG));
        limiteCredito.setUnnecessaryValueGraphicImageName(fa(FA.UNNECESSARY_VALUE + FA.WITH_SIZE_LG));
        /**/
        limiteCredito.setDefaultGraphicImageTooltip(imagenLimiteCredito1, "valor no especificado");
        limiteCredito.setDefaultGraphicImageTooltip(imagenLimiteCredito2, "limite de crédito < 500");
        limiteCredito.setDefaultGraphicImageTooltip(imagenLimiteCredito3, "limite de crédito < 1.000");
        limiteCredito.setDefaultGraphicImageTooltip(imagenLimiteCredito4, "limite de crédito < 2.000");
        limiteCredito.setDefaultGraphicImageTooltip(imagenLimiteCredito5, "limite de crédito < 5.000");
        limiteCredito.setDefaultGraphicImageTooltip(imagenLimiteCredito6, "limite de crédito < 10.000");
        limiteCredito.setDefaultGraphicImageTooltip(imagenLimiteCredito7, "limite de crédito >= 10.000");
        /**/
        limiteCredito.setLocalizedGraphicImageTooltip(ENGLISH, imagenLimiteCredito1, "unspecified value");
        limiteCredito.setLocalizedGraphicImageTooltip(ENGLISH, imagenLimiteCredito2, "credit limit < 500");
        limiteCredito.setLocalizedGraphicImageTooltip(ENGLISH, imagenLimiteCredito3, "credit limit < 1.000");
        limiteCredito.setLocalizedGraphicImageTooltip(ENGLISH, imagenLimiteCredito4, "credit limit < 2.000");
        limiteCredito.setLocalizedGraphicImageTooltip(ENGLISH, imagenLimiteCredito5, "credit limit < 5.000");
        limiteCredito.setLocalizedGraphicImageTooltip(ENGLISH, imagenLimiteCredito6, "credit limit < 10.000");
        limiteCredito.setLocalizedGraphicImageTooltip(ENGLISH, imagenLimiteCredito7, "credit limit >= 10.000");
        /**/
        // </editor-fold>
        /**/
        formaPago.setInitialValue(formaPago.EFECTIVO);
        formaPago.setDefaultValue(formaPago.EFECTIVO);
        /**/
        formaPago.setDefaultAnchoredLabel("medio de pago");
        /**/
        banco.setDefaultAnchoredLabel("banco");
        banco.setDefaultDescription("banco al que corresponde la cuenta o la tarjeta; solo es necesario si la forma de pago es Cheque o Tarjeta");
        /**/
        tarjeta.setDefaultAnchoredLabel("tarjeta");
        tarjeta.setDefaultDescription("número de tarjeta de crédito o débito utilizada para el pago; solo es necesaria si la forma de pago es Tarjeta");
        /**/
    }

    @Override
    protected void settleCollections() {
        super.settleCollections();
        /*
        direcciones.setDefaultLabel("direcciones del cliente");
        direcciones.setDefaultShortLabel("direcciones");
        direcciones.setLocalizedDescription(SPANISH, "colección de direcciones del cliente");
        direcciones.addCount(1);
        /**/
    }

    @Override
    protected void settleLinks() {
        super.settleLinks();
        /**/
        departamento.linkCalculableValueEntityReference(municipio.distrito.departamento);
        distrito.linkCalculableValueEntityReference(municipio.distrito);
        /**/
        linkForeignQueryProperty(municipio.distrito.codigo);
        linkForeignQueryProperty(municipio.distrito.nombre);
        linkForeignQueryProperty(municipio.distrito.departamento.codigo);
        linkForeignQueryProperty(municipio.distrito.departamento.nombre);
    }

    protected Step step001, step002, step003;

    @Override
    protected void settleSteps() {
        super.settleSteps();
//      step001.setSequenceNumber(1);
        step001.setDefaultLabel("Datos básicos del cliente");
        step001.setDefaultShortLabel("cliente");
        step001.newStepField(codigo, nombre, imagen, archivoImagen, fechaInicioRelacion, actividadEconomica);
//      step002.setSequenceNumber(2);
        step002.setDefaultLabel("Información de contacto");
        step002.setDefaultShortLabel("contacto");
        step002.newStepField(pais);
        step002.newStepField(jurisdiccion);
        step002.newStepField(departamento);
        step002.newStepField(distrito);
        step002.newStepField(municipio);
        step002.newStepField(telefonoFijo);
        step002.newStepField(telefonoMovil);
        step002.newStepField(telefonoInteligente);
        step002.newStepField(correoElectronico);
        step002.newStepField(paginaWeb);
//      step002.newStepField(direcciones);
        step002.newStepField(direccionPrincipal);
//      step003.setSequenceNumber(3);
        step003.setDefaultLabel("Información de crédito y forma de pago");
        step003.setDefaultShortLabel("crédito y forma de pago");
        step003.newStepField(analizado, aprobado, auditado, ingresoPromedio, limiteCredito);
        step003.newStepField(formaPago, banco, tarjeta);
    }

    protected Tab tab001, tab002, tab003;

    @Override
    protected void settleTabs() {
        super.settleTabs();
        tab001.copy(step001, false); // false para una copia superficial, excluyendo los campos del paso.
        tab001.newTabField(imagen, archivoImagen, fechaInicioRelacion, actividadEconomica);
        tab002.copy(step002);
        tab003.copy(step003);
    }

    protected View v1;

    @Override
    protected void settleViews() {
        super.settleViews();
        /**/
        ViewField vf;
        /**/
        v1.setDefaultLabel("Clientes por Jurisdicción, Actividad Económica y Tipo de Cliente");
        vf = v1.newControlField(jurisdiccion.codigo);
        vf.setDefaultLabel("jurisdicción");
        v1.newHeadingField(jurisdiccion.nombre, jurisdiccion.codigo);
        vf = v1.newHeadingField(jurisdiccion.superior.codigo, jurisdiccion.codigo);
        vf.setDefaultLabel("jurisdicción superior");
        vf = v1.newHeadingField(jurisdiccion.superior.nombre, jurisdiccion.codigo);
        vf.setDefaultLabel("nombre de jurisdicción superior");
        vf = v1.newControlField(actividadEconomica.codigo);
        vf.setDefaultLabel("actividad económica");
        v1.newHeadingField(actividadEconomica.nombre, actividadEconomica.codigo);
        vf = v1.newControlField(tipo.codigo);
        vf.setDefaultLabel("tipo de cliente");
        v1.newDetailField(codigo);
        v1.newDetailField(nombre, SortOption.ASC);
        vf = v1.newDetailField(fechaInicioRelacion);
        vf.setDefaultLabel("inicio de la relación");
        vf.setDefaultShortLabel("cliente desde");
        vf.setPixels(96);
        vf = v1.newDetailField(analizado);
        vf.setPixels(64);
        vf = v1.newDetailField(aprobado);
        vf.setPixels(64);
        vf = v1.newDetailField(auditado);
        vf.setPixels(64);
        v1.newDetailField(limiteCredito, ViewFieldAggregation.AVERAGE_DEVIATION_MINIMUM_MAXIMUM);
    }

    protected Segment clientesAAA, misClientes;

    protected Segment pagoConEfectivo, pagoConCheque, pagoConTarjeta;

    protected Check check101, check103, check111, check113, check121, check123;
//
//  Check check201, check202;

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        /**/
        clientesAAA = and(analizado, aprobado, auditado);
        clientesAAA.setDefaultCollectionLabel("todos los clientes con crédito analizado, aprobado y auditado");
        clientesAAA.setDefaultCollectionShortLabel("Clientes AAA");
        clientesAAA.setDefaultDescription("el crédito del cliente está analizado, aprobado y auditado");
        clientesAAA.setDefaultErrorMessage("el crédito del cliente no está analizado, aprobado y auditado");
        /**/
        misClientes = ejecutivo.id.isEqualTo(CURRENT_USER_ID);
        misClientes.setDefaultCollectionLabel("todos los clientes cuyo ejecutivo es el usuario actual");
        misClientes.setDefaultCollectionShortLabel("Mis clientes");
        misClientes.setDefaultDescription("el usuario actual es el ejecutivo del cliente");
        misClientes.setDefaultErrorMessage("el usuario actual no es el ejecutivo del cliente");
        /**/
        pagoConEfectivo = formaPago.isEqualTo(formaPago.EFECTIVO);
        pagoConEfectivo.setDefaultDescription("la forma de pago es efectivo");
        pagoConEfectivo.setDefaultErrorMessage("la forma de pago no es efectivo");
        /**/
        pagoConCheque = formaPago.isEqualTo(formaPago.CHEQUE);
        pagoConCheque.setDefaultDescription("la forma de pago es cheque");
        pagoConCheque.setDefaultErrorMessage("la forma de pago no es cheque");
        /**/
        pagoConTarjeta = formaPago.isEqualTo(formaPago.TARJETA);
        pagoConTarjeta.setDefaultDescription("la forma de pago es tarjeta");
        pagoConTarjeta.setDefaultErrorMessage("la forma de pago no es tarjeta");
        /**/
        check101 = pagoConEfectivo.implies(banco.isNull());
        check101.setDefaultErrorMessage("si el pago es en efectivo entonces no se puede especificar el banco");
        /**/
        check103 = pagoConEfectivo.implies(tarjeta.isNull());
        check103.setDefaultErrorMessage("si el pago es en efectivo entonces no se puede especificar la tarjeta");
        /**/
        check111 = pagoConCheque.implies(banco.isNotNull());
        check111.setDefaultErrorMessage("si el pago es con cheque entonces se tiene que especificar el banco");
        /**/
        check113 = pagoConCheque.implies(tarjeta.isNull());
        check113.setDefaultErrorMessage("si el pago es con cheque entonces no se puede especificar la tarjeta");
        /**/
        check121 = pagoConTarjeta.implies(banco.isNotNull());
        check121.setDefaultErrorMessage("si el pago es con tarjeta entonces se tiene que especificar el banco");
        /**/
        check123 = pagoConTarjeta.implies(tarjeta.isNotNull());
        check123.setDefaultErrorMessage("si el pago es con tarjeta entonces se tiene que especificar la tarjeta");
        /*
        check201 = distrito.isNotNull().implies(distrito.departamento.isEqualTo(departamento));
        check201.setDefaultLabel("chequear distrito");
        check201.setDefaultDescription("el distrito debería pertenecer al departamento especificado");
        check201.setDefaultErrorMessage("el distrito no pertenece al departamento especificado");
        //
        check202 = municipio.isNotNull().implies(municipio.distrito.isEqualTo(distrito));
        check202.setDefaultLabel("chequear municipio");
        check202.setDefaultDescription("el municipio debería pertenecer al distrito especificado");
        check202.setDefaultErrorMessage("el municipio no pertenece al distrito especificado");
        //
        check300 = or(
            correoElectronico.endsWith("@gmail.com"),
            correoElectronico.endsWith("@hotmail.com"),
            correoElectronico.endsWith("@outlook.com"),
            correoElectronico.endsWith("@yahoo.com")
        );
        check300.setDefaultErrorMessage("el dominio del correo electrónico no es válido; "
            + "debe ser gmail.com, hotmail.com, outlook.com o yahoo.com");
        /**/
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        /**/
        addSelectSegment(clientesAAA, misClientes);
        /*
        archivoImagen.setRenderingFilter(UNTRUTH, true);
        /**/
        limiteCredito.setRequiringFilter(aprobado);
        /**/
        direccionPrincipal.setSearchQueryFilter(direccionPrincipal.cliente.isEqualTo(this));
        /**/
        jurisdiccion.setModifyingFilter(pais.sede);
        jurisdiccion.setNullifyingFilter(not(pais.sede));
        jurisdiccion.setRenderingFilter(pais.sede, true);
        /**/
        departamento.setModifyingFilter(pais.sede);
        departamento.setNullifyingFilter(not(pais.sede));
        departamento.setRenderingFilter(pais.sede, true);
        /**/
        distrito.setModifyingFilter(pais.sede);
        distrito.setNullifyingFilter(not(pais.sede));
        distrito.setSearchQueryFilter(distrito.departamento.isEqualTo(departamento));
        distrito.setRenderingFilter(pais.sede, true);
        /**/
        municipio.setModifyingFilter(pais.sede);
        municipio.setNullifyingFilter(not(pais.sede));
        municipio.setSearchQueryFilter(municipio.distrito.isEqualTo(distrito));
        municipio.setRenderingFilter(pais.sede, true);
        /**/
        banco.setModifyingFilter(pagoConCheque.or(pagoConTarjeta));
        banco.setRenderingFilter(pagoConCheque.or(pagoConTarjeta), true);
        banco.setRequiringFilter(pagoConCheque.or(pagoConTarjeta));
        banco.setNullifyingFilter(pagoConEfectivo);
        /**/
        tarjeta.setModifyingFilter(pagoConTarjeta);
        tarjeta.setRenderingFilter(pagoConTarjeta, true);
        tarjeta.setRequiringFilter(pagoConTarjeta);
        tarjeta.setNullifyingFilter(pagoConEfectivo.or(pagoConCheque));
    }

    protected AprobarCredito aprobarCredito;

    protected AdjuntarDocumento adjuntarDocumento;

    protected CargarImagen cargarImagen;

}
