/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.cliente;

import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import adalid.core.properties.ext.GoogleMapProperty;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;
import showcase.meta.entidad.configuracion.Ciudad;
import showcase.meta.entidad.configuracion.Departamento;

@EntityDataGen
@EntityClass(independent = Kleenean.FALSE, resourceType = ResourceType.OPERATION, resourceGender = ResourceGender.FEMININE)
public class DireccionCliente extends PersistentEntityBase {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public DireccionCliente(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        addAllocationStrings(
            "ciudad.departamento"
        );
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("dirección del cliente");
        setDefaultCollectionLabel("Direcciones del Cliente");
    }

    @ColumnField(nullable = Kleenean.FALSE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.TABLE_AND_DETAIL)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE, heading = Kleenean.TRUE)
    public Cliente cliente;

    @NameProperty
    public StringProperty direccion;

    @ColumnField(calculable = Kleenean.TRUE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.TRUE, anchor = "direccion", anchorType = AnchorType.INLINE)
    @EntityReferenceSearch(searchType = SearchType.LIST)
    public Departamento departamento;

    @ColumnField()
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.TRUE, anchor = "departamento", anchorType = AnchorType.INLINE)
    @EntityReferenceSearch(searchType = SearchType.LIST)
    public Ciudad ciudad;

    @ColumnField()
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.TRUE, anchor = "departamento", anchorType = AnchorType.INLINE)
    @StringField(maxLength = 10)
    public StringProperty codigoPostal;

    @PropertyField(create = Kleenean.TRUE, table = Kleenean.TRUE, report = Kleenean.TRUE)
    @CharacterDataGen(type = DataGenType.RANDOM, pattern = "000-0000, 000-0000")
    public StringProperty telefonos;

    /*
    @EmbeddedDocument(sourceType = EmbeddedDocumentType.IFRAME, sourceURLs = EMBED_MAPS, searchURL = GOOGLE_MAPS, displayWidth = 640, displayHeight = 480)
    @StringField(converter = GOOGLE_MAPS_EMBED_CONVERTER)
    @PropertyField(create = Kleenean.TRUE)
    public StringProperty mapa;

    /**/
    @EmbeddedDocument
    @PropertyField(create = Kleenean.TRUE)
    public GoogleMapProperty mapa;

    @Override
    protected void settleProperties() {
        super.settleProperties();
        /**/
        direccion.setDefaultLabel("dirección");
        direccion.setDefaultAnchorLabel("dirección");
        direccion.setDefaultAnchoredLabel("dirección");
        direccion.setDefaultDescription("calle o avenida, número, apartamento o suite o unidad, edificio, piso, etc.");
        /**/
        telefonos.setDefaultLabel("teléfonos");
        /*
        mapa.setDefaultDescription(GOOGLE_MAPS_EMBED_SPANISH_DESCRIPTION);
        mapa.setDefaultShortDescription(GOOGLE_MAPS_EMBED_SPANISH_SHORT_DESCRIPTION);
        mapa.setDefaultTooltip(GOOGLE_MAPS_EMBED_SPANISH_TOOLTIP);
        /*
        mapa.setLocalizedDescription(ENGLISH, GOOGLE_MAPS_EMBED_ENGLISH_DESCRIPTION);
        mapa.setLocalizedShortDescription(ENGLISH, GOOGLE_MAPS_EMBED_ENGLISH_SHORT_DESCRIPTION);
        mapa.setLocalizedTooltip(ENGLISH, GOOGLE_MAPS_EMBED_ENGLISH_TOOLTIP);
        /**/
    }

    @Override
    protected void settleLinks() {
        super.settleLinks();
        /**/
        departamento.linkCalculableValueEntityReference(ciudad.departamento);
        /**/
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        /**/
        ciudad.setSearchQueryFilter(ciudad.departamento.isEqualTo(departamento));
        /**/
    }

}
