/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.cliente;

import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import java.lang.reflect.Field;

@DiscriminatorValue("2")
@EntityDataGen(start = 1, step = 1, stop = 25)
@EntityDetailView(enabled = Kleenean.TRUE, menu = ViewMenuOption.WRITING, inserting = Kleenean.TRUE)
public class PersonaJuridica extends Cliente {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public PersonaJuridica(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of PersonaJuridica's attributes">
        setLocalizedLabel(ENGLISH, "legal person");
        setLocalizedLabel(SPANISH, "persona jurídica");
        setLocalizedCollectionLabel(ENGLISH, "Legal persons");
        setLocalizedCollectionLabel(SPANISH, "Personas Jurídicas");
        // </editor-fold>
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of PersonaJuridica's properties">
        fechaRegistro.setLocalizedLabel(ENGLISH, "registration date");
        /**/
        capitalPagado.setLocalizedLabel(ENGLISH, "paid-in capital");
        /**/
        capitalSuscrito.setLocalizedLabel(ENGLISH, "subscribed capital");
        /**/
        contacto.setLocalizedLabel(ENGLISH, "contact");
        /**/
        matriz.setLocalizedLabel(ENGLISH, "matrix");
        // </editor-fold>
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("persona jurídica");
        setDefaultCollectionLabel("Personas Jurídicas");
        setDefaultMenuOptionLabel(DisplayFormat.DETAIL, "Agregar Personas Jurídicas");
        /**/
        setLocalizedMenuOptionLabel(ENGLISH, DisplayFormat.DETAIL, "Add Legal Persons");
        /**/
    }

    @PropertyField(create = Kleenean.TRUE)
    @TemporalDataGen(type = DataGenType.RANDOM, min = "-60Y", max = "-21Y")
    public DateProperty fechaRegistro;

    @PropertyField(create = Kleenean.TRUE)
    @NumericDataGen(type = DataGenType.RANDOM, min = "10000", max = "1000000")
    public BigDecimalProperty capitalPagado;

    @PropertyField(create = Kleenean.TRUE)
    @NumericDataGen(type = DataGenType.RANDOM, min = "10000", max = "1000000")
    public BigDecimalProperty capitalSuscrito;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.TRUE)
    @EntityReferenceSearch(displayMode = DisplayMode.WRITING)
    public PersonaFisica contacto;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.TRUE, report = Kleenean.TRUE)
    @EntityReferenceSearch(displayMode = DisplayMode.WRITING)
    public PersonaJuridica matriz;

    @Override
    protected void settleProperties() {
        super.settleProperties();
        imagen.setAvatarDefault(AvatarDefault.COMPANY);
        fechaRegistro.setMinValue("1901-01-01");
        fechaRegistro.setMaxValue(CURRENT_DATE);
        contacto.setDefaultLabel("contacto");
        matriz.setDefaultLabel("matriz");
    }

    @Override
    protected void settleSteps() {
        super.settleSteps();
        step001.newStepField(fechaRegistro, capitalPagado, capitalSuscrito, contacto, matriz);
    }

    @Override
    protected void settleTabs() {
        super.settleTabs();
        tab001.newTabField(fechaRegistro, capitalPagado, capitalSuscrito, contacto, matriz);
    }

}
