/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.cliente.i18n;

import adalid.core.ViewField;
import adalid.core.interfaces.Artifact;
import java.lang.reflect.Field;

/**
 * Cliente is a generated java file.
 * <ul>
 * <li>template: templates/meta/java/i18n/component.vm</li>
 * <li>template-author: Jorge Campins</li>
 * <li>file-encoding: UTF-8</li>
 * <li>file-preserve: false -> file will be replaced when regenerating the project</li>
 * </ul>
 *
 * @author ADALID (template by Jorge Campins)
 */
public class Cliente extends showcase.meta.entidad.cliente.Cliente {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public Cliente(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of Cliente's attributes">
        setLocalizedLabel(ENGLISH, "customer");
        setLocalizedCollectionLabel(ENGLISH, "Customers");
        // </editor-fold>
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of Cliente's properties">
        tipo.setLocalizedLabel(ENGLISH, "customer type");
//      tipo.setLocalizedLabel(SPANISH, "tipo de cliente");
        /**/
        codigo.setLocalizedLabel(ENGLISH, "code");
//      codigo.setLocalizedLabel(SPANISH, "código");
        codigo.setLocalizedRegexErrorMessage(ENGLISH, "client code does not conform to the specified pattern; It must be a sequence of characters of up to 3 capital letters followed by a sequence of up to 7 digits; for example, N1005323");
//      codigo.setLocalizedRegexErrorMessage(SPANISH, "código de cliente no cumple con el patrón especificado;  debe ser una secuencia caracteres de hasta 3 letras mayúsculas seguida de una secuencia de hasta 7 digitos; por ejemplo, N1005323");
        /**/
        nombre.setLocalizedLabel(ENGLISH, "customer name");
        nombre.setLocalizedShortLabel(ENGLISH, "name");
        /**/
        imagen.setLocalizedLabel(ENGLISH, "image");
        imagen.setLocalizedTooltip(ENGLISH, "client's photo or logo");
//      imagen.setLocalizedTooltip(SPANISH, "foto o logo del cliente");
        /**/
        archivoImagen.setLocalizedLabel(ENGLISH, "image file");
//      archivoImagen.setLocalizedLabel(SPANISH, "archivo imagen");
        archivoImagen.setLocalizedTooltip(ENGLISH, "URL of the file that contains the image (photo or logo) of the client");
//      archivoImagen.setLocalizedTooltip(SPANISH, "URL del archivo que contiene la imagen (foto o logo) del cliente");
        /**/
        actividadEconomica.setLocalizedLabel(ENGLISH, "economic activity");
//      actividadEconomica.setLocalizedLabel(SPANISH, "actividad económica");
        /**/
        fechaInicioRelacion.setLocalizedLabel(ENGLISH, "relationship start date");
//      fechaInicioRelacion.setLocalizedLabel(SPANISH, "fecha de inicio de la relación");
        fechaInicioRelacion.setLocalizedShortLabel(ENGLISH, "start");
//      fechaInicioRelacion.setLocalizedShortLabel(SPANISH, "inicio");
        /**/
        ejecutivo.setLocalizedLabel(ENGLISH, "client executive");
        ejecutivo.setLocalizedShortLabel(ENGLISH, "executive");
        /**/
        global.setLocalizedLabel(ENGLISH, "global setting");
//      global.setLocalizedLabel(SPANISH, "configuración global");
        global.setLocalizedShortLabel(ENGLISH, "setting");
//      global.setLocalizedShortLabel(SPANISH, "configuración");
        /**/
        pais.setLocalizedLabel(ENGLISH, "country");
//      pais.setLocalizedLabel(SPANISH, "país");
        /**/
        jurisdiccion.setLocalizedLabel(ENGLISH, "jurisdiction");
//      jurisdiccion.setLocalizedLabel(SPANISH, "jurisdicción");
        /**/
        departamento.setLocalizedLabel(ENGLISH, "department");
        /**/
        distrito.setLocalizedLabel(ENGLISH, "district");
        /**/
        municipio.setLocalizedLabel(ENGLISH, "municipality");
        /**/
        telefonoFijo.setLocalizedLabel(ENGLISH, "landline");
//      telefonoFijo.setLocalizedLabel(SPANISH, "teléfono fijo");
        /**/
        telefonoMovil.setLocalizedLabel(ENGLISH, "mobile phone");
//      telefonoMovil.setLocalizedLabel(SPANISH, "teléfono móvil");
        /**/
        telefonoInteligente.setLocalizedLabel(ENGLISH, "WhatsApp phone number");
//      telefonoInteligente.setLocalizedLabel(SPANISH, "número de teléfono WhatsApp");
        telefonoInteligente.setLocalizedDescription(ENGLISH, "mobile phone number capable of running WhatsApp; " + PHONE_REGEX_ENGLISH_DESCRIPTION);
//      telefonoInteligente.setLocalizedDescription(SPANISH, "número de teléfono móvil capaz de ejecutar WhatsApp; " + PHONE_REGEX_SPANISH_DESCRIPTION);
        telefonoInteligente.setLocalizedShortDescription(ENGLISH, "mobile phone number capable of running WhatsApp; " + PHONE_REGEX_ENGLISH_DESCRIPTION);
//      telefonoInteligente.setLocalizedShortDescription(SPANISH, "número de teléfono móvil capaz de ejecutar WhatsApp; " + PHONE_REGEX_SPANISH_DESCRIPTION);
        /*
        telefonoInteligente.setLocalizedRegexErrorMessage(ENGLISH, PHONE_REGEX_ENGLISH_ERROR_MESSAGE);
        telefonoInteligente.setLocalizedRegexErrorMessage(SPANISH, PHONE_REGEX_SPANISH_ERROR_MESSAGE);
        /**/
        correoElectronico.setLocalizedLabel(ENGLISH, "email");
//      correoElectronico.setLocalizedLabel(SPANISH, "correo electrónico");
        correoElectronico.setLocalizedRegexErrorMessage(ENGLISH, "email does not meet the required pattern");
//      correoElectronico.setLocalizedRegexErrorMessage(SPANISH, "correo electrónico no cumple con el patrón requerido");
        /**/
        paginaWeb.setLocalizedLabel(ENGLISH, "Web page");
//      paginaWeb.setLocalizedLabel(SPANISH, "página web");
        /**/
        direccionPrincipal.setLocalizedLabel(ENGLISH, "Main address");
        /**/
        analizado.setLocalizedLabel(ENGLISH, "analyzed");
        analizado.setLocalizedTooltip(ENGLISH, "the client's credit analysis has already been carried out");
//      analizado.setLocalizedTooltip(SPANISH, "el análisis de crédito del cliente ya se llevó a cabo");
        /**/
        aprobado.setLocalizedLabel(ENGLISH, "approved");
        aprobado.setLocalizedTooltip(ENGLISH, "the customer's credit limit has been approved");
//      aprobado.setLocalizedTooltip(SPANISH, "el límite de crédito del cliente ha sido aprobado");
        /**/
        auditado.setLocalizedLabel(ENGLISH, "audited");
        auditado.setLocalizedTooltip(ENGLISH, "the analysis and/or approval of the client's credit limit has been audited");
//      auditado.setLocalizedTooltip(SPANISH, "el análisis y/o la aprobación del límite de crédito del cliente han sido auditados");
        /**/
        ingresoPromedio.setLocalizedLabel(ENGLISH, "average income");
//      ingresoPromedio.setLocalizedLabel(SPANISH, "ingreso promedio");
        /**/
        limiteCredito.setLocalizedLabel(ENGLISH, "credit limit");
//      limiteCredito.setLocalizedLabel(SPANISH, "límite de crédito");
        /**/
        formaPago.setLocalizedLabel(ENGLISH, "way to pay");
//      formaPago.setLocalizedLabel(SPANISH, "forma de pago");
        formaPago.setLocalizedAnchoredLabel(ENGLISH, "medio de pago");
//      formaPago.setLocalizedAnchoredLabel(SPANISH, "medio de pago");
        /**/
        banco.setLocalizedLabel(ENGLISH, "bank");
        banco.setLocalizedAnchoredLabel(ENGLISH, "banco");
        banco.setLocalizedDescription(ENGLISH, "bank to which the account or card corresponds; It is only necessary if the payment method is Check or Card");
//      banco.setLocalizedDescription(SPANISH, "banco al que corresponde la cuenta o la tarjeta; solo es necesario si la forma de pago es Cheque o Tarjeta");
        /**/
        tarjeta.setLocalizedLabel(ENGLISH, "card");
        tarjeta.setLocalizedAnchoredLabel(ENGLISH, "tarjeta");
        tarjeta.setLocalizedDescription(ENGLISH, "credit or debit card number used for payment; It is only necessary if the payment method is Card");
//      tarjeta.setLocalizedDescription(SPANISH, "número de tarjeta de crédito o débito utilizada para el pago; solo es necesaria si la forma de pago es Tarjeta");
        // </editor-fold>
    }

    @Override
    protected void localizeSteps() {
        super.localizeSteps();
        // <editor-fold defaultstate="collapsed" desc="localization of Cliente's steps">
        step001.setLocalizedLabel(ENGLISH, "Basic customer information");
//      step001.setLocalizedLabel(SPANISH, "Datos básicos del cliente");
        step001.setLocalizedShortLabel(ENGLISH, "customer");
//      step001.setLocalizedShortLabel(SPANISH, "cliente");
        /**/
        step002.setLocalizedLabel(ENGLISH, "Contact information");
//      step002.setLocalizedLabel(SPANISH, "Información de contacto");
        step002.setLocalizedShortLabel(ENGLISH, "contact");
//      step002.setLocalizedShortLabel(SPANISH, "contacto");
        /**/
        step003.setLocalizedLabel(ENGLISH, "Credit information and payment method");
//      step003.setLocalizedLabel(SPANISH, "Información de crédito y forma de pago");
        step003.setLocalizedShortLabel(ENGLISH, "credit and payment method");
//      step003.setLocalizedShortLabel(SPANISH, "crédito y forma de pago");
        // </editor-fold>
    }

    @Override
    protected void localizeTabs() {
        super.localizeTabs();
        // <editor-fold defaultstate="collapsed" desc="localization of Cliente's tabs">
        tab001.setLocalizedLabel(ENGLISH, "Basic customer information");
//      tab001.setLocalizedLabel(SPANISH, "Datos básicos del cliente");
        tab001.setLocalizedShortLabel(ENGLISH, "customer");
//      tab001.setLocalizedShortLabel(SPANISH, "cliente");
        /**/
        tab002.setLocalizedLabel(ENGLISH, "Contact information");
//      tab002.setLocalizedLabel(SPANISH, "Información de contacto");
        tab002.setLocalizedShortLabel(ENGLISH, "contact");
//      tab002.setLocalizedShortLabel(SPANISH, "contacto");
        /**/
        tab003.setLocalizedLabel(ENGLISH, "Credit information and payment method");
//      tab003.setLocalizedLabel(SPANISH, "Información de crédito y forma de pago");
        tab003.setLocalizedShortLabel(ENGLISH, "credit and payment method");
//      tab003.setLocalizedShortLabel(SPANISH, "crédito y forma de pago");
        // </editor-fold>
    }

    @Override
    protected void localizeViews() {
        super.localizeViews();
        // <editor-fold defaultstate="collapsed" desc="localization of Cliente's views">
        v1.setLocalizedLabel(ENGLISH, "Clients by Jurisdiction, Economic Activity and Client Type");
//      v1.setLocalizedLabel(SPANISH, "Clientes por Jurisdicción, Actividad Económica y Tipo de Cliente");
        ViewField vf0001 = v1.getField(jurisdiccion.codigo);
        if (vf0001 != null) {
            vf0001.setLocalizedLabel(ENGLISH, "jurisdiction");
//          vf0001.setLocalizedLabel(SPANISH, "jurisdicción");
        }
        ViewField vf0002 = v1.getField(jurisdiccion.nombre);
        if (vf0002 != null) {
            vf0002.setLocalizedLabel(ENGLISH, "name");
        }
        ViewField vf0003 = v1.getField(jurisdiccion.superior.codigo);
        if (vf0003 != null) {
            vf0003.setLocalizedLabel(ENGLISH, "higher jurisdiction");
//          vf0003.setLocalizedLabel(SPANISH, "jurisdicción superior");
        }
        ViewField vf0004 = v1.getField(jurisdiccion.superior.nombre);
        if (vf0004 != null) {
            vf0004.setLocalizedLabel(ENGLISH, "top jurisdiction name");
//          vf0004.setLocalizedLabel(SPANISH, "nombre de jurisdicción superior");
        }
        ViewField vf0005 = v1.getField(actividadEconomica.codigo);
        if (vf0005 != null) {
            vf0005.setLocalizedLabel(ENGLISH, "economic activity");
//          vf0005.setLocalizedLabel(SPANISH, "actividad económica");
        }
        ViewField vf0006 = v1.getField(actividadEconomica.nombre);
        if (vf0006 != null) {
            vf0006.setLocalizedLabel(ENGLISH, "name");
        }
        ViewField vf0007 = v1.getField(tipo.codigo);
        if (vf0007 != null) {
            vf0007.setLocalizedLabel(ENGLISH, "customer type");
//          vf0007.setLocalizedLabel(SPANISH, "tipo de cliente");
        }
        ViewField vf0008 = v1.getField(codigo);
        if (vf0008 != null) {
            vf0008.setLocalizedLabel(ENGLISH, "code");
        }
        ViewField vf0009 = v1.getField(nombre);
        if (vf0009 != null) {
            vf0009.setLocalizedLabel(ENGLISH, "name");
        }
        ViewField vf0010 = v1.getField(fechaInicioRelacion);
        if (vf0010 != null) {
            vf0010.setLocalizedLabel(ENGLISH, "beginning of the relationship");
//          vf0010.setLocalizedLabel(SPANISH, "inicio de la relación");
            vf0010.setLocalizedShortLabel(ENGLISH, "client since");
//          vf0010.setLocalizedShortLabel(SPANISH, "cliente desde");
        }
        ViewField vf0011 = v1.getField(analizado);
        if (vf0011 != null) {
            vf0011.setLocalizedLabel(ENGLISH, "analyzed");
        }
        ViewField vf0012 = v1.getField(aprobado);
        if (vf0012 != null) {
            vf0012.setLocalizedLabel(ENGLISH, "approved");
        }
        ViewField vf0013 = v1.getField(auditado);
        if (vf0013 != null) {
            vf0013.setLocalizedLabel(ENGLISH, "audited");
        }
        ViewField vf0014 = v1.getField(limiteCredito);
        if (vf0014 != null) {
            vf0014.setLocalizedLabel(ENGLISH, "credit limit");
        }
        // </editor-fold>
    }

    @Override
    protected void localizeExpressions() {
        super.localizeExpressions();
        // <editor-fold defaultstate="collapsed" desc="localization of Cliente's expressions">
        clientesAAA.setLocalizedCollectionLabel(ENGLISH, "all clients with credit analyzed, approved and audited");
//      clientesAAA.setLocalizedCollectionLabel(SPANISH, "todos los clientes con crédito analizado, aprobado y auditado");
        clientesAAA.setLocalizedCollectionShortLabel(ENGLISH, "AAA clients");
//      clientesAAA.setLocalizedCollectionShortLabel(SPANISH, "Clientes AAA");
        clientesAAA.setLocalizedDescription(ENGLISH, "the client's credit is analyzed, approved and audited");
//      clientesAAA.setLocalizedDescription(SPANISH, "el crédito del cliente está analizado, aprobado y auditado");
        clientesAAA.setLocalizedErrorMessage(ENGLISH, "the client's credit is not analyzed, approved and audited");
//      clientesAAA.setLocalizedErrorMessage(SPANISH, "el crédito del cliente no está analizado, aprobado y auditado");
        /**/
        misClientes.setLocalizedCollectionLabel(ENGLISH, "all clients whose executive is the current user");
//      misClientes.setLocalizedCollectionLabel(SPANISH, "todos los clientes cuyo ejecutivo es el usuario actual");
        misClientes.setLocalizedCollectionShortLabel(ENGLISH, "My clients");
//      misClientes.setLocalizedCollectionShortLabel(SPANISH, "Mis clientes");
        misClientes.setLocalizedDescription(ENGLISH, "the current user is the client's executive");
//      misClientes.setLocalizedDescription(SPANISH, "el usuario actual es el ejecutivo del cliente");
        misClientes.setLocalizedErrorMessage(ENGLISH, "the current user is not the client's executive");
//      misClientes.setLocalizedErrorMessage(SPANISH, "el usuario actual no es el ejecutivo del cliente");
        /**/
        pagoConEfectivo.setLocalizedDescription(ENGLISH, "the payment method is cash");
//      pagoConEfectivo.setLocalizedDescription(SPANISH, "la forma de pago es efectivo");
        pagoConEfectivo.setLocalizedErrorMessage(ENGLISH, "the payment method is not cash");
//      pagoConEfectivo.setLocalizedErrorMessage(SPANISH, "la forma de pago no es efectivo");
        /**/
        pagoConCheque.setLocalizedDescription(ENGLISH, "the payment method is check");
//      pagoConCheque.setLocalizedDescription(SPANISH, "la forma de pago es cheque");
        pagoConCheque.setLocalizedErrorMessage(ENGLISH, "the payment method is not check");
//      pagoConCheque.setLocalizedErrorMessage(SPANISH, "la forma de pago no es cheque");
        /**/
        pagoConTarjeta.setLocalizedDescription(ENGLISH, "the payment method is card");
//      pagoConTarjeta.setLocalizedDescription(SPANISH, "la forma de pago es tarjeta");
        pagoConTarjeta.setLocalizedErrorMessage(ENGLISH, "the payment method is not card");
//      pagoConTarjeta.setLocalizedErrorMessage(SPANISH, "la forma de pago no es tarjeta");
        /**/
        check101.setLocalizedErrorMessage(ENGLISH, "If the payment is in cash then the bank cannot be specified");
//      check101.setLocalizedErrorMessage(SPANISH, "si el pago es en efectivo entonces no se puede especificar el banco");
        /**/
        check103.setLocalizedErrorMessage(ENGLISH, "If the payment is in cash then the card cannot be specified");
//      check103.setLocalizedErrorMessage(SPANISH, "si el pago es en efectivo entonces no se puede especificar la tarjeta");
        /**/
        check111.setLocalizedErrorMessage(ENGLISH, "If payment is by check then the bank must be specified");
//      check111.setLocalizedErrorMessage(SPANISH, "si el pago es con cheque entonces se tiene que especificar el banco");
        /**/
        check113.setLocalizedErrorMessage(ENGLISH, "If payment is by check then the card cannot be specified");
//      check113.setLocalizedErrorMessage(SPANISH, "si el pago es con cheque entonces no se puede especificar la tarjeta");
        /**/
        check121.setLocalizedErrorMessage(ENGLISH, "If the payment is by card then the bank must be specified");
//      check121.setLocalizedErrorMessage(SPANISH, "si el pago es con tarjeta entonces se tiene que especificar el banco");
        /**/
        check123.setLocalizedErrorMessage(ENGLISH, "If the payment is by card then the card must be specified");
//      check123.setLocalizedErrorMessage(SPANISH, "si el pago es con tarjeta entonces se tiene que especificar la tarjeta");
        // </editor-fold>
    }

    public class AprobarCredito extends showcase.meta.operacion.cliente.AprobarCredito {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of AprobarCredito's attributes">
            setLocalizedLabel(ENGLISH, "approve credit");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of AprobarCredito's parameters">
            cliente.setLocalizedLabel(ENGLISH, "customer");
            /**/
            limiteCredito.setLocalizedLabel(ENGLISH, "credit limit");
//          limiteCredito.setLocalizedLabel(SPANISH, "límite de crédito");
            // </editor-fold>
        }

    }

    public class AdjuntarDocumento extends showcase.meta.operacion.cliente.AdjuntarDocumento {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of AdjuntarDocumento's attributes">
            setLocalizedLabel(ENGLISH, "add and attach document");
//          setLocalizedLabel(SPANISH, "agregar y adjuntar documento");
            setLocalizedShortLabel(ENGLISH, "Attach document");
//          setLocalizedShortLabel(SPANISH, "adjuntar documento");
            setLocalizedDescription(ENGLISH, "add and attach a document to the client");
//          setLocalizedDescription(SPANISH, "agrega y adjunta un documento al cliente");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of AdjuntarDocumento's parameters">
            cliente.setLocalizedLabel(ENGLISH, "customer");
            /**/
            archivo.setLocalizedLabel(ENGLISH, "archive");
            /**/
            descripcion.setLocalizedLabel(ENGLISH, "description");
            // </editor-fold>
        }

    }

    public class CargarImagen extends showcase.meta.operacion.cliente.CargarImagen {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of CargarImagen's attributes">
            setLocalizedLabel(ENGLISH, "upload image");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of CargarImagen's parameters">
            cliente.setLocalizedLabel(ENGLISH, "customer");
            /**/
            imagen.setLocalizedLabel(ENGLISH, "image");
            imagen.setLocalizedTooltip(ENGLISH, "URL of the file that contains the image (photo or logo) of the client");
            // </editor-fold>
        }

    }

}
