/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.cliente.i18n;

import adalid.core.interfaces.Artifact;
import java.lang.reflect.Field;

/**
 * PersonaFisica is a generated java file.
 * <ul>
 * <li>template: templates/meta/java/i18n/component.vm</li>
 * <li>template-author: Jorge Campins</li>
 * <li>file-encoding: UTF-8</li>
 * <li>file-preserve: false -> file will be replaced when regenerating the project</li>
 * </ul>
 *
 * @author ADALID (template by Jorge Campins)
 */
public class PersonaFisica extends showcase.meta.entidad.cliente.PersonaFisica {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public PersonaFisica(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of PersonaFisica's attributes">
        setLocalizedLabel(ENGLISH, "Physical person");
//      setLocalizedLabel(SPANISH, "persona física");
        setLocalizedCollectionLabel(ENGLISH, "Physical persons");
//      setLocalizedCollectionLabel(SPANISH, "Personas Físicas");
        // </editor-fold>
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of PersonaFisica's properties">
        fechaNacimiento.setLocalizedLabel(ENGLISH, "birth date");
        /**/
        edad.setLocalizedLabel(ENGLISH, "age");
        /**/
        personaAdulta.setLocalizedLabel(ENGLISH, "adult person");
        /**/
        sexo.setLocalizedLabel(ENGLISH, "sex");
        /**/
        estadoCivil.setLocalizedLabel(ENGLISH, "civil status");
//      estadoCivil.setLocalizedLabel(SPANISH, "estado civil");
        /**/
        conyuge.setLocalizedLabel(ENGLISH, "spouse");
//      conyuge.setLocalizedLabel(SPANISH, "cónyuge");
        /**/
        empleador.setLocalizedLabel(ENGLISH, "employer");
        // </editor-fold>
    }

    @Override
    protected void localizeExpressions() {
        super.localizeExpressions();
        // <editor-fold defaultstate="collapsed" desc="localization of PersonaFisica's expressions">
        check301.setLocalizedErrorMessage(ENGLISH, "spouse cannot be specified if the person is single");
//      check301.setLocalizedErrorMessage(SPANISH, "cónyuge no se puede especificar si la persona está soltera");
        /**/
        check302.setLocalizedErrorMessage(ENGLISH, "spouse has to be someone else");
//      check302.setLocalizedErrorMessage(SPANISH, "cónyuge tiene que ser otra persona");
        /**/
        check303.setLocalizedErrorMessage(ENGLISH, "spouse must be a person of the opposite sex");
//      check303.setLocalizedErrorMessage(SPANISH, "cónyuge tiene que ser una persona del sexo opuesto");
        // </editor-fold>
    }

}
