/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.configuracion;

import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;

@EntityClass(resourceType = ResourceType.CONFIGURATION)
@EntityDataGen(start = 1, step = 1, stop = 10)
@EntitySelectOperation(rowsLimit = 0, onload = SelectOnloadOption.EXECUTE)
public class ActividadEconomica extends PersistentEntityBase {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public ActividadEconomica(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("actividad económica");
        setDefaultCollectionLabel("Actividades Económicas");
    }

    @BusinessKey
    public StringProperty codigo;

    @NameProperty
    public StringProperty nombre;

    @DescriptionProperty
    public StringProperty descripcion;

}
