/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.configuracion;

import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;
import meta.entidad.comun.control.acceso.Usuario;

@EntityClass(resourceType = ResourceType.CONFIGURATION, independent = Kleenean.FALSE)
@EntityDataGen(start = 1, step = 1, stop = 50)
public class CuentaBancaria extends PersistentEntityBase {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public CuentaBancaria(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    // </editor-fold>
    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings("agencia.banco");
    }

    @BusinessKey
    public StringProperty numero;

    @ColumnField(nullable = Kleenean.FALSE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.TABLE)
    public AgenciaBancaria agencia;

    @OwnerProperty
    @ColumnField(nullable = Kleenean.TRUE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.TRUE)
    public Usuario responsable;

    @Override
    protected void settleLinks() {
        super.settleLinks();
        linkForeignSegmentProperty(agencia.banco);
    }

}
