/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.configuracion;

import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;

@EntityClass(resourceType = ResourceType.CONFIGURATION)
@EntityDataGen(start = 1, step = 1, stop = 10)
@EntityDetailView()
@EntitySelectOperation(rowsLimit = 0, onload = SelectOnloadOption.EXECUTE)
@EntityTableView(inserts = Kleenean.FALSE)
@EntityTreeView(enabled = Kleenean.TRUE, menu = ViewMenuOption.ALL)
public class Jurisdiccion extends PersistentEntityBase {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public Jurisdiccion(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("jurisdicción");
        setDefaultCollectionLabel("Jurisdicciones");
        setDefaultMenuOptionLabel(DisplayFormat.TABLE, "Tabla de Jurisdicciones");
        setDefaultMenuOptionLabel(DisplayFormat.TREE, "Árbol de Jurisdicciones");
    }

    @BusinessKey
    public StringProperty codigo;

    @NameProperty
    public StringProperty nombre;

    @ParentProperty
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(table = Kleenean.TRUE, create = Kleenean.TRUE)
    @EntityReferenceDataGen(nullable = 100)
    public Jurisdiccion superior;

    protected Check check101;

    /*
    protected Check check201, check202;

    /**/
    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        /**/
        check101 = superior.isNotNull().implies(superior.isNotEqualTo(this));
        check101.setDefaultLabel("chequear jurisdicción superior");
        check101.setDefaultDescription("la jurisdicción superior no puede ser la misma jurisdicción");
        check101.setDefaultErrorMessage("la jurisdicción superior es la misma jurisdicción");
        /*
        check201 = superior.isNotNull().implies(superior.evaluate("PredicadoJurisdiccionSuperior"));
//      check201.setCheckpoint(Checkpoint.USER_INTERFACE);
        check201.setDefaultLabel("chequear jurisdicción superior");
        check201.setDefaultDescription("la jurisdicción superior debe cumplir con el predicado");
        check201.setDefaultErrorMessage("la jurisdicción superior no cumple con el predicado");
        /*
        check202 = evaluate("PredicadoJurisdiccion");
//      check202.setCheckpoint(Checkpoint.USER_INTERFACE);
        check202.setDefaultLabel("chequear jurisdicción");
        check202.setDefaultDescription("la jurisdicción debe cumplir con el predicado");
        check202.setDefaultErrorMessage("la jurisdicción no cumple con el predicado");
        /**/
    }

}
