/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.configuracion;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;
import showcase.meta.entidad.cliente.Cliente;

@EntityClass(resourceType = ResourceType.CONFIGURATION, independent = Kleenean.FALSE)
@EntityDataGen(start = 1, step = 1, stop = 100)
@EntityDetailView(
    readingViewBelowDetailSnippet = "/entity/Municipio/belowDetailSnippet",
    writingViewBelowDetailSnippet = "/entity/Municipio/belowDetailSnippet"
)
public class Municipio extends PersistentEntityBase {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public Municipio(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        addAllocationStrings(
            "distrito.departamento.region"
        );
    }

    @BusinessKey
    public StringProperty codigo;

    @NameProperty
    public StringProperty nombre;

    @ColumnField(nullable = Kleenean.FALSE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.TABLE_AND_DETAIL)
    @PropertyField(update = Kleenean.FALSE)
    public Distrito distrito;

    /**/
    @OneToMany(targetEntity = Cliente.class, cascade = {CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH})
    @EntityCollectionField(format = DataEntryFormat.DETAIL_OR_TABLE,
        readingViewRowActionSnippet = "/entity/Municipio/clientesRowActionSnippet",
        writingViewRowActionSnippet = "/entity/Municipio/clientesRowActionSnippet"
    )
    public EntityCollection clientes;

    @Override
    protected void settleCollections() {
        super.settleCollections();
        clientes.setDefaultLabel("clientes del municipio");
        clientes.setDefaultShortLabel("clientes");
        clientes.setDefaultDescription("colección de clientes que habitan en el municipio");
    }

    /**/
    protected Step step001, step002;

    @Override
    protected void settleSteps() {
        super.settleSteps();
        step001.setDefaultLabel("Datos básicos");
        step001.setDefaultShortLabel("municipio");
        step001.newStepField(codigo, nombre, distrito);
        step002.setDefaultLabel("Clientes que habitan en el municipio");
        step002.setDefaultShortLabel("clientes");
        step002.newStepField(clientes);
    }

    protected Tab tab001, tab002;

    @Override
    protected void settleTabs() {
        super.settleTabs();
        tab001.copy(step001);
        tab002.copy(step002);
    }

    /**/
}
