/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.configuracion.fija;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEnumerationEntityBase;
import meta.entidad.comun.configuracion.basica.ModuloAplicacion;
import meta.entidad.comun.control.acceso.GrupoUsuario;
import meta.entidad.comun.control.acceso.Rol;
import showcase.meta.entidad.configuracion.*;
import showcase.meta.entidad.cuenta.TipoCodigoUsuario;

@EntityDetailView(enabled = Kleenean.TRUE, menu = ViewMenuOption.WRITING)
@EntityExportOperation(enabled = Kleenean.FALSE)
@EntityReportOperation(enabled = Kleenean.FALSE)
@EntityTableView(enabled = Kleenean.FALSE)
public class ConfiguracionGlobal extends PersistentEnumerationEntityBase {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public ConfiguracionGlobal(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        addAllocationStrings(
            "distritoPredeterminado.departamento",
            "municipioPredeterminado.distrito",
            "agenciaPredeterminada.banco",
            "cuentaPredeterminada.agencia"
        );
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("configuración global");
        setDefaultShortLabel("configuración");
        setDefaultCollectionLabel("Configuración Global");
        setDefaultCollectionShortLabel("Configuración");
    }

    @CastingField("codigo")
    @PropertyField(hidden = Kleenean.TRUE)
    public StringProperty codigoCastingField;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(update = Kleenean.FALSE, prominent = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME_AND_CHARACTER_KEY)
    public Pais paisSede;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(update = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME_AND_CHARACTER_KEY)
    public Departamento departamentoPredeterminado;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(update = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME_AND_CHARACTER_KEY)
    public Distrito distritoPredeterminado;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(update = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME_AND_CHARACTER_KEY)
    public Municipio municipioPredeterminado;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(update = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.DISPLAY, displayFormat = SearchDisplayFormat.TREE)
    @EntityReferenceDisplay(style = EntityReferenceStyle.NAME_AND_CHARACTER_KEY)
    public Jurisdiccion jurisdiccionPredeterminada;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(update = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME_AND_CHARACTER_KEY)
    public ActividadEconomica actividadPredeterminada;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(update = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME_AND_CHARACTER_KEY)
    public Banco bancoPredeterminado;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(update = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME_AND_CHARACTER_KEY)
    public AgenciaBancaria agenciaPredeterminada;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(update = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME_AND_CHARACTER_KEY)
    public CuentaBancaria cuentaPredeterminada;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(update = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME_AND_CHARACTER_KEY)
    public TipoCodigoUsuario tipoCodigoUsuario;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(update = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME_AND_CHARACTER_KEY)
    public GrupoUsuario grupoPredeterminado;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(update = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME_AND_CHARACTER_KEY)
    public Rol rolPredeterminado;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(update = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME_AND_CHARACTER_KEY)
    public ModuloAplicacion moduloPredeterminado;

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
//  @PropertyField(update = Kleenean.TRUE, writingDetailSnippet = "etiquetaPredefinida")
    @PropertyField(hidden = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.LIST)
    public EtiquetaPredefinida etiquetaPredefinida;

    @Override
    protected void settleProperties() {
        super.settleProperties();
        paisSede.setDefaultLabel("país sede");
        jurisdiccionPredeterminada.setDefaultLabel("jurisdicción predeterminada");
        tipoCodigoUsuario.setDefaultLabel("tipo de código de usuario");
        tipoCodigoUsuario.setDefaultValue(tipoCodigoUsuario.NOMBRE);
        tipoCodigoUsuario.setInitialValue(tipoCodigoUsuario.NOMBRE);
        moduloPredeterminado.setDefaultLabel("módulo predeterminado");
    }

    public Instance GLOBAL;

    @Override
    protected void settleInstances() {
        super.settleInstances();
        GLOBAL.newInstanceField(numero, 0);
        GLOBAL.newInstanceField(codigo, "global");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        /**/
        distritoPredeterminado.setModifyingFilter(departamentoPredeterminado.isNotNull());
        distritoPredeterminado.setNullifyingFilter(departamentoPredeterminado.isNull());
        distritoPredeterminado.setSearchQueryFilter(distritoPredeterminado.departamento.isEqualTo(departamentoPredeterminado));
        /**/
        municipioPredeterminado.setModifyingFilter(departamentoPredeterminado.isNotNull().and(distritoPredeterminado.isNotNull()));
        municipioPredeterminado.setNullifyingFilter(departamentoPredeterminado.isNull().or(distritoPredeterminado.isNull()));
        municipioPredeterminado.setSearchQueryFilter(municipioPredeterminado.distrito.isEqualTo(distritoPredeterminado));
        /**/
        agenciaPredeterminada.setModifyingFilter(bancoPredeterminado.isNotNull());
        agenciaPredeterminada.setNullifyingFilter(bancoPredeterminado.isNull());
        agenciaPredeterminada.setSearchQueryFilter(agenciaPredeterminada.banco.isEqualTo(bancoPredeterminado));
        /**/
        cuentaPredeterminada.setModifyingFilter(agenciaPredeterminada.isNotNull());
        cuentaPredeterminada.setNullifyingFilter(agenciaPredeterminada.isNull());
        cuentaPredeterminada.setSearchQueryFilter(cuentaPredeterminada.agencia.isEqualTo(agenciaPredeterminada));
        /**/
        rolPredeterminado.setSearchQueryFilter(rolPredeterminado.esSuperRol.isFalse());
        /**/
    }

}
