/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.configuracion.fija;

import adalid.core.*;
import adalid.core.interfaces.*;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEnumerationEntityBase;

public class EstadoPedido extends PersistentEnumerationEntityBase {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public EstadoPedido(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("estado de pedido");
        setDefaultCollectionLabel("Estados de Pedido");
    }

    public Instance RECIBIDO, PROCESADO, COBRADO, ENVIADO, CANCELADO;

    @Override
    protected void settleInstances() {
        super.settleInstances();
        /**/
        RECIBIDO.setCustomTag(InstanceTag.PURPLISH);
        PROCESADO.setCustomTag(InstanceTag.BLUISH);
        COBRADO.setCustomTag(InstanceTag.GREENISH);
        ENVIADO.setCustomTag(InstanceTag.YELLOWISH);
        CANCELADO.setCustomTag(InstanceTag.REDISH);
        /**/
    }

}
