/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.configuracion.fija;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEnumerationEntityBase;

@EntityExportOperation(enabled = Kleenean.TRUE)
@EntityReportOperation(enabled = Kleenean.TRUE)
@EntityReferenceSearch(searchType = SearchType.RADIO, radioColumns = 0)
@EntityTableView(enabled = Kleenean.TRUE, updates = Kleenean.TRUE, responsiveMode = TableResponsiveMode.AUTO)
public class FormaPago extends PersistentEnumerationEntityBase {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public FormaPago(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("forma de pago");
        setDefaultCollectionLabel("Formas de Pago");
    }

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.TRUE, report = Kleenean.TRUE, update = Kleenean.TRUE, responsivePriority = 0)
    @NumericField(type = NumericFieldType.KNOB, symbol = "%")
    public IntegerProperty descuento;

    @Override
    protected void settleProperties() {
        super.settleProperties();
        descuento.setDefaultTooltip("porcentaje de descuento");
        descuento.setDefaultValue(0);
        descuento.setInitialValue(0);
        descuento.setMaxValue(15);
        descuento.setMinValue(0);
    }

    public Instance EFECTIVO, CHEQUE, TARJETA;

    @Override
    protected void settleInstances() {
        super.settleInstances();
//      EFECTIVO.newInstanceField(codigo, "Efectivo");
//      CHEQUE.newInstanceField(codigo, "Cheque");
        TARJETA.newInstanceField(codigo, "Tarjeta de Crédito");
    }

}
