/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.configuracion.fija;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import java.lang.reflect.Field;

/**
 * Nacionalidades con códigos de la norma ISO 3166-1.
 *
 * @author Jorge Campins
 * @see <a href="https://es.wikipedia.org/wiki/ISO_3166-1">ISO 3166-1</a>
 */
@EntityReferenceDisplay(style = EntityReferenceStyle.NAME)
@EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME_AND_CHARACTER_KEY)
@EntityTableView(enabled = Kleenean.TRUE)
public class Nacionalidad extends AbstractPersistentEnumerationEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public Nacionalidad(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("nacionalidad");
        setDefaultCollectionLabel("Nacionalidades");
    }

    @PrimaryKey
    public IntegerProperty numero;

    @VersionProperty
    public LongProperty version;

    @BusinessKey
    @StringField(maxLength = 2, translatable = Kleenean.FALSE)
    public StringProperty codigo;

    @NameProperty
    @PropertyField(update = Kleenean.TRUE)
    public StringProperty nombre;

    @ColumnField(nullable = Kleenean.FALSE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @OneToOne(navigability = Navigability.UNIDIRECTIONAL)
    @PropertyField(table = Kleenean.TRUE)
    public Pais pais;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.TRUE)
    public BooleanProperty sede;

    @Override
    protected void settleProperties() {
        super.settleProperties();
        /**/
        setOrderBy(nombre);
        /**/
        codigo.setDefaultLabel("código");
        codigo.setDefaultDescription("código que identifica la nacionalidad, según del estándar internacional de normalización ISO 3166-1 alfa-2");
        nombre.setDefaultLabel("nacionalidad");
        sede.setDefaultValue(false);
    }

    public Instance XAD, XAE, XAF, XAG, XAI, XAL, XAM, XAO, XAQ, XAR, XAS, XAT, XAU, XAW, XAX, XAZ, XBA, XBB, XBD, XBE,
        XBF, XBG, XBH, XBI, XBJ, XBL, XBM, XBN, XBO, XBQ, XBR, XBS, XBT, XBV, XBW, XBY, XBZ, XCA, XCC, XCD,
        XCF, XCG, XCH, XCI, XCK, XCL, XCM, XCN, XCO, XCR, XCU, XCV, XCW, XCX, XCY, XCZ, XDE, XDJ, XDK, XDM,
        XDO, XDZ, XEC, XEE, XEG, XEH, XER, XES, XET, XFI, XFJ, XFK, XFM, XFO, XFR, XGA, XGB, XGD, XGE, XGF,
        XGG, XGH, XGI, XGL, XGM, XGN, XGP, XGQ, XGR, XGS, XGT, XGU, XGW, XGY, XHK, XHM, XHN, XHR, XHT, XHU,
        XID, XIE, XIL, XIM, XIN, XIO, XIQ, XIR, XIS, XIT, XJE, XJM, XJO, XJP, XKE, XKG, XKH, XKI, XKM, XKN,
        XKP, XKR, XKW, XKY, XKZ, XLA, XLB, XLC, XLI, XLK, XLR, XLS, XLT, XLU, XLV, XLY, XMA, XMC, XMD, XME,
        XMF, XMG, XMH, XMK, XML, XMM, XMN, XMO, XMP, XMQ, XMR, XMS, XMT, XMU, XMV, XMW, XMX, XMY, XMZ, XNA,
        XNC, XNE, XNF, XNG, XNI, XNL, XNO, XNP, XNR, XNU, XNZ, XOM, XPA, XPE, XPF, XPG, XPH, XPK, XPL, XPM,
        XPN, XPR, XPS, XPT, XPW, XPY, XQA, XRE, XRO, XRS, XRU, XRW, XSA, XSB, XSC, XSD, XSE, XSG, XSH, XSI,
        XSJ, XSK, XSL, XSM, XSN, XSO, XSR, XSS, XST, XSV, XSX, XSY, XSZ, XTC, XTD, XTF, XTG, XTH, XTJ, XTK,
        XTL, XTM, XTN, XTO, XTR, XTT, XTV, XTW, XTZ, XUA, XUG, XUM, XUS, XUY, XUZ, XVA, XVC, XVE, XVG, XVI,
        XVN, XVU, XWF, XWS, XYE, XYT, XZA, XZM, XZW; // la letra X evita coincidencias con palabras reservadas de SQL

    @Override
    protected void settleInstances() {
        super.settleInstances();
        /**/
        // <editor-fold defaultstate="collapsed" desc="newInstanceField(numero)">
        XAD.newInstanceField(numero, 20);
        XAE.newInstanceField(numero, 784);
        XAF.newInstanceField(numero, 4);
        XAG.newInstanceField(numero, 28);
        XAI.newInstanceField(numero, 660);
        XAL.newInstanceField(numero, 8);
        XAM.newInstanceField(numero, 51);
        XAO.newInstanceField(numero, 24);
        XAQ.newInstanceField(numero, 10);
        XAR.newInstanceField(numero, 32);
        XAS.newInstanceField(numero, 16);
        XAT.newInstanceField(numero, 40);
        XAU.newInstanceField(numero, 36);
        XAW.newInstanceField(numero, 533);
        XAX.newInstanceField(numero, 248);
        XAZ.newInstanceField(numero, 31);
        XBA.newInstanceField(numero, 70);
        XBB.newInstanceField(numero, 52);
        XBD.newInstanceField(numero, 50);
        XBE.newInstanceField(numero, 56);
        XBF.newInstanceField(numero, 854);
        XBG.newInstanceField(numero, 100);
        XBH.newInstanceField(numero, 48);
        XBI.newInstanceField(numero, 108);
        XBJ.newInstanceField(numero, 204);
        XBL.newInstanceField(numero, 652);
        XBM.newInstanceField(numero, 60);
        XBN.newInstanceField(numero, 96);
        XBO.newInstanceField(numero, 68);
        XBQ.newInstanceField(numero, 535);
        XBR.newInstanceField(numero, 76);
        XBS.newInstanceField(numero, 44);
        XBT.newInstanceField(numero, 64);
        XBV.newInstanceField(numero, 74);
        XBW.newInstanceField(numero, 72);
        XBY.newInstanceField(numero, 112);
        XBZ.newInstanceField(numero, 84);
        XCA.newInstanceField(numero, 124);
        XCC.newInstanceField(numero, 166);
        XCD.newInstanceField(numero, 180);
        XCF.newInstanceField(numero, 140);
        XCG.newInstanceField(numero, 178);
        XCH.newInstanceField(numero, 756);
        XCI.newInstanceField(numero, 384);
        XCK.newInstanceField(numero, 184);
        XCL.newInstanceField(numero, 152);
        XCM.newInstanceField(numero, 120);
        XCN.newInstanceField(numero, 156);
        XCO.newInstanceField(numero, 170);
        XCR.newInstanceField(numero, 188);
        XCU.newInstanceField(numero, 192);
        XCV.newInstanceField(numero, 132);
        XCW.newInstanceField(numero, 531);
        XCX.newInstanceField(numero, 162);
        XCY.newInstanceField(numero, 196);
        XCZ.newInstanceField(numero, 203);
        XDE.newInstanceField(numero, 276);
        XDJ.newInstanceField(numero, 262);
        XDK.newInstanceField(numero, 208);
        XDM.newInstanceField(numero, 212);
        XDO.newInstanceField(numero, 214);
        XDZ.newInstanceField(numero, 12);
        XEC.newInstanceField(numero, 218);
        XEE.newInstanceField(numero, 233);
        XEG.newInstanceField(numero, 818);
        XEH.newInstanceField(numero, 732);
        XER.newInstanceField(numero, 232);
        XES.newInstanceField(numero, 724);
        XET.newInstanceField(numero, 231);
        XFI.newInstanceField(numero, 246);
        XFJ.newInstanceField(numero, 242);
        XFK.newInstanceField(numero, 238);
        XFM.newInstanceField(numero, 583);
        XFO.newInstanceField(numero, 234);
        XFR.newInstanceField(numero, 250);
        XGA.newInstanceField(numero, 266);
        XGB.newInstanceField(numero, 826);
        XGD.newInstanceField(numero, 308);
        XGE.newInstanceField(numero, 268);
        XGF.newInstanceField(numero, 254);
        XGG.newInstanceField(numero, 831);
        XGH.newInstanceField(numero, 288);
        XGI.newInstanceField(numero, 292);
        XGL.newInstanceField(numero, 304);
        XGM.newInstanceField(numero, 270);
        XGN.newInstanceField(numero, 324);
        XGP.newInstanceField(numero, 312);
        XGQ.newInstanceField(numero, 226);
        XGR.newInstanceField(numero, 300);
        XGS.newInstanceField(numero, 239);
        XGT.newInstanceField(numero, 320);
        XGU.newInstanceField(numero, 316);
        XGW.newInstanceField(numero, 624);
        XGY.newInstanceField(numero, 328);
        XHK.newInstanceField(numero, 344);
        XHM.newInstanceField(numero, 334);
        XHN.newInstanceField(numero, 340);
        XHR.newInstanceField(numero, 191);
        XHT.newInstanceField(numero, 332);
        XHU.newInstanceField(numero, 348);
        XID.newInstanceField(numero, 360);
        XIE.newInstanceField(numero, 372);
        XIL.newInstanceField(numero, 376);
        XIM.newInstanceField(numero, 833);
        XIN.newInstanceField(numero, 356);
        XIO.newInstanceField(numero, 86);
        XIQ.newInstanceField(numero, 368);
        XIR.newInstanceField(numero, 364);
        XIS.newInstanceField(numero, 352);
        XIT.newInstanceField(numero, 380);
        XJE.newInstanceField(numero, 832);
        XJM.newInstanceField(numero, 388);
        XJO.newInstanceField(numero, 400);
        XJP.newInstanceField(numero, 392);
        XKE.newInstanceField(numero, 404);
        XKG.newInstanceField(numero, 417);
        XKH.newInstanceField(numero, 116);
        XKI.newInstanceField(numero, 296);
        XKM.newInstanceField(numero, 174);
        XKN.newInstanceField(numero, 659);
        XKP.newInstanceField(numero, 408);
        XKR.newInstanceField(numero, 410);
        XKW.newInstanceField(numero, 414);
        XKY.newInstanceField(numero, 136);
        XKZ.newInstanceField(numero, 398);
        XLA.newInstanceField(numero, 418);
        XLB.newInstanceField(numero, 422);
        XLC.newInstanceField(numero, 662);
        XLI.newInstanceField(numero, 438);
        XLK.newInstanceField(numero, 144);
        XLR.newInstanceField(numero, 430);
        XLS.newInstanceField(numero, 426);
        XLT.newInstanceField(numero, 440);
        XLU.newInstanceField(numero, 442);
        XLV.newInstanceField(numero, 428);
        XLY.newInstanceField(numero, 434);
        XMA.newInstanceField(numero, 504);
        XMC.newInstanceField(numero, 492);
        XMD.newInstanceField(numero, 498);
        XME.newInstanceField(numero, 499);
        XMF.newInstanceField(numero, 663);
        XMG.newInstanceField(numero, 450);
        XMH.newInstanceField(numero, 584);
        XMK.newInstanceField(numero, 807);
        XML.newInstanceField(numero, 466);
        XMM.newInstanceField(numero, 104);
        XMN.newInstanceField(numero, 496);
        XMO.newInstanceField(numero, 446);
        XMP.newInstanceField(numero, 580);
        XMQ.newInstanceField(numero, 474);
        XMR.newInstanceField(numero, 478);
        XMS.newInstanceField(numero, 500);
        XMT.newInstanceField(numero, 470);
        XMU.newInstanceField(numero, 480);
        XMV.newInstanceField(numero, 462);
        XMW.newInstanceField(numero, 454);
        XMX.newInstanceField(numero, 484);
        XMY.newInstanceField(numero, 458);
        XMZ.newInstanceField(numero, 508);
        XNA.newInstanceField(numero, 516);
        XNC.newInstanceField(numero, 540);
        XNE.newInstanceField(numero, 562);
        XNF.newInstanceField(numero, 574);
        XNG.newInstanceField(numero, 566);
        XNI.newInstanceField(numero, 558);
        XNL.newInstanceField(numero, 528);
        XNO.newInstanceField(numero, 578);
        XNP.newInstanceField(numero, 524);
        XNR.newInstanceField(numero, 520);
        XNU.newInstanceField(numero, 570);
        XNZ.newInstanceField(numero, 554);
        XOM.newInstanceField(numero, 512);
        XPA.newInstanceField(numero, 591);
        XPE.newInstanceField(numero, 604);
        XPF.newInstanceField(numero, 258);
        XPG.newInstanceField(numero, 598);
        XPH.newInstanceField(numero, 608);
        XPK.newInstanceField(numero, 586);
        XPL.newInstanceField(numero, 616);
        XPM.newInstanceField(numero, 666);
        XPN.newInstanceField(numero, 612);
        XPR.newInstanceField(numero, 630);
        XPS.newInstanceField(numero, 275);
        XPT.newInstanceField(numero, 620);
        XPW.newInstanceField(numero, 585);
        XPY.newInstanceField(numero, 600);
        XQA.newInstanceField(numero, 634);
        XRE.newInstanceField(numero, 638);
        XRO.newInstanceField(numero, 642);
        XRS.newInstanceField(numero, 688);
        XRU.newInstanceField(numero, 643);
        XRW.newInstanceField(numero, 646);
        XSA.newInstanceField(numero, 682);
        XSB.newInstanceField(numero, 90);
        XSC.newInstanceField(numero, 690);
        XSD.newInstanceField(numero, 729);
        XSE.newInstanceField(numero, 752);
        XSG.newInstanceField(numero, 702);
        XSH.newInstanceField(numero, 654);
        XSI.newInstanceField(numero, 705);
        XSJ.newInstanceField(numero, 744);
        XSK.newInstanceField(numero, 703);
        XSL.newInstanceField(numero, 694);
        XSM.newInstanceField(numero, 674);
        XSN.newInstanceField(numero, 686);
        XSO.newInstanceField(numero, 706);
        XSR.newInstanceField(numero, 740);
        XSS.newInstanceField(numero, 728);
        XST.newInstanceField(numero, 678);
        XSV.newInstanceField(numero, 222);
        XSX.newInstanceField(numero, 534);
        XSY.newInstanceField(numero, 760);
        XSZ.newInstanceField(numero, 748);
        XTC.newInstanceField(numero, 796);
        XTD.newInstanceField(numero, 148);
        XTF.newInstanceField(numero, 260);
        XTG.newInstanceField(numero, 768);
        XTH.newInstanceField(numero, 764);
        XTJ.newInstanceField(numero, 762);
        XTK.newInstanceField(numero, 772);
        XTL.newInstanceField(numero, 626);
        XTM.newInstanceField(numero, 795);
        XTN.newInstanceField(numero, 788);
        XTO.newInstanceField(numero, 776);
        XTR.newInstanceField(numero, 792);
        XTT.newInstanceField(numero, 780);
        XTV.newInstanceField(numero, 798);
        XTW.newInstanceField(numero, 158);
        XTZ.newInstanceField(numero, 834);
        XUA.newInstanceField(numero, 804);
        XUG.newInstanceField(numero, 800);
        XUM.newInstanceField(numero, 581);
        XUS.newInstanceField(numero, 840);
        XUY.newInstanceField(numero, 858);
        XUZ.newInstanceField(numero, 860);
        XVA.newInstanceField(numero, 336);
        XVC.newInstanceField(numero, 670);
        XVE.newInstanceField(numero, 862);
        XVG.newInstanceField(numero, 92);
        XVI.newInstanceField(numero, 850);
        XVN.newInstanceField(numero, 704);
        XVU.newInstanceField(numero, 548);
        XWF.newInstanceField(numero, 876);
        XWS.newInstanceField(numero, 882);
        XYE.newInstanceField(numero, 887);
        XYT.newInstanceField(numero, 175);
        XZA.newInstanceField(numero, 710);
        XZM.newInstanceField(numero, 894);
        XZW.newInstanceField(numero, 716);
        // </editor-fold>
        /**/
        // <editor-fold defaultstate="collapsed" desc="newInstanceField(codigo)">
        XAD.newInstanceField(codigo, "AD");
        XAE.newInstanceField(codigo, "AE");
        XAF.newInstanceField(codigo, "AF");
        XAG.newInstanceField(codigo, "AG");
        XAI.newInstanceField(codigo, "AI");
        XAL.newInstanceField(codigo, "AL");
        XAM.newInstanceField(codigo, "AM");
        XAO.newInstanceField(codigo, "AO");
        XAQ.newInstanceField(codigo, "AQ");
        XAR.newInstanceField(codigo, "AR");
        XAS.newInstanceField(codigo, "AS");
        XAT.newInstanceField(codigo, "AT");
        XAU.newInstanceField(codigo, "AU");
        XAW.newInstanceField(codigo, "AW");
        XAX.newInstanceField(codigo, "AX");
        XAZ.newInstanceField(codigo, "AZ");
        XBA.newInstanceField(codigo, "BA");
        XBB.newInstanceField(codigo, "BB");
        XBD.newInstanceField(codigo, "BD");
        XBE.newInstanceField(codigo, "BE");
        XBF.newInstanceField(codigo, "BF");
        XBG.newInstanceField(codigo, "BG");
        XBH.newInstanceField(codigo, "BH");
        XBI.newInstanceField(codigo, "BI");
        XBJ.newInstanceField(codigo, "BJ");
        XBL.newInstanceField(codigo, "BL");
        XBM.newInstanceField(codigo, "BM");
        XBN.newInstanceField(codigo, "BN");
        XBO.newInstanceField(codigo, "BO");
        XBQ.newInstanceField(codigo, "BQ");
        XBR.newInstanceField(codigo, "BR");
        XBS.newInstanceField(codigo, "BS");
        XBT.newInstanceField(codigo, "BT");
        XBV.newInstanceField(codigo, "BV");
        XBW.newInstanceField(codigo, "BW");
        XBY.newInstanceField(codigo, "BY");
        XBZ.newInstanceField(codigo, "BZ");
        XCA.newInstanceField(codigo, "CA");
        XCC.newInstanceField(codigo, "CC");
        XCD.newInstanceField(codigo, "CD");
        XCF.newInstanceField(codigo, "CF");
        XCG.newInstanceField(codigo, "CG");
        XCH.newInstanceField(codigo, "CH");
        XCI.newInstanceField(codigo, "CI");
        XCK.newInstanceField(codigo, "CK");
        XCL.newInstanceField(codigo, "CL");
        XCM.newInstanceField(codigo, "CM");
        XCN.newInstanceField(codigo, "CN");
        XCO.newInstanceField(codigo, "CO");
        XCR.newInstanceField(codigo, "CR");
        XCU.newInstanceField(codigo, "CU");
        XCV.newInstanceField(codigo, "CV");
        XCW.newInstanceField(codigo, "CW");
        XCX.newInstanceField(codigo, "CX");
        XCY.newInstanceField(codigo, "CY");
        XCZ.newInstanceField(codigo, "CZ");
        XDE.newInstanceField(codigo, "DE");
        XDJ.newInstanceField(codigo, "DJ");
        XDK.newInstanceField(codigo, "DK");
        XDM.newInstanceField(codigo, "DM");
        XDO.newInstanceField(codigo, "DO");
        XDZ.newInstanceField(codigo, "DZ");
        XEC.newInstanceField(codigo, "EC");
        XEE.newInstanceField(codigo, "EE");
        XEG.newInstanceField(codigo, "EG");
        XEH.newInstanceField(codigo, "EH");
        XER.newInstanceField(codigo, "ER");
        XES.newInstanceField(codigo, "ES");
        XET.newInstanceField(codigo, "ET");
        XFI.newInstanceField(codigo, "FI");
        XFJ.newInstanceField(codigo, "FJ");
        XFK.newInstanceField(codigo, "FK");
        XFM.newInstanceField(codigo, "FM");
        XFO.newInstanceField(codigo, "FO");
        XFR.newInstanceField(codigo, "FR");
        XGA.newInstanceField(codigo, "GA");
        XGB.newInstanceField(codigo, "GB");
        XGD.newInstanceField(codigo, "GD");
        XGE.newInstanceField(codigo, "GE");
        XGF.newInstanceField(codigo, "GF");
        XGG.newInstanceField(codigo, "GG");
        XGH.newInstanceField(codigo, "GH");
        XGI.newInstanceField(codigo, "GI");
        XGL.newInstanceField(codigo, "GL");
        XGM.newInstanceField(codigo, "GM");
        XGN.newInstanceField(codigo, "GN");
        XGP.newInstanceField(codigo, "GP");
        XGQ.newInstanceField(codigo, "GQ");
        XGR.newInstanceField(codigo, "GR");
        XGS.newInstanceField(codigo, "GS");
        XGT.newInstanceField(codigo, "GT");
        XGU.newInstanceField(codigo, "GU");
        XGW.newInstanceField(codigo, "GW");
        XGY.newInstanceField(codigo, "GY");
        XHK.newInstanceField(codigo, "HK");
        XHM.newInstanceField(codigo, "HM");
        XHN.newInstanceField(codigo, "HN");
        XHR.newInstanceField(codigo, "HR");
        XHT.newInstanceField(codigo, "HT");
        XHU.newInstanceField(codigo, "HU");
        XID.newInstanceField(codigo, "ID");
        XIE.newInstanceField(codigo, "IE");
        XIL.newInstanceField(codigo, "IL");
        XIM.newInstanceField(codigo, "IM");
        XIN.newInstanceField(codigo, "IN");
        XIO.newInstanceField(codigo, "IO");
        XIQ.newInstanceField(codigo, "IQ");
        XIR.newInstanceField(codigo, "IR");
        XIS.newInstanceField(codigo, "IS");
        XIT.newInstanceField(codigo, "IT");
        XJE.newInstanceField(codigo, "JE");
        XJM.newInstanceField(codigo, "JM");
        XJO.newInstanceField(codigo, "JO");
        XJP.newInstanceField(codigo, "JP");
        XKE.newInstanceField(codigo, "KE");
        XKG.newInstanceField(codigo, "KG");
        XKH.newInstanceField(codigo, "KH");
        XKI.newInstanceField(codigo, "KI");
        XKM.newInstanceField(codigo, "KM");
        XKN.newInstanceField(codigo, "KN");
        XKP.newInstanceField(codigo, "KP");
        XKR.newInstanceField(codigo, "KR");
        XKW.newInstanceField(codigo, "KW");
        XKY.newInstanceField(codigo, "KY");
        XKZ.newInstanceField(codigo, "KZ");
        XLA.newInstanceField(codigo, "LA");
        XLB.newInstanceField(codigo, "LB");
        XLC.newInstanceField(codigo, "LC");
        XLI.newInstanceField(codigo, "LI");
        XLK.newInstanceField(codigo, "LK");
        XLR.newInstanceField(codigo, "LR");
        XLS.newInstanceField(codigo, "LS");
        XLT.newInstanceField(codigo, "LT");
        XLU.newInstanceField(codigo, "LU");
        XLV.newInstanceField(codigo, "LV");
        XLY.newInstanceField(codigo, "LY");
        XMA.newInstanceField(codigo, "MA");
        XMC.newInstanceField(codigo, "MC");
        XMD.newInstanceField(codigo, "MD");
        XME.newInstanceField(codigo, "ME");
        XMF.newInstanceField(codigo, "MF");
        XMG.newInstanceField(codigo, "MG");
        XMH.newInstanceField(codigo, "MH");
        XMK.newInstanceField(codigo, "MK");
        XML.newInstanceField(codigo, "ML");
        XMM.newInstanceField(codigo, "MM");
        XMN.newInstanceField(codigo, "MN");
        XMO.newInstanceField(codigo, "MO");
        XMP.newInstanceField(codigo, "MP");
        XMQ.newInstanceField(codigo, "MQ");
        XMR.newInstanceField(codigo, "MR");
        XMS.newInstanceField(codigo, "MS");
        XMT.newInstanceField(codigo, "MT");
        XMU.newInstanceField(codigo, "MU");
        XMV.newInstanceField(codigo, "MV");
        XMW.newInstanceField(codigo, "MW");
        XMX.newInstanceField(codigo, "MX");
        XMY.newInstanceField(codigo, "MY");
        XMZ.newInstanceField(codigo, "MZ");
        XNA.newInstanceField(codigo, "NA");
        XNC.newInstanceField(codigo, "NC");
        XNE.newInstanceField(codigo, "NE");
        XNF.newInstanceField(codigo, "NF");
        XNG.newInstanceField(codigo, "NG");
        XNI.newInstanceField(codigo, "NI");
        XNL.newInstanceField(codigo, "NL");
        XNO.newInstanceField(codigo, "NO");
        XNP.newInstanceField(codigo, "NP");
        XNR.newInstanceField(codigo, "NR");
        XNU.newInstanceField(codigo, "NU");
        XNZ.newInstanceField(codigo, "NZ");
        XOM.newInstanceField(codigo, "OM");
        XPA.newInstanceField(codigo, "PA");
        XPE.newInstanceField(codigo, "PE");
        XPF.newInstanceField(codigo, "PF");
        XPG.newInstanceField(codigo, "PG");
        XPH.newInstanceField(codigo, "PH");
        XPK.newInstanceField(codigo, "PK");
        XPL.newInstanceField(codigo, "PL");
        XPM.newInstanceField(codigo, "PM");
        XPN.newInstanceField(codigo, "PN");
        XPR.newInstanceField(codigo, "PR");
        XPS.newInstanceField(codigo, "PS");
        XPT.newInstanceField(codigo, "PT");
        XPW.newInstanceField(codigo, "PW");
        XPY.newInstanceField(codigo, "PY");
        XQA.newInstanceField(codigo, "QA");
        XRE.newInstanceField(codigo, "RE");
        XRO.newInstanceField(codigo, "RO");
        XRS.newInstanceField(codigo, "RS");
        XRU.newInstanceField(codigo, "RU");
        XRW.newInstanceField(codigo, "RW");
        XSA.newInstanceField(codigo, "SA");
        XSB.newInstanceField(codigo, "SB");
        XSC.newInstanceField(codigo, "SC");
        XSD.newInstanceField(codigo, "SD");
        XSE.newInstanceField(codigo, "SE");
        XSG.newInstanceField(codigo, "SG");
        XSH.newInstanceField(codigo, "SH");
        XSI.newInstanceField(codigo, "SI");
        XSJ.newInstanceField(codigo, "SJ");
        XSK.newInstanceField(codigo, "SK");
        XSL.newInstanceField(codigo, "SL");
        XSM.newInstanceField(codigo, "SM");
        XSN.newInstanceField(codigo, "SN");
        XSO.newInstanceField(codigo, "SO");
        XSR.newInstanceField(codigo, "SR");
        XSS.newInstanceField(codigo, "SS");
        XST.newInstanceField(codigo, "ST");
        XSV.newInstanceField(codigo, "SV");
        XSX.newInstanceField(codigo, "SX");
        XSY.newInstanceField(codigo, "SY");
        XSZ.newInstanceField(codigo, "SZ");
        XTC.newInstanceField(codigo, "TC");
        XTD.newInstanceField(codigo, "TD");
        XTF.newInstanceField(codigo, "TF");
        XTG.newInstanceField(codigo, "TG");
        XTH.newInstanceField(codigo, "TH");
        XTJ.newInstanceField(codigo, "TJ");
        XTK.newInstanceField(codigo, "TK");
        XTL.newInstanceField(codigo, "TL");
        XTM.newInstanceField(codigo, "TM");
        XTN.newInstanceField(codigo, "TN");
        XTO.newInstanceField(codigo, "TO");
        XTR.newInstanceField(codigo, "TR");
        XTT.newInstanceField(codigo, "TT");
        XTV.newInstanceField(codigo, "TV");
        XTW.newInstanceField(codigo, "TW");
        XTZ.newInstanceField(codigo, "TZ");
        XUA.newInstanceField(codigo, "UA");
        XUG.newInstanceField(codigo, "UG");
        XUM.newInstanceField(codigo, "UM");
        XUS.newInstanceField(codigo, "US");
        XUY.newInstanceField(codigo, "UY");
        XUZ.newInstanceField(codigo, "UZ");
        XVA.newInstanceField(codigo, "VA");
        XVC.newInstanceField(codigo, "VC");
        XVE.newInstanceField(codigo, "VE");
        XVG.newInstanceField(codigo, "VG");
        XVI.newInstanceField(codigo, "VI");
        XVN.newInstanceField(codigo, "VN");
        XVU.newInstanceField(codigo, "VU");
        XWF.newInstanceField(codigo, "WF");
        XWS.newInstanceField(codigo, "WS");
        XYE.newInstanceField(codigo, "YE");
        XYT.newInstanceField(codigo, "YT");
        XZA.newInstanceField(codigo, "ZA");
        XZM.newInstanceField(codigo, "ZM");
        XZW.newInstanceField(codigo, "ZW");
        // </editor-fold>
        /**/
        // <editor-fold defaultstate="collapsed" desc="newInstanceField(nombre)">
        XAD.newInstanceField(nombre, "Andorrana");
        XAE.newInstanceField(nombre, "Emiratí");
        XAF.newInstanceField(nombre, "Afgana");
        XAG.newInstanceField(nombre, "Antiguana");
        XAI.newInstanceField(nombre, "Anguilana");
        XAL.newInstanceField(nombre, "Albana");
        XAM.newInstanceField(nombre, "Armenia");
        XAO.newInstanceField(nombre, "Angolana");
        XAQ.newInstanceField(nombre, "Antarctica");
        XAR.newInstanceField(nombre, "Argentina");
        XAS.newInstanceField(nombre, "Samoamericana");
        XAT.newInstanceField(nombre, "Austríaca");
        XAU.newInstanceField(nombre, "Australiana");
        XAW.newInstanceField(nombre, "Arubeña");
        XAX.newInstanceField(nombre, "Alandesa");
        XAZ.newInstanceField(nombre, "Azerbaiyana");
        XBA.newInstanceField(nombre, "Bosnia");
        XBB.newInstanceField(nombre, "Barbadense");
        XBD.newInstanceField(nombre, "Bangladesí");
        XBE.newInstanceField(nombre, "Belga");
        XBF.newInstanceField(nombre, "Burkinesa");
        XBG.newInstanceField(nombre, "Búlgara");
        XBH.newInstanceField(nombre, "Bahreiní");
        XBI.newInstanceField(nombre, "Burundesa");
        XBJ.newInstanceField(nombre, "Beninesa");
        XBL.newInstanceField(nombre, "Sanbartolomeana");
        XBM.newInstanceField(nombre, "Bermudeña");
        XBN.newInstanceField(nombre, "Bruneana");
        XBO.newInstanceField(nombre, "Boliviana");
        XBQ.newInstanceField(nombre, "Bonairense");
        XBR.newInstanceField(nombre, "Brasilera");
        XBS.newInstanceField(nombre, "Bahameña");
        XBT.newInstanceField(nombre, "Butanesa");
        XBV.newInstanceField(nombre, "Bouvetense");
        XBW.newInstanceField(nombre, "Botsuana");
        XBY.newInstanceField(nombre, "Bielorrusa");
        XBZ.newInstanceField(nombre, "Beliceña");
        XCA.newInstanceField(nombre, "Canadiense");
        XCC.newInstanceField(nombre, "Cocona");
        XCD.newInstanceField(nombre, "Congolesa");
        XCF.newInstanceField(nombre, "Centroafricana");
        XCG.newInstanceField(nombre, "Congolesa");
        XCH.newInstanceField(nombre, "Suiza");
        XCI.newInstanceField(nombre, "Marfileña");
        XCK.newInstanceField(nombre, "Cookiana");
        XCL.newInstanceField(nombre, "Chilena");
        XCM.newInstanceField(nombre, "Camerunesa");
        XCN.newInstanceField(nombre, "China");
        XCO.newInstanceField(nombre, "Colombiana");
        XCR.newInstanceField(nombre, "Costarricense");
        XCU.newInstanceField(nombre, "Cubana");
        XCV.newInstanceField(nombre, "Caboverdiana");
        XCW.newInstanceField(nombre, "Curazoleña");
        XCX.newInstanceField(nombre, "Navideña");
        XCY.newInstanceField(nombre, "Chipriota");
        XCZ.newInstanceField(nombre, "Checa");
        XDE.newInstanceField(nombre, "Alemán");
        XDJ.newInstanceField(nombre, "Djibouti");
        XDK.newInstanceField(nombre, "Danesa");
        XDM.newInstanceField(nombre, "Dominiquesa");
        XDO.newInstanceField(nombre, "Dominicana");
        XDZ.newInstanceField(nombre, "Argelina");
        XEC.newInstanceField(nombre, "Ecuatoriana");
        XEE.newInstanceField(nombre, "Estonia");
        XEG.newInstanceField(nombre, "Egipcia");
        XEH.newInstanceField(nombre, "Saharauí");
        XER.newInstanceField(nombre, "Eritrea");
        XES.newInstanceField(nombre, "Española");
        XET.newInstanceField(nombre, "Etíope");
        XFI.newInstanceField(nombre, "Finlandesa");
        XFJ.newInstanceField(nombre, "Fiyiana");
        XFK.newInstanceField(nombre, "Malvinense");
        XFM.newInstanceField(nombre, "Micronesia");
        XFO.newInstanceField(nombre, "Feroesa");
        XFR.newInstanceField(nombre, "Francesa");
        XGA.newInstanceField(nombre, "Gabonesa");
        XGB.newInstanceField(nombre, "Británica");
        XGD.newInstanceField(nombre, "Granadina");
        XGE.newInstanceField(nombre, "Georgiana");
        XGF.newInstanceField(nombre, "Guayanesa");
        XGG.newInstanceField(nombre, "Guernsey");
        XGH.newInstanceField(nombre, "Ghanesa");
        XGI.newInstanceField(nombre, "Gibraltareña");
        XGL.newInstanceField(nombre, "Groenlandés");
        XGM.newInstanceField(nombre, "Gambiana");
        XGN.newInstanceField(nombre, "Guineana");
        XGP.newInstanceField(nombre, "Guadalupe");
        XGQ.newInstanceField(nombre, "Guineana");
        XGR.newInstanceField(nombre, "Griega");
        XGS.newInstanceField(nombre, "Georgiana");
        XGT.newInstanceField(nombre, "Guatemalteca");
        XGU.newInstanceField(nombre, "Guameña");
        XGW.newInstanceField(nombre, "Guineana");
        XGY.newInstanceField(nombre, "Guayanasa");
        XHK.newInstanceField(nombre, "Hongkonesa");
        XHM.newInstanceField(nombre, "Heardiana");
        XHN.newInstanceField(nombre, "Hondureña");
        XHR.newInstanceField(nombre, "Croata");
        XHT.newInstanceField(nombre, "Haitiana");
        XHU.newInstanceField(nombre, "Hungara");
        XID.newInstanceField(nombre, "Indonesia");
        XIE.newInstanceField(nombre, "Irlandesa");
        XIL.newInstanceField(nombre, "Israelí");
        XIM.newInstanceField(nombre, "Manesa");
        XIN.newInstanceField(nombre, "India");
        XIO.newInstanceField(nombre, "Británica");
        XIQ.newInstanceField(nombre, "Iraquí");
        XIR.newInstanceField(nombre, "Irání");
        XIS.newInstanceField(nombre, "Islandesa");
        XIT.newInstanceField(nombre, "Italiana");
        XJE.newInstanceField(nombre, "Jerseyesa");
        XJM.newInstanceField(nombre, "Jamaiquina");
        XJO.newInstanceField(nombre, "Jordana");
        XJP.newInstanceField(nombre, "Japonesa");
        XKE.newInstanceField(nombre, "Keniana");
        XKG.newInstanceField(nombre, "Kirguisa");
        XKH.newInstanceField(nombre, "Camboyana");
        XKI.newInstanceField(nombre, "Kiribatiana");
        XKM.newInstanceField(nombre, "Comorana");
        XKN.newInstanceField(nombre, "Sancristobaleña");
        XKP.newInstanceField(nombre, "Norcoreana");
        XKR.newInstanceField(nombre, "Surcoreana");
        XKW.newInstanceField(nombre, "Kuwaití");
        XKY.newInstanceField(nombre, "Caimanesa");
        XKZ.newInstanceField(nombre, "Kazaja");
        XLA.newInstanceField(nombre, "Laosiana");
        XLB.newInstanceField(nombre, "Líbanesa");
        XLC.newInstanceField(nombre, "Santalucense");
        XLI.newInstanceField(nombre, "Liechtensteiniana");
        XLK.newInstanceField(nombre, "Ceilanesa");
        XLR.newInstanceField(nombre, "Liberiana");
        XLS.newInstanceField(nombre, "Lesotense");
        XLT.newInstanceField(nombre, "Lituana");
        XLU.newInstanceField(nombre, "Luxemburguesa");
        XLV.newInstanceField(nombre, "Letona");
        XLY.newInstanceField(nombre, "Libia");
        XMA.newInstanceField(nombre, "Marroquí");
        XMC.newInstanceField(nombre, "Monegasca");
        XMD.newInstanceField(nombre, "Moldava");
        XME.newInstanceField(nombre, "Montenegrina");
        XMF.newInstanceField(nombre, "Sanmartinense");
        XMG.newInstanceField(nombre, "Malgache");
        XMH.newInstanceField(nombre, "Marshalesa");
        XMK.newInstanceField(nombre, "Macedonia");
        XML.newInstanceField(nombre, "Maliense");
        XMM.newInstanceField(nombre, "Myanmarense");
        XMN.newInstanceField(nombre, "Mongola");
        XMO.newInstanceField(nombre, "Macaense");
        XMP.newInstanceField(nombre, "Chamorra");
        XMQ.newInstanceField(nombre, "Martinica");
        XMR.newInstanceField(nombre, "Mauritana");
        XMS.newInstanceField(nombre, "Montserratina");
        XMT.newInstanceField(nombre, "Maltesa");
        XMU.newInstanceField(nombre, "Mauriciana");
        XMV.newInstanceField(nombre, "Maldiva");
        XMW.newInstanceField(nombre, "Malawi");
        XMX.newInstanceField(nombre, "Méxicana");
        XMY.newInstanceField(nombre, "Malasia");
        XMZ.newInstanceField(nombre, "Mozambiqueña");
        XNA.newInstanceField(nombre, "Namibia");
        XNC.newInstanceField(nombre, "Neocaledonia");
        XNE.newInstanceField(nombre, "Nigerina");
        XNF.newInstanceField(nombre, "Norfolkense");
        XNG.newInstanceField(nombre, "Nigeriana");
        XNI.newInstanceField(nombre, "Nicaraguense");
        XNL.newInstanceField(nombre, "Países Bajos");
        XNO.newInstanceField(nombre, "Noruega");
        XNP.newInstanceField(nombre, "Nepalesa");
        XNR.newInstanceField(nombre, "Nauruana");
        XNU.newInstanceField(nombre, "Niueña");
        XNZ.newInstanceField(nombre, "Neozelandesa");
        XOM.newInstanceField(nombre, "Omaní");
        XPA.newInstanceField(nombre, "Panameña");
        XPE.newInstanceField(nombre, "Peruana");
        XPF.newInstanceField(nombre, "Francopolinesia");
        XPG.newInstanceField(nombre, "Papúa");
        XPH.newInstanceField(nombre, "Filipina");
        XPK.newInstanceField(nombre, "Pakistaní");
        XPL.newInstanceField(nombre, "Polaca");
        XPM.newInstanceField(nombre, "Sanpedrino");
        XPN.newInstanceField(nombre, "Pitcairnés");
        XPR.newInstanceField(nombre, "Puertorriqueña");
        XPS.newInstanceField(nombre, "Palestina");
        XPT.newInstanceField(nombre, "Portuguesa");
        XPW.newInstanceField(nombre, "Palauana");
        XPY.newInstanceField(nombre, "Paraguaya");
        XQA.newInstanceField(nombre, "Katarí");
        XRE.newInstanceField(nombre, "Reunión");
        XRO.newInstanceField(nombre, "Rumana");
        XRS.newInstanceField(nombre, "Serbia");
        XRU.newInstanceField(nombre, "Rusa");
        XRW.newInstanceField(nombre, "Ruandesa");
        XSA.newInstanceField(nombre, "Saudí");
        XSB.newInstanceField(nombre, "Salomonense");
        XSC.newInstanceField(nombre, "Seychelense");
        XSD.newInstanceField(nombre, "Sudanés");
        XSE.newInstanceField(nombre, "Sueca");
        XSG.newInstanceField(nombre, "Singapurense");
        XSH.newInstanceField(nombre, "Santahelena");
        XSI.newInstanceField(nombre, "Eslovena");
        XSJ.newInstanceField(nombre, "Svalbarense");
        XSK.newInstanceField(nombre, "Eslovaca");
        XSL.newInstanceField(nombre, "Sierraleonesa");
        XSM.newInstanceField(nombre, "Sanmarinense");
        XSN.newInstanceField(nombre, "Senegalés");
        XSO.newInstanceField(nombre, "Somalí");
        XSR.newInstanceField(nombre, "Surinamesa");
        XSS.newInstanceField(nombre, "Sursudanés");
        XST.newInstanceField(nombre, "Santotomense");
        XSV.newInstanceField(nombre, "Salvadoreña");
        XSX.newInstanceField(nombre, "Sanmartinense");
        XSY.newInstanceField(nombre, "Siria");
        XSZ.newInstanceField(nombre, "Eswatini");
        XTC.newInstanceField(nombre, "Turcocaiqueña");
        XTD.newInstanceField(nombre, "Chadiana");
        XTF.newInstanceField(nombre, "Francesa");
        XTG.newInstanceField(nombre, "Togolesa");
        XTH.newInstanceField(nombre, "Tailandesa");
        XTJ.newInstanceField(nombre, "Tayika");
        XTK.newInstanceField(nombre, "Tokelauense");
        XTL.newInstanceField(nombre, "Timorense");
        XTM.newInstanceField(nombre, "Turcomana");
        XTN.newInstanceField(nombre, "Tunecina");
        XTO.newInstanceField(nombre, "Tongana");
        XTR.newInstanceField(nombre, "Turca");
        XTT.newInstanceField(nombre, "Trinitense");
        XTV.newInstanceField(nombre, "Tuvaluana");
        XTW.newInstanceField(nombre, "Taiwanesa");
        XTZ.newInstanceField(nombre, "Tanzana");
        XUA.newInstanceField(nombre, "Ucraniana");
        XUG.newInstanceField(nombre, "Ugandesa");
        XUM.newInstanceField(nombre, "Insular estadounidense");
        XUS.newInstanceField(nombre, "Estadounidense");
        XUY.newInstanceField(nombre, "Uruguaya");
        XUZ.newInstanceField(nombre, "Uzbeka");
        XVA.newInstanceField(nombre, "Vaticana");
        XVC.newInstanceField(nombre, "Sanvicentina");
        XVE.newInstanceField(nombre, "Venezolana");
        XVG.newInstanceField(nombre, "Virgenense británica");
        XVI.newInstanceField(nombre, "Virgenense estadounidense");
        XVN.newInstanceField(nombre, "Vietnamita");
        XVU.newInstanceField(nombre, "Vanuatuense");
        XWF.newInstanceField(nombre, "Walisiana");
        XWS.newInstanceField(nombre, "Samoana");
        XYE.newInstanceField(nombre, "Yemení");
        XYT.newInstanceField(nombre, "Mayotense");
        XZA.newInstanceField(nombre, "Sudafricana");
        XZM.newInstanceField(nombre, "Zambiana");
        XZW.newInstanceField(nombre, "Zimbabuense");
        // </editor-fold>
        /**/
        // <editor-fold defaultstate="collapsed" desc="newInstanceField(pais)">
        XAD.newInstanceField(pais, pais.XAD);
        XAE.newInstanceField(pais, pais.XAE);
        XAF.newInstanceField(pais, pais.XAF);
        XAG.newInstanceField(pais, pais.XAG);
        XAI.newInstanceField(pais, pais.XAI);
        XAL.newInstanceField(pais, pais.XAL);
        XAM.newInstanceField(pais, pais.XAM);
        XAO.newInstanceField(pais, pais.XAO);
        XAQ.newInstanceField(pais, pais.XAQ);
        XAR.newInstanceField(pais, pais.XAR);
        XAS.newInstanceField(pais, pais.XAS);
        XAT.newInstanceField(pais, pais.XAT);
        XAU.newInstanceField(pais, pais.XAU);
        XAW.newInstanceField(pais, pais.XAW);
        XAX.newInstanceField(pais, pais.XAX);
        XAZ.newInstanceField(pais, pais.XAZ);
        XBA.newInstanceField(pais, pais.XBA);
        XBB.newInstanceField(pais, pais.XBB);
        XBD.newInstanceField(pais, pais.XBD);
        XBE.newInstanceField(pais, pais.XBE);
        XBF.newInstanceField(pais, pais.XBF);
        XBG.newInstanceField(pais, pais.XBG);
        XBH.newInstanceField(pais, pais.XBH);
        XBI.newInstanceField(pais, pais.XBI);
        XBJ.newInstanceField(pais, pais.XBJ);
        XBL.newInstanceField(pais, pais.XBL);
        XBM.newInstanceField(pais, pais.XBM);
        XBN.newInstanceField(pais, pais.XBN);
        XBO.newInstanceField(pais, pais.XBO);
        XBQ.newInstanceField(pais, pais.XBQ);
        XBR.newInstanceField(pais, pais.XBR);
        XBS.newInstanceField(pais, pais.XBS);
        XBT.newInstanceField(pais, pais.XBT);
        XBV.newInstanceField(pais, pais.XBV);
        XBW.newInstanceField(pais, pais.XBW);
        XBY.newInstanceField(pais, pais.XBY);
        XBZ.newInstanceField(pais, pais.XBZ);
        XCA.newInstanceField(pais, pais.XCA);
        XCC.newInstanceField(pais, pais.XCC);
        XCD.newInstanceField(pais, pais.XCD);
        XCF.newInstanceField(pais, pais.XCF);
        XCG.newInstanceField(pais, pais.XCG);
        XCH.newInstanceField(pais, pais.XCH);
        XCI.newInstanceField(pais, pais.XCI);
        XCK.newInstanceField(pais, pais.XCK);
        XCL.newInstanceField(pais, pais.XCL);
        XCM.newInstanceField(pais, pais.XCM);
        XCN.newInstanceField(pais, pais.XCN);
        XCO.newInstanceField(pais, pais.XCO);
        XCR.newInstanceField(pais, pais.XCR);
        XCU.newInstanceField(pais, pais.XCU);
        XCV.newInstanceField(pais, pais.XCV);
        XCW.newInstanceField(pais, pais.XCW);
        XCX.newInstanceField(pais, pais.XCX);
        XCY.newInstanceField(pais, pais.XCY);
        XCZ.newInstanceField(pais, pais.XCZ);
        XDE.newInstanceField(pais, pais.XDE);
        XDJ.newInstanceField(pais, pais.XDJ);
        XDK.newInstanceField(pais, pais.XDK);
        XDM.newInstanceField(pais, pais.XDM);
        XDO.newInstanceField(pais, pais.XDO);
        XDZ.newInstanceField(pais, pais.XDZ);
        XEC.newInstanceField(pais, pais.XEC);
        XEE.newInstanceField(pais, pais.XEE);
        XEG.newInstanceField(pais, pais.XEG);
        XEH.newInstanceField(pais, pais.XEH);
        XER.newInstanceField(pais, pais.XER);
        XES.newInstanceField(pais, pais.XES);
        XET.newInstanceField(pais, pais.XET);
        XFI.newInstanceField(pais, pais.XFI);
        XFJ.newInstanceField(pais, pais.XFJ);
        XFK.newInstanceField(pais, pais.XFK);
        XFM.newInstanceField(pais, pais.XFM);
        XFO.newInstanceField(pais, pais.XFO);
        XFR.newInstanceField(pais, pais.XFR);
        XGA.newInstanceField(pais, pais.XGA);
        XGB.newInstanceField(pais, pais.XGB);
        XGD.newInstanceField(pais, pais.XGD);
        XGE.newInstanceField(pais, pais.XGE);
        XGF.newInstanceField(pais, pais.XGF);
        XGG.newInstanceField(pais, pais.XGG);
        XGH.newInstanceField(pais, pais.XGH);
        XGI.newInstanceField(pais, pais.XGI);
        XGL.newInstanceField(pais, pais.XGL);
        XGM.newInstanceField(pais, pais.XGM);
        XGN.newInstanceField(pais, pais.XGN);
        XGP.newInstanceField(pais, pais.XGP);
        XGQ.newInstanceField(pais, pais.XGQ);
        XGR.newInstanceField(pais, pais.XGR);
        XGS.newInstanceField(pais, pais.XGS);
        XGT.newInstanceField(pais, pais.XGT);
        XGU.newInstanceField(pais, pais.XGU);
        XGW.newInstanceField(pais, pais.XGW);
        XGY.newInstanceField(pais, pais.XGY);
        XHK.newInstanceField(pais, pais.XHK);
        XHM.newInstanceField(pais, pais.XHM);
        XHN.newInstanceField(pais, pais.XHN);
        XHR.newInstanceField(pais, pais.XHR);
        XHT.newInstanceField(pais, pais.XHT);
        XHU.newInstanceField(pais, pais.XHU);
        XID.newInstanceField(pais, pais.XID);
        XIE.newInstanceField(pais, pais.XIE);
        XIL.newInstanceField(pais, pais.XIL);
        XIM.newInstanceField(pais, pais.XIM);
        XIN.newInstanceField(pais, pais.XIN);
        XIO.newInstanceField(pais, pais.XIO);
        XIQ.newInstanceField(pais, pais.XIQ);
        XIR.newInstanceField(pais, pais.XIR);
        XIS.newInstanceField(pais, pais.XIS);
        XIT.newInstanceField(pais, pais.XIT);
        XJE.newInstanceField(pais, pais.XJE);
        XJM.newInstanceField(pais, pais.XJM);
        XJO.newInstanceField(pais, pais.XJO);
        XJP.newInstanceField(pais, pais.XJP);
        XKE.newInstanceField(pais, pais.XKE);
        XKG.newInstanceField(pais, pais.XKG);
        XKH.newInstanceField(pais, pais.XKH);
        XKI.newInstanceField(pais, pais.XKI);
        XKM.newInstanceField(pais, pais.XKM);
        XKN.newInstanceField(pais, pais.XKN);
        XKP.newInstanceField(pais, pais.XKP);
        XKR.newInstanceField(pais, pais.XKR);
        XKW.newInstanceField(pais, pais.XKW);
        XKY.newInstanceField(pais, pais.XKY);
        XKZ.newInstanceField(pais, pais.XKZ);
        XLA.newInstanceField(pais, pais.XLA);
        XLB.newInstanceField(pais, pais.XLB);
        XLC.newInstanceField(pais, pais.XLC);
        XLI.newInstanceField(pais, pais.XLI);
        XLK.newInstanceField(pais, pais.XLK);
        XLR.newInstanceField(pais, pais.XLR);
        XLS.newInstanceField(pais, pais.XLS);
        XLT.newInstanceField(pais, pais.XLT);
        XLU.newInstanceField(pais, pais.XLU);
        XLV.newInstanceField(pais, pais.XLV);
        XLY.newInstanceField(pais, pais.XLY);
        XMA.newInstanceField(pais, pais.XMA);
        XMC.newInstanceField(pais, pais.XMC);
        XMD.newInstanceField(pais, pais.XMD);
        XME.newInstanceField(pais, pais.XME);
        XMF.newInstanceField(pais, pais.XMF);
        XMG.newInstanceField(pais, pais.XMG);
        XMH.newInstanceField(pais, pais.XMH);
        XMK.newInstanceField(pais, pais.XMK);
        XML.newInstanceField(pais, pais.XML);
        XMM.newInstanceField(pais, pais.XMM);
        XMN.newInstanceField(pais, pais.XMN);
        XMO.newInstanceField(pais, pais.XMO);
        XMP.newInstanceField(pais, pais.XMP);
        XMQ.newInstanceField(pais, pais.XMQ);
        XMR.newInstanceField(pais, pais.XMR);
        XMS.newInstanceField(pais, pais.XMS);
        XMT.newInstanceField(pais, pais.XMT);
        XMU.newInstanceField(pais, pais.XMU);
        XMV.newInstanceField(pais, pais.XMV);
        XMW.newInstanceField(pais, pais.XMW);
        XMX.newInstanceField(pais, pais.XMX);
        XMY.newInstanceField(pais, pais.XMY);
        XMZ.newInstanceField(pais, pais.XMZ);
        XNA.newInstanceField(pais, pais.XNA);
        XNC.newInstanceField(pais, pais.XNC);
        XNE.newInstanceField(pais, pais.XNE);
        XNF.newInstanceField(pais, pais.XNF);
        XNG.newInstanceField(pais, pais.XNG);
        XNI.newInstanceField(pais, pais.XNI);
        XNL.newInstanceField(pais, pais.XNL);
        XNO.newInstanceField(pais, pais.XNO);
        XNP.newInstanceField(pais, pais.XNP);
        XNR.newInstanceField(pais, pais.XNR);
        XNU.newInstanceField(pais, pais.XNU);
        XNZ.newInstanceField(pais, pais.XNZ);
        XOM.newInstanceField(pais, pais.XOM);
        XPA.newInstanceField(pais, pais.XPA);
        XPE.newInstanceField(pais, pais.XPE);
        XPF.newInstanceField(pais, pais.XPF);
        XPG.newInstanceField(pais, pais.XPG);
        XPH.newInstanceField(pais, pais.XPH);
        XPK.newInstanceField(pais, pais.XPK);
        XPL.newInstanceField(pais, pais.XPL);
        XPM.newInstanceField(pais, pais.XPM);
        XPN.newInstanceField(pais, pais.XPN);
        XPR.newInstanceField(pais, pais.XPR);
        XPS.newInstanceField(pais, pais.XPS);
        XPT.newInstanceField(pais, pais.XPT);
        XPW.newInstanceField(pais, pais.XPW);
        XPY.newInstanceField(pais, pais.XPY);
        XQA.newInstanceField(pais, pais.XQA);
        XRE.newInstanceField(pais, pais.XRE);
        XRO.newInstanceField(pais, pais.XRO);
        XRS.newInstanceField(pais, pais.XRS);
        XRU.newInstanceField(pais, pais.XRU);
        XRW.newInstanceField(pais, pais.XRW);
        XSA.newInstanceField(pais, pais.XSA);
        XSB.newInstanceField(pais, pais.XSB);
        XSC.newInstanceField(pais, pais.XSC);
        XSD.newInstanceField(pais, pais.XSD);
        XSE.newInstanceField(pais, pais.XSE);
        XSG.newInstanceField(pais, pais.XSG);
        XSH.newInstanceField(pais, pais.XSH);
        XSI.newInstanceField(pais, pais.XSI);
        XSJ.newInstanceField(pais, pais.XSJ);
        XSK.newInstanceField(pais, pais.XSK);
        XSL.newInstanceField(pais, pais.XSL);
        XSM.newInstanceField(pais, pais.XSM);
        XSN.newInstanceField(pais, pais.XSN);
        XSO.newInstanceField(pais, pais.XSO);
        XSR.newInstanceField(pais, pais.XSR);
        XSS.newInstanceField(pais, pais.XSS);
        XST.newInstanceField(pais, pais.XST);
        XSV.newInstanceField(pais, pais.XSV);
        XSX.newInstanceField(pais, pais.XSX);
        XSY.newInstanceField(pais, pais.XSY);
        XSZ.newInstanceField(pais, pais.XSZ);
        XTC.newInstanceField(pais, pais.XTC);
        XTD.newInstanceField(pais, pais.XTD);
        XTF.newInstanceField(pais, pais.XTF);
        XTG.newInstanceField(pais, pais.XTG);
        XTH.newInstanceField(pais, pais.XTH);
        XTJ.newInstanceField(pais, pais.XTJ);
        XTK.newInstanceField(pais, pais.XTK);
        XTL.newInstanceField(pais, pais.XTL);
        XTM.newInstanceField(pais, pais.XTM);
        XTN.newInstanceField(pais, pais.XTN);
        XTO.newInstanceField(pais, pais.XTO);
        XTR.newInstanceField(pais, pais.XTR);
        XTT.newInstanceField(pais, pais.XTT);
        XTV.newInstanceField(pais, pais.XTV);
        XTW.newInstanceField(pais, pais.XTW);
        XTZ.newInstanceField(pais, pais.XTZ);
        XUA.newInstanceField(pais, pais.XUA);
        XUG.newInstanceField(pais, pais.XUG);
        XUM.newInstanceField(pais, pais.XUM);
        XUS.newInstanceField(pais, pais.XUS);
        XUY.newInstanceField(pais, pais.XUY);
        XUZ.newInstanceField(pais, pais.XUZ);
        XVA.newInstanceField(pais, pais.XVA);
        XVC.newInstanceField(pais, pais.XVC);
        XVE.newInstanceField(pais, pais.XVE);
        XVG.newInstanceField(pais, pais.XVG);
        XVI.newInstanceField(pais, pais.XVI);
        XVN.newInstanceField(pais, pais.XVN);
        XVU.newInstanceField(pais, pais.XVU);
        XWF.newInstanceField(pais, pais.XWF);
        XWS.newInstanceField(pais, pais.XWS);
        XYE.newInstanceField(pais, pais.XYE);
        XYT.newInstanceField(pais, pais.XYT);
        XZA.newInstanceField(pais, pais.XZA);
        XZM.newInstanceField(pais, pais.XZM);
        XZW.newInstanceField(pais, pais.XZW);
        // </editor-fold>
        /**/
    }

}
