/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.configuracion.fija;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import adalid.core.properties.ext.GoogleMapProperty;
import java.lang.reflect.Field;

/**
 * Paises con códigos de la norma ISO 3166-1.
 *
 * @author Jorge Campins
 * @see <a href="https://es.wikipedia.org/wiki/ISO_3166-1">ISO 3166-1</a>
 */
@EntityReferenceDisplay(style = EntityReferenceStyle.NAME)
@EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME_AND_CHARACTER_KEY)
@EntityTableView(enabled = Kleenean.TRUE, rows = 5)
@EntityDetailView(enabled = Kleenean.TRUE)
public class Pais extends AbstractPersistentEnumerationEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public Pais(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("país");
        setDefaultCollectionLabel("Países");
    }

    @PrimaryKey
    public IntegerProperty numero;

    @VersionProperty
    public LongProperty version;

    @BusinessKey
    @StringField(maxLength = 2, translatable = Kleenean.FALSE)
    public StringProperty codigo;

    @NameProperty
    @PropertyField(update = Kleenean.TRUE)
    public StringProperty nombre;

    @StringField(maxLength = 10)
    public StringProperty e164;

    @ColumnField(nullable = Kleenean.FALSE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @OneToOne(navigability = Navigability.UNIDIRECTIONAL)
    @PropertyField(table = Kleenean.TRUE, columnFilter = Kleenean.FALSE)
    public Nacionalidad nacionalidad;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(table = Kleenean.TRUE)
    public BooleanProperty sede;

    @ImageProperty(avatarShape = AvatarShape.RECTANGLE, avatarDefault = AvatarDefault.UNSEEN)
    @PropertyField(table = Kleenean.TRUE)
    public BinaryProperty bandera;

    @ColumnField(calculable = Kleenean.TRUE)
    @FileReference(types = MimeType.IMAGE, blobField = "bandera")
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.FALSE, report = Kleenean.FALSE)
    public StringProperty archivoBandera;

    @GraphicImage
    @PropertyField(table = Kleenean.TRUE)
    public BinaryProperty escudo;

    @ColumnField(calculable = Kleenean.TRUE)
    @FileReference(types = MimeType.IMAGE, blobField = "escudo")
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.FALSE, report = Kleenean.FALSE)
    public StringProperty archivoEscudo;

    /*
    @EmbeddedDocument(sourceType = EmbeddedDocumentType.IFRAME, sourceURLs = EMBED_MAPS, searchURL = GOOGLE_MAPS, displayWidth = 640, displayHeight = 480)
    @StringField(converter = GOOGLE_MAPS_EMBED_CONVERTER)
    @PropertyField(update = Kleenean.TRUE)
    public StringProperty mapa;

    /**/
    @EmbeddedDocument
    @PropertyField(update = Kleenean.TRUE)
    public GoogleMapProperty mapa;

    private static final String iframe_prefix_string = "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=";

    private static final String iframe_suffix_string = "\" width=\"640\" height=\"480\""
        + " allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>";

    private static final Expression iframe_prefix = charStringOf(iframe_prefix_string);

    private static final Expression iframe_suffix = charStringOf(iframe_suffix_string);

    @Override
    protected void settleProperties() {
        super.settleProperties();
        /**/
        setOrderBy(nombre);
        /**/
        codigo.setDefaultLabel("código");
        codigo.setDefaultDescription("código que identifica al país, según del estándar internacional de normalización ISO 3166-1 alfa-2");
        nombre.setDefaultLabel("país");
        e164.setDefaultLabel("prefijo telefónico");
        e164.setDefaultDescription("código numérico usado como prefijo para llamadas telefónicas internacionales");
        sede.setDefaultValue(false);
        bandera.setDefaultLabel("bandera");
        bandera.setDefaultTooltip("bandera del país");
        archivoBandera.setDefaultLabel("archivo bandera");
        archivoBandera.setDefaultTooltip("URL del archivo que contiene la bandera del país");
        archivoBandera.setCalculableValueExpression(bandera.fileReferenceCalculableValueExpression());
        escudo.setDefaultLabel("escudo");
        escudo.setDefaultTooltip("escudo del país");
        archivoEscudo.setDefaultLabel("archivo escudo");
        archivoEscudo.setDefaultTooltip("URL del archivo que contiene la escudo del país");
        archivoEscudo.setCalculableValueExpression(escudo.fileReferenceCalculableValueExpression());
        mapa.setDefaultDescription("Mapa provisto por Google Maps.\nEspecifique el nombre del país para obtener el mapa.");
        mapa.setDefaultShortDescription("Mapa provisto por Google Maps.\nEspecifique el nombre del país para obtener el mapa.");
        mapa.setDefaultValue(concat(iframe_prefix, nombre.diacriticlessAscii(), iframe_suffix)); // falla si nombre contiene caracteres especiales
    }

    public Instance XAD, XAE, XAF, XAG, XAI, XAL, XAM, XAO, XAQ, XAR, XAS, XAT, XAU, XAW, XAX, XAZ, XBA, XBB, XBD, XBE,
        XBF, XBG, XBH, XBI, XBJ, XBL, XBM, XBN, XBO, XBQ, XBR, XBS, XBT, XBV, XBW, XBY, XBZ, XCA, XCC, XCD,
        XCF, XCG, XCH, XCI, XCK, XCL, XCM, XCN, XCO, XCR, XCU, XCV, XCW, XCX, XCY, XCZ, XDE, XDJ, XDK, XDM,
        XDO, XDZ, XEC, XEE, XEG, XEH, XER, XES, XET, XFI, XFJ, XFK, XFM, XFO, XFR, XGA, XGB, XGD, XGE, XGF,
        XGG, XGH, XGI, XGL, XGM, XGN, XGP, XGQ, XGR, XGS, XGT, XGU, XGW, XGY, XHK, XHM, XHN, XHR, XHT, XHU,
        XID, XIE, XIL, XIM, XIN, XIO, XIQ, XIR, XIS, XIT, XJE, XJM, XJO, XJP, XKE, XKG, XKH, XKI, XKM, XKN,
        XKP, XKR, XKW, XKY, XKZ, XLA, XLB, XLC, XLI, XLK, XLR, XLS, XLT, XLU, XLV, XLY, XMA, XMC, XMD, XME,
        XMF, XMG, XMH, XMK, XML, XMM, XMN, XMO, XMP, XMQ, XMR, XMS, XMT, XMU, XMV, XMW, XMX, XMY, XMZ, XNA,
        XNC, XNE, XNF, XNG, XNI, XNL, XNO, XNP, XNR, XNU, XNZ, XOM, XPA, XPE, XPF, XPG, XPH, XPK, XPL, XPM,
        XPN, XPR, XPS, XPT, XPW, XPY, XQA, XRE, XRO, XRS, XRU, XRW, XSA, XSB, XSC, XSD, XSE, XSG, XSH, XSI,
        XSJ, XSK, XSL, XSM, XSN, XSO, XSR, XSS, XST, XSV, XSX, XSY, XSZ, XTC, XTD, XTF, XTG, XTH, XTJ, XTK,
        XTL, XTM, XTN, XTO, XTR, XTT, XTV, XTW, XTZ, XUA, XUG, XUM, XUS, XUY, XUZ, XVA, XVC, XVE, XVG, XVI,
        XVN, XVU, XWF, XWS, XYE, XYT, XZA, XZM, XZW; // la letra X evita coincidencias con palabras reservadas de SQL

    @Override
    protected void settleInstances() {
        super.settleInstances();
        /**/
        // <editor-fold defaultstate="collapsed" desc="newInstanceField(numero)">
        XAD.newInstanceField(numero, 20);
        XAE.newInstanceField(numero, 784);
        XAF.newInstanceField(numero, 4);
        XAG.newInstanceField(numero, 28);
        XAI.newInstanceField(numero, 660);
        XAL.newInstanceField(numero, 8);
        XAM.newInstanceField(numero, 51);
        XAO.newInstanceField(numero, 24);
        XAQ.newInstanceField(numero, 10);
        XAR.newInstanceField(numero, 32);
        XAS.newInstanceField(numero, 16);
        XAT.newInstanceField(numero, 40);
        XAU.newInstanceField(numero, 36);
        XAW.newInstanceField(numero, 533);
        XAX.newInstanceField(numero, 248);
        XAZ.newInstanceField(numero, 31);
        XBA.newInstanceField(numero, 70);
        XBB.newInstanceField(numero, 52);
        XBD.newInstanceField(numero, 50);
        XBE.newInstanceField(numero, 56);
        XBF.newInstanceField(numero, 854);
        XBG.newInstanceField(numero, 100);
        XBH.newInstanceField(numero, 48);
        XBI.newInstanceField(numero, 108);
        XBJ.newInstanceField(numero, 204);
        XBL.newInstanceField(numero, 652);
        XBM.newInstanceField(numero, 60);
        XBN.newInstanceField(numero, 96);
        XBO.newInstanceField(numero, 68);
        XBQ.newInstanceField(numero, 535);
        XBR.newInstanceField(numero, 76);
        XBS.newInstanceField(numero, 44);
        XBT.newInstanceField(numero, 64);
        XBV.newInstanceField(numero, 74);
        XBW.newInstanceField(numero, 72);
        XBY.newInstanceField(numero, 112);
        XBZ.newInstanceField(numero, 84);
        XCA.newInstanceField(numero, 124);
        XCC.newInstanceField(numero, 166);
        XCD.newInstanceField(numero, 180);
        XCF.newInstanceField(numero, 140);
        XCG.newInstanceField(numero, 178);
        XCH.newInstanceField(numero, 756);
        XCI.newInstanceField(numero, 384);
        XCK.newInstanceField(numero, 184);
        XCL.newInstanceField(numero, 152);
        XCM.newInstanceField(numero, 120);
        XCN.newInstanceField(numero, 156);
        XCO.newInstanceField(numero, 170);
        XCR.newInstanceField(numero, 188);
        XCU.newInstanceField(numero, 192);
        XCV.newInstanceField(numero, 132);
        XCW.newInstanceField(numero, 531);
        XCX.newInstanceField(numero, 162);
        XCY.newInstanceField(numero, 196);
        XCZ.newInstanceField(numero, 203);
        XDE.newInstanceField(numero, 276);
        XDJ.newInstanceField(numero, 262);
        XDK.newInstanceField(numero, 208);
        XDM.newInstanceField(numero, 212);
        XDO.newInstanceField(numero, 214);
        XDZ.newInstanceField(numero, 12);
        XEC.newInstanceField(numero, 218);
        XEE.newInstanceField(numero, 233);
        XEG.newInstanceField(numero, 818);
        XEH.newInstanceField(numero, 732);
        XER.newInstanceField(numero, 232);
        XES.newInstanceField(numero, 724);
        XET.newInstanceField(numero, 231);
        XFI.newInstanceField(numero, 246);
        XFJ.newInstanceField(numero, 242);
        XFK.newInstanceField(numero, 238);
        XFM.newInstanceField(numero, 583);
        XFO.newInstanceField(numero, 234);
        XFR.newInstanceField(numero, 250);
        XGA.newInstanceField(numero, 266);
        XGB.newInstanceField(numero, 826);
        XGD.newInstanceField(numero, 308);
        XGE.newInstanceField(numero, 268);
        XGF.newInstanceField(numero, 254);
        XGG.newInstanceField(numero, 831);
        XGH.newInstanceField(numero, 288);
        XGI.newInstanceField(numero, 292);
        XGL.newInstanceField(numero, 304);
        XGM.newInstanceField(numero, 270);
        XGN.newInstanceField(numero, 324);
        XGP.newInstanceField(numero, 312);
        XGQ.newInstanceField(numero, 226);
        XGR.newInstanceField(numero, 300);
        XGS.newInstanceField(numero, 239);
        XGT.newInstanceField(numero, 320);
        XGU.newInstanceField(numero, 316);
        XGW.newInstanceField(numero, 624);
        XGY.newInstanceField(numero, 328);
        XHK.newInstanceField(numero, 344);
        XHM.newInstanceField(numero, 334);
        XHN.newInstanceField(numero, 340);
        XHR.newInstanceField(numero, 191);
        XHT.newInstanceField(numero, 332);
        XHU.newInstanceField(numero, 348);
        XID.newInstanceField(numero, 360);
        XIE.newInstanceField(numero, 372);
        XIL.newInstanceField(numero, 376);
        XIM.newInstanceField(numero, 833);
        XIN.newInstanceField(numero, 356);
        XIO.newInstanceField(numero, 86);
        XIQ.newInstanceField(numero, 368);
        XIR.newInstanceField(numero, 364);
        XIS.newInstanceField(numero, 352);
        XIT.newInstanceField(numero, 380);
        XJE.newInstanceField(numero, 832);
        XJM.newInstanceField(numero, 388);
        XJO.newInstanceField(numero, 400);
        XJP.newInstanceField(numero, 392);
        XKE.newInstanceField(numero, 404);
        XKG.newInstanceField(numero, 417);
        XKH.newInstanceField(numero, 116);
        XKI.newInstanceField(numero, 296);
        XKM.newInstanceField(numero, 174);
        XKN.newInstanceField(numero, 659);
        XKP.newInstanceField(numero, 408);
        XKR.newInstanceField(numero, 410);
        XKW.newInstanceField(numero, 414);
        XKY.newInstanceField(numero, 136);
        XKZ.newInstanceField(numero, 398);
        XLA.newInstanceField(numero, 418);
        XLB.newInstanceField(numero, 422);
        XLC.newInstanceField(numero, 662);
        XLI.newInstanceField(numero, 438);
        XLK.newInstanceField(numero, 144);
        XLR.newInstanceField(numero, 430);
        XLS.newInstanceField(numero, 426);
        XLT.newInstanceField(numero, 440);
        XLU.newInstanceField(numero, 442);
        XLV.newInstanceField(numero, 428);
        XLY.newInstanceField(numero, 434);
        XMA.newInstanceField(numero, 504);
        XMC.newInstanceField(numero, 492);
        XMD.newInstanceField(numero, 498);
        XME.newInstanceField(numero, 499);
        XMF.newInstanceField(numero, 663);
        XMG.newInstanceField(numero, 450);
        XMH.newInstanceField(numero, 584);
        XMK.newInstanceField(numero, 807);
        XML.newInstanceField(numero, 466);
        XMM.newInstanceField(numero, 104);
        XMN.newInstanceField(numero, 496);
        XMO.newInstanceField(numero, 446);
        XMP.newInstanceField(numero, 580);
        XMQ.newInstanceField(numero, 474);
        XMR.newInstanceField(numero, 478);
        XMS.newInstanceField(numero, 500);
        XMT.newInstanceField(numero, 470);
        XMU.newInstanceField(numero, 480);
        XMV.newInstanceField(numero, 462);
        XMW.newInstanceField(numero, 454);
        XMX.newInstanceField(numero, 484);
        XMY.newInstanceField(numero, 458);
        XMZ.newInstanceField(numero, 508);
        XNA.newInstanceField(numero, 516);
        XNC.newInstanceField(numero, 540);
        XNE.newInstanceField(numero, 562);
        XNF.newInstanceField(numero, 574);
        XNG.newInstanceField(numero, 566);
        XNI.newInstanceField(numero, 558);
        XNL.newInstanceField(numero, 528);
        XNO.newInstanceField(numero, 578);
        XNP.newInstanceField(numero, 524);
        XNR.newInstanceField(numero, 520);
        XNU.newInstanceField(numero, 570);
        XNZ.newInstanceField(numero, 554);
        XOM.newInstanceField(numero, 512);
        XPA.newInstanceField(numero, 591);
        XPE.newInstanceField(numero, 604);
        XPF.newInstanceField(numero, 258);
        XPG.newInstanceField(numero, 598);
        XPH.newInstanceField(numero, 608);
        XPK.newInstanceField(numero, 586);
        XPL.newInstanceField(numero, 616);
        XPM.newInstanceField(numero, 666);
        XPN.newInstanceField(numero, 612);
        XPR.newInstanceField(numero, 630);
        XPS.newInstanceField(numero, 275);
        XPT.newInstanceField(numero, 620);
        XPW.newInstanceField(numero, 585);
        XPY.newInstanceField(numero, 600);
        XQA.newInstanceField(numero, 634);
        XRE.newInstanceField(numero, 638);
        XRO.newInstanceField(numero, 642);
        XRS.newInstanceField(numero, 688);
        XRU.newInstanceField(numero, 643);
        XRW.newInstanceField(numero, 646);
        XSA.newInstanceField(numero, 682);
        XSB.newInstanceField(numero, 90);
        XSC.newInstanceField(numero, 690);
        XSD.newInstanceField(numero, 729);
        XSE.newInstanceField(numero, 752);
        XSG.newInstanceField(numero, 702);
        XSH.newInstanceField(numero, 654);
        XSI.newInstanceField(numero, 705);
        XSJ.newInstanceField(numero, 744);
        XSK.newInstanceField(numero, 703);
        XSL.newInstanceField(numero, 694);
        XSM.newInstanceField(numero, 674);
        XSN.newInstanceField(numero, 686);
        XSO.newInstanceField(numero, 706);
        XSR.newInstanceField(numero, 740);
        XSS.newInstanceField(numero, 728);
        XST.newInstanceField(numero, 678);
        XSV.newInstanceField(numero, 222);
        XSX.newInstanceField(numero, 534);
        XSY.newInstanceField(numero, 760);
        XSZ.newInstanceField(numero, 748);
        XTC.newInstanceField(numero, 796);
        XTD.newInstanceField(numero, 148);
        XTF.newInstanceField(numero, 260);
        XTG.newInstanceField(numero, 768);
        XTH.newInstanceField(numero, 764);
        XTJ.newInstanceField(numero, 762);
        XTK.newInstanceField(numero, 772);
        XTL.newInstanceField(numero, 626);
        XTM.newInstanceField(numero, 795);
        XTN.newInstanceField(numero, 788);
        XTO.newInstanceField(numero, 776);
        XTR.newInstanceField(numero, 792);
        XTT.newInstanceField(numero, 780);
        XTV.newInstanceField(numero, 798);
        XTW.newInstanceField(numero, 158);
        XTZ.newInstanceField(numero, 834);
        XUA.newInstanceField(numero, 804);
        XUG.newInstanceField(numero, 800);
        XUM.newInstanceField(numero, 581);
        XUS.newInstanceField(numero, 840);
        XUY.newInstanceField(numero, 858);
        XUZ.newInstanceField(numero, 860);
        XVA.newInstanceField(numero, 336);
        XVC.newInstanceField(numero, 670);
        XVE.newInstanceField(numero, 862);
        XVG.newInstanceField(numero, 92);
        XVI.newInstanceField(numero, 850);
        XVN.newInstanceField(numero, 704);
        XVU.newInstanceField(numero, 548);
        XWF.newInstanceField(numero, 876);
        XWS.newInstanceField(numero, 882);
        XYE.newInstanceField(numero, 887);
        XYT.newInstanceField(numero, 175);
        XZA.newInstanceField(numero, 710);
        XZM.newInstanceField(numero, 894);
        XZW.newInstanceField(numero, 716);
        // </editor-fold>
        /**/
        // <editor-fold defaultstate="collapsed" desc="newInstanceField(codigo)">
        XAD.newInstanceField(codigo, "AD");
        XAE.newInstanceField(codigo, "AE");
        XAF.newInstanceField(codigo, "AF");
        XAG.newInstanceField(codigo, "AG");
        XAI.newInstanceField(codigo, "AI");
        XAL.newInstanceField(codigo, "AL");
        XAM.newInstanceField(codigo, "AM");
        XAO.newInstanceField(codigo, "AO");
        XAQ.newInstanceField(codigo, "AQ");
        XAR.newInstanceField(codigo, "AR");
        XAS.newInstanceField(codigo, "AS");
        XAT.newInstanceField(codigo, "AT");
        XAU.newInstanceField(codigo, "AU");
        XAW.newInstanceField(codigo, "AW");
        XAX.newInstanceField(codigo, "AX");
        XAZ.newInstanceField(codigo, "AZ");
        XBA.newInstanceField(codigo, "BA");
        XBB.newInstanceField(codigo, "BB");
        XBD.newInstanceField(codigo, "BD");
        XBE.newInstanceField(codigo, "BE");
        XBF.newInstanceField(codigo, "BF");
        XBG.newInstanceField(codigo, "BG");
        XBH.newInstanceField(codigo, "BH");
        XBI.newInstanceField(codigo, "BI");
        XBJ.newInstanceField(codigo, "BJ");
        XBL.newInstanceField(codigo, "BL");
        XBM.newInstanceField(codigo, "BM");
        XBN.newInstanceField(codigo, "BN");
        XBO.newInstanceField(codigo, "BO");
        XBQ.newInstanceField(codigo, "BQ");
        XBR.newInstanceField(codigo, "BR");
        XBS.newInstanceField(codigo, "BS");
        XBT.newInstanceField(codigo, "BT");
        XBV.newInstanceField(codigo, "BV");
        XBW.newInstanceField(codigo, "BW");
        XBY.newInstanceField(codigo, "BY");
        XBZ.newInstanceField(codigo, "BZ");
        XCA.newInstanceField(codigo, "CA");
        XCC.newInstanceField(codigo, "CC");
        XCD.newInstanceField(codigo, "CD");
        XCF.newInstanceField(codigo, "CF");
        XCG.newInstanceField(codigo, "CG");
        XCH.newInstanceField(codigo, "CH");
        XCI.newInstanceField(codigo, "CI");
        XCK.newInstanceField(codigo, "CK");
        XCL.newInstanceField(codigo, "CL");
        XCM.newInstanceField(codigo, "CM");
        XCN.newInstanceField(codigo, "CN");
        XCO.newInstanceField(codigo, "CO");
        XCR.newInstanceField(codigo, "CR");
        XCU.newInstanceField(codigo, "CU");
        XCV.newInstanceField(codigo, "CV");
        XCW.newInstanceField(codigo, "CW");
        XCX.newInstanceField(codigo, "CX");
        XCY.newInstanceField(codigo, "CY");
        XCZ.newInstanceField(codigo, "CZ");
        XDE.newInstanceField(codigo, "DE");
        XDJ.newInstanceField(codigo, "DJ");
        XDK.newInstanceField(codigo, "DK");
        XDM.newInstanceField(codigo, "DM");
        XDO.newInstanceField(codigo, "DO");
        XDZ.newInstanceField(codigo, "DZ");
        XEC.newInstanceField(codigo, "EC");
        XEE.newInstanceField(codigo, "EE");
        XEG.newInstanceField(codigo, "EG");
        XEH.newInstanceField(codigo, "EH");
        XER.newInstanceField(codigo, "ER");
        XES.newInstanceField(codigo, "ES");
        XET.newInstanceField(codigo, "ET");
        XFI.newInstanceField(codigo, "FI");
        XFJ.newInstanceField(codigo, "FJ");
        XFK.newInstanceField(codigo, "FK");
        XFM.newInstanceField(codigo, "FM");
        XFO.newInstanceField(codigo, "FO");
        XFR.newInstanceField(codigo, "FR");
        XGA.newInstanceField(codigo, "GA");
        XGB.newInstanceField(codigo, "GB");
        XGD.newInstanceField(codigo, "GD");
        XGE.newInstanceField(codigo, "GE");
        XGF.newInstanceField(codigo, "GF");
        XGG.newInstanceField(codigo, "GG");
        XGH.newInstanceField(codigo, "GH");
        XGI.newInstanceField(codigo, "GI");
        XGL.newInstanceField(codigo, "GL");
        XGM.newInstanceField(codigo, "GM");
        XGN.newInstanceField(codigo, "GN");
        XGP.newInstanceField(codigo, "GP");
        XGQ.newInstanceField(codigo, "GQ");
        XGR.newInstanceField(codigo, "GR");
        XGS.newInstanceField(codigo, "GS");
        XGT.newInstanceField(codigo, "GT");
        XGU.newInstanceField(codigo, "GU");
        XGW.newInstanceField(codigo, "GW");
        XGY.newInstanceField(codigo, "GY");
        XHK.newInstanceField(codigo, "HK");
        XHM.newInstanceField(codigo, "HM");
        XHN.newInstanceField(codigo, "HN");
        XHR.newInstanceField(codigo, "HR");
        XHT.newInstanceField(codigo, "HT");
        XHU.newInstanceField(codigo, "HU");
        XID.newInstanceField(codigo, "ID");
        XIE.newInstanceField(codigo, "IE");
        XIL.newInstanceField(codigo, "IL");
        XIM.newInstanceField(codigo, "IM");
        XIN.newInstanceField(codigo, "IN");
        XIO.newInstanceField(codigo, "IO");
        XIQ.newInstanceField(codigo, "IQ");
        XIR.newInstanceField(codigo, "IR");
        XIS.newInstanceField(codigo, "IS");
        XIT.newInstanceField(codigo, "IT");
        XJE.newInstanceField(codigo, "JE");
        XJM.newInstanceField(codigo, "JM");
        XJO.newInstanceField(codigo, "JO");
        XJP.newInstanceField(codigo, "JP");
        XKE.newInstanceField(codigo, "KE");
        XKG.newInstanceField(codigo, "KG");
        XKH.newInstanceField(codigo, "KH");
        XKI.newInstanceField(codigo, "KI");
        XKM.newInstanceField(codigo, "KM");
        XKN.newInstanceField(codigo, "KN");
        XKP.newInstanceField(codigo, "KP");
        XKR.newInstanceField(codigo, "KR");
        XKW.newInstanceField(codigo, "KW");
        XKY.newInstanceField(codigo, "KY");
        XKZ.newInstanceField(codigo, "KZ");
        XLA.newInstanceField(codigo, "LA");
        XLB.newInstanceField(codigo, "LB");
        XLC.newInstanceField(codigo, "LC");
        XLI.newInstanceField(codigo, "LI");
        XLK.newInstanceField(codigo, "LK");
        XLR.newInstanceField(codigo, "LR");
        XLS.newInstanceField(codigo, "LS");
        XLT.newInstanceField(codigo, "LT");
        XLU.newInstanceField(codigo, "LU");
        XLV.newInstanceField(codigo, "LV");
        XLY.newInstanceField(codigo, "LY");
        XMA.newInstanceField(codigo, "MA");
        XMC.newInstanceField(codigo, "MC");
        XMD.newInstanceField(codigo, "MD");
        XME.newInstanceField(codigo, "ME");
        XMF.newInstanceField(codigo, "MF");
        XMG.newInstanceField(codigo, "MG");
        XMH.newInstanceField(codigo, "MH");
        XMK.newInstanceField(codigo, "MK");
        XML.newInstanceField(codigo, "ML");
        XMM.newInstanceField(codigo, "MM");
        XMN.newInstanceField(codigo, "MN");
        XMO.newInstanceField(codigo, "MO");
        XMP.newInstanceField(codigo, "MP");
        XMQ.newInstanceField(codigo, "MQ");
        XMR.newInstanceField(codigo, "MR");
        XMS.newInstanceField(codigo, "MS");
        XMT.newInstanceField(codigo, "MT");
        XMU.newInstanceField(codigo, "MU");
        XMV.newInstanceField(codigo, "MV");
        XMW.newInstanceField(codigo, "MW");
        XMX.newInstanceField(codigo, "MX");
        XMY.newInstanceField(codigo, "MY");
        XMZ.newInstanceField(codigo, "MZ");
        XNA.newInstanceField(codigo, "NA");
        XNC.newInstanceField(codigo, "NC");
        XNE.newInstanceField(codigo, "NE");
        XNF.newInstanceField(codigo, "NF");
        XNG.newInstanceField(codigo, "NG");
        XNI.newInstanceField(codigo, "NI");
        XNL.newInstanceField(codigo, "NL");
        XNO.newInstanceField(codigo, "NO");
        XNP.newInstanceField(codigo, "NP");
        XNR.newInstanceField(codigo, "NR");
        XNU.newInstanceField(codigo, "NU");
        XNZ.newInstanceField(codigo, "NZ");
        XOM.newInstanceField(codigo, "OM");
        XPA.newInstanceField(codigo, "PA");
        XPE.newInstanceField(codigo, "PE");
        XPF.newInstanceField(codigo, "PF");
        XPG.newInstanceField(codigo, "PG");
        XPH.newInstanceField(codigo, "PH");
        XPK.newInstanceField(codigo, "PK");
        XPL.newInstanceField(codigo, "PL");
        XPM.newInstanceField(codigo, "PM");
        XPN.newInstanceField(codigo, "PN");
        XPR.newInstanceField(codigo, "PR");
        XPS.newInstanceField(codigo, "PS");
        XPT.newInstanceField(codigo, "PT");
        XPW.newInstanceField(codigo, "PW");
        XPY.newInstanceField(codigo, "PY");
        XQA.newInstanceField(codigo, "QA");
        XRE.newInstanceField(codigo, "RE");
        XRO.newInstanceField(codigo, "RO");
        XRS.newInstanceField(codigo, "RS");
        XRU.newInstanceField(codigo, "RU");
        XRW.newInstanceField(codigo, "RW");
        XSA.newInstanceField(codigo, "SA");
        XSB.newInstanceField(codigo, "SB");
        XSC.newInstanceField(codigo, "SC");
        XSD.newInstanceField(codigo, "SD");
        XSE.newInstanceField(codigo, "SE");
        XSG.newInstanceField(codigo, "SG");
        XSH.newInstanceField(codigo, "SH");
        XSI.newInstanceField(codigo, "SI");
        XSJ.newInstanceField(codigo, "SJ");
        XSK.newInstanceField(codigo, "SK");
        XSL.newInstanceField(codigo, "SL");
        XSM.newInstanceField(codigo, "SM");
        XSN.newInstanceField(codigo, "SN");
        XSO.newInstanceField(codigo, "SO");
        XSR.newInstanceField(codigo, "SR");
        XSS.newInstanceField(codigo, "SS");
        XST.newInstanceField(codigo, "ST");
        XSV.newInstanceField(codigo, "SV");
        XSX.newInstanceField(codigo, "SX");
        XSY.newInstanceField(codigo, "SY");
        XSZ.newInstanceField(codigo, "SZ");
        XTC.newInstanceField(codigo, "TC");
        XTD.newInstanceField(codigo, "TD");
        XTF.newInstanceField(codigo, "TF");
        XTG.newInstanceField(codigo, "TG");
        XTH.newInstanceField(codigo, "TH");
        XTJ.newInstanceField(codigo, "TJ");
        XTK.newInstanceField(codigo, "TK");
        XTL.newInstanceField(codigo, "TL");
        XTM.newInstanceField(codigo, "TM");
        XTN.newInstanceField(codigo, "TN");
        XTO.newInstanceField(codigo, "TO");
        XTR.newInstanceField(codigo, "TR");
        XTT.newInstanceField(codigo, "TT");
        XTV.newInstanceField(codigo, "TV");
        XTW.newInstanceField(codigo, "TW");
        XTZ.newInstanceField(codigo, "TZ");
        XUA.newInstanceField(codigo, "UA");
        XUG.newInstanceField(codigo, "UG");
        XUM.newInstanceField(codigo, "UM");
        XUS.newInstanceField(codigo, "US");
        XUY.newInstanceField(codigo, "UY");
        XUZ.newInstanceField(codigo, "UZ");
        XVA.newInstanceField(codigo, "VA");
        XVC.newInstanceField(codigo, "VC");
        XVE.newInstanceField(codigo, "VE");
        XVG.newInstanceField(codigo, "VG");
        XVI.newInstanceField(codigo, "VI");
        XVN.newInstanceField(codigo, "VN");
        XVU.newInstanceField(codigo, "VU");
        XWF.newInstanceField(codigo, "WF");
        XWS.newInstanceField(codigo, "WS");
        XYE.newInstanceField(codigo, "YE");
        XYT.newInstanceField(codigo, "YT");
        XZA.newInstanceField(codigo, "ZA");
        XZM.newInstanceField(codigo, "ZM");
        XZW.newInstanceField(codigo, "ZW");
        // </editor-fold>
        /**/
        // <editor-fold defaultstate="collapsed" desc="newInstanceField(nombre)">
        XAD.newInstanceField(nombre, "Andorra");
        XAE.newInstanceField(nombre, "Emiratos Árabes Unidos");
        XAF.newInstanceField(nombre, "Afganistán");
        XAG.newInstanceField(nombre, "Antigua y Barbuda");
        XAI.newInstanceField(nombre, "Anguila");
        XAL.newInstanceField(nombre, "Albania");
        XAM.newInstanceField(nombre, "Armenia");
        XAO.newInstanceField(nombre, "Angola");
        XAQ.newInstanceField(nombre, "Antártida");
        XAR.newInstanceField(nombre, "Argentina");
        XAS.newInstanceField(nombre, "Samoa Americana");
        XAT.newInstanceField(nombre, "Austria");
        XAU.newInstanceField(nombre, "Australia");
        XAW.newInstanceField(nombre, "Aruba");
        XAX.newInstanceField(nombre, "Aland");
        XAZ.newInstanceField(nombre, "Azerbaiyán");
        XBA.newInstanceField(nombre, "Bosnia y Herzegovina");
        XBB.newInstanceField(nombre, "Barbados");
        XBD.newInstanceField(nombre, "Bangladés");
        XBE.newInstanceField(nombre, "Bélgica");
        XBF.newInstanceField(nombre, "Burkina Faso");
        XBG.newInstanceField(nombre, "Bulgaria");
        XBH.newInstanceField(nombre, "Baréin");
        XBI.newInstanceField(nombre, "Burundi");
        XBJ.newInstanceField(nombre, "Benín");
        XBL.newInstanceField(nombre, "San Bartolomé");
        XBM.newInstanceField(nombre, "Bermudas");
        XBN.newInstanceField(nombre, "Brunéi");
        XBO.newInstanceField(nombre, "Bolivia");
        XBQ.newInstanceField(nombre, "Bonaire, San Eustaquio y Saba");
        XBR.newInstanceField(nombre, "Brasil");
        XBS.newInstanceField(nombre, "Bahamas");
        XBT.newInstanceField(nombre, "Bután");
        XBV.newInstanceField(nombre, "Isla Bouvet");
        XBW.newInstanceField(nombre, "Botsuana");
        XBY.newInstanceField(nombre, "Bielorrusia");
        XBZ.newInstanceField(nombre, "Belice");
        XCA.newInstanceField(nombre, "Canadá");
        XCC.newInstanceField(nombre, "Islas Cocos");
        XCD.newInstanceField(nombre, "República Democrática del Congo");
        XCF.newInstanceField(nombre, "República Centroafricana");
        XCG.newInstanceField(nombre, "República del Congo");
        XCH.newInstanceField(nombre, "Suiza");
        XCI.newInstanceField(nombre, "Costa de Marfil");
        XCK.newInstanceField(nombre, "Islas Cook");
        XCL.newInstanceField(nombre, "Chile");
        XCM.newInstanceField(nombre, "Camerún");
        XCN.newInstanceField(nombre, "China");
        XCO.newInstanceField(nombre, "Colombia");
        XCR.newInstanceField(nombre, "Costa Rica");
        XCU.newInstanceField(nombre, "Cuba");
        XCV.newInstanceField(nombre, "Cabo Verde");
        XCW.newInstanceField(nombre, "Curazao");
        XCX.newInstanceField(nombre, "Isla de Navidad");
        XCY.newInstanceField(nombre, "Chipre");
        XCZ.newInstanceField(nombre, "República Checa");
        XDE.newInstanceField(nombre, "Alemania");
        XDJ.newInstanceField(nombre, "Yibuti");
        XDK.newInstanceField(nombre, "Dinamarca");
        XDM.newInstanceField(nombre, "Dominica");
        XDO.newInstanceField(nombre, "República Dominicana");
        XDZ.newInstanceField(nombre, "Argelia");
        XEC.newInstanceField(nombre, "Ecuador");
        XEE.newInstanceField(nombre, "Estonia");
        XEG.newInstanceField(nombre, "Egipto");
        XEH.newInstanceField(nombre, "República Árabe Saharaui Democrática");
        XER.newInstanceField(nombre, "Eritrea");
        XES.newInstanceField(nombre, "España");
        XET.newInstanceField(nombre, "Etiopía");
        XFI.newInstanceField(nombre, "Finlandia");
        XFJ.newInstanceField(nombre, "Fiyi");
        XFK.newInstanceField(nombre, "Islas Malvinas");
        XFM.newInstanceField(nombre, "Micronesia");
        XFO.newInstanceField(nombre, "Islas Feroe");
        XFR.newInstanceField(nombre, "Francia");
        XGA.newInstanceField(nombre, "Gabón");
        XGB.newInstanceField(nombre, "Reino Unido");
        XGD.newInstanceField(nombre, "Granada");
        XGE.newInstanceField(nombre, "Georgia");
        XGF.newInstanceField(nombre, "Guayana Francesa");
        XGG.newInstanceField(nombre, "Guernsey");
        XGH.newInstanceField(nombre, "Ghana");
        XGI.newInstanceField(nombre, "Gibraltar");
        XGL.newInstanceField(nombre, "Groenlandia");
        XGM.newInstanceField(nombre, "Gambia");
        XGN.newInstanceField(nombre, "Guinea");
        XGP.newInstanceField(nombre, "Guadalupe");
        XGQ.newInstanceField(nombre, "Guinea Ecuatorial");
        XGR.newInstanceField(nombre, "Grecia");
        XGS.newInstanceField(nombre, "Islas Georgias del Sur y Sandwich del Sur");
        XGT.newInstanceField(nombre, "Guatemala");
        XGU.newInstanceField(nombre, "Guam");
        XGW.newInstanceField(nombre, "Guinea-Bisáu");
        XGY.newInstanceField(nombre, "Guyana");
        XHK.newInstanceField(nombre, "Hong Kong");
        XHM.newInstanceField(nombre, "Islas Heard y McDonald");
        XHN.newInstanceField(nombre, "Honduras");
        XHR.newInstanceField(nombre, "Croacia");
        XHT.newInstanceField(nombre, "Haití");
        XHU.newInstanceField(nombre, "Hungría");
        XID.newInstanceField(nombre, "Indonesia");
        XIE.newInstanceField(nombre, "Irlanda");
        XIL.newInstanceField(nombre, "Israel");
        XIM.newInstanceField(nombre, "Isla de Man");
        XIN.newInstanceField(nombre, "India");
        XIO.newInstanceField(nombre, "Territorio Británico del Océano Índico");
        XIQ.newInstanceField(nombre, "Irak");
        XIR.newInstanceField(nombre, "Irán");
        XIS.newInstanceField(nombre, "Islandia");
        XIT.newInstanceField(nombre, "Italia");
        XJE.newInstanceField(nombre, "Jersey");
        XJM.newInstanceField(nombre, "Jamaica");
        XJO.newInstanceField(nombre, "Jordania");
        XJP.newInstanceField(nombre, "Japón");
        XKE.newInstanceField(nombre, "Kenia");
        XKG.newInstanceField(nombre, "Kirguistán");
        XKH.newInstanceField(nombre, "Camboya");
        XKI.newInstanceField(nombre, "Kiribati");
        XKM.newInstanceField(nombre, "Comoras");
        XKN.newInstanceField(nombre, "San Cristóbal y Nieves");
        XKP.newInstanceField(nombre, "Corea del Norte");
        XKR.newInstanceField(nombre, "Corea del Sur");
        XKW.newInstanceField(nombre, "Kuwait");
        XKY.newInstanceField(nombre, "Islas Caimán");
        XKZ.newInstanceField(nombre, "Kazajistán");
        XLA.newInstanceField(nombre, "Laos");
        XLB.newInstanceField(nombre, "Líbano");
        XLC.newInstanceField(nombre, "Santa Lucía");
        XLI.newInstanceField(nombre, "Liechtenstein");
        XLK.newInstanceField(nombre, "Sri Lanka");
        XLR.newInstanceField(nombre, "Liberia");
        XLS.newInstanceField(nombre, "Lesoto");
        XLT.newInstanceField(nombre, "Lituania");
        XLU.newInstanceField(nombre, "Luxemburgo");
        XLV.newInstanceField(nombre, "Letonia");
        XLY.newInstanceField(nombre, "Libia");
        XMA.newInstanceField(nombre, "Marruecos");
        XMC.newInstanceField(nombre, "Mónaco");
        XMD.newInstanceField(nombre, "Moldavia");
        XME.newInstanceField(nombre, "Montenegro");
        XMF.newInstanceField(nombre, "San Martín (parte francesa)");
        XMG.newInstanceField(nombre, "Madagascar");
        XMH.newInstanceField(nombre, "Islas Marshall");
        XMK.newInstanceField(nombre, "Macedonia del Norte");
        XML.newInstanceField(nombre, "Malí");
        XMM.newInstanceField(nombre, "Birmania");
        XMN.newInstanceField(nombre, "Mongolia");
        XMO.newInstanceField(nombre, "Macao");
        XMP.newInstanceField(nombre, "Islas Marianas del Norte");
        XMQ.newInstanceField(nombre, "Martinica");
        XMR.newInstanceField(nombre, "Mauritania");
        XMS.newInstanceField(nombre, "Montserrat");
        XMT.newInstanceField(nombre, "Malta");
        XMU.newInstanceField(nombre, "Mauricio");
        XMV.newInstanceField(nombre, "Maldivas");
        XMW.newInstanceField(nombre, "Malaui");
        XMX.newInstanceField(nombre, "México");
        XMY.newInstanceField(nombre, "Malasia");
        XMZ.newInstanceField(nombre, "Mozambique");
        XNA.newInstanceField(nombre, "Namibia");
        XNC.newInstanceField(nombre, "Nueva Caledonia");
        XNE.newInstanceField(nombre, "Níger");
        XNF.newInstanceField(nombre, "Isla Norfolk");
        XNG.newInstanceField(nombre, "Nigeria");
        XNI.newInstanceField(nombre, "Nicaragua");
        XNL.newInstanceField(nombre, "Países Bajos");
        XNO.newInstanceField(nombre, "Noruega");
        XNP.newInstanceField(nombre, "Nepal");
        XNR.newInstanceField(nombre, "Nauru");
        XNU.newInstanceField(nombre, "Niue");
        XNZ.newInstanceField(nombre, "Nueva Zelanda");
        XOM.newInstanceField(nombre, "Omán");
        XPA.newInstanceField(nombre, "Panamá");
        XPE.newInstanceField(nombre, "Perú");
        XPF.newInstanceField(nombre, "Polinesia Francesa");
        XPG.newInstanceField(nombre, "Papúa Nueva Guinea");
        XPH.newInstanceField(nombre, "Filipinas");
        XPK.newInstanceField(nombre, "Pakistán");
        XPL.newInstanceField(nombre, "Polonia");
        XPM.newInstanceField(nombre, "San Pedro y Miquelón");
        XPN.newInstanceField(nombre, "Islas Pitcairn");
        XPR.newInstanceField(nombre, "Puerto Rico");
        XPS.newInstanceField(nombre, "Palestina");
        XPT.newInstanceField(nombre, "Portugal");
        XPW.newInstanceField(nombre, "Palaos");
        XPY.newInstanceField(nombre, "Paraguay");
        XQA.newInstanceField(nombre, "Catar");
        XRE.newInstanceField(nombre, "Reunión");
        XRO.newInstanceField(nombre, "Rumania");
        XRS.newInstanceField(nombre, "Serbia");
        XRU.newInstanceField(nombre, "Rusia");
        XRW.newInstanceField(nombre, "Ruanda");
        XSA.newInstanceField(nombre, "Arabia Saudita");
        XSB.newInstanceField(nombre, "Islas Salomón");
        XSC.newInstanceField(nombre, "Seychelles");
        XSD.newInstanceField(nombre, "Sudán");
        XSE.newInstanceField(nombre, "Suecia");
        XSG.newInstanceField(nombre, "Singapur");
        XSH.newInstanceField(nombre, "Santa Elena, Ascensión y Tristán de Acuña");
        XSI.newInstanceField(nombre, "Eslovenia");
        XSJ.newInstanceField(nombre, "Svalbard y Jan Mayen");
        XSK.newInstanceField(nombre, "Eslovaquia");
        XSL.newInstanceField(nombre, "Sierra Leona");
        XSM.newInstanceField(nombre, "San Marino");
        XSN.newInstanceField(nombre, "Senegal");
        XSO.newInstanceField(nombre, "Somalia");
        XSR.newInstanceField(nombre, "Surinam");
        XSS.newInstanceField(nombre, "Sudán del Sur");
        XST.newInstanceField(nombre, "Santo Tomé y Príncipe");
        XSV.newInstanceField(nombre, "El Salvador");
        XSX.newInstanceField(nombre, "San Martín (parte holandesa)");
        XSY.newInstanceField(nombre, "Siria");
        XSZ.newInstanceField(nombre, "Suazilandia");
        XTC.newInstanceField(nombre, "Islas Turcas y Caicos");
        XTD.newInstanceField(nombre, "Chad");
        XTF.newInstanceField(nombre, "Tierras Australes y Antárticas Francesas");
        XTG.newInstanceField(nombre, "Togo");
        XTH.newInstanceField(nombre, "Tailandia");
        XTJ.newInstanceField(nombre, "Tayikistán");
        XTK.newInstanceField(nombre, "Tokelau");
        XTL.newInstanceField(nombre, "Timor Oriental");
        XTM.newInstanceField(nombre, "Turkmenistán");
        XTN.newInstanceField(nombre, "Túnez");
        XTO.newInstanceField(nombre, "Tonga");
        XTR.newInstanceField(nombre, "Turquía");
        XTT.newInstanceField(nombre, "Trinidad y Tobago");
        XTV.newInstanceField(nombre, "Tuvalu");
        XTW.newInstanceField(nombre, "Taiwán (República de China)");
        XTZ.newInstanceField(nombre, "Tanzania");
        XUA.newInstanceField(nombre, "Ucrania");
        XUG.newInstanceField(nombre, "Uganda");
        XUM.newInstanceField(nombre, "Islas Ultramarinas Menores de los Estados Unidos");
        XUS.newInstanceField(nombre, "Estados Unidos");
        XUY.newInstanceField(nombre, "Uruguay");
        XUZ.newInstanceField(nombre, "Uzbekistán");
        XVA.newInstanceField(nombre, "Ciudad del Vaticano");
        XVC.newInstanceField(nombre, "San Vicente y las Granadinas");
        XVE.newInstanceField(nombre, "Venezuela");
        XVG.newInstanceField(nombre, "Islas Vírgenes Británicas");
        XVI.newInstanceField(nombre, "Islas Vírgenes de los Estados Unidos");
        XVN.newInstanceField(nombre, "Vietnam");
        XVU.newInstanceField(nombre, "Vanuatu");
        XWF.newInstanceField(nombre, "Wallis y Futuna");
        XWS.newInstanceField(nombre, "Samoa");
        XYE.newInstanceField(nombre, "Yemen");
        XYT.newInstanceField(nombre, "Mayotte");
        XZA.newInstanceField(nombre, "Sudáfrica");
        XZM.newInstanceField(nombre, "Zambia");
        XZW.newInstanceField(nombre, "Zimbabue");
        // </editor-fold>
        /**/
        // <editor-fold defaultstate="collapsed" desc="newInstanceField(e164)">
        XAD.newInstanceField(e164, "+376");
        XAE.newInstanceField(e164, "+971");
        XAF.newInstanceField(e164, "+93");
        XAG.newInstanceField(e164, "+1-268");
        XAI.newInstanceField(e164, "+1-264");
        XAL.newInstanceField(e164, "+355");
        XAM.newInstanceField(e164, "+374");
        XAO.newInstanceField(e164, "+244");
        XAQ.newInstanceField(e164, "+672");
        XAR.newInstanceField(e164, "+54");
        XAS.newInstanceField(e164, "+1-684");
        XAT.newInstanceField(e164, "+43");
        XAU.newInstanceField(e164, "+61");
        XAW.newInstanceField(e164, "+297");
        XAX.newInstanceField(e164, "+358");
        XAZ.newInstanceField(e164, "+994");
        XBA.newInstanceField(e164, "+387");
        XBB.newInstanceField(e164, "+1-246");
        XBD.newInstanceField(e164, "+880");
        XBE.newInstanceField(e164, "+32");
        XBF.newInstanceField(e164, "+226");
        XBG.newInstanceField(e164, "+359");
        XBH.newInstanceField(e164, "+973");
        XBI.newInstanceField(e164, "+257");
        XBJ.newInstanceField(e164, "+229");
        XBL.newInstanceField(e164, "+590");
        XBM.newInstanceField(e164, "+1-441");
        XBN.newInstanceField(e164, "+673");
        XBO.newInstanceField(e164, "+591");
        XBQ.newInstanceField(e164, "+599");
        XBR.newInstanceField(e164, "+55");
        XBS.newInstanceField(e164, "+1-242");
        XBT.newInstanceField(e164, "+975");
//      XBV.newInstanceField(e164, null);
        XBW.newInstanceField(e164, "+267");
        XBY.newInstanceField(e164, "+375");
        XBZ.newInstanceField(e164, "+501");
        XCA.newInstanceField(e164, "+1");
        XCC.newInstanceField(e164, "+61");
        XCD.newInstanceField(e164, "+243");
        XCF.newInstanceField(e164, "+236");
        XCG.newInstanceField(e164, "+242");
        XCH.newInstanceField(e164, "+41");
        XCI.newInstanceField(e164, "+225");
        XCK.newInstanceField(e164, "+682");
        XCL.newInstanceField(e164, "+56");
        XCM.newInstanceField(e164, "+237");
        XCN.newInstanceField(e164, "+86");
        XCO.newInstanceField(e164, "+57");
        XCR.newInstanceField(e164, "+506");
        XCU.newInstanceField(e164, "+53");
        XCV.newInstanceField(e164, "+238");
        XCW.newInstanceField(e164, "+599");
        XCX.newInstanceField(e164, "+61");
        XCY.newInstanceField(e164, "+357");
        XCZ.newInstanceField(e164, "+420");
        XDE.newInstanceField(e164, "+49");
        XDJ.newInstanceField(e164, "+253");
        XDK.newInstanceField(e164, "+45");
        XDM.newInstanceField(e164, "+1-767");
        XDO.newInstanceField(e164, "+1-809");
        XDZ.newInstanceField(e164, "+213");
        XEC.newInstanceField(e164, "+593");
        XEE.newInstanceField(e164, "+372");
        XEG.newInstanceField(e164, "+20");
        XEH.newInstanceField(e164, "+212");
        XER.newInstanceField(e164, "+291");
        XES.newInstanceField(e164, "+34");
        XET.newInstanceField(e164, "+251");
        XFI.newInstanceField(e164, "+358");
        XFJ.newInstanceField(e164, "+679");
        XFK.newInstanceField(e164, "+500");
        XFM.newInstanceField(e164, "+691");
        XFO.newInstanceField(e164, "+298");
        XFR.newInstanceField(e164, "+33");
        XGA.newInstanceField(e164, "+241");
        XGB.newInstanceField(e164, "+44");
        XGD.newInstanceField(e164, "+1-473");
        XGE.newInstanceField(e164, "+995");
        XGF.newInstanceField(e164, "+594");
        XGG.newInstanceField(e164, "+44");
        XGH.newInstanceField(e164, "+233");
        XGI.newInstanceField(e164, "+350");
        XGL.newInstanceField(e164, "+299");
        XGM.newInstanceField(e164, "+220");
        XGN.newInstanceField(e164, "+224");
        XGP.newInstanceField(e164, "+590");
        XGQ.newInstanceField(e164, "+240");
        XGR.newInstanceField(e164, "+30");
        XGS.newInstanceField(e164, "+500");
        XGT.newInstanceField(e164, "+502");
        XGU.newInstanceField(e164, "+1-671");
        XGW.newInstanceField(e164, "+245");
        XGY.newInstanceField(e164, "+592");
        XHK.newInstanceField(e164, "+852");
//      XHM.newInstanceField(e164, null);
        XHN.newInstanceField(e164, "+504");
        XHR.newInstanceField(e164, "+385");
        XHT.newInstanceField(e164, "+509");
        XHU.newInstanceField(e164, "+36");
        XID.newInstanceField(e164, "+62");
        XIE.newInstanceField(e164, "+353");
        XIL.newInstanceField(e164, "+972");
        XIM.newInstanceField(e164, "+44");
        XIN.newInstanceField(e164, "+91");
        XIO.newInstanceField(e164, "+246");
        XIQ.newInstanceField(e164, "+964");
        XIR.newInstanceField(e164, "+98");
        XIS.newInstanceField(e164, "+354");
        XIT.newInstanceField(e164, "+39");
        XJE.newInstanceField(e164, "+44");
        XJM.newInstanceField(e164, "+1-876");
        XJO.newInstanceField(e164, "+962");
        XJP.newInstanceField(e164, "+81");
        XKE.newInstanceField(e164, "+254");
        XKG.newInstanceField(e164, "+996");
        XKH.newInstanceField(e164, "+855");
        XKI.newInstanceField(e164, "+686");
        XKM.newInstanceField(e164, "+269");
        XKN.newInstanceField(e164, "+1-869");
        XKP.newInstanceField(e164, "+850");
        XKR.newInstanceField(e164, "+82");
        XKW.newInstanceField(e164, "+965");
        XKY.newInstanceField(e164, "+1-345");
        XKZ.newInstanceField(e164, "+7");
        XLA.newInstanceField(e164, "+856");
        XLB.newInstanceField(e164, "+961");
        XLC.newInstanceField(e164, "+1-758");
        XLI.newInstanceField(e164, "+423");
        XLK.newInstanceField(e164, "+94");
        XLR.newInstanceField(e164, "+231");
        XLS.newInstanceField(e164, "+266");
        XLT.newInstanceField(e164, "+370");
        XLU.newInstanceField(e164, "+352");
        XLV.newInstanceField(e164, "+371");
        XLY.newInstanceField(e164, "+218");
        XMA.newInstanceField(e164, "+212");
        XMC.newInstanceField(e164, "+377");
        XMD.newInstanceField(e164, "+373");
        XME.newInstanceField(e164, "+382");
        XMF.newInstanceField(e164, "+590");
        XMG.newInstanceField(e164, "+261");
        XMH.newInstanceField(e164, "+692");
        XMK.newInstanceField(e164, "+389");
        XML.newInstanceField(e164, "+223");
        XMM.newInstanceField(e164, "+95");
        XMN.newInstanceField(e164, "+976");
        XMO.newInstanceField(e164, "+853");
        XMP.newInstanceField(e164, "+1-670");
        XMQ.newInstanceField(e164, "+596");
        XMR.newInstanceField(e164, "+222");
        XMS.newInstanceField(e164, "+1-664");
        XMT.newInstanceField(e164, "+356");
        XMU.newInstanceField(e164, "+230");
        XMV.newInstanceField(e164, "+960");
        XMW.newInstanceField(e164, "+265");
        XMX.newInstanceField(e164, "+52");
        XMY.newInstanceField(e164, "+60");
        XMZ.newInstanceField(e164, "+258");
        XNA.newInstanceField(e164, "+264");
        XNC.newInstanceField(e164, "+687");
        XNE.newInstanceField(e164, "+227");
        XNF.newInstanceField(e164, "+672");
        XNG.newInstanceField(e164, "+234");
        XNI.newInstanceField(e164, "+505");
        XNL.newInstanceField(e164, "+31");
        XNO.newInstanceField(e164, "+47");
        XNP.newInstanceField(e164, "+977");
        XNR.newInstanceField(e164, "+674");
        XNU.newInstanceField(e164, "+683");
        XNZ.newInstanceField(e164, "+64");
        XOM.newInstanceField(e164, "+968");
        XPA.newInstanceField(e164, "+507");
        XPE.newInstanceField(e164, "+51");
        XPF.newInstanceField(e164, "+689");
        XPG.newInstanceField(e164, "+675");
        XPH.newInstanceField(e164, "+63");
        XPK.newInstanceField(e164, "+92");
        XPL.newInstanceField(e164, "+48");
        XPM.newInstanceField(e164, "+508");
        XPN.newInstanceField(e164, "+64");
        XPR.newInstanceField(e164, "+1");
        XPS.newInstanceField(e164, "+970");
        XPT.newInstanceField(e164, "+351");
        XPW.newInstanceField(e164, "+680");
        XPY.newInstanceField(e164, "+595");
        XQA.newInstanceField(e164, "+974");
        XRE.newInstanceField(e164, "+262");
        XRO.newInstanceField(e164, "+40");
        XRS.newInstanceField(e164, "+381");
        XRU.newInstanceField(e164, "+7");
        XRW.newInstanceField(e164, "+250");
        XSA.newInstanceField(e164, "+966");
        XSB.newInstanceField(e164, "+677");
        XSC.newInstanceField(e164, "+248");
        XSD.newInstanceField(e164, "+249");
        XSE.newInstanceField(e164, "+46");
        XSG.newInstanceField(e164, "+65");
        XSH.newInstanceField(e164, "+290");
        XSI.newInstanceField(e164, "+386");
        XSJ.newInstanceField(e164, "+47");
        XSK.newInstanceField(e164, "+421");
        XSL.newInstanceField(e164, "+232");
        XSM.newInstanceField(e164, "+378");
        XSN.newInstanceField(e164, "+221");
        XSO.newInstanceField(e164, "+252");
        XSR.newInstanceField(e164, "+597");
        XSS.newInstanceField(e164, "+211");
        XST.newInstanceField(e164, "+239");
        XSV.newInstanceField(e164, "+503");
        XSX.newInstanceField(e164, "+1-721");
        XSY.newInstanceField(e164, "+963");
        XSZ.newInstanceField(e164, "+268");
        XTC.newInstanceField(e164, "+1-649");
        XTD.newInstanceField(e164, "+235");
//      XTF.newInstanceField(e164, null);
        XTG.newInstanceField(e164, "+228");
        XTH.newInstanceField(e164, "+66");
        XTJ.newInstanceField(e164, "+992");
        XTK.newInstanceField(e164, "+690");
        XTL.newInstanceField(e164, "+670");
        XTM.newInstanceField(e164, "+993");
        XTN.newInstanceField(e164, "+216");
        XTO.newInstanceField(e164, "+676");
        XTR.newInstanceField(e164, "+90");
        XTT.newInstanceField(e164, "+1-868");
        XTV.newInstanceField(e164, "+688");
        XTW.newInstanceField(e164, "+886");
        XTZ.newInstanceField(e164, "+255");
        XUA.newInstanceField(e164, "+380");
        XUG.newInstanceField(e164, "+256");
//      XUM.newInstanceField(e164, null);
        XUS.newInstanceField(e164, "+1");
        XUY.newInstanceField(e164, "+598");
        XUZ.newInstanceField(e164, "+998");
        XVA.newInstanceField(e164, "+39");
        XVC.newInstanceField(e164, "+1-784");
        XVE.newInstanceField(e164, "+58");
        XVG.newInstanceField(e164, "+1-284");
        XVI.newInstanceField(e164, "+1-340");
        XVN.newInstanceField(e164, "+84");
        XVU.newInstanceField(e164, "+678");
        XWF.newInstanceField(e164, "+681");
        XWS.newInstanceField(e164, "+685");
        XYE.newInstanceField(e164, "+967");
        XYT.newInstanceField(e164, "+262");
        XZA.newInstanceField(e164, "+27");
        XZM.newInstanceField(e164, "+260");
        XZW.newInstanceField(e164, "+263");
        // </editor-fold>
        /**/
        // <editor-fold defaultstate="collapsed" desc="newInstanceField(nacionalidad)">
        XAD.newInstanceField(nacionalidad, nacionalidad.XAD);
        XAE.newInstanceField(nacionalidad, nacionalidad.XAE);
        XAF.newInstanceField(nacionalidad, nacionalidad.XAF);
        XAG.newInstanceField(nacionalidad, nacionalidad.XAG);
        XAI.newInstanceField(nacionalidad, nacionalidad.XAI);
        XAL.newInstanceField(nacionalidad, nacionalidad.XAL);
        XAM.newInstanceField(nacionalidad, nacionalidad.XAM);
        XAO.newInstanceField(nacionalidad, nacionalidad.XAO);
        XAQ.newInstanceField(nacionalidad, nacionalidad.XAQ);
        XAR.newInstanceField(nacionalidad, nacionalidad.XAR);
        XAS.newInstanceField(nacionalidad, nacionalidad.XAS);
        XAT.newInstanceField(nacionalidad, nacionalidad.XAT);
        XAU.newInstanceField(nacionalidad, nacionalidad.XAU);
        XAW.newInstanceField(nacionalidad, nacionalidad.XAW);
        XAX.newInstanceField(nacionalidad, nacionalidad.XAX);
        XAZ.newInstanceField(nacionalidad, nacionalidad.XAZ);
        XBA.newInstanceField(nacionalidad, nacionalidad.XBA);
        XBB.newInstanceField(nacionalidad, nacionalidad.XBB);
        XBD.newInstanceField(nacionalidad, nacionalidad.XBD);
        XBE.newInstanceField(nacionalidad, nacionalidad.XBE);
        XBF.newInstanceField(nacionalidad, nacionalidad.XBF);
        XBG.newInstanceField(nacionalidad, nacionalidad.XBG);
        XBH.newInstanceField(nacionalidad, nacionalidad.XBH);
        XBI.newInstanceField(nacionalidad, nacionalidad.XBI);
        XBJ.newInstanceField(nacionalidad, nacionalidad.XBJ);
        XBL.newInstanceField(nacionalidad, nacionalidad.XBL);
        XBM.newInstanceField(nacionalidad, nacionalidad.XBM);
        XBN.newInstanceField(nacionalidad, nacionalidad.XBN);
        XBO.newInstanceField(nacionalidad, nacionalidad.XBO);
        XBQ.newInstanceField(nacionalidad, nacionalidad.XBQ);
        XBR.newInstanceField(nacionalidad, nacionalidad.XBR);
        XBS.newInstanceField(nacionalidad, nacionalidad.XBS);
        XBT.newInstanceField(nacionalidad, nacionalidad.XBT);
        XBV.newInstanceField(nacionalidad, nacionalidad.XBV);
        XBW.newInstanceField(nacionalidad, nacionalidad.XBW);
        XBY.newInstanceField(nacionalidad, nacionalidad.XBY);
        XBZ.newInstanceField(nacionalidad, nacionalidad.XBZ);
        XCA.newInstanceField(nacionalidad, nacionalidad.XCA);
        XCC.newInstanceField(nacionalidad, nacionalidad.XCC);
        XCD.newInstanceField(nacionalidad, nacionalidad.XCD);
        XCF.newInstanceField(nacionalidad, nacionalidad.XCF);
        XCG.newInstanceField(nacionalidad, nacionalidad.XCG);
        XCH.newInstanceField(nacionalidad, nacionalidad.XCH);
        XCI.newInstanceField(nacionalidad, nacionalidad.XCI);
        XCK.newInstanceField(nacionalidad, nacionalidad.XCK);
        XCL.newInstanceField(nacionalidad, nacionalidad.XCL);
        XCM.newInstanceField(nacionalidad, nacionalidad.XCM);
        XCN.newInstanceField(nacionalidad, nacionalidad.XCN);
        XCO.newInstanceField(nacionalidad, nacionalidad.XCO);
        XCR.newInstanceField(nacionalidad, nacionalidad.XCR);
        XCU.newInstanceField(nacionalidad, nacionalidad.XCU);
        XCV.newInstanceField(nacionalidad, nacionalidad.XCV);
        XCW.newInstanceField(nacionalidad, nacionalidad.XCW);
        XCX.newInstanceField(nacionalidad, nacionalidad.XCX);
        XCY.newInstanceField(nacionalidad, nacionalidad.XCY);
        XCZ.newInstanceField(nacionalidad, nacionalidad.XCZ);
        XDE.newInstanceField(nacionalidad, nacionalidad.XDE);
        XDJ.newInstanceField(nacionalidad, nacionalidad.XDJ);
        XDK.newInstanceField(nacionalidad, nacionalidad.XDK);
        XDM.newInstanceField(nacionalidad, nacionalidad.XDM);
        XDO.newInstanceField(nacionalidad, nacionalidad.XDO);
        XDZ.newInstanceField(nacionalidad, nacionalidad.XDZ);
        XEC.newInstanceField(nacionalidad, nacionalidad.XEC);
        XEE.newInstanceField(nacionalidad, nacionalidad.XEE);
        XEG.newInstanceField(nacionalidad, nacionalidad.XEG);
        XEH.newInstanceField(nacionalidad, nacionalidad.XEH);
        XER.newInstanceField(nacionalidad, nacionalidad.XER);
        XES.newInstanceField(nacionalidad, nacionalidad.XES);
        XET.newInstanceField(nacionalidad, nacionalidad.XET);
        XFI.newInstanceField(nacionalidad, nacionalidad.XFI);
        XFJ.newInstanceField(nacionalidad, nacionalidad.XFJ);
        XFK.newInstanceField(nacionalidad, nacionalidad.XFK);
        XFM.newInstanceField(nacionalidad, nacionalidad.XFM);
        XFO.newInstanceField(nacionalidad, nacionalidad.XFO);
        XFR.newInstanceField(nacionalidad, nacionalidad.XFR);
        XGA.newInstanceField(nacionalidad, nacionalidad.XGA);
        XGB.newInstanceField(nacionalidad, nacionalidad.XGB);
        XGD.newInstanceField(nacionalidad, nacionalidad.XGD);
        XGE.newInstanceField(nacionalidad, nacionalidad.XGE);
        XGF.newInstanceField(nacionalidad, nacionalidad.XGF);
        XGG.newInstanceField(nacionalidad, nacionalidad.XGG);
        XGH.newInstanceField(nacionalidad, nacionalidad.XGH);
        XGI.newInstanceField(nacionalidad, nacionalidad.XGI);
        XGL.newInstanceField(nacionalidad, nacionalidad.XGL);
        XGM.newInstanceField(nacionalidad, nacionalidad.XGM);
        XGN.newInstanceField(nacionalidad, nacionalidad.XGN);
        XGP.newInstanceField(nacionalidad, nacionalidad.XGP);
        XGQ.newInstanceField(nacionalidad, nacionalidad.XGQ);
        XGR.newInstanceField(nacionalidad, nacionalidad.XGR);
        XGS.newInstanceField(nacionalidad, nacionalidad.XGS);
        XGT.newInstanceField(nacionalidad, nacionalidad.XGT);
        XGU.newInstanceField(nacionalidad, nacionalidad.XGU);
        XGW.newInstanceField(nacionalidad, nacionalidad.XGW);
        XGY.newInstanceField(nacionalidad, nacionalidad.XGY);
        XHK.newInstanceField(nacionalidad, nacionalidad.XHK);
        XHM.newInstanceField(nacionalidad, nacionalidad.XHM);
        XHN.newInstanceField(nacionalidad, nacionalidad.XHN);
        XHR.newInstanceField(nacionalidad, nacionalidad.XHR);
        XHT.newInstanceField(nacionalidad, nacionalidad.XHT);
        XHU.newInstanceField(nacionalidad, nacionalidad.XHU);
        XID.newInstanceField(nacionalidad, nacionalidad.XID);
        XIE.newInstanceField(nacionalidad, nacionalidad.XIE);
        XIL.newInstanceField(nacionalidad, nacionalidad.XIL);
        XIM.newInstanceField(nacionalidad, nacionalidad.XIM);
        XIN.newInstanceField(nacionalidad, nacionalidad.XIN);
        XIO.newInstanceField(nacionalidad, nacionalidad.XIO);
        XIQ.newInstanceField(nacionalidad, nacionalidad.XIQ);
        XIR.newInstanceField(nacionalidad, nacionalidad.XIR);
        XIS.newInstanceField(nacionalidad, nacionalidad.XIS);
        XIT.newInstanceField(nacionalidad, nacionalidad.XIT);
        XJE.newInstanceField(nacionalidad, nacionalidad.XJE);
        XJM.newInstanceField(nacionalidad, nacionalidad.XJM);
        XJO.newInstanceField(nacionalidad, nacionalidad.XJO);
        XJP.newInstanceField(nacionalidad, nacionalidad.XJP);
        XKE.newInstanceField(nacionalidad, nacionalidad.XKE);
        XKG.newInstanceField(nacionalidad, nacionalidad.XKG);
        XKH.newInstanceField(nacionalidad, nacionalidad.XKH);
        XKI.newInstanceField(nacionalidad, nacionalidad.XKI);
        XKM.newInstanceField(nacionalidad, nacionalidad.XKM);
        XKN.newInstanceField(nacionalidad, nacionalidad.XKN);
        XKP.newInstanceField(nacionalidad, nacionalidad.XKP);
        XKR.newInstanceField(nacionalidad, nacionalidad.XKR);
        XKW.newInstanceField(nacionalidad, nacionalidad.XKW);
        XKY.newInstanceField(nacionalidad, nacionalidad.XKY);
        XKZ.newInstanceField(nacionalidad, nacionalidad.XKZ);
        XLA.newInstanceField(nacionalidad, nacionalidad.XLA);
        XLB.newInstanceField(nacionalidad, nacionalidad.XLB);
        XLC.newInstanceField(nacionalidad, nacionalidad.XLC);
        XLI.newInstanceField(nacionalidad, nacionalidad.XLI);
        XLK.newInstanceField(nacionalidad, nacionalidad.XLK);
        XLR.newInstanceField(nacionalidad, nacionalidad.XLR);
        XLS.newInstanceField(nacionalidad, nacionalidad.XLS);
        XLT.newInstanceField(nacionalidad, nacionalidad.XLT);
        XLU.newInstanceField(nacionalidad, nacionalidad.XLU);
        XLV.newInstanceField(nacionalidad, nacionalidad.XLV);
        XLY.newInstanceField(nacionalidad, nacionalidad.XLY);
        XMA.newInstanceField(nacionalidad, nacionalidad.XMA);
        XMC.newInstanceField(nacionalidad, nacionalidad.XMC);
        XMD.newInstanceField(nacionalidad, nacionalidad.XMD);
        XME.newInstanceField(nacionalidad, nacionalidad.XME);
        XMF.newInstanceField(nacionalidad, nacionalidad.XMF);
        XMG.newInstanceField(nacionalidad, nacionalidad.XMG);
        XMH.newInstanceField(nacionalidad, nacionalidad.XMH);
        XMK.newInstanceField(nacionalidad, nacionalidad.XMK);
        XML.newInstanceField(nacionalidad, nacionalidad.XML);
        XMM.newInstanceField(nacionalidad, nacionalidad.XMM);
        XMN.newInstanceField(nacionalidad, nacionalidad.XMN);
        XMO.newInstanceField(nacionalidad, nacionalidad.XMO);
        XMP.newInstanceField(nacionalidad, nacionalidad.XMP);
        XMQ.newInstanceField(nacionalidad, nacionalidad.XMQ);
        XMR.newInstanceField(nacionalidad, nacionalidad.XMR);
        XMS.newInstanceField(nacionalidad, nacionalidad.XMS);
        XMT.newInstanceField(nacionalidad, nacionalidad.XMT);
        XMU.newInstanceField(nacionalidad, nacionalidad.XMU);
        XMV.newInstanceField(nacionalidad, nacionalidad.XMV);
        XMW.newInstanceField(nacionalidad, nacionalidad.XMW);
        XMX.newInstanceField(nacionalidad, nacionalidad.XMX);
        XMY.newInstanceField(nacionalidad, nacionalidad.XMY);
        XMZ.newInstanceField(nacionalidad, nacionalidad.XMZ);
        XNA.newInstanceField(nacionalidad, nacionalidad.XNA);
        XNC.newInstanceField(nacionalidad, nacionalidad.XNC);
        XNE.newInstanceField(nacionalidad, nacionalidad.XNE);
        XNF.newInstanceField(nacionalidad, nacionalidad.XNF);
        XNG.newInstanceField(nacionalidad, nacionalidad.XNG);
        XNI.newInstanceField(nacionalidad, nacionalidad.XNI);
        XNL.newInstanceField(nacionalidad, nacionalidad.XNL);
        XNO.newInstanceField(nacionalidad, nacionalidad.XNO);
        XNP.newInstanceField(nacionalidad, nacionalidad.XNP);
        XNR.newInstanceField(nacionalidad, nacionalidad.XNR);
        XNU.newInstanceField(nacionalidad, nacionalidad.XNU);
        XNZ.newInstanceField(nacionalidad, nacionalidad.XNZ);
        XOM.newInstanceField(nacionalidad, nacionalidad.XOM);
        XPA.newInstanceField(nacionalidad, nacionalidad.XPA);
        XPE.newInstanceField(nacionalidad, nacionalidad.XPE);
        XPF.newInstanceField(nacionalidad, nacionalidad.XPF);
        XPG.newInstanceField(nacionalidad, nacionalidad.XPG);
        XPH.newInstanceField(nacionalidad, nacionalidad.XPH);
        XPK.newInstanceField(nacionalidad, nacionalidad.XPK);
        XPL.newInstanceField(nacionalidad, nacionalidad.XPL);
        XPM.newInstanceField(nacionalidad, nacionalidad.XPM);
        XPN.newInstanceField(nacionalidad, nacionalidad.XPN);
        XPR.newInstanceField(nacionalidad, nacionalidad.XPR);
        XPS.newInstanceField(nacionalidad, nacionalidad.XPS);
        XPT.newInstanceField(nacionalidad, nacionalidad.XPT);
        XPW.newInstanceField(nacionalidad, nacionalidad.XPW);
        XPY.newInstanceField(nacionalidad, nacionalidad.XPY);
        XQA.newInstanceField(nacionalidad, nacionalidad.XQA);
        XRE.newInstanceField(nacionalidad, nacionalidad.XRE);
        XRO.newInstanceField(nacionalidad, nacionalidad.XRO);
        XRS.newInstanceField(nacionalidad, nacionalidad.XRS);
        XRU.newInstanceField(nacionalidad, nacionalidad.XRU);
        XRW.newInstanceField(nacionalidad, nacionalidad.XRW);
        XSA.newInstanceField(nacionalidad, nacionalidad.XSA);
        XSB.newInstanceField(nacionalidad, nacionalidad.XSB);
        XSC.newInstanceField(nacionalidad, nacionalidad.XSC);
        XSD.newInstanceField(nacionalidad, nacionalidad.XSD);
        XSE.newInstanceField(nacionalidad, nacionalidad.XSE);
        XSG.newInstanceField(nacionalidad, nacionalidad.XSG);
        XSH.newInstanceField(nacionalidad, nacionalidad.XSH);
        XSI.newInstanceField(nacionalidad, nacionalidad.XSI);
        XSJ.newInstanceField(nacionalidad, nacionalidad.XSJ);
        XSK.newInstanceField(nacionalidad, nacionalidad.XSK);
        XSL.newInstanceField(nacionalidad, nacionalidad.XSL);
        XSM.newInstanceField(nacionalidad, nacionalidad.XSM);
        XSN.newInstanceField(nacionalidad, nacionalidad.XSN);
        XSO.newInstanceField(nacionalidad, nacionalidad.XSO);
        XSR.newInstanceField(nacionalidad, nacionalidad.XSR);
        XSS.newInstanceField(nacionalidad, nacionalidad.XSS);
        XST.newInstanceField(nacionalidad, nacionalidad.XST);
        XSV.newInstanceField(nacionalidad, nacionalidad.XSV);
        XSX.newInstanceField(nacionalidad, nacionalidad.XSX);
        XSY.newInstanceField(nacionalidad, nacionalidad.XSY);
        XSZ.newInstanceField(nacionalidad, nacionalidad.XSZ);
        XTC.newInstanceField(nacionalidad, nacionalidad.XTC);
        XTD.newInstanceField(nacionalidad, nacionalidad.XTD);
        XTF.newInstanceField(nacionalidad, nacionalidad.XTF);
        XTG.newInstanceField(nacionalidad, nacionalidad.XTG);
        XTH.newInstanceField(nacionalidad, nacionalidad.XTH);
        XTJ.newInstanceField(nacionalidad, nacionalidad.XTJ);
        XTK.newInstanceField(nacionalidad, nacionalidad.XTK);
        XTL.newInstanceField(nacionalidad, nacionalidad.XTL);
        XTM.newInstanceField(nacionalidad, nacionalidad.XTM);
        XTN.newInstanceField(nacionalidad, nacionalidad.XTN);
        XTO.newInstanceField(nacionalidad, nacionalidad.XTO);
        XTR.newInstanceField(nacionalidad, nacionalidad.XTR);
        XTT.newInstanceField(nacionalidad, nacionalidad.XTT);
        XTV.newInstanceField(nacionalidad, nacionalidad.XTV);
        XTW.newInstanceField(nacionalidad, nacionalidad.XTW);
        XTZ.newInstanceField(nacionalidad, nacionalidad.XTZ);
        XUA.newInstanceField(nacionalidad, nacionalidad.XUA);
        XUG.newInstanceField(nacionalidad, nacionalidad.XUG);
        XUM.newInstanceField(nacionalidad, nacionalidad.XUM);
        XUS.newInstanceField(nacionalidad, nacionalidad.XUS);
        XUY.newInstanceField(nacionalidad, nacionalidad.XUY);
        XUZ.newInstanceField(nacionalidad, nacionalidad.XUZ);
        XVA.newInstanceField(nacionalidad, nacionalidad.XVA);
        XVC.newInstanceField(nacionalidad, nacionalidad.XVC);
        XVE.newInstanceField(nacionalidad, nacionalidad.XVE);
        XVG.newInstanceField(nacionalidad, nacionalidad.XVG);
        XVI.newInstanceField(nacionalidad, nacionalidad.XVI);
        XVN.newInstanceField(nacionalidad, nacionalidad.XVN);
        XVU.newInstanceField(nacionalidad, nacionalidad.XVU);
        XWF.newInstanceField(nacionalidad, nacionalidad.XWF);
        XWS.newInstanceField(nacionalidad, nacionalidad.XWS);
        XYE.newInstanceField(nacionalidad, nacionalidad.XYE);
        XYT.newInstanceField(nacionalidad, nacionalidad.XYT);
        XZA.newInstanceField(nacionalidad, nacionalidad.XZA);
        XZM.newInstanceField(nacionalidad, nacionalidad.XZM);
        XZW.newInstanceField(nacionalidad, nacionalidad.XZW);
        // </editor-fold>
        /**/
        // <editor-fold defaultstate="collapsed" desc="newInstanceField(mapa)">
        /**/
        XAD.newInstanceField(mapa, iframe_prefix_string + "Andorra" + iframe_suffix_string);
        XAE.newInstanceField(mapa, iframe_prefix_string + "Emiratos+Arabes+Unidos" + iframe_suffix_string);
        XAF.newInstanceField(mapa, iframe_prefix_string + "Afganistan" + iframe_suffix_string);
        XAG.newInstanceField(mapa, iframe_prefix_string + "Antigua+y+Barbuda" + iframe_suffix_string);
        XAI.newInstanceField(mapa, iframe_prefix_string + "Anguila" + iframe_suffix_string);
        XAL.newInstanceField(mapa, iframe_prefix_string + "Albania" + iframe_suffix_string);
        XAM.newInstanceField(mapa, iframe_prefix_string + "Armenia" + iframe_suffix_string);
        XAO.newInstanceField(mapa, iframe_prefix_string + "Angola" + iframe_suffix_string);
        XAQ.newInstanceField(mapa, iframe_prefix_string + "Antartida" + iframe_suffix_string);
        XAR.newInstanceField(mapa, iframe_prefix_string + "Argentina" + iframe_suffix_string);
        XAS.newInstanceField(mapa, iframe_prefix_string + "Samoa+Americana" + iframe_suffix_string);
        XAT.newInstanceField(mapa, iframe_prefix_string + "Austria" + iframe_suffix_string);
        XAU.newInstanceField(mapa, iframe_prefix_string + "Australia" + iframe_suffix_string);
        XAW.newInstanceField(mapa, iframe_prefix_string + "Aruba" + iframe_suffix_string);
        XAX.newInstanceField(mapa, iframe_prefix_string + "Aland" + iframe_suffix_string);
        XAZ.newInstanceField(mapa, iframe_prefix_string + "Azerbaiyan" + iframe_suffix_string);
        XBA.newInstanceField(mapa, iframe_prefix_string + "Bosnia+y+Herzegovina" + iframe_suffix_string);
        XBB.newInstanceField(mapa, iframe_prefix_string + "Barbados" + iframe_suffix_string);
        XBD.newInstanceField(mapa, iframe_prefix_string + "Banglades" + iframe_suffix_string);
        XBE.newInstanceField(mapa, iframe_prefix_string + "Belgica" + iframe_suffix_string);
        XBF.newInstanceField(mapa, iframe_prefix_string + "Burkina+Faso" + iframe_suffix_string);
        XBG.newInstanceField(mapa, iframe_prefix_string + "Bulgaria" + iframe_suffix_string);
        XBH.newInstanceField(mapa, iframe_prefix_string + "Barein" + iframe_suffix_string);
        XBI.newInstanceField(mapa, iframe_prefix_string + "Burundi" + iframe_suffix_string);
        XBJ.newInstanceField(mapa, iframe_prefix_string + "Benin" + iframe_suffix_string);
        XBL.newInstanceField(mapa, iframe_prefix_string + "San+Bartolome" + iframe_suffix_string);
        XBM.newInstanceField(mapa, iframe_prefix_string + "Bermudas" + iframe_suffix_string);
        XBN.newInstanceField(mapa, iframe_prefix_string + "Brunei" + iframe_suffix_string);
        XBO.newInstanceField(mapa, iframe_prefix_string + "Bolivia" + iframe_suffix_string);
        XBQ.newInstanceField(mapa, iframe_prefix_string + "Bonaire,+San+Eustaquio+y+Saba" + iframe_suffix_string);
        XBR.newInstanceField(mapa, iframe_prefix_string + "Brasil" + iframe_suffix_string);
        XBS.newInstanceField(mapa, iframe_prefix_string + "Bahamas" + iframe_suffix_string);
        XBT.newInstanceField(mapa, iframe_prefix_string + "Butan" + iframe_suffix_string);
        XBV.newInstanceField(mapa, iframe_prefix_string + "Isla+Bouvet" + iframe_suffix_string);
        XBW.newInstanceField(mapa, iframe_prefix_string + "Botsuana" + iframe_suffix_string);
        XBY.newInstanceField(mapa, iframe_prefix_string + "Bielorrusia" + iframe_suffix_string);
        XBZ.newInstanceField(mapa, iframe_prefix_string + "Belice" + iframe_suffix_string);
        XCA.newInstanceField(mapa, iframe_prefix_string + "Canada" + iframe_suffix_string);
        XCC.newInstanceField(mapa, iframe_prefix_string + "Islas+Cocos" + iframe_suffix_string);
        XCD.newInstanceField(mapa, iframe_prefix_string + "Republica+Democratica+del+Congo" + iframe_suffix_string);
        XCF.newInstanceField(mapa, iframe_prefix_string + "Republica+Centroafricana" + iframe_suffix_string);
        XCG.newInstanceField(mapa, iframe_prefix_string + "Republic+of+the+Congo" + iframe_suffix_string);
        XCH.newInstanceField(mapa, iframe_prefix_string + "Suiza" + iframe_suffix_string);
        XCI.newInstanceField(mapa, iframe_prefix_string + "Costa+de+Marfil" + iframe_suffix_string);
        XCK.newInstanceField(mapa, iframe_prefix_string + "Islas+Cook" + iframe_suffix_string);
        XCL.newInstanceField(mapa, iframe_prefix_string + "Chile" + iframe_suffix_string);
        XCM.newInstanceField(mapa, iframe_prefix_string + "Camerun" + iframe_suffix_string);
        XCN.newInstanceField(mapa, iframe_prefix_string + "Rep%C3%BAblica+Popolar+China" + iframe_suffix_string);
        XCO.newInstanceField(mapa, iframe_prefix_string + "Colombia" + iframe_suffix_string);
        XCR.newInstanceField(mapa, iframe_prefix_string + "Costa+Rica" + iframe_suffix_string);
        XCU.newInstanceField(mapa, iframe_prefix_string + "Cuba" + iframe_suffix_string);
        XCV.newInstanceField(mapa, iframe_prefix_string + "Cabo+Verde" + iframe_suffix_string);
        XCW.newInstanceField(mapa, iframe_prefix_string + "Curazao" + iframe_suffix_string);
        XCX.newInstanceField(mapa, iframe_prefix_string + "Isla+de+Navidad" + iframe_suffix_string);
        XCY.newInstanceField(mapa, iframe_prefix_string + "Chipre" + iframe_suffix_string);
        XCZ.newInstanceField(mapa, iframe_prefix_string + "Republica+Checa" + iframe_suffix_string);
        XDE.newInstanceField(mapa, iframe_prefix_string + "Alemania" + iframe_suffix_string);
        XDJ.newInstanceField(mapa, iframe_prefix_string + "Yibuti" + iframe_suffix_string);
        XDK.newInstanceField(mapa, iframe_prefix_string + "Dinamarca" + iframe_suffix_string);
        XDM.newInstanceField(mapa, iframe_prefix_string + "Dominica" + iframe_suffix_string);
        XDO.newInstanceField(mapa, iframe_prefix_string + "Republica+Dominicana" + iframe_suffix_string);
        XDZ.newInstanceField(mapa, iframe_prefix_string + "Argelia" + iframe_suffix_string);
        XEC.newInstanceField(mapa, iframe_prefix_string + "Ecuador" + iframe_suffix_string);
        XEE.newInstanceField(mapa, iframe_prefix_string + "Estonia" + iframe_suffix_string);
        XEG.newInstanceField(mapa, iframe_prefix_string + "Egipto" + iframe_suffix_string);
        XEH.newInstanceField(mapa, iframe_prefix_string + "Sahara+Occidental" + iframe_suffix_string);
        XER.newInstanceField(mapa, iframe_prefix_string + "Eritrea" + iframe_suffix_string);
        XES.newInstanceField(mapa, iframe_prefix_string + "Espana" + iframe_suffix_string);
        XET.newInstanceField(mapa, iframe_prefix_string + "Etiopia" + iframe_suffix_string);
        XFI.newInstanceField(mapa, iframe_prefix_string + "Finlandia" + iframe_suffix_string);
        XFJ.newInstanceField(mapa, iframe_prefix_string + "Fiyi" + iframe_suffix_string);
        XFK.newInstanceField(mapa, iframe_prefix_string + "Islas+Malvinas" + iframe_suffix_string);
        XFM.newInstanceField(mapa, iframe_prefix_string + "Micronesia" + iframe_suffix_string);
        XFO.newInstanceField(mapa, iframe_prefix_string + "Islas+Feroe" + iframe_suffix_string);
        XFR.newInstanceField(mapa, iframe_prefix_string + "Francia" + iframe_suffix_string);
        XGA.newInstanceField(mapa, iframe_prefix_string + "Gabon" + iframe_suffix_string);
        XGB.newInstanceField(mapa, iframe_prefix_string + "Reino+Unido" + iframe_suffix_string);
        XGD.newInstanceField(mapa, iframe_prefix_string + "Granada%2C+Caribe" + iframe_suffix_string);
        XGE.newInstanceField(mapa, iframe_prefix_string + "Georgia" + iframe_suffix_string);
        XGF.newInstanceField(mapa, iframe_prefix_string + "Guayana+Francesa" + iframe_suffix_string);
        XGG.newInstanceField(mapa, iframe_prefix_string + "Guernsey" + iframe_suffix_string);
        XGH.newInstanceField(mapa, iframe_prefix_string + "Ghana" + iframe_suffix_string);
        XGI.newInstanceField(mapa, iframe_prefix_string + "Gibraltar" + iframe_suffix_string);
        XGL.newInstanceField(mapa, iframe_prefix_string + "Groenlandia" + iframe_suffix_string);
        XGM.newInstanceField(mapa, iframe_prefix_string + "Gambia" + iframe_suffix_string);
        XGN.newInstanceField(mapa, iframe_prefix_string + "Guinea" + iframe_suffix_string);
        XGP.newInstanceField(mapa, iframe_prefix_string + "Guadalupe" + iframe_suffix_string);
        XGQ.newInstanceField(mapa, iframe_prefix_string + "Guinea+Ecuatorial" + iframe_suffix_string);
        XGR.newInstanceField(mapa, iframe_prefix_string + "Grecia" + iframe_suffix_string);
        XGS.newInstanceField(mapa, iframe_prefix_string + "Islas+Georgias+del+Sur+y+Sandwich+del+Sur" + iframe_suffix_string);
        XGT.newInstanceField(mapa, iframe_prefix_string + "Guatemala" + iframe_suffix_string);
        XGU.newInstanceField(mapa, iframe_prefix_string + "Guam" + iframe_suffix_string);
        XGW.newInstanceField(mapa, iframe_prefix_string + "Guinea-Bisau" + iframe_suffix_string);
        XGY.newInstanceField(mapa, iframe_prefix_string + "Guyana" + iframe_suffix_string);
        XHK.newInstanceField(mapa, iframe_prefix_string + "Hong+Kong" + iframe_suffix_string);
        XHM.newInstanceField(mapa, iframe_prefix_string + "Islas+Heard+y+McDonald" + iframe_suffix_string);
        XHN.newInstanceField(mapa, iframe_prefix_string + "Honduras" + iframe_suffix_string);
        XHR.newInstanceField(mapa, iframe_prefix_string + "Croacia" + iframe_suffix_string);
        XHT.newInstanceField(mapa, iframe_prefix_string + "Haiti" + iframe_suffix_string);
        XHU.newInstanceField(mapa, iframe_prefix_string + "Hungria" + iframe_suffix_string);
        XID.newInstanceField(mapa, iframe_prefix_string + "Indonesia" + iframe_suffix_string);
        XIE.newInstanceField(mapa, iframe_prefix_string + "Irlanda" + iframe_suffix_string);
        XIL.newInstanceField(mapa, iframe_prefix_string + "Israel" + iframe_suffix_string);
        XIM.newInstanceField(mapa, iframe_prefix_string + "Isla+de+Man" + iframe_suffix_string);
        XIN.newInstanceField(mapa, iframe_prefix_string + "India" + iframe_suffix_string);
        XIO.newInstanceField(mapa, iframe_prefix_string + "Territorio+Britanico+del+Oceano+Indico" + iframe_suffix_string);
        XIQ.newInstanceField(mapa, iframe_prefix_string + "Irak" + iframe_suffix_string);
        XIR.newInstanceField(mapa, iframe_prefix_string + "Iran" + iframe_suffix_string);
        XIS.newInstanceField(mapa, iframe_prefix_string + "Islandia" + iframe_suffix_string);
        XIT.newInstanceField(mapa, iframe_prefix_string + "Italia" + iframe_suffix_string);
        XJE.newInstanceField(mapa, iframe_prefix_string + "Jersey" + iframe_suffix_string);
        XJM.newInstanceField(mapa, iframe_prefix_string + "Jamaica" + iframe_suffix_string);
        XJO.newInstanceField(mapa, iframe_prefix_string + "Jordania" + iframe_suffix_string);
        XJP.newInstanceField(mapa, iframe_prefix_string + "Japon" + iframe_suffix_string);
        XKE.newInstanceField(mapa, iframe_prefix_string + "Kenia" + iframe_suffix_string);
        XKG.newInstanceField(mapa, iframe_prefix_string + "Kirguistan" + iframe_suffix_string);
        XKH.newInstanceField(mapa, iframe_prefix_string + "Camboya" + iframe_suffix_string);
        XKI.newInstanceField(mapa, iframe_prefix_string + "Kiribati" + iframe_suffix_string);
        XKM.newInstanceField(mapa, iframe_prefix_string + "Comoras" + iframe_suffix_string);
        XKN.newInstanceField(mapa, iframe_prefix_string + "San+Cristobal+y+Nieves" + iframe_suffix_string);
        XKP.newInstanceField(mapa, iframe_prefix_string + "Corea+del+Norte" + iframe_suffix_string);
        XKR.newInstanceField(mapa, iframe_prefix_string + "Corea+del+Sur" + iframe_suffix_string);
        XKW.newInstanceField(mapa, iframe_prefix_string + "Kuwait" + iframe_suffix_string);
        XKY.newInstanceField(mapa, iframe_prefix_string + "Islas+Caiman" + iframe_suffix_string);
        XKZ.newInstanceField(mapa, iframe_prefix_string + "Kazajistan" + iframe_suffix_string);
        XLA.newInstanceField(mapa, iframe_prefix_string + "Laos" + iframe_suffix_string);
        XLB.newInstanceField(mapa, iframe_prefix_string + "Libano" + iframe_suffix_string);
        XLC.newInstanceField(mapa, iframe_prefix_string + "Santa+Lucia%2C+Caribe" + iframe_suffix_string);
        XLI.newInstanceField(mapa, iframe_prefix_string + "Liechtenstein" + iframe_suffix_string);
        XLK.newInstanceField(mapa, iframe_prefix_string + "Sri+Lanka" + iframe_suffix_string);
        XLR.newInstanceField(mapa, iframe_prefix_string + "Liberia" + iframe_suffix_string);
        XLS.newInstanceField(mapa, iframe_prefix_string + "Lesoto" + iframe_suffix_string);
        XLT.newInstanceField(mapa, iframe_prefix_string + "Lituania" + iframe_suffix_string);
        XLU.newInstanceField(mapa, iframe_prefix_string + "Luxemburgo" + iframe_suffix_string);
        XLV.newInstanceField(mapa, iframe_prefix_string + "Letonia" + iframe_suffix_string);
        XLY.newInstanceField(mapa, iframe_prefix_string + "Libia" + iframe_suffix_string);
        XMA.newInstanceField(mapa, iframe_prefix_string + "Marruecos" + iframe_suffix_string);
        XMC.newInstanceField(mapa, iframe_prefix_string + "Monaco" + iframe_suffix_string);
        XMD.newInstanceField(mapa, iframe_prefix_string + "Moldavia" + iframe_suffix_string);
        XME.newInstanceField(mapa, iframe_prefix_string + "Montenegro" + iframe_suffix_string);
        XMF.newInstanceField(mapa, iframe_prefix_string + "Saint+Martin" + iframe_suffix_string);
        XMG.newInstanceField(mapa, iframe_prefix_string + "Madagascar" + iframe_suffix_string);
        XMH.newInstanceField(mapa, iframe_prefix_string + "Islas+Marshall" + iframe_suffix_string);
        XMK.newInstanceField(mapa, iframe_prefix_string + "Macedonia+del+Norte" + iframe_suffix_string);
        XML.newInstanceField(mapa, iframe_prefix_string + "Mali" + iframe_suffix_string);
        XMM.newInstanceField(mapa, iframe_prefix_string + "Birmania" + iframe_suffix_string);
        XMN.newInstanceField(mapa, iframe_prefix_string + "Mongolia" + iframe_suffix_string);
        XMO.newInstanceField(mapa, iframe_prefix_string + "Macao" + iframe_suffix_string);
        XMP.newInstanceField(mapa, iframe_prefix_string + "Islas+Marianas+del+Norte" + iframe_suffix_string);
        XMQ.newInstanceField(mapa, iframe_prefix_string + "Martinica" + iframe_suffix_string);
        XMR.newInstanceField(mapa, iframe_prefix_string + "Mauritania" + iframe_suffix_string);
        XMS.newInstanceField(mapa, iframe_prefix_string + "Montserrat%2C+Caribe" + iframe_suffix_string);
        XMT.newInstanceField(mapa, iframe_prefix_string + "Malta" + iframe_suffix_string);
        XMU.newInstanceField(mapa, iframe_prefix_string + "Mauricio" + iframe_suffix_string);
        XMV.newInstanceField(mapa, iframe_prefix_string + "Maldivas" + iframe_suffix_string);
        XMW.newInstanceField(mapa, iframe_prefix_string + "Malaui" + iframe_suffix_string);
        XMX.newInstanceField(mapa, iframe_prefix_string + "Mexico" + iframe_suffix_string);
        XMY.newInstanceField(mapa, iframe_prefix_string + "Malasia" + iframe_suffix_string);
        XMZ.newInstanceField(mapa, iframe_prefix_string + "Mozambique" + iframe_suffix_string);
        XNA.newInstanceField(mapa, iframe_prefix_string + "Namibia" + iframe_suffix_string);
        XNC.newInstanceField(mapa, iframe_prefix_string + "Nueva+Caledonia" + iframe_suffix_string);
        XNE.newInstanceField(mapa, iframe_prefix_string + "Niger" + iframe_suffix_string);
        XNF.newInstanceField(mapa, iframe_prefix_string + "Isla+Norfolk" + iframe_suffix_string);
        XNG.newInstanceField(mapa, iframe_prefix_string + "Nigeria" + iframe_suffix_string);
        XNI.newInstanceField(mapa, iframe_prefix_string + "Nicaragua" + iframe_suffix_string);
        XNL.newInstanceField(mapa, iframe_prefix_string + "Paises+Bajos" + iframe_suffix_string);
        XNO.newInstanceField(mapa, iframe_prefix_string + "Noruega" + iframe_suffix_string);
        XNP.newInstanceField(mapa, iframe_prefix_string + "Nepal" + iframe_suffix_string);
        XNR.newInstanceField(mapa, iframe_prefix_string + "Nauru" + iframe_suffix_string);
        XNU.newInstanceField(mapa, iframe_prefix_string + "Niue" + iframe_suffix_string);
        XNZ.newInstanceField(mapa, iframe_prefix_string + "Nueva+Zelanda" + iframe_suffix_string);
        XOM.newInstanceField(mapa, iframe_prefix_string + "Oman" + iframe_suffix_string);
        XPA.newInstanceField(mapa, iframe_prefix_string + "Panama" + iframe_suffix_string);
        XPE.newInstanceField(mapa, iframe_prefix_string + "Peru" + iframe_suffix_string);
        XPF.newInstanceField(mapa, iframe_prefix_string + "Polinesia+Francesa" + iframe_suffix_string);
        XPG.newInstanceField(mapa, iframe_prefix_string + "Papua+Nueva+Guinea" + iframe_suffix_string);
        XPH.newInstanceField(mapa, iframe_prefix_string + "Filipinas" + iframe_suffix_string);
        XPK.newInstanceField(mapa, iframe_prefix_string + "Pakistan" + iframe_suffix_string);
        XPL.newInstanceField(mapa, iframe_prefix_string + "Polonia" + iframe_suffix_string);
        XPM.newInstanceField(mapa, iframe_prefix_string + "San+Pedro+y+Miquelon" + iframe_suffix_string);
        XPN.newInstanceField(mapa, iframe_prefix_string + "Islas+Pitcairn" + iframe_suffix_string);
        XPR.newInstanceField(mapa, iframe_prefix_string + "Puerto+Rico" + iframe_suffix_string);
        XPS.newInstanceField(mapa, iframe_prefix_string + "Palestina" + iframe_suffix_string);
        XPT.newInstanceField(mapa, iframe_prefix_string + "Portugal" + iframe_suffix_string);
        XPW.newInstanceField(mapa, iframe_prefix_string + "Palaos" + iframe_suffix_string);
        XPY.newInstanceField(mapa, iframe_prefix_string + "Paraguay" + iframe_suffix_string);
        XQA.newInstanceField(mapa, iframe_prefix_string + "Catar" + iframe_suffix_string);
        XRE.newInstanceField(mapa, iframe_prefix_string + "Reunion" + iframe_suffix_string);
        XRO.newInstanceField(mapa, iframe_prefix_string + "Rumania" + iframe_suffix_string);
        XRS.newInstanceField(mapa, iframe_prefix_string + "Serbia" + iframe_suffix_string);
        XRU.newInstanceField(mapa, iframe_prefix_string + "Rusia" + iframe_suffix_string);
        XRW.newInstanceField(mapa, iframe_prefix_string + "Ruanda" + iframe_suffix_string);
        XSA.newInstanceField(mapa, iframe_prefix_string + "Arabia+Saudita" + iframe_suffix_string);
        XSB.newInstanceField(mapa, iframe_prefix_string + "Islas+Salomon" + iframe_suffix_string);
        XSC.newInstanceField(mapa, iframe_prefix_string + "Seychelles" + iframe_suffix_string);
        XSD.newInstanceField(mapa, iframe_prefix_string + "Sudan" + iframe_suffix_string);
        XSE.newInstanceField(mapa, iframe_prefix_string + "Suecia" + iframe_suffix_string);
        XSG.newInstanceField(mapa, iframe_prefix_string + "Singapur" + iframe_suffix_string);
        XSH.newInstanceField(mapa, iframe_prefix_string + "St+Helena%2C+Ascension+and+Tristan+da+Cunha" + iframe_suffix_string);
        XSI.newInstanceField(mapa, iframe_prefix_string + "Eslovenia" + iframe_suffix_string);
        XSJ.newInstanceField(mapa, iframe_prefix_string + "Svalbard+y+Jan+Mayen" + iframe_suffix_string);
        XSK.newInstanceField(mapa, iframe_prefix_string + "Eslovaquia" + iframe_suffix_string);
        XSL.newInstanceField(mapa, iframe_prefix_string + "Sierra+Leona" + iframe_suffix_string);
        XSM.newInstanceField(mapa, iframe_prefix_string + "San+Marino" + iframe_suffix_string);
        XSN.newInstanceField(mapa, iframe_prefix_string + "Senegal" + iframe_suffix_string);
        XSO.newInstanceField(mapa, iframe_prefix_string + "Somalia" + iframe_suffix_string);
        XSR.newInstanceField(mapa, iframe_prefix_string + "Surinam" + iframe_suffix_string);
        XSS.newInstanceField(mapa, iframe_prefix_string + "Sudan+del+Sur" + iframe_suffix_string);
        XST.newInstanceField(mapa, iframe_prefix_string + "Santo+Tome+y+Principe" + iframe_suffix_string);
        XSV.newInstanceField(mapa, iframe_prefix_string + "El+Salvador" + iframe_suffix_string);
        XSX.newInstanceField(mapa, iframe_prefix_string + "St+Marteen" + iframe_suffix_string);
        XSY.newInstanceField(mapa, iframe_prefix_string + "Siria" + iframe_suffix_string);
        XSZ.newInstanceField(mapa, iframe_prefix_string + "Suazilandia" + iframe_suffix_string);
        XTC.newInstanceField(mapa, iframe_prefix_string + "Islas+Turcas+y+Caicos" + iframe_suffix_string);
        XTD.newInstanceField(mapa, iframe_prefix_string + "Chad" + iframe_suffix_string);
        XTF.newInstanceField(mapa, iframe_prefix_string + "Tierras+Australes+y+Antarticas+Francesas" + iframe_suffix_string);
        XTG.newInstanceField(mapa, iframe_prefix_string + "Togo" + iframe_suffix_string);
        XTH.newInstanceField(mapa, iframe_prefix_string + "Tailandia" + iframe_suffix_string);
        XTJ.newInstanceField(mapa, iframe_prefix_string + "Tayikistan" + iframe_suffix_string);
        XTK.newInstanceField(mapa, iframe_prefix_string + "Tokelau" + iframe_suffix_string);
        XTL.newInstanceField(mapa, iframe_prefix_string + "Timor+Oriental" + iframe_suffix_string);
        XTM.newInstanceField(mapa, iframe_prefix_string + "Turkmenistan" + iframe_suffix_string);
        XTN.newInstanceField(mapa, iframe_prefix_string + "Tunez" + iframe_suffix_string);
        XTO.newInstanceField(mapa, iframe_prefix_string + "Tonga" + iframe_suffix_string);
        XTR.newInstanceField(mapa, iframe_prefix_string + "Turquia" + iframe_suffix_string);
        XTT.newInstanceField(mapa, iframe_prefix_string + "Trinidad+y+Tobago" + iframe_suffix_string);
        XTV.newInstanceField(mapa, iframe_prefix_string + "Tuvalu" + iframe_suffix_string);
        XTW.newInstanceField(mapa, iframe_prefix_string + "Taiwan+%28Republica+de+China%29" + iframe_suffix_string);
        XTZ.newInstanceField(mapa, iframe_prefix_string + "Tanzania" + iframe_suffix_string);
        XUA.newInstanceField(mapa, iframe_prefix_string + "Ucrania" + iframe_suffix_string);
        XUG.newInstanceField(mapa, iframe_prefix_string + "Uganda" + iframe_suffix_string);
        XUM.newInstanceField(mapa, iframe_prefix_string + "Islas+Ultramarinas+Menores+de+los+Estados+Unidos" + iframe_suffix_string);
        XUS.newInstanceField(mapa, iframe_prefix_string + "Estados+Unidos" + iframe_suffix_string);
        XUY.newInstanceField(mapa, iframe_prefix_string + "Uruguay" + iframe_suffix_string);
        XUZ.newInstanceField(mapa, iframe_prefix_string + "Uzbekistan" + iframe_suffix_string);
        XVA.newInstanceField(mapa, iframe_prefix_string + "Ciudad+del+Vaticano" + iframe_suffix_string);
        XVC.newInstanceField(mapa, iframe_prefix_string + "San+Vicente+y+las+Granadinas" + iframe_suffix_string);
        XVE.newInstanceField(mapa, iframe_prefix_string + "Venezuela" + iframe_suffix_string);
        XVG.newInstanceField(mapa, iframe_prefix_string + "Islas+Virgenes+Britanicas" + iframe_suffix_string);
        XVI.newInstanceField(mapa, iframe_prefix_string + "Islas+Virgenes+de+los+Estados+Unidos" + iframe_suffix_string);
        XVN.newInstanceField(mapa, iframe_prefix_string + "Vietnam" + iframe_suffix_string);
        XVU.newInstanceField(mapa, iframe_prefix_string + "Vanuatu" + iframe_suffix_string);
        XWF.newInstanceField(mapa, iframe_prefix_string + "Wallis+y+Futuna" + iframe_suffix_string);
        XWS.newInstanceField(mapa, iframe_prefix_string + "Samoa" + iframe_suffix_string);
        XYE.newInstanceField(mapa, iframe_prefix_string + "Yemen" + iframe_suffix_string);
        XYT.newInstanceField(mapa, iframe_prefix_string + "Mayotte" + iframe_suffix_string);
        XZA.newInstanceField(mapa, iframe_prefix_string + "Sudafrica" + iframe_suffix_string);
        XZM.newInstanceField(mapa, iframe_prefix_string + "Zambia" + iframe_suffix_string);
        XZW.newInstanceField(mapa, iframe_prefix_string + "Zimbabue" + iframe_suffix_string);
        /**/
        // </editor-fold>
        /**/
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        /*
        archivoBandera.setRenderingFilter(UNTRUTH, true);
        archivoEscudo.setRenderingFilter(UNTRUTH, true);
        /**/
    }

}
