/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.configuracion.fija;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEnumerationEntityBase;

@EntityReferenceSearch(searchType = SearchType.RADIO, radioColumns = 1)
public class Region extends PersistentEnumerationEntityBase {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public Region(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    public Instance AREA_METROPOLITANA, REGION_OCCIDENTAL, REGION_ORIENTAL;

    @Override
    protected void settleInstances() {
        super.settleInstances();
        AREA_METROPOLITANA.newInstanceField(codigo, "Área Metropolitana");
        REGION_OCCIDENTAL.newInstanceField(codigo, "Región Occidental");
        REGION_ORIENTAL.newInstanceField(codigo, "Región Oriental");
    }

}
