/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.configuracion.fija.ve.i18n;

import adalid.core.interfaces.Artifact;
import java.lang.reflect.Field;

/**
 * Pais is a generated java file.
 * <ul>
 * <li>template: templates/meta/java/i18n/component.vm</li>
 * <li>template-author: Jorge Campins</li>
 * <li>file-encoding: UTF-8</li>
 * <li>file-preserve: false -> file will be replaced when regenerating the project</li>
 * </ul>
 *
 * @author ADALID (template by Jorge Campins)
 */
public class Pais extends showcase.meta.entidad.configuracion.fija.ve.Pais {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public Pais(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of Pais's attributes">
        setLocalizedLabel(ENGLISH, "country");
//      setLocalizedLabel(SPANISH, "país");
        setLocalizedCollectionLabel(ENGLISH, "Countries");
//      setLocalizedCollectionLabel(SPANISH, "Países");
        // </editor-fold>
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of Pais's properties">
        codigo.setLocalizedLabel(ENGLISH, "code");
//      codigo.setLocalizedLabel(SPANISH, "código");
        codigo.setLocalizedDescription(ENGLISH, "code that identifies the country, according to the international standardization standard ISO 3166-1 alpha-2");
//      codigo.setLocalizedDescription(SPANISH, "código que identifica al país, según del estándar internacional de normalización ISO 3166-1 alfa-2");
        /**/
        nombre.setLocalizedLabel(ENGLISH, "country");
//      nombre.setLocalizedLabel(SPANISH, "país");
        /**/
        nacionalidad.setLocalizedLabel(ENGLISH, "nationality");
        /**/
        sede.setLocalizedLabel(ENGLISH, "campus");
        /**/
        bandera.setLocalizedLabel(ENGLISH, "flag");
        bandera.setLocalizedTooltip(ENGLISH, "country flag");
//      bandera.setLocalizedTooltip(SPANISH, "bandera del país");
        /**/
        archivoBandera.setLocalizedLabel(ENGLISH, "flag file");
//      archivoBandera.setLocalizedLabel(SPANISH, "archivo bandera");
        archivoBandera.setLocalizedTooltip(ENGLISH, "URL of the file containing the country's flag");
//      archivoBandera.setLocalizedTooltip(SPANISH, "URL del archivo que contiene la bandera del país");
        /**/
        escudo.setLocalizedLabel(ENGLISH, "shield");
        escudo.setLocalizedTooltip(ENGLISH, "country shield");
//      escudo.setLocalizedTooltip(SPANISH, "escudo del país");
        /**/
        archivoEscudo.setLocalizedLabel(ENGLISH, "shield file");
//      archivoEscudo.setLocalizedLabel(SPANISH, "archivo escudo");
        archivoEscudo.setLocalizedTooltip(ENGLISH, "URL of the file containing the country's coat of arms");
//      archivoEscudo.setLocalizedTooltip(SPANISH, "URL del archivo que contiene la escudo del país");
        /**/
        mapa.setLocalizedLabel(ENGLISH, "map");
        mapa.setLocalizedDescription(ENGLISH, "Map provided by Google Maps.\nSpecify the country name to get the map.");
//      mapa.setLocalizedDescription(SPANISH, "Mapa provisto por Google Maps.\nEspecifique el nombre del país para obtener el mapa.");
        mapa.setLocalizedShortDescription(ENGLISH, "Map provided by Google Maps.\nSpecify the country name to get the map.");
//      mapa.setLocalizedShortDescription(SPANISH, "Mapa provisto por Google Maps.\nEspecifique el nombre del país para obtener el mapa.");
        // </editor-fold>
    }

    @Override
    protected void localizeInstances() {
        super.localizeInstances();
        // <editor-fold defaultstate="collapsed" desc="localization of Pais's instances">
//      XAD.newInstanceField(codigo, "A.D.", ENGLISH);
//      XAD.newInstanceField(codigo, "AD", SPANISH);
        /**/
        XAD.newInstanceField(nombre, "Andorra", ENGLISH);
//      XAD.newInstanceField(nombre, "Andorra", SPANISH);
        /**/
//      XAD.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Andorra\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XAD.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Andorra\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XAE.newInstanceField(codigo, "A.E.", ENGLISH);
//      XAE.newInstanceField(codigo, "AE", SPANISH);
        /**/
        XAE.newInstanceField(nombre, "United Arab Emirates", ENGLISH);
//      XAE.newInstanceField(nombre, "Emiratos Árabes Unidos", SPANISH);
        /**/
//      XAE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Emiratos+Arabes+Unidos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XAE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Emiratos+Arabes+Unidos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XAF.newInstanceField(codigo, "AF", ENGLISH);
//      XAF.newInstanceField(codigo, "AF", SPANISH);
        /**/
        XAF.newInstanceField(nombre, "Afghanistan", ENGLISH);
//      XAF.newInstanceField(nombre, "Afganistán", SPANISH);
        /**/
//      XAF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Afganistan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XAF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Afganistan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XAG.newInstanceField(codigo, "AG", ENGLISH);
//      XAG.newInstanceField(codigo, "AG", SPANISH);
        /**/
        XAG.newInstanceField(nombre, "Old and bearded", ENGLISH);
//      XAG.newInstanceField(nombre, "Antigua y Barbuda", SPANISH);
        /**/
//      XAG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Antigua+y+Barbuda\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XAG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Antigua+y+Barbuda\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XAI.newInstanceField(codigo, "AI", ENGLISH);
//      XAI.newInstanceField(codigo, "AI", SPANISH);
        /**/
        XAI.newInstanceField(nombre, "Eel", ENGLISH);
//      XAI.newInstanceField(nombre, "Anguila", SPANISH);
        /**/
//      XAI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Anguila\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XAI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Anguila\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XAL.newInstanceField(codigo, "TO THE", ENGLISH);
//      XAL.newInstanceField(codigo, "AL", SPANISH);
        /**/
        XAL.newInstanceField(nombre, "Albania", ENGLISH);
//      XAL.newInstanceField(nombre, "Albania", SPANISH);
        /**/
//      XAL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Albania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XAL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Albania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XAM.newInstanceField(codigo, "A.M", ENGLISH);
//      XAM.newInstanceField(codigo, "AM", SPANISH);
        /**/
        XAM.newInstanceField(nombre, "Armenia", ENGLISH);
//      XAM.newInstanceField(nombre, "Armenia", SPANISH);
        /**/
//      XAM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Armenia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XAM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Armenia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XAO.newInstanceField(codigo, "A.O.", ENGLISH);
//      XAO.newInstanceField(codigo, "AO", SPANISH);
        /**/
        XAO.newInstanceField(nombre, "Angola", ENGLISH);
//      XAO.newInstanceField(nombre, "Angola", SPANISH);
        /**/
//      XAO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Angola\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XAO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Angola\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XAQ.newInstanceField(codigo, "AQ", ENGLISH);
//      XAQ.newInstanceField(codigo, "AQ", SPANISH);
        /**/
        XAQ.newInstanceField(nombre, "Antarctica", ENGLISH);
//      XAQ.newInstanceField(nombre, "Antártida", SPANISH);
        /**/
//      XAQ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Antartida\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XAQ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Antartida\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XAR.newInstanceField(codigo, "A.R.", ENGLISH);
//      XAR.newInstanceField(codigo, "AR", SPANISH);
        /**/
        XAR.newInstanceField(nombre, "Argentina", ENGLISH);
//      XAR.newInstanceField(nombre, "Argentina", SPANISH);
        /**/
//      XAR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Argentina\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XAR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Argentina\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XAS.newInstanceField(codigo, "ACE", ENGLISH);
//      XAS.newInstanceField(codigo, "AS", SPANISH);
        /**/
        XAS.newInstanceField(nombre, "American Samoa", ENGLISH);
//      XAS.newInstanceField(nombre, "Samoa Americana", SPANISH);
        /**/
//      XAS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Samoa+Americana\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XAS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Samoa+Americana\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XAT.newInstanceField(codigo, "AT", ENGLISH);
//      XAT.newInstanceField(codigo, "AT", SPANISH);
        /**/
        XAT.newInstanceField(nombre, "Austria", ENGLISH);
//      XAT.newInstanceField(nombre, "Austria", SPANISH);
        /**/
//      XAT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Austria\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XAT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Austria\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XAU.newInstanceField(codigo, "AU", ENGLISH);
//      XAU.newInstanceField(codigo, "AU", SPANISH);
        /**/
        XAU.newInstanceField(nombre, "Australia", ENGLISH);
//      XAU.newInstanceField(nombre, "Australia", SPANISH);
        /**/
//      XAU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Australia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XAU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Australia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XAW.newInstanceField(codigo, "A.W.", ENGLISH);
//      XAW.newInstanceField(codigo, "AW", SPANISH);
        /**/
        XAW.newInstanceField(nombre, "Aruba", ENGLISH);
//      XAW.newInstanceField(nombre, "Aruba", SPANISH);
        /**/
//      XAW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Aruba\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XAW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Aruba\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XAX.newInstanceField(codigo, "AX", ENGLISH);
//      XAX.newInstanceField(codigo, "AX", SPANISH);
        /**/
        XAX.newInstanceField(nombre, "Alan", ENGLISH);
//      XAX.newInstanceField(nombre, "Aland", SPANISH);
        /**/
//      XAX.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Aland\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XAX.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Aland\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XAZ.newInstanceField(codigo, "AZ", ENGLISH);
//      XAZ.newInstanceField(codigo, "AZ", SPANISH);
        /**/
        XAZ.newInstanceField(nombre, "Azerbaijan", ENGLISH);
//      XAZ.newInstanceField(nombre, "Azerbaiyán", SPANISH);
        /**/
//      XAZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Azerbaiyan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XAZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Azerbaiyan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBA.newInstanceField(codigo, "B.A.", ENGLISH);
//      XBA.newInstanceField(codigo, "BA", SPANISH);
        /**/
        XBA.newInstanceField(nombre, "Bosnia and Herzegovina", ENGLISH);
//      XBA.newInstanceField(nombre, "Bosnia y Herzegovina", SPANISH);
        /**/
//      XBA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Bosnia+y+Herzegovina\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Bosnia+y+Herzegovina\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBB.newInstanceField(codigo, "B.B.", ENGLISH);
//      XBB.newInstanceField(codigo, "BB", SPANISH);
        /**/
        XBB.newInstanceField(nombre, "Barbados", ENGLISH);
//      XBB.newInstanceField(nombre, "Barbados", SPANISH);
        /**/
//      XBB.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Barbados\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBB.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Barbados\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBD.newInstanceField(codigo, "BD", ENGLISH);
//      XBD.newInstanceField(codigo, "BD", SPANISH);
        /**/
        XBD.newInstanceField(nombre, "Bangladesh", ENGLISH);
//      XBD.newInstanceField(nombre, "Bangladés", SPANISH);
        /**/
//      XBD.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Banglades\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBD.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Banglades\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBE.newInstanceField(codigo, "B.E.", ENGLISH);
//      XBE.newInstanceField(codigo, "BE", SPANISH);
        /**/
        XBE.newInstanceField(nombre, "Belgium", ENGLISH);
//      XBE.newInstanceField(nombre, "Bélgica", SPANISH);
        /**/
//      XBE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Belgica\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Belgica\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBF.newInstanceField(codigo, "B.F.", ENGLISH);
//      XBF.newInstanceField(codigo, "BF", SPANISH);
        /**/
        XBF.newInstanceField(nombre, "Burkina Faso", ENGLISH);
//      XBF.newInstanceField(nombre, "Burkina Faso", SPANISH);
        /**/
//      XBF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Burkina+Faso\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Burkina+Faso\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBG.newInstanceField(codigo, "B.G.", ENGLISH);
//      XBG.newInstanceField(codigo, "BG", SPANISH);
        /**/
        XBG.newInstanceField(nombre, "Bulgaria", ENGLISH);
//      XBG.newInstanceField(nombre, "Bulgaria", SPANISH);
        /**/
//      XBG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Bulgaria\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Bulgaria\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBH.newInstanceField(codigo, "B.H.", ENGLISH);
//      XBH.newInstanceField(codigo, "BH", SPANISH);
        /**/
        XBH.newInstanceField(nombre, "Bahrain", ENGLISH);
//      XBH.newInstanceField(nombre, "Baréin", SPANISH);
        /**/
//      XBH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Barein\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Barein\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBI.newInstanceField(codigo, "BI", ENGLISH);
//      XBI.newInstanceField(codigo, "BI", SPANISH);
        /**/
        XBI.newInstanceField(nombre, "Burundi", ENGLISH);
//      XBI.newInstanceField(nombre, "Burundi", SPANISH);
        /**/
//      XBI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Burundi\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Burundi\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBJ.newInstanceField(codigo, "B.J.", ENGLISH);
//      XBJ.newInstanceField(codigo, "BJ", SPANISH);
        /**/
        XBJ.newInstanceField(nombre, "Benin", ENGLISH);
//      XBJ.newInstanceField(nombre, "Benín", SPANISH);
        /**/
//      XBJ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Benin\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBJ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Benin\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBL.newInstanceField(codigo, "B.L.", ENGLISH);
//      XBL.newInstanceField(codigo, "BL", SPANISH);
        /**/
        XBL.newInstanceField(nombre, "San Bartolome", ENGLISH);
//      XBL.newInstanceField(nombre, "San Bartolomé", SPANISH);
        /**/
//      XBL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=San+Bartolome\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=San+Bartolome\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBM.newInstanceField(codigo, "B.M.", ENGLISH);
//      XBM.newInstanceField(codigo, "BM", SPANISH);
        /**/
        XBM.newInstanceField(nombre, "Bermuda", ENGLISH);
//      XBM.newInstanceField(nombre, "Bermudas", SPANISH);
        /**/
//      XBM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Bermudas\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Bermudas\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBN.newInstanceField(codigo, "B.N.", ENGLISH);
//      XBN.newInstanceField(codigo, "BN", SPANISH);
        /**/
        XBN.newInstanceField(nombre, "Brunei", ENGLISH);
//      XBN.newInstanceField(nombre, "Brunéi", SPANISH);
        /**/
//      XBN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Brunei\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Brunei\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBO.newInstanceField(codigo, "B.O.", ENGLISH);
//      XBO.newInstanceField(codigo, "BO", SPANISH);
        /**/
        XBO.newInstanceField(nombre, "Bolivia", ENGLISH);
//      XBO.newInstanceField(nombre, "Bolivia", SPANISH);
        /**/
//      XBO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Bolivia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Bolivia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBQ.newInstanceField(codigo, "B.Q.", ENGLISH);
//      XBQ.newInstanceField(codigo, "BQ", SPANISH);
        /**/
        XBQ.newInstanceField(nombre, "Bonaire, Saint Eustatius and Saba", ENGLISH);
//      XBQ.newInstanceField(nombre, "Bonaire, San Eustaquio y Saba", SPANISH);
        /**/
//      XBQ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Bonaire,+San+Eustaquio+y+Saba\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBQ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Bonaire,+San+Eustaquio+y+Saba\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBR.newInstanceField(codigo, "BR", ENGLISH);
//      XBR.newInstanceField(codigo, "BR", SPANISH);
        /**/
        XBR.newInstanceField(nombre, "Brazil", ENGLISH);
//      XBR.newInstanceField(nombre, "Brasil", SPANISH);
        /**/
//      XBR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Brasil\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Brasil\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBS.newInstanceField(codigo, "B.S.", ENGLISH);
//      XBS.newInstanceField(codigo, "BS", SPANISH);
        /**/
        XBS.newInstanceField(nombre, "Bahamas", ENGLISH);
//      XBS.newInstanceField(nombre, "Bahamas", SPANISH);
        /**/
//      XBS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Bahamas\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Bahamas\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBT.newInstanceField(codigo, "B.T.", ENGLISH);
//      XBT.newInstanceField(codigo, "BT", SPANISH);
        /**/
        XBT.newInstanceField(nombre, "Bhutan", ENGLISH);
//      XBT.newInstanceField(nombre, "Bután", SPANISH);
        /**/
//      XBT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Butan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Butan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBV.newInstanceField(codigo, "B.V.", ENGLISH);
//      XBV.newInstanceField(codigo, "BV", SPANISH);
        /**/
        XBV.newInstanceField(nombre, "Bouvet Island", ENGLISH);
//      XBV.newInstanceField(nombre, "Isla Bouvet", SPANISH);
        /**/
//      XBV.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Isla+Bouvet\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBV.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Isla+Bouvet\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBW.newInstanceField(codigo, "B.W.", ENGLISH);
//      XBW.newInstanceField(codigo, "BW", SPANISH);
        /**/
        XBW.newInstanceField(nombre, "Botswana", ENGLISH);
//      XBW.newInstanceField(nombre, "Botsuana", SPANISH);
        /**/
//      XBW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Botsuana\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Botsuana\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBY.newInstanceField(codigo, "BY", ENGLISH);
//      XBY.newInstanceField(codigo, "BY", SPANISH);
        /**/
        XBY.newInstanceField(nombre, "Belarus", ENGLISH);
//      XBY.newInstanceField(nombre, "Bielorrusia", SPANISH);
        /**/
//      XBY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Bielorrusia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Bielorrusia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XBZ.newInstanceField(codigo, "B.Z.", ENGLISH);
//      XBZ.newInstanceField(codigo, "BZ", SPANISH);
        /**/
        XBZ.newInstanceField(nombre, "Belize", ENGLISH);
//      XBZ.newInstanceField(nombre, "Belice", SPANISH);
        /**/
//      XBZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Belice\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XBZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Belice\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCA.newInstanceField(codigo, "AC", ENGLISH);
//      XCA.newInstanceField(codigo, "CA", SPANISH);
        /**/
        XCA.newInstanceField(nombre, "Canada", ENGLISH);
//      XCA.newInstanceField(nombre, "Canadá", SPANISH);
        /**/
//      XCA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Canada\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Canada\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCC.newInstanceField(codigo, "DC", ENGLISH);
//      XCC.newInstanceField(codigo, "CC", SPANISH);
        /**/
        XCC.newInstanceField(nombre, "Cocos Islands", ENGLISH);
//      XCC.newInstanceField(nombre, "Islas Cocos", SPANISH);
        /**/
//      XCC.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Cocos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCC.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Cocos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCD.newInstanceField(codigo, "CD", ENGLISH);
//      XCD.newInstanceField(codigo, "CD", SPANISH);
        /**/
        XCD.newInstanceField(nombre, "Democratic Republic of Congo", ENGLISH);
//      XCD.newInstanceField(nombre, "República Democrática del Congo", SPANISH);
        /**/
//      XCD.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Republica+Democratica+del+Congo\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCD.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Republica+Democratica+del+Congo\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCF.newInstanceField(codigo, "C.F.", ENGLISH);
//      XCF.newInstanceField(codigo, "CF", SPANISH);
        /**/
        XCF.newInstanceField(nombre, "Central African Republic", ENGLISH);
//      XCF.newInstanceField(nombre, "República Centroafricana", SPANISH);
        /**/
//      XCF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Republica+Centroafricana\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Republica+Centroafricana\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCG.newInstanceField(codigo, "CG", ENGLISH);
//      XCG.newInstanceField(codigo, "CG", SPANISH);
        /**/
        XCG.newInstanceField(nombre, "Republic of Congo", ENGLISH);
//      XCG.newInstanceField(nombre, "República del Congo", SPANISH);
        /**/
//      XCG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Republic+of+the+Congo\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Republic+of+the+Congo\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCH.newInstanceField(codigo, "CH", ENGLISH);
//      XCH.newInstanceField(codigo, "CH", SPANISH);
        /**/
        XCH.newInstanceField(nombre, "Swiss", ENGLISH);
//      XCH.newInstanceField(nombre, "Suiza", SPANISH);
        /**/
//      XCH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Suiza\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Suiza\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCI.newInstanceField(codigo, "IC", ENGLISH);
//      XCI.newInstanceField(codigo, "CI", SPANISH);
        /**/
        XCI.newInstanceField(nombre, "Ivory Coast", ENGLISH);
//      XCI.newInstanceField(nombre, "Costa de Marfil", SPANISH);
        /**/
//      XCI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Costa+de+Marfil\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Costa+de+Marfil\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCK.newInstanceField(codigo, "C.K.", ENGLISH);
//      XCK.newInstanceField(codigo, "CK", SPANISH);
        /**/
        XCK.newInstanceField(nombre, "Cook Islands", ENGLISH);
//      XCK.newInstanceField(nombre, "Islas Cook", SPANISH);
        /**/
//      XCK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Cook\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Cook\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCL.newInstanceField(codigo, "CL", ENGLISH);
//      XCL.newInstanceField(codigo, "CL", SPANISH);
        /**/
        XCL.newInstanceField(nombre, "Chili", ENGLISH);
//      XCL.newInstanceField(nombre, "Chile", SPANISH);
        /**/
//      XCL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Chile\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Chile\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCM.newInstanceField(codigo, "CM", ENGLISH);
//      XCM.newInstanceField(codigo, "CM", SPANISH);
        /**/
        XCM.newInstanceField(nombre, "Cameroon", ENGLISH);
//      XCM.newInstanceField(nombre, "Camerún", SPANISH);
        /**/
//      XCM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Camerun\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Camerun\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCN.newInstanceField(codigo, "C.N.", ENGLISH);
//      XCN.newInstanceField(codigo, "CN", SPANISH);
        /**/
        XCN.newInstanceField(nombre, "China", ENGLISH);
//      XCN.newInstanceField(nombre, "China", SPANISH);
        /**/
//      XCN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Rep%C3%BAblica+Popolar+China\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Rep%C3%BAblica+Popolar+China\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCO.newInstanceField(codigo, "CO", ENGLISH);
//      XCO.newInstanceField(codigo, "CO", SPANISH);
        /**/
        XCO.newInstanceField(nombre, "Colombia", ENGLISH);
//      XCO.newInstanceField(nombre, "Colombia", SPANISH);
        /**/
//      XCO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Colombia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Colombia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCR.newInstanceField(codigo, "C.R.", ENGLISH);
//      XCR.newInstanceField(codigo, "CR", SPANISH);
        /**/
        XCR.newInstanceField(nombre, "Costa Rica", ENGLISH);
//      XCR.newInstanceField(nombre, "Costa Rica", SPANISH);
        /**/
//      XCR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Costa+Rica\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Costa+Rica\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCU.newInstanceField(codigo, "C.U.", ENGLISH);
//      XCU.newInstanceField(codigo, "CU", SPANISH);
        /**/
        XCU.newInstanceField(nombre, "Cuba", ENGLISH);
//      XCU.newInstanceField(nombre, "Cuba", SPANISH);
        /**/
//      XCU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Cuba\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Cuba\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCV.newInstanceField(codigo, "CV", ENGLISH);
//      XCV.newInstanceField(codigo, "CV", SPANISH);
        /**/
        XCV.newInstanceField(nombre, "Cape Verde", ENGLISH);
//      XCV.newInstanceField(nombre, "Cabo Verde", SPANISH);
        /**/
//      XCV.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Cabo+Verde\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCV.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Cabo+Verde\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCW.newInstanceField(codigo, "C.W.", ENGLISH);
//      XCW.newInstanceField(codigo, "CW", SPANISH);
        /**/
        XCW.newInstanceField(nombre, "Curacao", ENGLISH);
//      XCW.newInstanceField(nombre, "Curazao", SPANISH);
        /**/
//      XCW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Curazao\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Curazao\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCX.newInstanceField(codigo, "C.X.", ENGLISH);
//      XCX.newInstanceField(codigo, "CX", SPANISH);
        /**/
        XCX.newInstanceField(nombre, "Christmas Island", ENGLISH);
//      XCX.newInstanceField(nombre, "Isla de Navidad", SPANISH);
        /**/
//      XCX.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Isla+de+Navidad\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCX.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Isla+de+Navidad\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCY.newInstanceField(codigo, "C.Y.", ENGLISH);
//      XCY.newInstanceField(codigo, "CY", SPANISH);
        /**/
        XCY.newInstanceField(nombre, "Cyprus", ENGLISH);
//      XCY.newInstanceField(nombre, "Chipre", SPANISH);
        /**/
//      XCY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Chipre\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Chipre\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XCZ.newInstanceField(codigo, "C.Z.", ENGLISH);
//      XCZ.newInstanceField(codigo, "CZ", SPANISH);
        /**/
        XCZ.newInstanceField(nombre, "Czech Republic", ENGLISH);
//      XCZ.newInstanceField(nombre, "República Checa", SPANISH);
        /**/
//      XCZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Republica+Checa\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XCZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Republica+Checa\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XDE.newInstanceField(codigo, "OF", ENGLISH);
//      XDE.newInstanceField(codigo, "DE", SPANISH);
        /**/
        XDE.newInstanceField(nombre, "Germany", ENGLISH);
//      XDE.newInstanceField(nombre, "Alemania", SPANISH);
        /**/
//      XDE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Alemania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XDE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Alemania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XDJ.newInstanceField(codigo, "DJ", ENGLISH);
//      XDJ.newInstanceField(codigo, "DJ", SPANISH);
        /**/
        XDJ.newInstanceField(nombre, "Djibouti", ENGLISH);
//      XDJ.newInstanceField(nombre, "Yibuti", SPANISH);
        /**/
//      XDJ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Yibuti\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XDJ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Yibuti\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XDK.newInstanceField(codigo, "D.K.", ENGLISH);
//      XDK.newInstanceField(codigo, "DK", SPANISH);
        /**/
        XDK.newInstanceField(nombre, "Denmark", ENGLISH);
//      XDK.newInstanceField(nombre, "Dinamarca", SPANISH);
        /**/
//      XDK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Dinamarca\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XDK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Dinamarca\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XDM.newInstanceField(codigo, "DM", ENGLISH);
//      XDM.newInstanceField(codigo, "DM", SPANISH);
        /**/
        XDM.newInstanceField(nombre, "Dominica", ENGLISH);
//      XDM.newInstanceField(nombre, "Dominica", SPANISH);
        /**/
//      XDM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Dominica\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XDM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Dominica\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XDO.newInstanceField(codigo, "DO", ENGLISH);
//      XDO.newInstanceField(codigo, "DO", SPANISH);
        /**/
        XDO.newInstanceField(nombre, "Dominican Republic", ENGLISH);
//      XDO.newInstanceField(nombre, "República Dominicana", SPANISH);
        /**/
//      XDO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Republica+Dominicana\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XDO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Republica+Dominicana\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XDZ.newInstanceField(codigo, "DZ", ENGLISH);
//      XDZ.newInstanceField(codigo, "DZ", SPANISH);
        /**/
        XDZ.newInstanceField(nombre, "Algeria", ENGLISH);
//      XDZ.newInstanceField(nombre, "Argelia", SPANISH);
        /**/
//      XDZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Argelia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XDZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Argelia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XEC.newInstanceField(codigo, "E.C.", ENGLISH);
//      XEC.newInstanceField(codigo, "EC", SPANISH);
        /**/
        XEC.newInstanceField(nombre, "Ecuador", ENGLISH);
//      XEC.newInstanceField(nombre, "Ecuador", SPANISH);
        /**/
//      XEC.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Ecuador\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XEC.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Ecuador\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XEE.newInstanceField(codigo, "EE", ENGLISH);
//      XEE.newInstanceField(codigo, "EE", SPANISH);
        /**/
        XEE.newInstanceField(nombre, "Estonia", ENGLISH);
//      XEE.newInstanceField(nombre, "Estonia", SPANISH);
        /**/
//      XEE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Estonia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XEE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Estonia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XEG.newInstanceField(codigo, "E.G.", ENGLISH);
//      XEG.newInstanceField(codigo, "EG", SPANISH);
        /**/
        XEG.newInstanceField(nombre, "Egypt", ENGLISH);
//      XEG.newInstanceField(nombre, "Egipto", SPANISH);
        /**/
//      XEG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Egipto\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XEG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Egipto\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XEH.newInstanceField(codigo, "HEY", ENGLISH);
//      XEH.newInstanceField(codigo, "EH", SPANISH);
        /**/
        XEH.newInstanceField(nombre, "Sahrawi Arab Democratic Republic", ENGLISH);
//      XEH.newInstanceField(nombre, "República Árabe Saharaui Democrática", SPANISH);
        /**/
//      XEH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Sahara+Occidental\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XEH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Sahara+Occidental\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XER.newInstanceField(codigo, "E.R.", ENGLISH);
//      XER.newInstanceField(codigo, "ER", SPANISH);
        /**/
        XER.newInstanceField(nombre, "Eritrea", ENGLISH);
//      XER.newInstanceField(nombre, "Eritrea", SPANISH);
        /**/
//      XER.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Eritrea\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XER.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Eritrea\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XES.newInstanceField(codigo, "IS", ENGLISH);
//      XES.newInstanceField(codigo, "ES", SPANISH);
        /**/
        XES.newInstanceField(nombre, "Spain", ENGLISH);
//      XES.newInstanceField(nombre, "España", SPANISH);
        /**/
//      XES.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Espana\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XES.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Espana\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XET.newInstanceField(codigo, "E.T.", ENGLISH);
//      XET.newInstanceField(codigo, "ET", SPANISH);
        /**/
        XET.newInstanceField(nombre, "Ethiopia", ENGLISH);
//      XET.newInstanceField(nombre, "Etiopía", SPANISH);
        /**/
//      XET.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Etiopia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XET.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Etiopia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XFI.newInstanceField(codigo, "FI", ENGLISH);
//      XFI.newInstanceField(codigo, "FI", SPANISH);
        /**/
        XFI.newInstanceField(nombre, "Finland", ENGLISH);
//      XFI.newInstanceField(nombre, "Finlandia", SPANISH);
        /**/
//      XFI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Finlandia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XFI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Finlandia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XFJ.newInstanceField(codigo, "F.J.", ENGLISH);
//      XFJ.newInstanceField(codigo, "FJ", SPANISH);
        /**/
        XFJ.newInstanceField(nombre, "Fiji", ENGLISH);
//      XFJ.newInstanceField(nombre, "Fiyi", SPANISH);
        /**/
//      XFJ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Fiyi\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XFJ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Fiyi\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XFK.newInstanceField(codigo, "F.K.", ENGLISH);
//      XFK.newInstanceField(codigo, "FK", SPANISH);
        /**/
        XFK.newInstanceField(nombre, "Falkland Islands", ENGLISH);
//      XFK.newInstanceField(nombre, "Islas Malvinas", SPANISH);
        /**/
//      XFK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Malvinas\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XFK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Malvinas\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XFM.newInstanceField(codigo, "FM", ENGLISH);
//      XFM.newInstanceField(codigo, "FM", SPANISH);
        /**/
        XFM.newInstanceField(nombre, "Micronesia", ENGLISH);
//      XFM.newInstanceField(nombre, "Micronesia", SPANISH);
        /**/
//      XFM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Micronesia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XFM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Micronesia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XFO.newInstanceField(codigo, "FO", ENGLISH);
//      XFO.newInstanceField(codigo, "FO", SPANISH);
        /**/
        XFO.newInstanceField(nombre, "Faroe Islands", ENGLISH);
//      XFO.newInstanceField(nombre, "Islas Feroe", SPANISH);
        /**/
//      XFO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Feroe\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XFO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Feroe\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XFR.newInstanceField(codigo, "FR", ENGLISH);
//      XFR.newInstanceField(codigo, "FR", SPANISH);
        /**/
        XFR.newInstanceField(nombre, "France", ENGLISH);
//      XFR.newInstanceField(nombre, "Francia", SPANISH);
        /**/
//      XFR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Francia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XFR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Francia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGA.newInstanceField(codigo, "G.A.", ENGLISH);
//      XGA.newInstanceField(codigo, "GA", SPANISH);
        /**/
        XGA.newInstanceField(nombre, "Gabon", ENGLISH);
//      XGA.newInstanceField(nombre, "Gabón", SPANISH);
        /**/
//      XGA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Gabon\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Gabon\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGB.newInstanceField(codigo, "GB", ENGLISH);
//      XGB.newInstanceField(codigo, "GB", SPANISH);
        /**/
        XGB.newInstanceField(nombre, "United Kingdom", ENGLISH);
//      XGB.newInstanceField(nombre, "Reino Unido", SPANISH);
        /**/
//      XGB.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Reino+Unido\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGB.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Reino+Unido\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGD.newInstanceField(codigo, "G.D.", ENGLISH);
//      XGD.newInstanceField(codigo, "GD", SPANISH);
        /**/
        XGD.newInstanceField(nombre, "Grenade", ENGLISH);
//      XGD.newInstanceField(nombre, "Granada", SPANISH);
        /**/
//      XGD.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Granada%2C+Caribe\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGD.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Granada%2C+Caribe\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGE.newInstanceField(codigo, "G.E.", ENGLISH);
//      XGE.newInstanceField(codigo, "GE", SPANISH);
        /**/
        XGE.newInstanceField(nombre, "Georgia", ENGLISH);
//      XGE.newInstanceField(nombre, "Georgia", SPANISH);
        /**/
//      XGE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Georgia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Georgia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGF.newInstanceField(codigo, "GF", ENGLISH);
//      XGF.newInstanceField(codigo, "GF", SPANISH);
        /**/
        XGF.newInstanceField(nombre, "French Guiana", ENGLISH);
//      XGF.newInstanceField(nombre, "Guayana Francesa", SPANISH);
        /**/
//      XGF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guayana+Francesa\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guayana+Francesa\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGG.newInstanceField(codigo, "GG", ENGLISH);
//      XGG.newInstanceField(codigo, "GG", SPANISH);
        /**/
        XGG.newInstanceField(nombre, "Guernsey", ENGLISH);
//      XGG.newInstanceField(nombre, "Guernsey", SPANISH);
        /**/
//      XGG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guernsey\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guernsey\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGH.newInstanceField(codigo, "G.H.", ENGLISH);
//      XGH.newInstanceField(codigo, "GH", SPANISH);
        /**/
        XGH.newInstanceField(nombre, "Ghana", ENGLISH);
//      XGH.newInstanceField(nombre, "Ghana", SPANISH);
        /**/
//      XGH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Ghana\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Ghana\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGI.newInstanceField(codigo, "G.I.", ENGLISH);
//      XGI.newInstanceField(codigo, "GI", SPANISH);
        /**/
        XGI.newInstanceField(nombre, "Gibraltar", ENGLISH);
//      XGI.newInstanceField(nombre, "Gibraltar", SPANISH);
        /**/
//      XGI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Gibraltar\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Gibraltar\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGL.newInstanceField(codigo, "G.L.", ENGLISH);
//      XGL.newInstanceField(codigo, "GL", SPANISH);
        /**/
        XGL.newInstanceField(nombre, "Greenland", ENGLISH);
//      XGL.newInstanceField(nombre, "Groenlandia", SPANISH);
        /**/
//      XGL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Groenlandia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Groenlandia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGM.newInstanceField(codigo, "GM", ENGLISH);
//      XGM.newInstanceField(codigo, "GM", SPANISH);
        /**/
        XGM.newInstanceField(nombre, "Gambia", ENGLISH);
//      XGM.newInstanceField(nombre, "Gambia", SPANISH);
        /**/
//      XGM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Gambia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Gambia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGN.newInstanceField(codigo, "G.N.", ENGLISH);
//      XGN.newInstanceField(codigo, "GN", SPANISH);
        /**/
        XGN.newInstanceField(nombre, "Guinea", ENGLISH);
//      XGN.newInstanceField(nombre, "Guinea", SPANISH);
        /**/
//      XGN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guinea\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guinea\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGP.newInstanceField(codigo, "GP", ENGLISH);
//      XGP.newInstanceField(codigo, "GP", SPANISH);
        /**/
        XGP.newInstanceField(nombre, "Guadeloupe", ENGLISH);
//      XGP.newInstanceField(nombre, "Guadalupe", SPANISH);
        /**/
//      XGP.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guadalupe\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGP.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guadalupe\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGQ.newInstanceField(codigo, "GQ", ENGLISH);
//      XGQ.newInstanceField(codigo, "GQ", SPANISH);
        /**/
        XGQ.newInstanceField(nombre, "Equatorial Guinea", ENGLISH);
//      XGQ.newInstanceField(nombre, "Guinea Ecuatorial", SPANISH);
        /**/
//      XGQ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guinea+Ecuatorial\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGQ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guinea+Ecuatorial\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGR.newInstanceField(codigo, "GR", ENGLISH);
//      XGR.newInstanceField(codigo, "GR", SPANISH);
        /**/
        XGR.newInstanceField(nombre, "Greece", ENGLISH);
//      XGR.newInstanceField(nombre, "Grecia", SPANISH);
        /**/
//      XGR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Grecia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Grecia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGS.newInstanceField(codigo, "G.S.", ENGLISH);
//      XGS.newInstanceField(codigo, "GS", SPANISH);
        /**/
        XGS.newInstanceField(nombre, "South Georgia and the South Sandwich Islands", ENGLISH);
//      XGS.newInstanceField(nombre, "Islas Georgias del Sur y Sandwich del Sur", SPANISH);
        /**/
//      XGS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Georgias+del+Sur+y+Sandwich+del+Sur\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Georgias+del+Sur+y+Sandwich+del+Sur\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGT.newInstanceField(codigo, "G.T.", ENGLISH);
//      XGT.newInstanceField(codigo, "GT", SPANISH);
        /**/
        XGT.newInstanceField(nombre, "Guatemala", ENGLISH);
//      XGT.newInstanceField(nombre, "Guatemala", SPANISH);
        /**/
//      XGT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guatemala\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guatemala\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGU.newInstanceField(codigo, "G.U.", ENGLISH);
//      XGU.newInstanceField(codigo, "GU", SPANISH);
        /**/
        XGU.newInstanceField(nombre, "guam", ENGLISH);
//      XGU.newInstanceField(nombre, "Guam", SPANISH);
        /**/
//      XGU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guam\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guam\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGW.newInstanceField(codigo, "G.W.", ENGLISH);
//      XGW.newInstanceField(codigo, "GW", SPANISH);
        /**/
        XGW.newInstanceField(nombre, "Guinea-Bissau", ENGLISH);
//      XGW.newInstanceField(nombre, "Guinea-Bisáu", SPANISH);
        /**/
//      XGW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guinea-Bisau\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guinea-Bisau\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XGY.newInstanceField(codigo, "GY", ENGLISH);
//      XGY.newInstanceField(codigo, "GY", SPANISH);
        /**/
        XGY.newInstanceField(nombre, "Guyana", ENGLISH);
//      XGY.newInstanceField(nombre, "Guyana", SPANISH);
        /**/
//      XGY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guyana\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XGY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Guyana\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XHK.newInstanceField(codigo, "H.K.", ENGLISH);
//      XHK.newInstanceField(codigo, "HK", SPANISH);
        /**/
        XHK.newInstanceField(nombre, "Hong Kong", ENGLISH);
//      XHK.newInstanceField(nombre, "Hong Kong", SPANISH);
        /**/
//      XHK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Hong+Kong\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XHK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Hong+Kong\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XHM.newInstanceField(codigo, "H.M.", ENGLISH);
//      XHM.newInstanceField(codigo, "HM", SPANISH);
        /**/
        XHM.newInstanceField(nombre, "Heard and McDonald Islands", ENGLISH);
//      XHM.newInstanceField(nombre, "Islas Heard y McDonald", SPANISH);
        /**/
//      XHM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Heard+y+McDonald\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XHM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Heard+y+McDonald\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XHN.newInstanceField(codigo, "H.N.", ENGLISH);
//      XHN.newInstanceField(codigo, "HN", SPANISH);
        /**/
        XHN.newInstanceField(nombre, "Honduras", ENGLISH);
//      XHN.newInstanceField(nombre, "Honduras", SPANISH);
        /**/
//      XHN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Honduras\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XHN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Honduras\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XHR.newInstanceField(codigo, "HR", ENGLISH);
//      XHR.newInstanceField(codigo, "HR", SPANISH);
        /**/
        XHR.newInstanceField(nombre, "Croatia", ENGLISH);
//      XHR.newInstanceField(nombre, "Croacia", SPANISH);
        /**/
//      XHR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Croacia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XHR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Croacia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XHT.newInstanceField(codigo, "H.T.", ENGLISH);
//      XHT.newInstanceField(codigo, "HT", SPANISH);
        /**/
        XHT.newInstanceField(nombre, "Haiti", ENGLISH);
//      XHT.newInstanceField(nombre, "Haití", SPANISH);
        /**/
//      XHT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Haiti\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XHT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Haiti\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XHU.newInstanceField(codigo, "HU", ENGLISH);
//      XHU.newInstanceField(codigo, "HU", SPANISH);
        /**/
        XHU.newInstanceField(nombre, "Hungary", ENGLISH);
//      XHU.newInstanceField(nombre, "Hungría", SPANISH);
        /**/
//      XHU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Hungria\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XHU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Hungria\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XID.newInstanceField(codigo, "ID", ENGLISH);
//      XID.newInstanceField(codigo, "ID", SPANISH);
        /**/
        XID.newInstanceField(nombre, "Indonesia", ENGLISH);
//      XID.newInstanceField(nombre, "Indonesia", SPANISH);
        /**/
//      XID.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Indonesia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XID.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Indonesia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XIE.newInstanceField(codigo, "I.E.", ENGLISH);
//      XIE.newInstanceField(codigo, "IE", SPANISH);
        /**/
        XIE.newInstanceField(nombre, "Ireland", ENGLISH);
//      XIE.newInstanceField(nombre, "Irlanda", SPANISH);
        /**/
//      XIE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Irlanda\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XIE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Irlanda\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XIL.newInstanceField(codigo, "I.L.", ENGLISH);
//      XIL.newInstanceField(codigo, "IL", SPANISH);
        /**/
        XIL.newInstanceField(nombre, "Israel", ENGLISH);
//      XIL.newInstanceField(nombre, "Israel", SPANISH);
        /**/
//      XIL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Israel\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XIL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Israel\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XIM.newInstanceField(codigo, "I.M.", ENGLISH);
//      XIM.newInstanceField(codigo, "IM", SPANISH);
        /**/
        XIM.newInstanceField(nombre, "Isle of Man", ENGLISH);
//      XIM.newInstanceField(nombre, "Isla de Man", SPANISH);
        /**/
//      XIM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Isla+de+Man\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XIM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Isla+de+Man\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XIN.newInstanceField(codigo, "IN", ENGLISH);
//      XIN.newInstanceField(codigo, "IN", SPANISH);
        /**/
        XIN.newInstanceField(nombre, "India", ENGLISH);
//      XIN.newInstanceField(nombre, "India", SPANISH);
        /**/
//      XIN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=India\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XIN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=India\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XIO.newInstanceField(codigo, "IO", ENGLISH);
//      XIO.newInstanceField(codigo, "IO", SPANISH);
        /**/
        XIO.newInstanceField(nombre, "British Indian Ocean Territory", ENGLISH);
//      XIO.newInstanceField(nombre, "Territorio Británico del Océano Índico", SPANISH);
        /**/
//      XIO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Territorio+Britanico+del+Oceano+Indico\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XIO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Territorio+Britanico+del+Oceano+Indico\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XIQ.newInstanceField(codigo, "IQ", ENGLISH);
//      XIQ.newInstanceField(codigo, "IQ", SPANISH);
        /**/
        XIQ.newInstanceField(nombre, "Iraq", ENGLISH);
//      XIQ.newInstanceField(nombre, "Irak", SPANISH);
        /**/
//      XIQ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Irak\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XIQ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Irak\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XIR.newInstanceField(codigo, "GO", ENGLISH);
//      XIR.newInstanceField(codigo, "IR", SPANISH);
        /**/
        XIR.newInstanceField(nombre, "Iran", ENGLISH);
//      XIR.newInstanceField(nombre, "Irán", SPANISH);
        /**/
//      XIR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Iran\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XIR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Iran\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XIS.newInstanceField(codigo, "ES", ENGLISH);
//      XIS.newInstanceField(codigo, "IS", SPANISH);
        /**/
        XIS.newInstanceField(nombre, "Iceland", ENGLISH);
//      XIS.newInstanceField(nombre, "Islandia", SPANISH);
        /**/
//      XIS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islandia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XIS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islandia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XIT.newInstanceField(codigo, "ITEM", ENGLISH);
//      XIT.newInstanceField(codigo, "IT", SPANISH);
        /**/
        XIT.newInstanceField(nombre, "Italy", ENGLISH);
//      XIT.newInstanceField(nombre, "Italia", SPANISH);
        /**/
//      XIT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Italia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XIT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Italia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XJE.newInstanceField(codigo, "J.E.", ENGLISH);
//      XJE.newInstanceField(codigo, "JE", SPANISH);
        /**/
        XJE.newInstanceField(nombre, "sweater", ENGLISH);
//      XJE.newInstanceField(nombre, "Jersey", SPANISH);
        /**/
//      XJE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Jersey\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XJE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Jersey\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XJM.newInstanceField(codigo, "J.M.", ENGLISH);
//      XJM.newInstanceField(codigo, "JM", SPANISH);
        /**/
        XJM.newInstanceField(nombre, "Jamaica", ENGLISH);
//      XJM.newInstanceField(nombre, "Jamaica", SPANISH);
        /**/
//      XJM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Jamaica\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XJM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Jamaica\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XJO.newInstanceField(codigo, "JO", ENGLISH);
//      XJO.newInstanceField(codigo, "JO", SPANISH);
        /**/
        XJO.newInstanceField(nombre, "Jordan", ENGLISH);
//      XJO.newInstanceField(nombre, "Jordania", SPANISH);
        /**/
//      XJO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Jordania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XJO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Jordania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XJP.newInstanceField(codigo, "J.P.", ENGLISH);
//      XJP.newInstanceField(codigo, "JP", SPANISH);
        /**/
        XJP.newInstanceField(nombre, "Japan", ENGLISH);
//      XJP.newInstanceField(nombre, "Japón", SPANISH);
        /**/
//      XJP.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Japon\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XJP.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Japon\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XKE.newInstanceField(codigo, "K.E.", ENGLISH);
//      XKE.newInstanceField(codigo, "KE", SPANISH);
        /**/
        XKE.newInstanceField(nombre, "Kenya", ENGLISH);
//      XKE.newInstanceField(nombre, "Kenia", SPANISH);
        /**/
//      XKE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Kenia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XKE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Kenia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XKG.newInstanceField(codigo, "KG", ENGLISH);
//      XKG.newInstanceField(codigo, "KG", SPANISH);
        /**/
        XKG.newInstanceField(nombre, "Kyrgyzstan", ENGLISH);
//      XKG.newInstanceField(nombre, "Kirguistán", SPANISH);
        /**/
//      XKG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Kirguistan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XKG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Kirguistan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XKH.newInstanceField(codigo, "K.H.", ENGLISH);
//      XKH.newInstanceField(codigo, "KH", SPANISH);
        /**/
        XKH.newInstanceField(nombre, "Cambodia", ENGLISH);
//      XKH.newInstanceField(nombre, "Camboya", SPANISH);
        /**/
//      XKH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Camboya\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XKH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Camboya\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XKI.newInstanceField(codigo, "KI", ENGLISH);
//      XKI.newInstanceField(codigo, "KI", SPANISH);
        /**/
        XKI.newInstanceField(nombre, "Kiribati", ENGLISH);
//      XKI.newInstanceField(nombre, "Kiribati", SPANISH);
        /**/
//      XKI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Kiribati\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XKI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Kiribati\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XKM.newInstanceField(codigo, "KM", ENGLISH);
//      XKM.newInstanceField(codigo, "KM", SPANISH);
        /**/
        XKM.newInstanceField(nombre, "Comoros", ENGLISH);
//      XKM.newInstanceField(nombre, "Comoras", SPANISH);
        /**/
//      XKM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Comoras\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XKM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Comoras\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XKN.newInstanceField(codigo, "K.N.", ENGLISH);
//      XKN.newInstanceField(codigo, "KN", SPANISH);
        /**/
        XKN.newInstanceField(nombre, "Saint Kitts and Nevis", ENGLISH);
//      XKN.newInstanceField(nombre, "San Cristóbal y Nieves", SPANISH);
        /**/
//      XKN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=San+Cristobal+y+Nieves\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XKN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=San+Cristobal+y+Nieves\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XKP.newInstanceField(codigo, "K.P.", ENGLISH);
//      XKP.newInstanceField(codigo, "KP", SPANISH);
        /**/
        XKP.newInstanceField(nombre, "North Korea", ENGLISH);
//      XKP.newInstanceField(nombre, "Corea del Norte", SPANISH);
        /**/
//      XKP.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Corea+del+Norte\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XKP.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Corea+del+Norte\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XKR.newInstanceField(codigo, "K.R.", ENGLISH);
//      XKR.newInstanceField(codigo, "KR", SPANISH);
        /**/
        XKR.newInstanceField(nombre, "South Korea", ENGLISH);
//      XKR.newInstanceField(nombre, "Corea del Sur", SPANISH);
        /**/
//      XKR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Corea+del+Sur\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XKR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Corea+del+Sur\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XKW.newInstanceField(codigo, "KW", ENGLISH);
//      XKW.newInstanceField(codigo, "KW", SPANISH);
        /**/
        XKW.newInstanceField(nombre, "Kuwait", ENGLISH);
//      XKW.newInstanceField(nombre, "Kuwait", SPANISH);
        /**/
//      XKW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Kuwait\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XKW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Kuwait\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XKY.newInstanceField(codigo, "K.Y.", ENGLISH);
//      XKY.newInstanceField(codigo, "KY", SPANISH);
        /**/
        XKY.newInstanceField(nombre, "Cayman Islands", ENGLISH);
//      XKY.newInstanceField(nombre, "Islas Caimán", SPANISH);
        /**/
//      XKY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Caiman\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XKY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Caiman\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XKZ.newInstanceField(codigo, "KZ", ENGLISH);
//      XKZ.newInstanceField(codigo, "KZ", SPANISH);
        /**/
        XKZ.newInstanceField(nombre, "Kazakhstan", ENGLISH);
//      XKZ.newInstanceField(nombre, "Kazajistán", SPANISH);
        /**/
//      XKZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Kazajistan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XKZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Kazajistan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XLA.newInstanceField(codigo, "THE", ENGLISH);
//      XLA.newInstanceField(codigo, "LA", SPANISH);
        /**/
        XLA.newInstanceField(nombre, "Laos", ENGLISH);
//      XLA.newInstanceField(nombre, "Laos", SPANISH);
        /**/
//      XLA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Laos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XLA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Laos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XLB.newInstanceField(codigo, "L.B.", ENGLISH);
//      XLB.newInstanceField(codigo, "LB", SPANISH);
        /**/
        XLB.newInstanceField(nombre, "Lebanon", ENGLISH);
//      XLB.newInstanceField(nombre, "Líbano", SPANISH);
        /**/
//      XLB.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Libano\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XLB.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Libano\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XLC.newInstanceField(codigo, "L.C.", ENGLISH);
//      XLC.newInstanceField(codigo, "LC", SPANISH);
        /**/
        XLC.newInstanceField(nombre, "St. Lucia", ENGLISH);
//      XLC.newInstanceField(nombre, "Santa Lucía", SPANISH);
        /**/
//      XLC.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Santa+Lucia%2C+Caribe\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XLC.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Santa+Lucia%2C+Caribe\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XLI.newInstanceField(codigo, "L.I.", ENGLISH);
//      XLI.newInstanceField(codigo, "LI", SPANISH);
        /**/
        XLI.newInstanceField(nombre, "Liechtenstein", ENGLISH);
//      XLI.newInstanceField(nombre, "Liechtenstein", SPANISH);
        /**/
//      XLI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Liechtenstein\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XLI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Liechtenstein\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XLK.newInstanceField(codigo, "L.K.", ENGLISH);
//      XLK.newInstanceField(codigo, "LK", SPANISH);
        /**/
        XLK.newInstanceField(nombre, "Sri Lanka", ENGLISH);
//      XLK.newInstanceField(nombre, "Sri Lanka", SPANISH);
        /**/
//      XLK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Sri+Lanka\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XLK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Sri+Lanka\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XLR.newInstanceField(codigo, "L.R.", ENGLISH);
//      XLR.newInstanceField(codigo, "LR", SPANISH);
        /**/
        XLR.newInstanceField(nombre, "Liberia", ENGLISH);
//      XLR.newInstanceField(nombre, "Liberia", SPANISH);
        /**/
//      XLR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Liberia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XLR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Liberia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XLS.newInstanceField(codigo, "L.S.", ENGLISH);
//      XLS.newInstanceField(codigo, "LS", SPANISH);
        /**/
        XLS.newInstanceField(nombre, "Lesotho", ENGLISH);
//      XLS.newInstanceField(nombre, "Lesoto", SPANISH);
        /**/
//      XLS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Lesoto\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XLS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Lesoto\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XLT.newInstanceField(codigo, "L.T.", ENGLISH);
//      XLT.newInstanceField(codigo, "LT", SPANISH);
        /**/
        XLT.newInstanceField(nombre, "Lithuania", ENGLISH);
//      XLT.newInstanceField(nombre, "Lituania", SPANISH);
        /**/
//      XLT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Lituania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XLT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Lituania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XLU.newInstanceField(codigo, "LU", ENGLISH);
//      XLU.newInstanceField(codigo, "LU", SPANISH);
        /**/
        XLU.newInstanceField(nombre, "Luxembourg", ENGLISH);
//      XLU.newInstanceField(nombre, "Luxemburgo", SPANISH);
        /**/
//      XLU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Luxemburgo\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XLU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Luxemburgo\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XLV.newInstanceField(codigo, "L.V.", ENGLISH);
//      XLV.newInstanceField(codigo, "LV", SPANISH);
        /**/
        XLV.newInstanceField(nombre, "Latvia", ENGLISH);
//      XLV.newInstanceField(nombre, "Letonia", SPANISH);
        /**/
//      XLV.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Letonia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XLV.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Letonia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XLY.newInstanceField(codigo, "L.Y.", ENGLISH);
//      XLY.newInstanceField(codigo, "LY", SPANISH);
        /**/
        XLY.newInstanceField(nombre, "Libya", ENGLISH);
//      XLY.newInstanceField(nombre, "Libia", SPANISH);
        /**/
//      XLY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Libia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XLY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Libia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMA.newInstanceField(codigo, "M.A.", ENGLISH);
//      XMA.newInstanceField(codigo, "MA", SPANISH);
        /**/
        XMA.newInstanceField(nombre, "Morocco", ENGLISH);
//      XMA.newInstanceField(nombre, "Marruecos", SPANISH);
        /**/
//      XMA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Marruecos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Marruecos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMC.newInstanceField(codigo, "MC", ENGLISH);
//      XMC.newInstanceField(codigo, "MC", SPANISH);
        /**/
        XMC.newInstanceField(nombre, "Monaco", ENGLISH);
//      XMC.newInstanceField(nombre, "Mónaco", SPANISH);
        /**/
//      XMC.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Monaco\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMC.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Monaco\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMD.newInstanceField(codigo, "M.D.", ENGLISH);
//      XMD.newInstanceField(codigo, "MD", SPANISH);
        /**/
        XMD.newInstanceField(nombre, "Moldova", ENGLISH);
//      XMD.newInstanceField(nombre, "Moldavia", SPANISH);
        /**/
//      XMD.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Moldavia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMD.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Moldavia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XME.newInstanceField(codigo, "I", ENGLISH);
//      XME.newInstanceField(codigo, "ME", SPANISH);
        /**/
        XME.newInstanceField(nombre, "Montenegro", ENGLISH);
//      XME.newInstanceField(nombre, "Montenegro", SPANISH);
        /**/
//      XME.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Montenegro\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XME.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Montenegro\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMF.newInstanceField(codigo, "M.F.", ENGLISH);
//      XMF.newInstanceField(codigo, "MF", SPANISH);
        /**/
        XMF.newInstanceField(nombre, "Saint Martin (French part)", ENGLISH);
//      XMF.newInstanceField(nombre, "San Martín (parte francesa)", SPANISH);
        /**/
//      XMF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Saint+Martin\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Saint+Martin\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMG.newInstanceField(codigo, "MG", ENGLISH);
//      XMG.newInstanceField(codigo, "MG", SPANISH);
        /**/
        XMG.newInstanceField(nombre, "Madagascar", ENGLISH);
//      XMG.newInstanceField(nombre, "Madagascar", SPANISH);
        /**/
//      XMG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Madagascar\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Madagascar\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMH.newInstanceField(codigo, "M.H.", ENGLISH);
//      XMH.newInstanceField(codigo, "MH", SPANISH);
        /**/
        XMH.newInstanceField(nombre, "Marshall Islands", ENGLISH);
//      XMH.newInstanceField(nombre, "Islas Marshall", SPANISH);
        /**/
//      XMH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Marshall\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Marshall\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMK.newInstanceField(codigo, "M.K.", ENGLISH);
//      XMK.newInstanceField(codigo, "MK", SPANISH);
        /**/
        XMK.newInstanceField(nombre, "North Macedonia", ENGLISH);
//      XMK.newInstanceField(nombre, "Macedonia del Norte", SPANISH);
        /**/
//      XMK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Macedonia+del+Norte\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Macedonia+del+Norte\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XML.newInstanceField(codigo, "M.L.", ENGLISH);
//      XML.newInstanceField(codigo, "ML", SPANISH);
        /**/
        XML.newInstanceField(nombre, "Mali", ENGLISH);
//      XML.newInstanceField(nombre, "Malí", SPANISH);
        /**/
//      XML.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Mali\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XML.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Mali\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMM.newInstanceField(codigo, "MM", ENGLISH);
//      XMM.newInstanceField(codigo, "MM", SPANISH);
        /**/
        XMM.newInstanceField(nombre, "Burma", ENGLISH);
//      XMM.newInstanceField(nombre, "Birmania", SPANISH);
        /**/
//      XMM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Birmania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Birmania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMN.newInstanceField(codigo, "M.N.", ENGLISH);
//      XMN.newInstanceField(codigo, "MN", SPANISH);
        /**/
        XMN.newInstanceField(nombre, "Mongolia", ENGLISH);
//      XMN.newInstanceField(nombre, "Mongolia", SPANISH);
        /**/
//      XMN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Mongolia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Mongolia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMO.newInstanceField(codigo, "M.O.", ENGLISH);
//      XMO.newInstanceField(codigo, "MO", SPANISH);
        /**/
        XMO.newInstanceField(nombre, "Macau", ENGLISH);
//      XMO.newInstanceField(nombre, "Macao", SPANISH);
        /**/
//      XMO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Macao\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Macao\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMP.newInstanceField(codigo, "M.P.", ENGLISH);
//      XMP.newInstanceField(codigo, "MP", SPANISH);
        /**/
        XMP.newInstanceField(nombre, "Northern Mariana Islands", ENGLISH);
//      XMP.newInstanceField(nombre, "Islas Marianas del Norte", SPANISH);
        /**/
//      XMP.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Marianas+del+Norte\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMP.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Marianas+del+Norte\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMQ.newInstanceField(codigo, "MQ", ENGLISH);
//      XMQ.newInstanceField(codigo, "MQ", SPANISH);
        /**/
        XMQ.newInstanceField(nombre, "Martinique", ENGLISH);
//      XMQ.newInstanceField(nombre, "Martinica", SPANISH);
        /**/
//      XMQ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Martinica\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMQ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Martinica\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMR.newInstanceField(codigo, "M.R.", ENGLISH);
//      XMR.newInstanceField(codigo, "MR", SPANISH);
        /**/
        XMR.newInstanceField(nombre, "Mauritania", ENGLISH);
//      XMR.newInstanceField(nombre, "Mauritania", SPANISH);
        /**/
//      XMR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Mauritania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Mauritania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMS.newInstanceField(codigo, "M.S.", ENGLISH);
//      XMS.newInstanceField(codigo, "MS", SPANISH);
        /**/
        XMS.newInstanceField(nombre, "Montserrat", ENGLISH);
//      XMS.newInstanceField(nombre, "Montserrat", SPANISH);
        /**/
//      XMS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Montserrat%2C+Caribe\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Montserrat%2C+Caribe\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMT.newInstanceField(codigo, "M.T.", ENGLISH);
//      XMT.newInstanceField(codigo, "MT", SPANISH);
        /**/
        XMT.newInstanceField(nombre, "malt", ENGLISH);
//      XMT.newInstanceField(nombre, "Malta", SPANISH);
        /**/
//      XMT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Malta\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Malta\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMU.newInstanceField(codigo, "MU", ENGLISH);
//      XMU.newInstanceField(codigo, "MU", SPANISH);
        /**/
        XMU.newInstanceField(nombre, "Mauricio", ENGLISH);
//      XMU.newInstanceField(nombre, "Mauricio", SPANISH);
        /**/
//      XMU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Mauricio\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Mauricio\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMV.newInstanceField(codigo, "M.V.", ENGLISH);
//      XMV.newInstanceField(codigo, "MV", SPANISH);
        /**/
        XMV.newInstanceField(nombre, "Maldives", ENGLISH);
//      XMV.newInstanceField(nombre, "Maldivas", SPANISH);
        /**/
//      XMV.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Maldivas\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMV.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Maldivas\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMW.newInstanceField(codigo, "MW", ENGLISH);
//      XMW.newInstanceField(codigo, "MW", SPANISH);
        /**/
        XMW.newInstanceField(nombre, "Malawi", ENGLISH);
//      XMW.newInstanceField(nombre, "Malaui", SPANISH);
        /**/
//      XMW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Malaui\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Malaui\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMX.newInstanceField(codigo, "MX", ENGLISH);
//      XMX.newInstanceField(codigo, "MX", SPANISH);
        /**/
        XMX.newInstanceField(nombre, "Mexico", ENGLISH);
//      XMX.newInstanceField(nombre, "México", SPANISH);
        /**/
//      XMX.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Mexico\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMX.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Mexico\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMY.newInstanceField(codigo, "MY", ENGLISH);
//      XMY.newInstanceField(codigo, "MY", SPANISH);
        /**/
        XMY.newInstanceField(nombre, "Malaysia", ENGLISH);
//      XMY.newInstanceField(nombre, "Malasia", SPANISH);
        /**/
//      XMY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Malasia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Malasia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XMZ.newInstanceField(codigo, "MZ", ENGLISH);
//      XMZ.newInstanceField(codigo, "MZ", SPANISH);
        /**/
        XMZ.newInstanceField(nombre, "Mozambique", ENGLISH);
//      XMZ.newInstanceField(nombre, "Mozambique", SPANISH);
        /**/
//      XMZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Mozambique\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XMZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Mozambique\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XNA.newInstanceField(codigo, "NA", ENGLISH);
//      XNA.newInstanceField(codigo, "NA", SPANISH);
        /**/
        XNA.newInstanceField(nombre, "Namibia", ENGLISH);
//      XNA.newInstanceField(nombre, "Namibia", SPANISH);
        /**/
//      XNA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Namibia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XNA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Namibia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XNC.newInstanceField(codigo, "NC", ENGLISH);
//      XNC.newInstanceField(codigo, "NC", SPANISH);
        /**/
        XNC.newInstanceField(nombre, "New Caledonia", ENGLISH);
//      XNC.newInstanceField(nombre, "Nueva Caledonia", SPANISH);
        /**/
//      XNC.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Nueva+Caledonia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XNC.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Nueva+Caledonia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XNE.newInstanceField(codigo, "NE", ENGLISH);
//      XNE.newInstanceField(codigo, "NE", SPANISH);
        /**/
        XNE.newInstanceField(nombre, "Niger", ENGLISH);
//      XNE.newInstanceField(nombre, "Níger", SPANISH);
        /**/
//      XNE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Niger\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XNE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Niger\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XNF.newInstanceField(codigo, "N.F.", ENGLISH);
//      XNF.newInstanceField(codigo, "NF", SPANISH);
        /**/
        XNF.newInstanceField(nombre, "Norfolk Island", ENGLISH);
//      XNF.newInstanceField(nombre, "Isla Norfolk", SPANISH);
        /**/
//      XNF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Isla+Norfolk\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XNF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Isla+Norfolk\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XNG.newInstanceField(codigo, "NG", ENGLISH);
//      XNG.newInstanceField(codigo, "NG", SPANISH);
        /**/
        XNG.newInstanceField(nombre, "Nigeria", ENGLISH);
//      XNG.newInstanceField(nombre, "Nigeria", SPANISH);
        /**/
//      XNG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Nigeria\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XNG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Nigeria\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XNI.newInstanceField(codigo, "NEITHER", ENGLISH);
//      XNI.newInstanceField(codigo, "NI", SPANISH);
        /**/
        XNI.newInstanceField(nombre, "Nicaragua", ENGLISH);
//      XNI.newInstanceField(nombre, "Nicaragua", SPANISH);
        /**/
//      XNI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Nicaragua\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XNI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Nicaragua\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XNL.newInstanceField(codigo, "N.L.", ENGLISH);
//      XNL.newInstanceField(codigo, "NL", SPANISH);
        /**/
        XNL.newInstanceField(nombre, "Netherlands", ENGLISH);
//      XNL.newInstanceField(nombre, "Países Bajos", SPANISH);
        /**/
//      XNL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Paises+Bajos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XNL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Paises+Bajos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XNO.newInstanceField(codigo, "NO", ENGLISH);
//      XNO.newInstanceField(codigo, "NO", SPANISH);
        /**/
        XNO.newInstanceField(nombre, "Norway", ENGLISH);
//      XNO.newInstanceField(nombre, "Noruega", SPANISH);
        /**/
//      XNO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Noruega\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XNO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Noruega\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XNP.newInstanceField(codigo, "NP", ENGLISH);
//      XNP.newInstanceField(codigo, "NP", SPANISH);
        /**/
        XNP.newInstanceField(nombre, "Nepal", ENGLISH);
//      XNP.newInstanceField(nombre, "Nepal", SPANISH);
        /**/
//      XNP.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Nepal\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XNP.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Nepal\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XNR.newInstanceField(codigo, "NR", ENGLISH);
//      XNR.newInstanceField(codigo, "NR", SPANISH);
        /**/
        XNR.newInstanceField(nombre, "Nauru", ENGLISH);
//      XNR.newInstanceField(nombre, "Nauru", SPANISH);
        /**/
//      XNR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Nauru\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XNR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Nauru\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XNU.newInstanceField(codigo, "WILDEBEEST", ENGLISH);
//      XNU.newInstanceField(codigo, "NU", SPANISH);
        /**/
        XNU.newInstanceField(nombre, "Niue", ENGLISH);
//      XNU.newInstanceField(nombre, "Niue", SPANISH);
        /**/
//      XNU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Niue\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XNU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Niue\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XNZ.newInstanceField(codigo, "NZ", ENGLISH);
//      XNZ.newInstanceField(codigo, "NZ", SPANISH);
        /**/
        XNZ.newInstanceField(nombre, "New Zealand", ENGLISH);
//      XNZ.newInstanceField(nombre, "Nueva Zelanda", SPANISH);
        /**/
//      XNZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Nueva+Zelanda\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XNZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Nueva+Zelanda\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XOM.newInstanceField(codigo, "OM", ENGLISH);
//      XOM.newInstanceField(codigo, "OM", SPANISH);
        /**/
        XOM.newInstanceField(nombre, "Oman", ENGLISH);
//      XOM.newInstanceField(nombre, "Omán", SPANISH);
        /**/
//      XOM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Oman\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XOM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Oman\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XPA.newInstanceField(codigo, "PA", ENGLISH);
//      XPA.newInstanceField(codigo, "PA", SPANISH);
        /**/
        XPA.newInstanceField(nombre, "Panama", ENGLISH);
//      XPA.newInstanceField(nombre, "Panamá", SPANISH);
        /**/
//      XPA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Panama\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XPA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Panama\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XPE.newInstanceField(codigo, "PE", ENGLISH);
//      XPE.newInstanceField(codigo, "PE", SPANISH);
        /**/
        XPE.newInstanceField(nombre, "Peru", ENGLISH);
//      XPE.newInstanceField(nombre, "Perú", SPANISH);
        /**/
//      XPE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Peru\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XPE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Peru\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XPF.newInstanceField(codigo, "PF", ENGLISH);
//      XPF.newInstanceField(codigo, "PF", SPANISH);
        /**/
        XPF.newInstanceField(nombre, "French Polynesia", ENGLISH);
//      XPF.newInstanceField(nombre, "Polinesia Francesa", SPANISH);
        /**/
//      XPF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Polinesia+Francesa\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XPF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Polinesia+Francesa\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XPG.newInstanceField(codigo, "P.G.", ENGLISH);
//      XPG.newInstanceField(codigo, "PG", SPANISH);
        /**/
        XPG.newInstanceField(nombre, "Papua New Guinea", ENGLISH);
//      XPG.newInstanceField(nombre, "Papúa Nueva Guinea", SPANISH);
        /**/
//      XPG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Papua+Nueva+Guinea\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XPG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Papua+Nueva+Guinea\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XPH.newInstanceField(codigo, "PH", ENGLISH);
//      XPH.newInstanceField(codigo, "PH", SPANISH);
        /**/
        XPH.newInstanceField(nombre, "Philippines", ENGLISH);
//      XPH.newInstanceField(nombre, "Filipinas", SPANISH);
        /**/
//      XPH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Filipinas\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XPH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Filipinas\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XPK.newInstanceField(codigo, "P.K.", ENGLISH);
//      XPK.newInstanceField(codigo, "PK", SPANISH);
        /**/
        XPK.newInstanceField(nombre, "Pakistan", ENGLISH);
//      XPK.newInstanceField(nombre, "Pakistán", SPANISH);
        /**/
//      XPK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Pakistan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XPK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Pakistan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XPL.newInstanceField(codigo, "P.L.", ENGLISH);
//      XPL.newInstanceField(codigo, "PL", SPANISH);
        /**/
        XPL.newInstanceField(nombre, "Poland", ENGLISH);
//      XPL.newInstanceField(nombre, "Polonia", SPANISH);
        /**/
//      XPL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Polonia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XPL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Polonia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XPM.newInstanceField(codigo, "P.M", ENGLISH);
//      XPM.newInstanceField(codigo, "PM", SPANISH);
        /**/
        XPM.newInstanceField(nombre, "Saint Pierre and Miquelon", ENGLISH);
//      XPM.newInstanceField(nombre, "San Pedro y Miquelón", SPANISH);
        /**/
//      XPM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=San+Pedro+y+Miquelon\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XPM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=San+Pedro+y+Miquelon\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XPN.newInstanceField(codigo, "P.N.", ENGLISH);
//      XPN.newInstanceField(codigo, "PN", SPANISH);
        /**/
        XPN.newInstanceField(nombre, "Pitcairn Islands", ENGLISH);
//      XPN.newInstanceField(nombre, "Islas Pitcairn", SPANISH);
        /**/
//      XPN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Pitcairn\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XPN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Pitcairn\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XPR.newInstanceField(codigo, "PR", ENGLISH);
//      XPR.newInstanceField(codigo, "PR", SPANISH);
        /**/
        XPR.newInstanceField(nombre, "Puerto Rico", ENGLISH);
//      XPR.newInstanceField(nombre, "Puerto Rico", SPANISH);
        /**/
//      XPR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Puerto+Rico\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XPR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Puerto+Rico\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XPS.newInstanceField(codigo, "P.S.", ENGLISH);
//      XPS.newInstanceField(codigo, "PS", SPANISH);
        /**/
        XPS.newInstanceField(nombre, "Palestine", ENGLISH);
//      XPS.newInstanceField(nombre, "Palestina", SPANISH);
        /**/
//      XPS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Palestina\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XPS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Palestina\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XPT.newInstanceField(codigo, "P.T.", ENGLISH);
//      XPT.newInstanceField(codigo, "PT", SPANISH);
        /**/
        XPT.newInstanceField(nombre, "Portugal", ENGLISH);
//      XPT.newInstanceField(nombre, "Portugal", SPANISH);
        /**/
//      XPT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Portugal\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XPT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Portugal\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XPW.newInstanceField(codigo, "P.W.", ENGLISH);
//      XPW.newInstanceField(codigo, "PW", SPANISH);
        /**/
        XPW.newInstanceField(nombre, "Palau", ENGLISH);
//      XPW.newInstanceField(nombre, "Palaos", SPANISH);
        /**/
//      XPW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Palaos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XPW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Palaos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XPY.newInstanceField(codigo, "P.Y.", ENGLISH);
//      XPY.newInstanceField(codigo, "PY", SPANISH);
        /**/
        XPY.newInstanceField(nombre, "Paraguay", ENGLISH);
//      XPY.newInstanceField(nombre, "Paraguay", SPANISH);
        /**/
//      XPY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Paraguay\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XPY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Paraguay\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XQA.newInstanceField(codigo, "QA", ENGLISH);
//      XQA.newInstanceField(codigo, "QA", SPANISH);
        /**/
        XQA.newInstanceField(nombre, "Taste", ENGLISH);
//      XQA.newInstanceField(nombre, "Catar", SPANISH);
        /**/
//      XQA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Catar\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XQA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Catar\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XRE.newInstanceField(codigo, "RE", ENGLISH);
//      XRE.newInstanceField(codigo, "RE", SPANISH);
        /**/
        XRE.newInstanceField(nombre, "Meeting", ENGLISH);
//      XRE.newInstanceField(nombre, "Reunión", SPANISH);
        /**/
//      XRE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Reunion\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XRE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Reunion\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XRO.newInstanceField(codigo, "R.O.", ENGLISH);
//      XRO.newInstanceField(codigo, "RO", SPANISH);
        /**/
        XRO.newInstanceField(nombre, "Romania", ENGLISH);
//      XRO.newInstanceField(nombre, "Rumania", SPANISH);
        /**/
//      XRO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Rumania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XRO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Rumania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XRS.newInstanceField(codigo, "R.S.", ENGLISH);
//      XRS.newInstanceField(codigo, "RS", SPANISH);
        /**/
        XRS.newInstanceField(nombre, "Serbia", ENGLISH);
//      XRS.newInstanceField(nombre, "Serbia", SPANISH);
        /**/
//      XRS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Serbia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XRS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Serbia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XRU.newInstanceField(codigo, "UK", ENGLISH);
//      XRU.newInstanceField(codigo, "RU", SPANISH);
        /**/
        XRU.newInstanceField(nombre, "Russia", ENGLISH);
//      XRU.newInstanceField(nombre, "Rusia", SPANISH);
        /**/
//      XRU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Rusia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XRU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Rusia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XRW.newInstanceField(codigo, "R.W.", ENGLISH);
//      XRW.newInstanceField(codigo, "RW", SPANISH);
        /**/
        XRW.newInstanceField(nombre, "Rwanda", ENGLISH);
//      XRW.newInstanceField(nombre, "Ruanda", SPANISH);
        /**/
//      XRW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Ruanda\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XRW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Ruanda\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSA.newInstanceField(codigo, "SA", ENGLISH);
//      XSA.newInstanceField(codigo, "SA", SPANISH);
        /**/
        XSA.newInstanceField(nombre, "Saudi Arabia", ENGLISH);
//      XSA.newInstanceField(nombre, "Arabia Saudita", SPANISH);
        /**/
//      XSA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Arabia+Saudita\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Arabia+Saudita\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSB.newInstanceField(codigo, "S.B.", ENGLISH);
//      XSB.newInstanceField(codigo, "SB", SPANISH);
        /**/
        XSB.newInstanceField(nombre, "Solomon Islands", ENGLISH);
//      XSB.newInstanceField(nombre, "Islas Salomón", SPANISH);
        /**/
//      XSB.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Salomon\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSB.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Salomon\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSC.newInstanceField(codigo, "S.C.", ENGLISH);
//      XSC.newInstanceField(codigo, "SC", SPANISH);
        /**/
        XSC.newInstanceField(nombre, "Seychelles", ENGLISH);
//      XSC.newInstanceField(nombre, "Seychelles", SPANISH);
        /**/
//      XSC.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Seychelles\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSC.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Seychelles\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSD.newInstanceField(codigo, "S.D.", ENGLISH);
//      XSD.newInstanceField(codigo, "SD", SPANISH);
        /**/
        XSD.newInstanceField(nombre, "Sudan", ENGLISH);
//      XSD.newInstanceField(nombre, "Sudán", SPANISH);
        /**/
//      XSD.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Sudan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSD.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Sudan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSE.newInstanceField(codigo, "HE", ENGLISH);
//      XSE.newInstanceField(codigo, "SE", SPANISH);
        /**/
        XSE.newInstanceField(nombre, "Sweden", ENGLISH);
//      XSE.newInstanceField(nombre, "Suecia", SPANISH);
        /**/
//      XSE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Suecia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Suecia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSG.newInstanceField(codigo, "S.G.", ENGLISH);
//      XSG.newInstanceField(codigo, "SG", SPANISH);
        /**/
        XSG.newInstanceField(nombre, "Singapore", ENGLISH);
//      XSG.newInstanceField(nombre, "Singapur", SPANISH);
        /**/
//      XSG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Singapur\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Singapur\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSH.newInstanceField(codigo, "SH", ENGLISH);
//      XSH.newInstanceField(codigo, "SH", SPANISH);
        /**/
        XSH.newInstanceField(nombre, "Saint Helena, Ascension and Tristan da Cunha", ENGLISH);
//      XSH.newInstanceField(nombre, "Santa Elena, Ascensión y Tristán de Acuña", SPANISH);
        /**/
//      XSH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=St+Helena%2C+Ascension+and+Tristan+da+Cunha\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=St+Helena%2C+Ascension+and+Tristan+da+Cunha\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSI.newInstanceField(codigo, "YEAH", ENGLISH);
//      XSI.newInstanceField(codigo, "SI", SPANISH);
        /**/
        XSI.newInstanceField(nombre, "Slovenia", ENGLISH);
//      XSI.newInstanceField(nombre, "Eslovenia", SPANISH);
        /**/
//      XSI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Eslovenia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Eslovenia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSJ.newInstanceField(codigo, "S.J.", ENGLISH);
//      XSJ.newInstanceField(codigo, "SJ", SPANISH);
        /**/
        XSJ.newInstanceField(nombre, "Svalbard and Jan Mayen", ENGLISH);
//      XSJ.newInstanceField(nombre, "Svalbard y Jan Mayen", SPANISH);
        /**/
//      XSJ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Svalbard+y+Jan+Mayen\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSJ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Svalbard+y+Jan+Mayen\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSK.newInstanceField(codigo, "SK", ENGLISH);
//      XSK.newInstanceField(codigo, "SK", SPANISH);
        /**/
        XSK.newInstanceField(nombre, "Slovakia", ENGLISH);
//      XSK.newInstanceField(nombre, "Eslovaquia", SPANISH);
        /**/
//      XSK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Eslovaquia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Eslovaquia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSL.newInstanceField(codigo, "SL", ENGLISH);
//      XSL.newInstanceField(codigo, "SL", SPANISH);
        /**/
        XSL.newInstanceField(nombre, "Sierra Leone", ENGLISH);
//      XSL.newInstanceField(nombre, "Sierra Leona", SPANISH);
        /**/
//      XSL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Sierra+Leona\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Sierra+Leona\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSM.newInstanceField(codigo, "YE", ENGLISH);
//      XSM.newInstanceField(codigo, "SM", SPANISH);
        /**/
        XSM.newInstanceField(nombre, "San Marino", ENGLISH);
//      XSM.newInstanceField(nombre, "San Marino", SPANISH);
        /**/
//      XSM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=San+Marino\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=San+Marino\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSN.newInstanceField(codigo, "S.N.", ENGLISH);
//      XSN.newInstanceField(codigo, "SN", SPANISH);
        /**/
        XSN.newInstanceField(nombre, "Senegal", ENGLISH);
//      XSN.newInstanceField(nombre, "Senegal", SPANISH);
        /**/
//      XSN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Senegal\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Senegal\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSO.newInstanceField(codigo, "SW", ENGLISH);
//      XSO.newInstanceField(codigo, "SO", SPANISH);
        /**/
        XSO.newInstanceField(nombre, "Somalia", ENGLISH);
//      XSO.newInstanceField(nombre, "Somalia", SPANISH);
        /**/
//      XSO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Somalia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Somalia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSR.newInstanceField(codigo, "MR", ENGLISH);
//      XSR.newInstanceField(codigo, "SR", SPANISH);
        /**/
        XSR.newInstanceField(nombre, "Surinam", ENGLISH);
//      XSR.newInstanceField(nombre, "Surinam", SPANISH);
        /**/
//      XSR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Surinam\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Surinam\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSS.newInstanceField(codigo, "H.H", ENGLISH);
//      XSS.newInstanceField(codigo, "SS", SPANISH);
        /**/
        XSS.newInstanceField(nombre, "South Sudan", ENGLISH);
//      XSS.newInstanceField(nombre, "Sudán del Sur", SPANISH);
        /**/
//      XSS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Sudan+del+Sur\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Sudan+del+Sur\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XST.newInstanceField(codigo, "S.T.", ENGLISH);
//      XST.newInstanceField(codigo, "ST", SPANISH);
        /**/
        XST.newInstanceField(nombre, "Sao Tome and Principe", ENGLISH);
//      XST.newInstanceField(nombre, "Santo Tomé y Príncipe", SPANISH);
        /**/
//      XST.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Santo+Tome+y+Principe\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XST.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Santo+Tome+y+Principe\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSV.newInstanceField(codigo, "S.V.", ENGLISH);
//      XSV.newInstanceField(codigo, "SV", SPANISH);
        /**/
        XSV.newInstanceField(nombre, "The Savior", ENGLISH);
//      XSV.newInstanceField(nombre, "El Salvador", SPANISH);
        /**/
//      XSV.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=El+Salvador\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSV.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=El+Salvador\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSX.newInstanceField(codigo, "SX", ENGLISH);
//      XSX.newInstanceField(codigo, "SX", SPANISH);
        /**/
        XSX.newInstanceField(nombre, "Saint Martin (Dutch part)", ENGLISH);
//      XSX.newInstanceField(nombre, "San Martín (parte holandesa)", SPANISH);
        /**/
//      XSX.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=St+Marteen\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSX.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=St+Marteen\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSY.newInstanceField(codigo, "S.Y.", ENGLISH);
//      XSY.newInstanceField(codigo, "SY", SPANISH);
        /**/
        XSY.newInstanceField(nombre, "Syria", ENGLISH);
//      XSY.newInstanceField(nombre, "Siria", SPANISH);
        /**/
//      XSY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Siria\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Siria\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XSZ.newInstanceField(codigo, "S.Z.", ENGLISH);
//      XSZ.newInstanceField(codigo, "SZ", SPANISH);
        /**/
        XSZ.newInstanceField(nombre, "Swaziland", ENGLISH);
//      XSZ.newInstanceField(nombre, "Suazilandia", SPANISH);
        /**/
//      XSZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Suazilandia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XSZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Suazilandia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XTC.newInstanceField(codigo, "T.C.", ENGLISH);
//      XTC.newInstanceField(codigo, "TC", SPANISH);
        /**/
        XTC.newInstanceField(nombre, "Turks and Caicos Islands", ENGLISH);
//      XTC.newInstanceField(nombre, "Islas Turcas y Caicos", SPANISH);
        /**/
//      XTC.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Turcas+y+Caicos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XTC.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Turcas+y+Caicos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XTD.newInstanceField(codigo, "T.D.", ENGLISH);
//      XTD.newInstanceField(codigo, "TD", SPANISH);
        /**/
        XTD.newInstanceField(nombre, "Chad", ENGLISH);
//      XTD.newInstanceField(nombre, "Chad", SPANISH);
        /**/
//      XTD.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Chad\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XTD.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Chad\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XTF.newInstanceField(codigo, "T.F.", ENGLISH);
//      XTF.newInstanceField(codigo, "TF", SPANISH);
        /**/
        XTF.newInstanceField(nombre, "French Southern and Antarctic Lands", ENGLISH);
//      XTF.newInstanceField(nombre, "Tierras Australes y Antárticas Francesas", SPANISH);
        /**/
//      XTF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Tierras+Australes+y+Antarticas+Francesas\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XTF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Tierras+Australes+y+Antarticas+Francesas\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XTG.newInstanceField(codigo, "T.G.", ENGLISH);
//      XTG.newInstanceField(codigo, "TG", SPANISH);
        /**/
        XTG.newInstanceField(nombre, "Togo", ENGLISH);
//      XTG.newInstanceField(nombre, "Togo", SPANISH);
        /**/
//      XTG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Togo\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XTG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Togo\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XTH.newInstanceField(codigo, "T.H.", ENGLISH);
//      XTH.newInstanceField(codigo, "TH", SPANISH);
        /**/
        XTH.newInstanceField(nombre, "Thailand", ENGLISH);
//      XTH.newInstanceField(nombre, "Tailandia", SPANISH);
        /**/
//      XTH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Tailandia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XTH.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Tailandia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XTJ.newInstanceField(codigo, "T.J.", ENGLISH);
//      XTJ.newInstanceField(codigo, "TJ", SPANISH);
        /**/
        XTJ.newInstanceField(nombre, "Tajikistan", ENGLISH);
//      XTJ.newInstanceField(nombre, "Tayikistán", SPANISH);
        /**/
//      XTJ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Tayikistan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XTJ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Tayikistan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XTK.newInstanceField(codigo, "T.K.", ENGLISH);
//      XTK.newInstanceField(codigo, "TK", SPANISH);
        /**/
        XTK.newInstanceField(nombre, "Tokelau", ENGLISH);
//      XTK.newInstanceField(nombre, "Tokelau", SPANISH);
        /**/
//      XTK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Tokelau\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XTK.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Tokelau\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XTL.newInstanceField(codigo, "T.L.", ENGLISH);
//      XTL.newInstanceField(codigo, "TL", SPANISH);
        /**/
        XTL.newInstanceField(nombre, "East Timor", ENGLISH);
//      XTL.newInstanceField(nombre, "Timor Oriental", SPANISH);
        /**/
//      XTL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Timor+Oriental\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XTL.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Timor+Oriental\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XTM.newInstanceField(codigo, "TM", ENGLISH);
//      XTM.newInstanceField(codigo, "TM", SPANISH);
        /**/
        XTM.newInstanceField(nombre, "Turkmenistan", ENGLISH);
//      XTM.newInstanceField(nombre, "Turkmenistán", SPANISH);
        /**/
//      XTM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Turkmenistan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XTM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Turkmenistan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XTN.newInstanceField(codigo, "TN", ENGLISH);
//      XTN.newInstanceField(codigo, "TN", SPANISH);
        /**/
        XTN.newInstanceField(nombre, "Tunisia", ENGLISH);
//      XTN.newInstanceField(nombre, "Túnez", SPANISH);
        /**/
//      XTN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Tunez\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XTN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Tunez\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XTO.newInstanceField(codigo, "TO", ENGLISH);
//      XTO.newInstanceField(codigo, "TO", SPANISH);
        /**/
        XTO.newInstanceField(nombre, "Tonga", ENGLISH);
//      XTO.newInstanceField(nombre, "Tonga", SPANISH);
        /**/
//      XTO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Tonga\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XTO.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Tonga\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XTR.newInstanceField(codigo, "TR", ENGLISH);
//      XTR.newInstanceField(codigo, "TR", SPANISH);
        /**/
        XTR.newInstanceField(nombre, "Türkiye", ENGLISH);
//      XTR.newInstanceField(nombre, "Turquía", SPANISH);
        /**/
//      XTR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Turquia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XTR.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Turquia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XTT.newInstanceField(codigo, "T.T.", ENGLISH);
//      XTT.newInstanceField(codigo, "TT", SPANISH);
        /**/
        XTT.newInstanceField(nombre, "Trinidad and Tobago", ENGLISH);
//      XTT.newInstanceField(nombre, "Trinidad y Tobago", SPANISH);
        /**/
//      XTT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Trinidad+y+Tobago\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XTT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Trinidad+y+Tobago\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XTV.newInstanceField(codigo, "TV", ENGLISH);
//      XTV.newInstanceField(codigo, "TV", SPANISH);
        /**/
        XTV.newInstanceField(nombre, "Tuvalu", ENGLISH);
//      XTV.newInstanceField(nombre, "Tuvalu", SPANISH);
        /**/
//      XTV.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Tuvalu\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XTV.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Tuvalu\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XTW.newInstanceField(codigo, "T.W.", ENGLISH);
//      XTW.newInstanceField(codigo, "TW", SPANISH);
        /**/
        XTW.newInstanceField(nombre, "Taiwan (Republic of China)", ENGLISH);
//      XTW.newInstanceField(nombre, "Taiwán (República de China)", SPANISH);
        /**/
//      XTW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Taiwan+%28Republica+de+China%29\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XTW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Taiwan+%28Republica+de+China%29\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XTZ.newInstanceField(codigo, "T.Z.", ENGLISH);
//      XTZ.newInstanceField(codigo, "TZ", SPANISH);
        /**/
        XTZ.newInstanceField(nombre, "Tanzania", ENGLISH);
//      XTZ.newInstanceField(nombre, "Tanzania", SPANISH);
        /**/
//      XTZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Tanzania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XTZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Tanzania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XUA.newInstanceField(codigo, "U.A.", ENGLISH);
//      XUA.newInstanceField(codigo, "UA", SPANISH);
        /**/
        XUA.newInstanceField(nombre, "Ukraine", ENGLISH);
//      XUA.newInstanceField(nombre, "Ucrania", SPANISH);
        /**/
//      XUA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Ucrania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XUA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Ucrania\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XUG.newInstanceField(codigo, "U.G.", ENGLISH);
//      XUG.newInstanceField(codigo, "UG", SPANISH);
        /**/
        XUG.newInstanceField(nombre, "Uganda", ENGLISH);
//      XUG.newInstanceField(nombre, "Uganda", SPANISH);
        /**/
//      XUG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Uganda\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XUG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Uganda\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XUM.newInstanceField(codigo, "UM", ENGLISH);
//      XUM.newInstanceField(codigo, "UM", SPANISH);
        /**/
        XUM.newInstanceField(nombre, "United States Minor Outlying Islands", ENGLISH);
//      XUM.newInstanceField(nombre, "Islas Ultramarinas Menores de los Estados Unidos", SPANISH);
        /**/
//      XUM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Ultramarinas+Menores+de+los+Estados+Unidos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XUM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Ultramarinas+Menores+de+los+Estados+Unidos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XUS.newInstanceField(codigo, "U.S.", ENGLISH);
//      XUS.newInstanceField(codigo, "US", SPANISH);
        /**/
        XUS.newInstanceField(nombre, "USA", ENGLISH);
//      XUS.newInstanceField(nombre, "Estados Unidos", SPANISH);
        /**/
//      XUS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Estados+Unidos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XUS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Estados+Unidos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XUY.newInstanceField(codigo, "Oops", ENGLISH);
//      XUY.newInstanceField(codigo, "UY", SPANISH);
        /**/
        XUY.newInstanceField(nombre, "Uruguay", ENGLISH);
//      XUY.newInstanceField(nombre, "Uruguay", SPANISH);
        /**/
//      XUY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Uruguay\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XUY.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Uruguay\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XUZ.newInstanceField(codigo, "U.Z.", ENGLISH);
//      XUZ.newInstanceField(codigo, "UZ", SPANISH);
        /**/
        XUZ.newInstanceField(nombre, "Uzbekistan", ENGLISH);
//      XUZ.newInstanceField(nombre, "Uzbekistán", SPANISH);
        /**/
//      XUZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Uzbekistan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XUZ.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Uzbekistan\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XVA.newInstanceField(codigo, "GOES", ENGLISH);
//      XVA.newInstanceField(codigo, "VA", SPANISH);
        /**/
        XVA.newInstanceField(nombre, "Vatican City", ENGLISH);
//      XVA.newInstanceField(nombre, "Ciudad del Vaticano", SPANISH);
        /**/
//      XVA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Ciudad+del+Vaticano\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XVA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Ciudad+del+Vaticano\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XVC.newInstanceField(codigo, "V.C.", ENGLISH);
//      XVC.newInstanceField(codigo, "VC", SPANISH);
        /**/
        XVC.newInstanceField(nombre, "St. Vincent and the Grenadines", ENGLISH);
//      XVC.newInstanceField(nombre, "San Vicente y las Granadinas", SPANISH);
        /**/
//      XVC.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=San+Vicente+y+las+Granadinas\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XVC.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=San+Vicente+y+las+Granadinas\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XVE.newInstanceField(codigo, "GO", ENGLISH);
//      XVE.newInstanceField(codigo, "VE", SPANISH);
        /**/
        XVE.newInstanceField(nombre, "Venezuela", ENGLISH);
//      XVE.newInstanceField(nombre, "Venezuela", SPANISH);
        /**/
//      XVE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Venezuela\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XVE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Venezuela\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XVG.newInstanceField(codigo, "V.G.", ENGLISH);
//      XVG.newInstanceField(codigo, "VG", SPANISH);
        /**/
        XVG.newInstanceField(nombre, "British Virgin Islands", ENGLISH);
//      XVG.newInstanceField(nombre, "Islas Vírgenes Británicas", SPANISH);
        /**/
//      XVG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Virgenes+Britanicas\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XVG.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Virgenes+Britanicas\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XVI.newInstanceField(codigo, "SAW", ENGLISH);
//      XVI.newInstanceField(codigo, "VI", SPANISH);
        /**/
        XVI.newInstanceField(nombre, "United States Virgin Islands", ENGLISH);
//      XVI.newInstanceField(nombre, "Islas Vírgenes de los Estados Unidos", SPANISH);
        /**/
//      XVI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Virgenes+de+los+Estados+Unidos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XVI.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Islas+Virgenes+de+los+Estados+Unidos\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XVN.newInstanceField(codigo, "VN", ENGLISH);
//      XVN.newInstanceField(codigo, "VN", SPANISH);
        /**/
        XVN.newInstanceField(nombre, "Vietnam", ENGLISH);
//      XVN.newInstanceField(nombre, "Vietnam", SPANISH);
        /**/
//      XVN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Vietnam\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XVN.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Vietnam\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XVU.newInstanceField(codigo, "VU", ENGLISH);
//      XVU.newInstanceField(codigo, "VU", SPANISH);
        /**/
        XVU.newInstanceField(nombre, "Vanuatu", ENGLISH);
//      XVU.newInstanceField(nombre, "Vanuatu", SPANISH);
        /**/
//      XVU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Vanuatu\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XVU.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Vanuatu\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XWF.newInstanceField(codigo, "W.F.", ENGLISH);
//      XWF.newInstanceField(codigo, "WF", SPANISH);
        /**/
        XWF.newInstanceField(nombre, "Wallis and Futuna", ENGLISH);
//      XWF.newInstanceField(nombre, "Wallis y Futuna", SPANISH);
        /**/
//      XWF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Wallis+y+Futuna\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XWF.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Wallis+y+Futuna\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XWS.newInstanceField(codigo, "W.S.", ENGLISH);
//      XWS.newInstanceField(codigo, "WS", SPANISH);
        /**/
        XWS.newInstanceField(nombre, "Samoa", ENGLISH);
//      XWS.newInstanceField(nombre, "Samoa", SPANISH);
        /**/
//      XWS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Samoa\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XWS.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Samoa\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XYE.newInstanceField(codigo, "Y.E.", ENGLISH);
//      XYE.newInstanceField(codigo, "YE", SPANISH);
        /**/
        XYE.newInstanceField(nombre, "Yemen", ENGLISH);
//      XYE.newInstanceField(nombre, "Yemen", SPANISH);
        /**/
//      XYE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Yemen\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XYE.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Yemen\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XYT.newInstanceField(codigo, "Y.T.", ENGLISH);
//      XYT.newInstanceField(codigo, "YT", SPANISH);
        /**/
        XYT.newInstanceField(nombre, "Mayotte", ENGLISH);
//      XYT.newInstanceField(nombre, "Mayotte", SPANISH);
        /**/
//      XYT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Mayotte\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XYT.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Mayotte\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XZA.newInstanceField(codigo, "ZA", ENGLISH);
//      XZA.newInstanceField(codigo, "ZA", SPANISH);
        /**/
        XZA.newInstanceField(nombre, "South Africa", ENGLISH);
//      XZA.newInstanceField(nombre, "Sudáfrica", SPANISH);
        /**/
//      XZA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Sudafrica\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XZA.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Sudafrica\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XZM.newInstanceField(codigo, "ZM", ENGLISH);
//      XZM.newInstanceField(codigo, "ZM", SPANISH);
        /**/
        XZM.newInstanceField(nombre, "Zambia", ENGLISH);
//      XZM.newInstanceField(nombre, "Zambia", SPANISH);
        /**/
//      XZM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Zambia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XZM.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Zambia\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        /**/
//      XZW.newInstanceField(codigo, "ZW", ENGLISH);
//      XZW.newInstanceField(codigo, "ZW", SPANISH);
        /**/
        XZW.newInstanceField(nombre, "Zimbabwe", ENGLISH);
//      XZW.newInstanceField(nombre, "Zimbabue", SPANISH);
        /**/
//      XZW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Zimbabue\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", ENGLISH);
//      XZW.newInstanceField(mapa, "<iframe src=\"https://www.google.com/maps/embed/v1/place?key=GOOGLE-MAPS-EMBED-API-KEY&q=Zimbabue\" width=\"640\" height=\"480\" allowfullscreen=\"true\" frameborder=\"0\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>", SPANISH);
        // </editor-fold>
    }

}
