/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.cuenta;

import adalid.core.annotations.*;
import adalid.core.enums.Kleenean;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;

@EntityCodeGen(gui = Kleenean.FALSE)
public class PrefijoCodigoUsuario extends PersistentEntityBase {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public PrefijoCodigoUsuario(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        /**/
        setDefaultLabel("prefijo de código de usuario");
        setDefaultShortLabel("prefijo");
        setDefaultCollectionLabel("Prefijos de Código de Usuario");
        setDefaultCollectionShortLabel("Prefijos");
        /**/
    }

    @BusinessKey
    public StringProperty codigo;

    @ColumnField(nullable = Kleenean.FALSE)
    public IntegerProperty secuencia;

    @Override
    protected void settleProperties() {
        super.settleProperties();
        /**/
        codigo.setDefaultLabel("código");
        codigo.setDefaultDescription("prefijo de código de usuario");
        /**/
        secuencia.setDefaultDescription("número de secuencia del último código que comienza con el prefijo");
        secuencia.setDefaultValue(1);
        /**/
    }

}
