/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.cuenta;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.parameters.*;
import adalid.core.parameters.ext.*;
import java.lang.reflect.Field;

@DiscriminatorValue("2")
@EntityInsertOperation(enabled = Kleenean.FALSE)
@EntityTableView(inserts = Kleenean.FALSE, updates = Kleenean.FALSE, menu = ViewMenuOption.NONE)
@EntityDetailView(enabled = Kleenean.TRUE)
@EntityConsoleView(enabled = Kleenean.TRUE, menu = Kleenean.FALSE)
public class SolicitudCambiarCorreoUsuario extends SolicitudCuentaUsuario {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public SolicitudCambiarCorreoUsuario(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
//      super.addAllocationStrings("fee", "faa", "foo");
    }

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of SolicitudCambiarCorreoUsuario's attributes">
        setLocalizedLabel(ENGLISH, "email change request");
        setLocalizedLabel(SPANISH, "solicitud de cambio de correo electrónico");
        setLocalizedShortLabel(SPANISH, "solicitud de cambio de correo");
        setLocalizedCollectionLabel(ENGLISH, "Email Change Requests");
        setLocalizedCollectionLabel(SPANISH, "Solicitudes de Cambio de Correo Electrónico");
        setLocalizedCollectionShortLabel(SPANISH, "Solicitudes de Cambio de Correo");
        // </editor-fold>
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of SolicitudCrearCuentaUsuario's properties">
        /**/
        usuario.setLocalizedDescription(ENGLISH, "application user to whom the email change request corresponds");
        usuario.setLocalizedDescription(SPANISH, "usuario de la aplicación al que corresponde la solicitud de cambio de correo electrónico");
        usuario.setLocalizedShortDescription(ENGLISH, "application user to whom the email change request corresponds");
        usuario.setLocalizedShortDescription(SPANISH, "usuario de la aplicación al que corresponde la solicitud de cambio de correo electrónico");
        /**/
        // </editor-fold>
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        /**/
        setDefaultLabel("solicitud de cambio de correo electrónico");
        setDefaultShortLabel("solicitud de cambio de correo");
        setDefaultCollectionLabel("Solicitudes de Cambio de Correo Electrónico");
        setDefaultCollectionShortLabel("Solicitudes de Cambio de Correo");
        /**/
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        /**/
        usuario.setDefaultDescription("usuario de la aplicación al que corresponde la solicitud de cambio de correo electrónico");
        usuario.setDefaultShortDescription("usuario de la aplicación al que corresponde la solicitud de cambio de correo electrónico");
        /**/
    }

//  http://localhost:8080/showcase102-web/faces/views/base/open/procesamiento/recursos/control/acceso/extra/SolicitudCambiarCorreoUsuario34.xhtml?id_funcion=-8302193829933745161
    protected Registrar registrar;

    @OperationClass(access = OperationAccess.PUBLIC)
    @ProcessOperationClass(serviceable = Kleenean.FALSE)
    @ConstructionOperationClass(type = SolicitudCambiarCorreoUsuario.class)
    public class Registrar extends ProcessOperation {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Registrar's attributes">
            setLocalizedLabel(ENGLISH, "request change of email");
            setLocalizedLabel(SPANISH, "solicitar cambio de correo");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Registrar's parameters">
            cedula.setLocalizedLabel(ENGLISH, "identification card");
            cedula.setLocalizedLabel(SPANISH, "cédula");
            cedula.setLocalizedRegexErrorMessage(ENGLISH, "ID card does not meet the specified pattern; must be a sequence of up to 9 digits, optionally ending with a letter; for example, 1234567, 1235813A");
            cedula.setLocalizedRegexErrorMessage(SPANISH, "cédula de identidad no cumple con el patrón especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            /**/
            fechaNacimiento.setLocalizedLabel(ENGLISH, "birthdate");
            fechaNacimiento.setLocalizedLabel(SPANISH, "fecha de nacimiento");
            /**/
            nombre.setLocalizedLabel(ENGLISH, "names and surnames");
            nombre.setLocalizedLabel(SPANISH, "nombres y apellidos");
            nombre.setLocalizedRegexErrorMessage(ENGLISH, "names and surnames does not comply with the specified pattern; can only contain letters, spaces, hyphens and single quotes");
            nombre.setLocalizedRegexErrorMessage(SPANISH, "nombres y apellidos no cumple con el patrón especificado; solo puede contener letras, espacios, guiones y comillas sencillas");
            /**/
            correoElectronico.setLocalizedLabel(ENGLISH, "email");
            correoElectronico.setLocalizedLabel(SPANISH, "correo electrónico");
            correoElectronico.setLocalizedRegexErrorMessage(ENGLISH, "email does not meet the specified pattern");
            correoElectronico.setLocalizedRegexErrorMessage(SPANISH, "correo electrónico no cumple con el patrón especificado");
            /**/
            confirmacionCorreoElectronico.setLocalizedLabel(ENGLISH, "email confirmation");
            confirmacionCorreoElectronico.setLocalizedLabel(SPANISH, "confirmación del correo");
            confirmacionCorreoElectronico.setLocalizedDescription(ENGLISH, "retype your email in this field");
            confirmacionCorreoElectronico.setLocalizedDescription(SPANISH, "escriba nuevamante su correo electrónico en este campo");
            confirmacionCorreoElectronico.setLocalizedRegexErrorMessage(ENGLISH, "confirmation email does not match the specified pattern");
            confirmacionCorreoElectronico.setLocalizedRegexErrorMessage(SPANISH, "confirmación del correo no cumple con el patrón especificado");
            /**/
            archivoCedula.setLocalizedLabel(ENGLISH, "image of the ID");
            archivoCedula.setLocalizedLabel(SPANISH, "imagen de la cédula");
            archivoCedula.setLocalizedDescription(ENGLISH, "File containing the image of the identity card; Its size should not exceed 1 MB.");
            archivoCedula.setLocalizedDescription(SPANISH, "Archivo que contiene la imagen de la cédula de identidad; su tamaño no debe superar 1 MB.");
            // </editor-fold>
        }

        @Override
        protected void localizeExpressions() {
            super.localizeExpressions();
            // <editor-fold defaultstate="collapsed" desc="localization of Registrar's expressions">
            check100.setLocalizedErrorMessage(ENGLISH, "the email domain is invalid; must be gmail.com, hotmail.com, outlook.com or yahoo.com");
            check100.setLocalizedErrorMessage(SPANISH, "el dominio del correo electrónico no es válido; debe ser gmail.com, hotmail.com, outlook.com o yahoo.com");
            /**/
            check110.setLocalizedErrorMessage(ENGLISH, "email and email confirmation are not the same");
            check110.setLocalizedErrorMessage(SPANISH, "el correo electrónico y la confirmación del correo no son iguales");
            // </editor-fold>
        }

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            setDefaultLabel("solicitar cambio de correo");
            setDefaultSuccessMessage("la solicitud fue registrada con éxito");
        }

        @ParameterField(required = Kleenean.TRUE, linkedField = "cedula")
        @StringField(maxLength = 10, regex = "^[0-9]{1,9}[A-Za-z]?$", letterCase = LetterCase.UPPER)
        protected StringParameter cedula;

        @ParameterField(required = Kleenean.TRUE, linkedField = "fechaNacimiento")
        @DateField(yearRange = 100)
        protected DateParameter fechaNacimiento;

        @ParameterField(required = Kleenean.TRUE, linkedField = "nombre")
        @StringField(maxLength = 100, regex = "^[\\p{IsLatin}][-' \\p{IsLatin}]*$", letterCase = LetterCase.UPPER)
        protected StringParameter nombre;

        /*
        @ParameterField(required = Kleenean.TRUE, linkedField = "correoElectronico")
        @StringField(maxLength = MAX_EMAIL_ADDRESS_LENGTH, regex = EMAIL_REGEX)
        protected StringParameter correoElectronico;

        @ParameterField(required = Kleenean.TRUE)
        @StringField(maxLength = MAX_EMAIL_ADDRESS_LENGTH, regex = EMAIL_REGEX)
        protected StringParameter confirmacionCorreoElectronico;

        /**/
        @ParameterField(required = Kleenean.TRUE, linkedField = "correoElectronico")
        protected EmailAddressParameter correoElectronico;

        @ParameterField(required = Kleenean.TRUE)
        protected EmailAddressParameter confirmacionCorreoElectronico;

        @ParameterField(required = Kleenean.TRUE, linkedField = "archivoCedula")
        @FileReference(types = MimeType.IMAGE, storage = UploadStorageOption.FILE, max = 1048576, virusScan = Kleenean.TRUE, pathTemplate = solicitud_cedula)
        protected StringParameter archivoCedula;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            /**/
            cedula.setDefaultLabel("cédula");
            cedula.setDefaultRegexErrorMessage("cédula de identidad no cumple con el patrón especificado;  "
                + "debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; "
                + "por ejemplo, 1234567, 1235813A");
            /**/
            fechaNacimiento.setDefaultLabel("fecha de nacimiento");
            fechaNacimiento.setInitialValue(cedula.isNull().then(NULL_TEMPORAL));
            fechaNacimiento.setMinValue(CURRENT_DATE.addYears(-100));
            fechaNacimiento.setMaxValue(CURRENT_DATE.addYears(-18));
            /**/
            nombre.setDefaultLabel("nombres y apellidos");
            nombre.setInitialValue(cedula.isNull().or(fechaNacimiento.isNull()).then(NULL_STRING));
            nombre.setDefaultRegexErrorMessage("nombres y apellidos no cumple con el patrón especificado; "
                + "solo puede contener letras, espacios, guiones y comillas sencillas");
            /**/
            correoElectronico.setDefaultLabel("correo electrónico");
            correoElectronico.setDefaultRegexErrorMessage("correo electrónico no cumple con el patrón especificado");
            /**/
            confirmacionCorreoElectronico.setDefaultLabel("confirmación del correo");
            confirmacionCorreoElectronico.setDefaultDescription("escriba nuevamante su correo electrónico en este campo");
            confirmacionCorreoElectronico.setDefaultRegexErrorMessage("confirmación del correo no cumple con el patrón especificado");
            /**/
            archivoCedula.setDefaultLabel("imagen de la cédula");
            archivoCedula.setDefaultDescription("Archivo que contiene la imagen de la cédula de identidad; su tamaño no debe superar 1 MB. ");
            /**/
        }

        protected Check check100, check110;

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            /**/
            check100 = or(
                correoElectronico.endsWith("@gmail.com"),
                correoElectronico.endsWith("@hotmail.com"),
                correoElectronico.endsWith("@outlook.com"),
                correoElectronico.endsWith("@yahoo.com")
            );
            check100.setDefaultErrorMessage("el dominio del correo electrónico no es válido; "
                + "debe ser gmail.com, hotmail.com, outlook.com o yahoo.com");
            /**/
            check110 = confirmacionCorreoElectronico.isEqualTo(correoElectronico);
            check110.setDefaultErrorMessage("el correo electrónico y la confirmación del correo no son iguales");
            /**/
        }

        @Override
        protected void settleFilters() {
            super.settleFilters();
            cedula.setModifyingFilter(archivoCedula.isNull());
            nombre.setModifyingFilter(UNTRUTH);
            archivoCedula.setModifyingFilter(cedula.isNotNull());
        }

    }

    protected Verificar verificar;

    @OperationClass(access = OperationAccess.PUBLIC)
    @ProcessOperationClass(serviceable = Kleenean.FALSE)
    public class Verificar extends ProcessOperation {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Verificar's attributes">
            setLocalizedLabel(ENGLISH, "verify email account");
            setLocalizedLabel(SPANISH, "verificar cuenta de correo");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Verificar's parameters">
            solicitud.setLocalizedLabel(ENGLISH, "application");
            /**/
            cedula.setLocalizedLabel(ENGLISH, "identification card");
            cedula.setLocalizedLabel(SPANISH, "cédula");
            cedula.setLocalizedRegexErrorMessage(ENGLISH, "ID card does not meet the specified pattern; must be a sequence of up to 9 digits, optionally ending with a letter; for example, 1234567, 1235813A");
            cedula.setLocalizedRegexErrorMessage(SPANISH, "cédula de identidad no cumple con el patrón especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            /**/
            fechaNacimiento.setLocalizedLabel(ENGLISH, "birthdate");
            fechaNacimiento.setLocalizedLabel(SPANISH, "fecha de nacimiento");
            // </editor-fold>
        }

        @Override
        protected void localizeExpressions() {
            super.localizeExpressions();
            // <editor-fold defaultstate="collapsed" desc="localization of Verificar's expressions">
            check100.setLocalizedErrorMessage(ENGLISH, "the ID is not the same as the applicant's ID");
            check100.setLocalizedErrorMessage(SPANISH, "la cédula no es igual a la cédula del solicitante");
            /**/
            check110.setLocalizedErrorMessage(ENGLISH, "the date of birth is not the same as the applicant's date of birth");
            check110.setLocalizedErrorMessage(SPANISH, "la fecha de nacimiento no es igual a la fecha de nacimiento del solicitante");
            // </editor-fold>
        }

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            setDefaultLabel("verificar cuenta de correo");
            setDefaultSuccessMessage("la cuenta de correo fue verificada con éxito");
        }

        @InstanceReference
        protected SolicitudCambiarCorreoUsuario solicitud;

        @ParameterField(required = Kleenean.TRUE, linkedField = "cedula")
        @StringField(maxLength = 10, regex = "^[0-9]{1,9}[A-Za-z]?$", letterCase = LetterCase.UPPER)
        protected StringParameter cedula;

        @ParameterField(required = Kleenean.TRUE, linkedField = "fechaNacimiento")
        @DateField(yearRange = 100)
        protected DateParameter fechaNacimiento;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            /**/
            solicitud.setDefaultLabel("solicitud");
            solicitud.condicion.setCurrentValue(solicitud.condicion.VERIFICADA);
            solicitud.fechaVerificada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
            /**/
            cedula.setDefaultLabel("cédula");
            cedula.setDefaultRegexErrorMessage("cédula de identidad no cumple con el patrón especificado;  "
                + "debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; "
                + "por ejemplo, 1234567, 1235813A");
            /**/
            fechaNacimiento.setDefaultLabel("fecha de nacimiento");
            fechaNacimiento.setInitialValue(cedula.isNull().then(NULL_TEMPORAL));
            fechaNacimiento.setMinValue(CURRENT_DATE.addYears(-100));
            fechaNacimiento.setMaxValue(CURRENT_DATE.addYears(-18));
            /**/
        }

        protected Check check100, check110;

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            /**/
            check100 = cedula.isEqualTo(solicitud.cedula);
            check100.setDefaultErrorMessage("la cédula no es igual a la cédula del solicitante");
            /**/
            check110 = fechaNacimiento.isEqualTo(solicitud.fechaNacimiento);
            check110.setDefaultErrorMessage("la fecha de nacimiento no es igual a la fecha de nacimiento del solicitante");
            /**/
        }

    }

    protected Anular anular;

    @OperationClass(access = OperationAccess.PRIVATE)
    @ProcessOperationClass(serviceable = Kleenean.FALSE)
    public class Anular extends ProcessOperation {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Anular's attributes">
            setLocalizedLabel(ENGLISH, "cancel request");
            setLocalizedLabel(SPANISH, "anular solicitud");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Anular's parameters">
            solicitud.setLocalizedLabel(ENGLISH, "application");
            // </editor-fold>
        }

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            setDefaultLabel("anular solicitud");
            setDefaultSuccessMessage("la solicitud fue anulada con éxito");
        }

        @InstanceReference
        protected SolicitudCambiarCorreoUsuario solicitud;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            solicitud.setDefaultLabel("solicitud");
            solicitud.condicion.setCurrentValue(solicitud.condicion.ANULADA);
            solicitud.fechaAnulada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
        }

    }

    protected Aprobar aprobar;

    @OperationClass(access = OperationAccess.RESTRICTED)
    @ProcessOperationClass(serviceable = Kleenean.FALSE)
    public class Aprobar extends ProcessOperation {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Aprobar's attributes">
            setLocalizedLabel(ENGLISH, "approve request");
            setLocalizedLabel(SPANISH, "aprobar solicitud");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Aprobar's parameters">
            solicitud.setLocalizedLabel(ENGLISH, "application");
            // </editor-fold>
        }

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            setDefaultLabel("aprobar solicitud");
            setDefaultSuccessMessage("la solicitud fue aprobada con éxito");
        }

        @InstanceReference
        protected SolicitudCambiarCorreoUsuario solicitud;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            solicitud.setDefaultLabel("solicitud");
            solicitud.condicion.setCurrentValue(solicitud.condicion.APROBADA);
            solicitud.fechaAprobada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
        }

    }

    protected Rechazar rechazar;

    @OperationClass(access = OperationAccess.RESTRICTED)
    @ProcessOperationClass(serviceable = Kleenean.FALSE)
    public class Rechazar extends ProcessOperation {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Rechazar's attributes">
            setLocalizedLabel(ENGLISH, "reject request");
            setLocalizedLabel(SPANISH, "rechazar solicitud");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Rechazar's parameters">
            solicitud.setLocalizedLabel(ENGLISH, "application");
            /**/
            observaciones.setLocalizedLabel(ENGLISH, "reason for rejection");
            observaciones.setLocalizedLabel(SPANISH, "motivo del rechazo");
            observaciones.setLocalizedDescription(ENGLISH, "Please describe in detail the reason why the application is being rejected.");
            observaciones.setLocalizedDescription(SPANISH, "Describa detalladamente el motivo por el cual se rechaza la solicitud");
            // </editor-fold>
        }

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            setDefaultLabel("rechazar solicitud");
            setDefaultSuccessMessage("la solicitud fue rechazada con éxito");
        }

        @InstanceReference
        protected SolicitudCambiarCorreoUsuario solicitud;

        @ParameterField(required = Kleenean.TRUE, linkedField = "observacionesUltimaTransicion")
        protected StringParameter observaciones;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            solicitud.setDefaultLabel("solicitud");
            solicitud.condicion.setCurrentValue(solicitud.condicion.RECHAZADA);
            solicitud.fechaRechazada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
            /**/
            observaciones.setDefaultLabel("motivo del rechazo");
            observaciones.setDefaultDescription("Describa detalladamente el motivo por el cual se rechaza la solicitud");
            /**/
        }

    }

    @Override
    protected void settleOperations() {
        super.settleOperations();
        /**/
        registrar.addTransition(null, registrada);
        verificar.addTransition(registrada, verificada);
        anular.addTransition(registrada, anulada);
        aprobar.addTransition(verificada, aprobada);
        rechazar.addTransition(verificada, rechazada);
        /**/
        verificar.addTriggerOn(registrada);
        aprobar.addTriggerOn(verificada);
        /**/
    }

}
