/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.cuenta;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.parameters.*;
import adalid.core.parameters.ext.*;
import adalid.core.properties.*;
import adalid.core.properties.ext.*;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.ModuloAplicacion;
import meta.entidad.comun.control.acceso.GrupoUsuario;
import meta.entidad.comun.control.acceso.Rol;

@DiscriminatorValue("1")
@EntityInsertOperation(enabled = Kleenean.FALSE)
@EntityTableView(inserts = Kleenean.FALSE, updates = Kleenean.FALSE, menu = ViewMenuOption.NONE)
@EntityDetailView(enabled = Kleenean.TRUE)
@EntityConsoleView(enabled = Kleenean.TRUE, menu = Kleenean.FALSE)
public class SolicitudCrearCuentaUsuario extends SolicitudCuentaUsuario {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public SolicitudCrearCuentaUsuario(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
//      super.addAllocationStrings("fee", "faa", "foo");
    }

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of SolicitudCrearCuentaUsuario's attributes">
        setLocalizedLabel(ENGLISH, "user account creation request");
        setLocalizedLabel(SPANISH, "solicitud de creación de cuenta de usuario");
        setLocalizedShortLabel(ENGLISH, "account creation request");
        setLocalizedShortLabel(SPANISH, "solicitud de creación de cuenta");
        setLocalizedCollectionLabel(ENGLISH, "User Account Creation Requests");
        setLocalizedCollectionLabel(SPANISH, "Solicitudes de Creación de Cuentas de Usuario");
        setLocalizedCollectionShortLabel(ENGLISH, "Account Creation Requests");
        setLocalizedCollectionShortLabel(SPANISH, "Solicitudes de Creación de Cuentas");
        // </editor-fold>
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of SolicitudCrearCuentaUsuario's properties">
        numeroTelefonoMovil.setLocalizedLabel(ENGLISH, "cell phone");
        numeroTelefonoMovil.setLocalizedLabel(SPANISH, "teléfono celular");
        numeroTelefonoMovil.setLocalizedDescription(ENGLISH, "cell phone number in international format");
        numeroTelefonoMovil.setLocalizedDescription(SPANISH, "número de teléfono celular en formato internacional");
        numeroTelefonoMovil.setLocalizedRegexErrorMessage(ENGLISH, "the phone number does not meet the required pattern; This must begin with a country code, i.e. a plus sign and a group of 1 to 3 digits, followed by a global subscriber number, i.e. a group of 7 to 14 digits; the country code and global subscriber number must be separated by a single blank or hyphen; The global subscriber number can be divided into area code, a group of 1 to 4 digits, and subscriber number, a group of 6 to 10 digits; the area code and subscriber number must be separated by a single blank space or hyphen; Whatever their distribution between the groups, the total number of digits must be between 8 and 15.");
        numeroTelefonoMovil.setLocalizedRegexErrorMessage(SPANISH, "el número de teléfono no cumple con el patrón requerido; éste debe comenzar con un código de país, es decir, un signo más y un grupo de 1 hasta 3 dígitos, seguido de un número de suscriptor global, es decir, un grupo de 7 hasta 14 dígitos; el código de país y el número de suscriptor global deben estar separados por un solo espacio en blanco o guión; el número de suscriptor global se puede dividir en código de área, un grupo de 1 hasta 4 dígitos, y número de suscriptor, un grupo de 6 a 10 dígitos; el código de área y el número de suscriptor deben estar separados por un solo espacio en blanco o guión; cualquiera que sea su distribución entre los grupos, el número total de dígitos debe estar entre 8 y 15.");
        /**/
        direccion.setLocalizedLabel(ENGLISH, "address");
        direccion.setLocalizedLabel(SPANISH, "dirección");
        /**/
        archivoSolicitud.setLocalizedLabel(ENGLISH, "application form");
        archivoSolicitud.setLocalizedLabel(SPANISH, "planilla de solicitud");
        archivoSolicitud.setLocalizedDescription(ENGLISH, "file containing the image of the application form");
        archivoSolicitud.setLocalizedDescription(SPANISH, "archivo que contiene la imagen de la planilla de solicitud");
        /**/
        usuario.setLocalizedDescription(ENGLISH, "application user created when approving the request");
        usuario.setLocalizedDescription(SPANISH, "usuario de la aplicación creado al aprobar la solicitud");
        usuario.setLocalizedShortDescription(ENGLISH, "application user created when approving the request");
        usuario.setLocalizedShortDescription(SPANISH, "usuario de la aplicación creado al aprobar la solicitud");
        /**/
        // </editor-fold>
    }

    @Override
    protected void localizeExpressions() {
        super.localizeExpressions();
        // <editor-fold defaultstate="collapsed" desc="localization of SolicitudCrearCuentaUsuario's expressions">
        activada.setLocalizedLabel(ENGLISH, "activated");
        activada.setLocalizedLabel(SPANISH, "activada");
        activada.setLocalizedDescription(ENGLISH, "activated");
        activada.setLocalizedErrorMessage(ENGLISH, "the request is not in state \"Activated\"");
        activada.setLocalizedErrorMessage(SPANISH, "la solicitud no se encuentra en estado \"Activada\"");
        // </editor-fold>
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        /**/
        setDefaultLabel("solicitud de creación de cuenta de usuario");
        setDefaultShortLabel("solicitud de creación de cuenta");
        setDefaultCollectionLabel("Solicitudes de Creación de Cuentas de Usuario");
        setDefaultCollectionShortLabel("Solicitudes de Creación de Cuentas");
        /**/
    }

    /*
    @ColumnField(nullable = Kleenean.TRUE)
    @StringField(maxLength = 20, regex = PHONE_REGEX, validator = PHONE_NUMBER_VALIDATOR)
    @PropertyField(create = Kleenean.TRUE, table = Kleenean.FALSE, anchor = "correoElectronico")
    public StringProperty numeroTelefonoMovil;

    /**/
    @ColumnField(nullable = Kleenean.TRUE)
    @PropertyField(create = Kleenean.TRUE, table = Kleenean.FALSE, anchor = "correoElectronico")
    public InternationalSmartphoneNumberProperty numeroTelefonoMovil;

    @StringField(maxLength = Constants.DEFAULT_STRING_FIELD_MAX_LENGTH)
    @PropertyField(create = Kleenean.TRUE, table = Kleenean.FALSE, anchor = "correoElectronico")
    public StringProperty direccion;

    @FileReference(types = MimeType.IMAGE, storage = UploadStorageOption.FILE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, anchor = "correoElectronico")
    public StringProperty archivoSolicitud;

    @Override
    protected void settleProperties() {
        super.settleProperties();
        /**/
        numeroTelefonoMovil.setDefaultLabel("teléfono celular");
        numeroTelefonoMovil.setDefaultDescription("número de teléfono celular en formato internacional");
        numeroTelefonoMovil.setDefaultRegexErrorMessage(PHONE_REGEX_SPANISH_ERROR_MESSAGE);
        /**/
        direccion.setDefaultLabel("dirección");
        /**/
        archivoSolicitud.setDefaultLabel("planilla de solicitud");
        archivoSolicitud.setDefaultDescription("archivo que contiene la imagen de la planilla de solicitud");
        /**/
        usuario.setDefaultDescription("usuario de la aplicación creado al aprobar la solicitud");
        usuario.setDefaultShortDescription("usuario de la aplicación creado al aprobar la solicitud");
        /**/
    }

    protected State activada;

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        /**/
        activada = condicion.isEqualTo(condicion.ACTIVADA);
        activada.setDefaultShortLabel("Activada");
        activada.setDefaultErrorMessage("la solicitud no se encuentra en estado \"Activada\"");
        activada.setTransitionDate(fechaActivada);
        /**/
        setHappyPath(registrada, verificada, aprobada, activada);
        setHappyPathDisplaySpots(HappyPathDisplaySpots.DETAIL_VIEW_AND_MASTER_HEADING);
        /**/
    }

//  http://localhost:8080/showcase102-web/faces/views/base/open/procesamiento/recursos/control/acceso/extra/SolicitudCrearCuentaUsuario34.xhtml?id_funcion=1760078673133416361
    protected Registrar registrar;

    @OperationClass(access = OperationAccess.PUBLIC)
    @ProcessOperationClass(serviceable = Kleenean.FALSE)
    @ConstructionOperationClass(type = SolicitudCrearCuentaUsuario.class)
    public class Registrar extends ProcessOperation {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Registrar's attributes">
            setLocalizedLabel(ENGLISH, "request account creation");
            setLocalizedLabel(SPANISH, "solicitar creación de cuenta");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Registrar's parameters">
            cedula.setLocalizedLabel(ENGLISH, "identification card");
            cedula.setLocalizedLabel(SPANISH, "cédula");
            cedula.setLocalizedRegexErrorMessage(ENGLISH, "ID card does not meet the specified pattern; must be a sequence of up to 9 digits, optionally ending with a letter; for example, 1234567, 1235813A");
            cedula.setLocalizedRegexErrorMessage(SPANISH, "cédula de identidad no cumple con el patrón especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            /**/
            fechaNacimiento.setLocalizedLabel(ENGLISH, "birthdate");
            fechaNacimiento.setLocalizedLabel(SPANISH, "fecha de nacimiento");
            /**/
            nombre.setLocalizedLabel(ENGLISH, "names and surnames");
            nombre.setLocalizedLabel(SPANISH, "nombres y apellidos");
            nombre.setLocalizedRegexErrorMessage(ENGLISH, "names and surnames does not comply with the specified pattern; can only contain letters, spaces, hyphens and single quotes");
            nombre.setLocalizedRegexErrorMessage(SPANISH, "nombres y apellidos no cumple con el patrón especificado; solo puede contener letras, espacios, guiones y comillas sencillas");
            /**/
            correoElectronico.setLocalizedLabel(ENGLISH, "email");
            correoElectronico.setLocalizedLabel(SPANISH, "correo electrónico");
            correoElectronico.setLocalizedRegexErrorMessage(ENGLISH, "email does not meet the specified pattern");
            correoElectronico.setLocalizedRegexErrorMessage(SPANISH, "correo electrónico no cumple con el patrón especificado");
            /**/
            confirmacionCorreoElectronico.setLocalizedLabel(ENGLISH, "email confirmation");
            confirmacionCorreoElectronico.setLocalizedLabel(SPANISH, "confirmación del correo");
            confirmacionCorreoElectronico.setLocalizedDescription(ENGLISH, "retype your email in this field");
            confirmacionCorreoElectronico.setLocalizedDescription(SPANISH, "escriba nuevamante su correo electrónico en este campo");
            confirmacionCorreoElectronico.setLocalizedRegexErrorMessage(ENGLISH, "confirmation email does not match the specified pattern");
            confirmacionCorreoElectronico.setLocalizedRegexErrorMessage(SPANISH, "confirmación del correo no cumple con el patrón especificado");
            /**/
            numeroTelefonoMovil.setLocalizedLabel(ENGLISH, "cell phone");
            numeroTelefonoMovil.setLocalizedLabel(SPANISH, "teléfono celular");
            numeroTelefonoMovil.setLocalizedDescription(ENGLISH, "cellphone number; this is an international phone number; must begin with a country code, followed by a global subscriber number or an area code and a subscriber number; for example: +58 4121234567, +58-412-1234567");
            numeroTelefonoMovil.setLocalizedDescription(SPANISH, "número de teléfono celular; este es un número de teléfono internacional; debe comenzar con un código de país, seguido de un número de suscriptor global o un código de área y un número de suscriptor; por ejemplo: +58 4121234567, +58-412-1234567");
            numeroTelefonoMovil.setLocalizedRegexErrorMessage(ENGLISH, "the phone number does not meet the required pattern; This must begin with a country code, i.e. a plus sign and a group of 1 to 3 digits, followed by a global subscriber number, i.e. a group of 7 to 14 digits; the country code and global subscriber number must be separated by a single blank or hyphen; The global subscriber number can be divided into area code, a group of 1 to 4 digits, and subscriber number, a group of 6 to 10 digits; the area code and subscriber number must be separated by a single blank space or hyphen; Whatever their distribution between the groups, the total number of digits must be between 8 and 15.");
            numeroTelefonoMovil.setLocalizedRegexErrorMessage(SPANISH, "el número de teléfono no cumple con el patrón requerido; éste debe comenzar con un código de país, es decir, un signo más y un grupo de 1 hasta 3 dígitos, seguido de un número de suscriptor global, es decir, un grupo de 7 hasta 14 dígitos; el código de país y el número de suscriptor global deben estar separados por un solo espacio en blanco o guión; el número de suscriptor global se puede dividir en código de área, un grupo de 1 hasta 4 dígitos, y número de suscriptor, un grupo de 6 a 10 dígitos; el código de área y el número de suscriptor deben estar separados por un solo espacio en blanco o guión; cualquiera que sea su distribución entre los grupos, el número total de dígitos debe estar entre 8 y 15.");
            /**/
            direccion.setLocalizedLabel(ENGLISH, "address");
            direccion.setLocalizedLabel(SPANISH, "dirección");
            /**/
            archivoSolicitud.setLocalizedLabel(ENGLISH, "application form");
            archivoSolicitud.setLocalizedLabel(SPANISH, "planilla de solicitud");
            archivoSolicitud.setLocalizedDescription(ENGLISH, "File that contains the image of the application form, signed by the user; Its size should not exceed 1 MB.");
            archivoSolicitud.setLocalizedDescription(SPANISH, "Archivo que contiene la imagen de la planilla de solicitud, firmada por el usuario; su tamaño no debe superar 1 MB.");
            /**/
            archivoCedula.setLocalizedLabel(ENGLISH, "image of the ID");
            archivoCedula.setLocalizedLabel(SPANISH, "imagen de la cédula");
            archivoCedula.setLocalizedDescription(ENGLISH, "File containing the image of the identity card; Its size should not exceed 1 MB.");
            archivoCedula.setLocalizedDescription(SPANISH, "Archivo que contiene la imagen de la cédula de identidad; su tamaño no debe superar 1 MB.");
            // </editor-fold>
        }

        @Override
        protected void localizeExpressions() {
            super.localizeExpressions();
            // <editor-fold defaultstate="collapsed" desc="localization of Registrar's expressions">
            check100.setLocalizedErrorMessage(ENGLISH, "the email domain is invalid; must be gmail.com, hotmail.com, outlook.com or yahoo.com");
            check100.setLocalizedErrorMessage(SPANISH, "el dominio del correo electrónico no es válido; debe ser gmail.com, hotmail.com, outlook.com o yahoo.com");
            /**/
            check110.setLocalizedErrorMessage(ENGLISH, "email and email confirmation are not the same");
            check110.setLocalizedErrorMessage(SPANISH, "el correo electrónico y la confirmación del correo no son iguales");
            // </editor-fold>
        }

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            setDefaultLabel("solicitar creación de cuenta");
            setDefaultSuccessMessage("la solicitud fue registrada con éxito");
        }

        @ParameterField(required = Kleenean.TRUE, linkedField = "cedula")
        @StringField(maxLength = 10, regex = "^[0-9]{1,9}[A-Za-z]?$", letterCase = LetterCase.UPPER)
        protected StringParameter cedula;

        @ParameterField(required = Kleenean.TRUE, linkedField = "fechaNacimiento")
        @DateField(yearRange = 100)
        protected DateParameter fechaNacimiento;

        @ParameterField(required = Kleenean.TRUE, linkedField = "nombre")
        @StringField(maxLength = 100, regex = "^[\\p{IsLatin}][-' \\p{IsLatin}]*$", letterCase = LetterCase.UPPER)
        protected StringParameter nombre;

        /*
        @ParameterField(required = Kleenean.TRUE, linkedField = "correoElectronico")
        @StringField(maxLength = MAX_EMAIL_ADDRESS_LENGTH, regex = EMAIL_REGEX)
        protected StringParameter correoElectronico;

        @ParameterField(required = Kleenean.TRUE)
        @StringField(maxLength = MAX_EMAIL_ADDRESS_LENGTH, regex = EMAIL_REGEX)
        protected StringParameter confirmacionCorreoElectronico;

        @ParameterField(required = Kleenean.FALSE, linkedField = "numeroTelefonoMovil")
        @StringField(maxLength = 20, regex = PHONE_REGEX, validator = PHONE_NUMBER_VALIDATOR)
        protected StringParameter numeroTelefonoMovil;

        /**/
        @ParameterField(required = Kleenean.TRUE, linkedField = "correoElectronico")
        protected EmailAddressParameter correoElectronico;

        @ParameterField(required = Kleenean.TRUE)
        protected EmailAddressParameter confirmacionCorreoElectronico;

        @ParameterField(required = Kleenean.FALSE, linkedField = "numeroTelefonoMovil")
        protected InternationalSmartphoneNumberParameter numeroTelefonoMovil;

        @ParameterField(required = Kleenean.TRUE, linkedField = "direccion")
        @StringField(maxLength = Constants.DEFAULT_STRING_FIELD_MAX_LENGTH)
        protected StringParameter direccion;

        @ParameterField(required = Kleenean.TRUE, linkedField = "archivoSolicitud")
        @FileReference(types = MimeType.IMAGE, storage = UploadStorageOption.FILE, max = 1048576, virusScan = Kleenean.TRUE, pathTemplate = solicitud_cedula)
        protected StringParameter archivoSolicitud;

        @ParameterField(required = Kleenean.TRUE, linkedField = "archivoCedula")
        @FileReference(types = MimeType.IMAGE, storage = UploadStorageOption.FILE, max = 1048576, virusScan = Kleenean.TRUE, pathTemplate = solicitud_cedula)
        protected StringParameter archivoCedula;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            /**/
            cedula.setDefaultLabel("cédula");
            cedula.setDefaultRegexErrorMessage("cédula de identidad no cumple con el patrón especificado;  "
                + "debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; "
                + "por ejemplo, 1234567, 1235813A");
            /**/
            fechaNacimiento.setDefaultLabel("fecha de nacimiento");
            fechaNacimiento.setInitialValue(cedula.isNull().then(NULL_TEMPORAL));
            fechaNacimiento.setMinValue(CURRENT_DATE.addYears(-100));
            fechaNacimiento.setMaxValue(CURRENT_DATE.addYears(-18));
            /**/
            nombre.setDefaultLabel("nombres y apellidos");
            nombre.setInitialValue(cedula.isNull().or(fechaNacimiento.isNull()).then(NULL_STRING));
            nombre.setDefaultRegexErrorMessage("nombres y apellidos no cumple con el patrón especificado; "
                + "solo puede contener letras, espacios, guiones y comillas sencillas");
            /**/
            correoElectronico.setDefaultLabel("correo electrónico");
            correoElectronico.setDefaultRegexErrorMessage("correo electrónico no cumple con el patrón especificado");
            /**/
            confirmacionCorreoElectronico.setDefaultLabel("confirmación del correo");
            confirmacionCorreoElectronico.setDefaultDescription("escriba nuevamante su correo electrónico en este campo");
            confirmacionCorreoElectronico.setDefaultRegexErrorMessage("confirmación del correo no cumple con el patrón especificado");
            /**/
            numeroTelefonoMovil.setDefaultLabel("teléfono celular");
            numeroTelefonoMovil.setDefaultDescription("número de teléfono celular; " + PHONE_REGEX_SPANISH_DESCRIPTION);
            numeroTelefonoMovil.setDefaultRegexErrorMessage(PHONE_REGEX_SPANISH_ERROR_MESSAGE);
            /**/
            direccion.setDefaultLabel("dirección");
            /**/
            archivoSolicitud.setDefaultLabel("planilla de solicitud");
            archivoSolicitud.setDefaultDescription("Archivo que contiene la imagen de la planilla de solicitud, firmada por el usuario; su tamaño no debe superar 1 MB. ");
            /**/
            archivoCedula.setDefaultLabel("imagen de la cédula");
            archivoCedula.setDefaultDescription("Archivo que contiene la imagen de la cédula de identidad; su tamaño no debe superar 1 MB. ");
            /**/
        }

        protected Check check100, check110;

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            /**/
            check100 = or(
                correoElectronico.endsWith("@gmail.com"),
                correoElectronico.endsWith("@hotmail.com"),
                correoElectronico.endsWith("@outlook.com"),
                correoElectronico.endsWith("@yahoo.com")
            );
            check100.setDefaultErrorMessage("el dominio del correo electrónico no es válido; "
                + "debe ser gmail.com, hotmail.com, outlook.com o yahoo.com");
            /**/
            check110 = confirmacionCorreoElectronico.isEqualTo(correoElectronico);
            check110.setDefaultErrorMessage("el correo electrónico y la confirmación del correo no son iguales");
            /**/
        }

        @Override
        protected void settleFilters() {
            super.settleFilters();
            cedula.setModifyingFilter(archivoSolicitud.isNull().and(archivoCedula.isNull()));
            nombre.setModifyingFilter(UNTRUTH);
            archivoSolicitud.setModifyingFilter(cedula.isNotNull());
            archivoCedula.setModifyingFilter(cedula.isNotNull());
        }

    }

    protected Verificar verificar;

    @OperationClass(access = OperationAccess.PUBLIC)
    @ProcessOperationClass(serviceable = Kleenean.FALSE)
    public class Verificar extends ProcessOperation {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Verificar's attributes">
            setLocalizedLabel(ENGLISH, "verify email account");
            setLocalizedLabel(SPANISH, "verificar cuenta de correo");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Verificar's parameters">
            solicitud.setLocalizedLabel(ENGLISH, "application");
            /**/
            cedula.setLocalizedLabel(ENGLISH, "identification card");
            cedula.setLocalizedLabel(SPANISH, "cédula");
            cedula.setLocalizedRegexErrorMessage(ENGLISH, "ID card does not meet the specified pattern; must be a sequence of up to 9 digits, optionally ending with a letter; for example, 1234567, 1235813A");
            cedula.setLocalizedRegexErrorMessage(SPANISH, "cédula de identidad no cumple con el patrón especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            /**/
            fechaNacimiento.setLocalizedLabel(ENGLISH, "birthdate");
            fechaNacimiento.setLocalizedLabel(SPANISH, "fecha de nacimiento");
            // </editor-fold>
        }

        @Override
        protected void localizeExpressions() {
            super.localizeExpressions();
            // <editor-fold defaultstate="collapsed" desc="localization of Verificar's expressions">
            check100.setLocalizedErrorMessage(ENGLISH, "the ID is not the same as the applicant's ID");
            check100.setLocalizedErrorMessage(SPANISH, "la cédula no es igual a la cédula del solicitante");
            /**/
            check110.setLocalizedErrorMessage(ENGLISH, "the date of birth is not the same as the applicant's date of birth");
            check110.setLocalizedErrorMessage(SPANISH, "la fecha de nacimiento no es igual a la fecha de nacimiento del solicitante");
            // </editor-fold>
        }

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            setDefaultLabel("verificar cuenta de correo");
            setDefaultSuccessMessage("la cuenta de correo fue verificada con éxito");
        }

        @InstanceReference
        protected SolicitudCrearCuentaUsuario solicitud;

        @ParameterField(required = Kleenean.TRUE, linkedField = "cedula")
        @StringField(maxLength = 10, regex = "^[0-9]{1,9}[A-Za-z]?$", letterCase = LetterCase.UPPER)
        protected StringParameter cedula;

        @ParameterField(required = Kleenean.TRUE, linkedField = "fechaNacimiento")
        @DateField(yearRange = 100)
        protected DateParameter fechaNacimiento;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            /**/
            solicitud.setDefaultLabel("solicitud");
            solicitud.condicion.setCurrentValue(solicitud.condicion.VERIFICADA);
            solicitud.fechaVerificada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
            /**/
            cedula.setDefaultLabel("cédula");
            cedula.setDefaultRegexErrorMessage("cédula de identidad no cumple con el patrón especificado;  "
                + "debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; "
                + "por ejemplo, 1234567, 1235813A");
            /**/
            fechaNacimiento.setDefaultLabel("fecha de nacimiento");
            fechaNacimiento.setInitialValue(cedula.isNull().then(NULL_TEMPORAL));
            fechaNacimiento.setMinValue(CURRENT_DATE.addYears(-100));
            fechaNacimiento.setMaxValue(CURRENT_DATE.addYears(-18));
            /**/
        }

        protected Check check100, check110;

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            /**/
            check100 = cedula.isEqualTo(solicitud.cedula);
            check100.setDefaultErrorMessage("la cédula no es igual a la cédula del solicitante");
            /**/
            check110 = fechaNacimiento.isEqualTo(solicitud.fechaNacimiento);
            check110.setDefaultErrorMessage("la fecha de nacimiento no es igual a la fecha de nacimiento del solicitante");
            /**/
        }

    }

    protected Anular anular;

    @OperationClass(access = OperationAccess.PRIVATE)
    @ProcessOperationClass(serviceable = Kleenean.FALSE)
    public class Anular extends ProcessOperation {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Anular's attributes">
            setLocalizedLabel(ENGLISH, "cancel request");
            setLocalizedLabel(SPANISH, "anular solicitud");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Anular's parameters">
            solicitud.setLocalizedLabel(ENGLISH, "application");
            // </editor-fold>
        }

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            setDefaultLabel("anular solicitud");
            setDefaultSuccessMessage("la solicitud fue anulada con éxito");
        }

        @InstanceReference
        protected SolicitudCrearCuentaUsuario solicitud;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            solicitud.setDefaultLabel("solicitud");
            solicitud.condicion.setCurrentValue(solicitud.condicion.ANULADA);
            solicitud.fechaAnulada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
        }

    }

    protected Aprobar aprobar;

    @OperationClass(access = OperationAccess.RESTRICTED, complex = Kleenean.TRUE)
    @ProcessOperationClass(serviceable = Kleenean.FALSE)
    @ConstructionOperationClass(type = Usuario.class, onsuccess = OnConstructionOperationSuccess.DISPLAY_NEW_INSTANCE)
    public class Aprobar extends ProcessOperation {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Aprobar's attributes">
            setLocalizedLabel(ENGLISH, "approve request");
            setLocalizedLabel(SPANISH, "aprobar solicitud");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Aprobar's parameters">
            solicitud.setLocalizedLabel(ENGLISH, "application");
            /**/
            codigoUsuario.setLocalizedLabel(ENGLISH, "user code");
            /**/
            grupo.setLocalizedLabel(ENGLISH, "user group");
            grupo.setLocalizedLabel(SPANISH, "grupo de usuarios");
            /**/
            rol.setLocalizedLabel(ENGLISH, "role");
            rol.setLocalizedDescription(ENGLISH, "application role");
            rol.setLocalizedDescription(SPANISH, "rol de la aplicación");
            /**/
            modulo.setLocalizedLabel(ENGLISH, "module");
            modulo.setLocalizedLabel(SPANISH, "módulo");
            // </editor-fold>
        }

        @Override
        protected void localizeExpressions() {
            super.localizeExpressions();
            // <editor-fold defaultstate="collapsed" desc="localization of Aprobar's expressions">
            check111.setLocalizedErrorMessage(ENGLISH, "the role cannot be an inactive role");
            check111.setLocalizedErrorMessage(SPANISH, "el rol no puede ser un rol inactivo");
            /**/
            check112.setLocalizedErrorMessage(ENGLISH, "the role cannot be a super role");
            check112.setLocalizedErrorMessage(SPANISH, "el rol no puede ser un súper-rol");
            /**/
            query113.setLocalizedErrorMessage(ENGLISH, "the role cannot be an inactive role or a super role");
            query113.setLocalizedErrorMessage(SPANISH, "el rol no puede ser un rol inactivo ni un súper-rol");
            // </editor-fold>
        }

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            setDefaultLabel("aprobar solicitud");
            setDefaultSuccessMessage("la solicitud fue aprobada con éxito");
        }

        @InstanceReference
        protected SolicitudCrearCuentaUsuario solicitud;

        @ParameterField(required = Kleenean.FALSE)
        @StringField(maxLength = MAX_EMAIL_ADDRESS_LENGTH) // maxLength = 36 until 01/12/2023
        protected StringParameter codigoUsuario;

        @ParameterField(required = Kleenean.FALSE)
        protected GrupoUsuario grupo;

        @ParameterField(required = Kleenean.FALSE)
        protected Rol rol;

        @ParameterField(required = Kleenean.FALSE)
        protected ModuloAplicacion modulo;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            solicitud.setDefaultLabel("solicitud");
            solicitud.condicion.setCurrentValue(solicitud.condicion.APROBADA);
            solicitud.fechaAprobada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
            /**/
            codigoUsuario.setDefaultValue(solicitud.cedula);
            codigoUsuario.setInitialValue(solicitud.cedula);
            /**/
        }

        protected Check check111, check112;

        protected BooleanExpression query113;

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            /**/
            check111 = rol.isNull().or(rol.esRolInactivo.isFalse());
            check111.setDefaultErrorMessage("el rol no puede ser un rol inactivo");
            /**/
            check112 = rol.isNull().or(rol.esSuperRol.isFalse());
            check112.setDefaultErrorMessage("el rol no puede ser un súper-rol");
            /**/
            query113 = rol.esRolInactivo.isFalse().and(rol.esSuperRol.isFalse());
            query113.setDefaultErrorMessage("el rol no puede ser un rol inactivo ni un súper-rol");
            /**/
        }

        @Override
        protected void settleFilters() {
            super.settleFilters();
            /**/
            codigoUsuario.setModifyingFilter(UNTRUTH);
            /**/
            rol.setSearchQueryFilter(query113);
            /**/
        }

    }

    protected Rechazar rechazar;

    @OperationClass(access = OperationAccess.RESTRICTED)
    @ProcessOperationClass(serviceable = Kleenean.FALSE)
    public class Rechazar extends ProcessOperation {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Rechazar's attributes">
            setLocalizedLabel(ENGLISH, "reject request");
            setLocalizedLabel(SPANISH, "rechazar solicitud");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Rechazar's parameters">
            solicitud.setLocalizedLabel(ENGLISH, "application");
            /**/
            observaciones.setLocalizedLabel(ENGLISH, "reason for rejection");
            observaciones.setLocalizedLabel(SPANISH, "motivo del rechazo");
            observaciones.setLocalizedDescription(ENGLISH, "Please describe in detail the reason why the application is being rejected.");
            observaciones.setLocalizedDescription(SPANISH, "Describa detalladamente el motivo por el cual se rechaza la solicitud");
            // </editor-fold>
        }

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            setDefaultLabel("rechazar solicitud");
            setDefaultSuccessMessage("la solicitud fue rechazada con éxito");
        }

        @InstanceReference
        protected SolicitudCrearCuentaUsuario solicitud;

        @ParameterField(required = Kleenean.TRUE, linkedField = "observacionesUltimaTransicion")
        protected StringParameter observaciones;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            solicitud.setDefaultLabel("solicitud");
            solicitud.condicion.setCurrentValue(solicitud.condicion.RECHAZADA);
            solicitud.fechaRechazada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
            /**/
            observaciones.setDefaultLabel("motivo del rechazo");
            observaciones.setDefaultDescription("Describa detalladamente el motivo por el cual se rechaza la solicitud");
            /**/
        }

    }

    protected Activar activar;

    @OperationClass(access = OperationAccess.PUBLIC)
    @ProcessOperationClass(serviceable = Kleenean.FALSE)
    public class Activar extends ProcessOperation {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Activar's attributes">
            setLocalizedLabel(ENGLISH, "activate account");
            setLocalizedLabel(SPANISH, "activar cuenta");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Activar's parameters">
            solicitud.setLocalizedLabel(ENGLISH, "application");
            /**/
            cedula.setLocalizedLabel(ENGLISH, "identification card");
            cedula.setLocalizedLabel(SPANISH, "cédula");
            cedula.setLocalizedRegexErrorMessage(ENGLISH, "ID card does not meet the specified pattern; must be a sequence of up to 9 digits, optionally ending with a letter; for example, 1234567, 1235813A");
            cedula.setLocalizedRegexErrorMessage(SPANISH, "cédula de identidad no cumple con el patrón especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            /**/
            fechaNacimiento.setLocalizedLabel(ENGLISH, "birthdate");
            fechaNacimiento.setLocalizedLabel(SPANISH, "fecha de nacimiento");
            /**/
            password.setLocalizedLabel(ENGLISH, "password");
            password.setLocalizedLabel(SPANISH, "contraseña");
            password.setLocalizedDescription(ENGLISH, "The password must be a sequence of up to 128 letters, numbers and other characters");
            password.setLocalizedDescription(SPANISH, "La contraseña debe ser una secuencia de hasta 128 letras, números y otros caracteres");
            /**/
            confirmacionPassword.setLocalizedLabel(ENGLISH, "password confirmation");
            confirmacionPassword.setLocalizedLabel(SPANISH, "confirmación de la contraseña");
            confirmacionPassword.setLocalizedDescription(ENGLISH, "Retype the password in this field");
            confirmacionPassword.setLocalizedDescription(SPANISH, "Escriba nuevamante la contraseña en este campo");
            // </editor-fold>
        }

        @Override
        protected void localizeExpressions() {
            super.localizeExpressions();
            // <editor-fold defaultstate="collapsed" desc="localization of Activar's expressions">
            check100.setLocalizedErrorMessage(ENGLISH, "the ID is not the same as the applicant's ID");
            check100.setLocalizedErrorMessage(SPANISH, "la cédula no es igual a la cédula del solicitante");
            /**/
            check110.setLocalizedErrorMessage(ENGLISH, "the date of birth is not the same as the applicant's date of birth");
            check110.setLocalizedErrorMessage(SPANISH, "la fecha de nacimiento no es igual a la fecha de nacimiento del solicitante");
            /**/
            check120.setLocalizedErrorMessage(ENGLISH, "password and password confirmation are not the same");
            check120.setLocalizedErrorMessage(SPANISH, "la contraseña y la confirmación de la contraseña no son iguales");
            // </editor-fold>
        }

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            setDefaultLabel("activar cuenta");
            setDefaultSuccessMessage("la cuenta fue activada con éxito");
        }

        @InstanceReference
        protected SolicitudCrearCuentaUsuario solicitud;

        @ParameterField(required = Kleenean.TRUE, linkedField = "cedula")
        @StringField(maxLength = 10, regex = "^[0-9]{1,9}[A-Za-z]?$", letterCase = LetterCase.UPPER)
        protected StringParameter cedula;

        @ParameterField(required = Kleenean.TRUE, linkedField = "fechaNacimiento")
        @DateField(yearRange = 100)
        protected DateParameter fechaNacimiento;

        @ParameterField(auditable = Kleenean.FALSE, password = Kleenean.TRUE, required = Kleenean.TRUE)
        @StringField(maxLength = 128, autoComplete = AutoComplete.NEW_PASSWORD)
        protected StringParameter password;

        @ParameterField(auditable = Kleenean.FALSE, password = Kleenean.TRUE, required = Kleenean.TRUE)
        @StringField(maxLength = 128, autoComplete = AutoComplete.OFF)
        protected StringParameter confirmacionPassword;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            /**/
            solicitud.setDefaultLabel("solicitud");
            solicitud.condicion.setCurrentValue(solicitud.condicion.ACTIVADA);
            solicitud.fechaActivada.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.fechaUltimaTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
            solicitud.usuarioUltimaTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
            /**/
            cedula.setDefaultLabel("cédula");
            cedula.setDefaultRegexErrorMessage("cédula de identidad no cumple con el patrón especificado;  "
                + "debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; "
                + "por ejemplo, 1234567, 1235813A");
            /**/
            fechaNacimiento.setDefaultLabel("fecha de nacimiento");
            fechaNacimiento.setInitialValue(cedula.isNull().then(NULL_TEMPORAL));
            fechaNacimiento.setMinValue(CURRENT_DATE.addYears(-100));
            fechaNacimiento.setMaxValue(CURRENT_DATE.addYears(-18));
            /**/
            password.setDefaultLabel("contraseña");
            password.setDefaultDescription("La contraseña debe ser una secuencia de hasta 128 letras, números y otros caracteres");
            /**/
            confirmacionPassword.setDefaultLabel("confirmación de la contraseña");
            confirmacionPassword.setDefaultDescription("Escriba nuevamante la contraseña en este campo");
            /**/
        }

        protected Check check100, check110, check120;

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            /**/
            check100 = cedula.isEqualTo(solicitud.cedula);
            check100.setDefaultErrorMessage("la cédula no es igual a la cédula del solicitante");
            /**/
            check110 = fechaNacimiento.isEqualTo(solicitud.fechaNacimiento);
            check110.setDefaultErrorMessage("la fecha de nacimiento no es igual a la fecha de nacimiento del solicitante");
            /**/
            check120 = password.isNullOrEqualTo(confirmacionPassword);
            check120.setDefaultErrorMessage("la contraseña y la confirmación de la contraseña no son iguales");
            /**/
        }

    }

    @Override
    protected void settleOperations() {
        super.settleOperations();
        /**/
        registrar.addTransition(null, registrada);
        verificar.addTransition(registrada, verificada);
        anular.addTransition(registrada, anulada);
        aprobar.addTransition(verificada, aprobada);
        rechazar.addTransition(verificada, rechazada);
        activar.addTransition(aprobada, activada);
        /**/
        verificar.addTriggerOn(registrada);
        aprobar.addTriggerOn(verificada);
        /**/
    }

}
