/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.cuenta;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import adalid.core.properties.ext.*;
import java.lang.reflect.Field;

@AbstractClass
@InheritanceMapping(strategy = InheritanceMappingStrategy.SINGLE_TABLE)
@EntityDeleteOperation(enabled = Kleenean.FALSE)
@EntityTableView(inserts = Kleenean.FALSE, updates = Kleenean.FALSE, menu = ViewMenuOption.NONE)
@EntityDetailView(enabled = Kleenean.FALSE)
@EntityConsoleView(enabled = Kleenean.FALSE, menu = Kleenean.FALSE)
public class SolicitudCuentaUsuario extends AbstractPersistentEntity {

    final String solicitud_cedula = "solicitud_cuenta_usuario.[cedula]";

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public SolicitudCuentaUsuario(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
//      super.addAllocationStrings("global.tipoCodigoUsuario");
    }

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of SolicitudCuentaUsuario's attributes">
        setLocalizedLabel(ENGLISH, "user account request");
        setLocalizedLabel(SPANISH, "solicitud de cuenta de usuario");
        setLocalizedShortLabel(ENGLISH, "application");
        setLocalizedShortLabel(SPANISH, "solicitud");
        setLocalizedCollectionLabel(ENGLISH, "User Account Requests");
        setLocalizedCollectionLabel(SPANISH, "Solicitudes de Cuentas de Usuario");
        setLocalizedCollectionShortLabel(ENGLISH, "Requests");
        setLocalizedCollectionShortLabel(SPANISH, "Solicitudes");
        // </editor-fold>
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of SolicitudCuentaUsuario's properties">
        tipo.setLocalizedLabel(ENGLISH, "type");
        /**/
        codigo.setLocalizedLabel(ENGLISH, "code");
        codigo.setLocalizedLabel(SPANISH, "código");
        /**/
        cedula.setLocalizedLabel(ENGLISH, "identification card");
        cedula.setLocalizedLabel(SPANISH, "cédula");
        cedula.setLocalizedRegexErrorMessage(ENGLISH, "ID card does not meet the specified pattern; must be a sequence of up to 9 digits, optionally ending with a letter; for example, 1234567, 1235813A");
        cedula.setLocalizedRegexErrorMessage(SPANISH, "cédula de identidad no cumple con el patrón especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
        /**/
        fechaNacimiento.setLocalizedLabel(ENGLISH, "birthdate");
        fechaNacimiento.setLocalizedLabel(SPANISH, "fecha de nacimiento");
        /**/
        nombre.setLocalizedLabel(ENGLISH, "names and surnames");
        nombre.setLocalizedLabel(SPANISH, "nombres y apellidos");
        nombre.setLocalizedRegexErrorMessage(ENGLISH, "names and surnames does not comply with the specified pattern; can only contain letters, spaces, hyphens and single quotes");
        nombre.setLocalizedRegexErrorMessage(SPANISH, "nombres y apellidos no cumple con el patrón especificado; solo puede contener letras, espacios, guiones y comillas sencillas");
        /**/
        correoElectronico.setLocalizedLabel(ENGLISH, "email");
        correoElectronico.setLocalizedLabel(SPANISH, "correo electrónico");
        correoElectronico.setLocalizedRegexErrorMessage(ENGLISH, "email does not meet the specified pattern");
        correoElectronico.setLocalizedRegexErrorMessage(SPANISH, "correo electrónico no cumple con el patrón especificado");
        /**/
        archivoCedula.setLocalizedLabel(ENGLISH, "image of the ID");
        archivoCedula.setLocalizedLabel(SPANISH, "imagen de la cédula");
        archivoCedula.setLocalizedDescription(ENGLISH, "file containing the image of the identity card");
        archivoCedula.setLocalizedDescription(SPANISH, "archivo que contiene la imagen de la cédula de identidad");
        /**/
        condicion.setLocalizedLabel(ENGLISH, "condition");
        condicion.setLocalizedLabel(SPANISH, "condición");
//      condicion.setLocalizedDescription(ENGLISH, "current status of user account request");
//      condicion.setLocalizedDescription(SPANISH, "estado actual de la solicitud de cuenta de usuario");
        /**/
        fechaUltimaTransicion.setLocalizedLabel(ENGLISH, "last transition date");
        fechaUltimaTransicion.setLocalizedLabel(SPANISH, "fecha última transición");
        fechaUltimaTransicion.setLocalizedShortLabel(ENGLISH, "transition date");
        fechaUltimaTransicion.setLocalizedShortLabel(SPANISH, "fecha transición");
        fechaUltimaTransicion.setLocalizedDescription(ENGLISH, "date of registration or last transition (change of status)");
        fechaUltimaTransicion.setLocalizedDescription(SPANISH, "fecha de registro o de la última transición (cambio de condición)");
        /**/
        usuarioUltimaTransicion.setLocalizedLabel(ENGLISH, "user last transition");
        usuarioUltimaTransicion.setLocalizedLabel(SPANISH, "usuario última transición");
        usuarioUltimaTransicion.setLocalizedShortLabel(ENGLISH, "user transition");
        usuarioUltimaTransicion.setLocalizedShortLabel(SPANISH, "usuario transición");
        usuarioUltimaTransicion.setLocalizedDescription(ENGLISH, "user who made the last transition (condition change)");
        usuarioUltimaTransicion.setLocalizedDescription(SPANISH, "usuario que realizó la última transición (cambio de condición)");
        /**/
        observacionesUltimaTransicion.setLocalizedLabel(ENGLISH, "last transition observations");
        observacionesUltimaTransicion.setLocalizedLabel(SPANISH, "observaciones última transición");
        observacionesUltimaTransicion.setLocalizedShortLabel(ENGLISH, "observations");
        observacionesUltimaTransicion.setLocalizedShortLabel(SPANISH, "observaciones");
        observacionesUltimaTransicion.setLocalizedDescription(ENGLISH, "observations of the last transition (condition change)");
        observacionesUltimaTransicion.setLocalizedDescription(SPANISH, "observaciones de la última transición (cambio de condición)");
        /**/
        usuario.setLocalizedLabel(ENGLISH, "user");
        usuario.setLocalizedDescription(ENGLISH, "application user");
        usuario.setLocalizedDescription(SPANISH, "usuario de la aplicación");
        // </editor-fold>
    }

    @Override
    protected void localizeExpressions() {
        super.localizeExpressions();
        // <editor-fold defaultstate="collapsed" desc="localization of SolicitudCuentaUsuario's expressions">
        registrada.setLocalizedLabel(ENGLISH, "registered");
        registrada.setLocalizedLabel(SPANISH, "registrada");
        registrada.setLocalizedDescription(ENGLISH, "registered");
        registrada.setLocalizedErrorMessage(ENGLISH, "The request is not in status \"Registered\"");
        registrada.setLocalizedErrorMessage(SPANISH, "la solicitud no se encuentra en estado \"Registrada\"");
        /**/
        verificada.setLocalizedLabel(ENGLISH, "verified");
        verificada.setLocalizedLabel(SPANISH, "verificada");
        verificada.setLocalizedDescription(ENGLISH, "verified");
        verificada.setLocalizedErrorMessage(ENGLISH, "The request is not in status \"Verified\"");
        verificada.setLocalizedErrorMessage(SPANISH, "la solicitud no se encuentra en estado \"Verificada\"");
        /**/
        anulada.setLocalizedLabel(ENGLISH, "annulled");
        anulada.setLocalizedLabel(SPANISH, "anulada");
        anulada.setLocalizedDescription(ENGLISH, "annulled");
        anulada.setLocalizedErrorMessage(ENGLISH, "The request is not in status \"Annulled\"");
        anulada.setLocalizedErrorMessage(SPANISH, "la solicitud no se encuentra en estado \"Anulada\"");
        /**/
        aprobada.setLocalizedLabel(ENGLISH, "approved");
        aprobada.setLocalizedLabel(SPANISH, "aprobada");
        aprobada.setLocalizedDescription(ENGLISH, "approved");
        aprobada.setLocalizedErrorMessage(ENGLISH, "The request is not in status \"Approved\"");
        aprobada.setLocalizedErrorMessage(SPANISH, "la solicitud no se encuentra en estado \"Aprobada\"");
        /**/
        rechazada.setLocalizedLabel(ENGLISH, "rejected");
        rechazada.setLocalizedLabel(SPANISH, "rechazada");
        rechazada.setLocalizedDescription(ENGLISH, "rejected");
        rechazada.setLocalizedErrorMessage(ENGLISH, "The request is not in status \"Rejected\"");
        rechazada.setLocalizedErrorMessage(SPANISH, "la solicitud no se encuentra en estado \"Rechazada\"");
        /**/
        check100.setLocalizedErrorMessage(ENGLISH, "the email domain is invalid; must be gmail.com, hotmail.com, outlook.com or yahoo.com");
        check100.setLocalizedErrorMessage(SPANISH, "el dominio del correo electrónico no es válido; debe ser gmail.com, hotmail.com, outlook.com o yahoo.com");
        // </editor-fold>
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        /**/
        setDefaultLabel("solicitud de cuenta de usuario");
        setDefaultShortLabel("solicitud");
        setDefaultCollectionLabel("Solicitudes de Cuentas de Usuario");
        setDefaultCollectionShortLabel("Solicitudes");
        /**/
    }

    @PrimaryKey
    public LongProperty id;

    @VersionProperty
    public LongProperty version;

    @DiscriminatorColumn
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(overlay = Kleenean.TRUE)
    public TipoSolicitudCuentaUsuario tipo;

    @BusinessKey
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, table = Kleenean.FALSE)
    public StringProperty codigo;

    @ColumnField(nullable = Kleenean.FALSE)
    @StringField(maxLength = 10, regex = "^[0-9]{1,9}[A-Za-z]?$", letterCase = LetterCase.UPPER)
    public StringProperty cedula;

    @ColumnField(nullable = Kleenean.FALSE)
    @DateField(yearRange = 100)
    public DateProperty fechaNacimiento;

    @NameProperty
    @StringField(maxLength = 100, regex = "^[\\p{IsLatin}][-' \\p{IsLatin}]*$", letterCase = LetterCase.UPPER)
    public StringProperty nombre;

    /*
    @ColumnField(nullable = Kleenean.FALSE)
    @StringField(maxLength = MAX_EMAIL_ADDRESS_LENGTH, regex = EMAIL_REGEX)
    @PropertyField(create = Kleenean.TRUE, table = Kleenean.FALSE, overlay = Kleenean.TRUE)
    public StringProperty correoElectronico;

    /**/
    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(create = Kleenean.TRUE, table = Kleenean.FALSE, overlay = Kleenean.TRUE)
    public EmailAddressProperty correoElectronico;

    @FileReference(types = MimeType.IMAGE, storage = UploadStorageOption.FILE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE)
    public StringProperty archivoCedula;

    @StateProperty(transitionUser = "usuarioUltimaTransicion", transitionDateTime = "fechaUltimaTransicion")
    @ColumnField(nullable = Kleenean.FALSE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, defaultCondition = DefaultCondition.IF_NULL_ON_INSERT)
    public CondicionSolicitudCuentaUsuario condicion;

    @PropertyField(hidden = Kleenean.TRUE, defaultCondition = DefaultCondition.IF_NULL_ON_INSERT)
    public DateProperty fechaRegistrada;

    @PropertyField(hidden = Kleenean.TRUE)
    public DateProperty fechaVerificada;

    @PropertyField(hidden = Kleenean.TRUE)
    public DateProperty fechaAnulada;

    @PropertyField(hidden = Kleenean.TRUE)
    public DateProperty fechaAprobada;

    @PropertyField(hidden = Kleenean.TRUE)
    public DateProperty fechaRechazada;

    @PropertyField(hidden = Kleenean.TRUE)
    public DateProperty fechaActivada;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, table = Kleenean.TRUE, overlay = Kleenean.TRUE, defaultCondition = DefaultCondition.IF_NULL_ON_INSERT)
    public DateProperty fechaUltimaTransicion;

    @ColumnField(nullable = Kleenean.TRUE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE)
    public Usuario usuarioUltimaTransicion;

    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE)
    public StringProperty observacionesUltimaTransicion;

    /*
    @ColumnField(calculable = Kleenean.TRUE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(hidden = Kleenean.TRUE)
    public ConfiguracionGlobal global;

    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE)
    @StringField(maxLength = 36) // A UUID is made up of hex digits along with 4 hyphens, which make its length equal to 36 characters
    public StringProperty codigoUsuario;

    /**/
    @ColumnField(nullable = Kleenean.TRUE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(navigability = Navigability.UNIDIRECTIONAL, view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, table = Kleenean.TRUE)
    public Usuario usuario;

    @Override
    protected void settleProperties() {
        super.settleProperties();
        /**/
        codigo.setDefaultLabel("código");
        codigo.setDefaultValue(id.toCharString());
        codigo.setInitialValue(id.toCharString());
        /**/
        cedula.setDefaultLabel("cédula");
        cedula.setDefaultRegexErrorMessage("cédula de identidad no cumple con el patrón especificado;  "
            + "debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; "
            + "por ejemplo, 1234567, 1235813A");
        /**/
        fechaNacimiento.setDefaultLabel("fecha de nacimiento");
        /**/
        nombre.setDefaultLabel("nombres y apellidos");
        nombre.setDefaultRegexErrorMessage("nombres y apellidos no cumple con el patrón especificado; "
            + "solo puede contener letras, espacios, guiones y comillas sencillas");
        /**/
        correoElectronico.setDefaultLabel("correo electrónico");
        correoElectronico.setDefaultRegexErrorMessage("correo electrónico no cumple con el patrón especificado");
        /**/
        archivoCedula.setDefaultLabel("imagen de la cédula");
        archivoCedula.setDefaultDescription("archivo que contiene la imagen de la cédula de identidad");
        /**/
        condicion.setDefaultLabel("condición");
//      condicion.setDefaultDescription("estado actual de la solicitud de cuenta de usuario");
        condicion.setDefaultValue(condicion.REGISTRADA);
        condicion.setInitialValue(condicion.REGISTRADA);
        /**/
        fechaRegistrada.setDefaultValue(SpecialTemporalValue.CURRENT_DATE);
        fechaRegistrada.setInitialValue(SpecialTemporalValue.CURRENT_DATE);
        /**/
        fechaUltimaTransicion.setDefaultLabel("fecha última transición");
        fechaUltimaTransicion.setDefaultShortLabel("fecha transición");
        fechaUltimaTransicion.setDefaultDescription("fecha de registro o de la última transición (cambio de condición)");
        fechaUltimaTransicion.setDefaultValue(SpecialTemporalValue.CURRENT_DATE);
        fechaUltimaTransicion.setInitialValue(SpecialTemporalValue.CURRENT_DATE);
        /**/
        usuarioUltimaTransicion.setDefaultLabel("usuario última transición");
        usuarioUltimaTransicion.setDefaultShortLabel("usuario transición");
        usuarioUltimaTransicion.setDefaultDescription("usuario que realizó la última transición (cambio de condición)");
        usuarioUltimaTransicion.setDefaultValue(SpecialEntityValue.CURRENT_USER);
        usuarioUltimaTransicion.setInitialValue(SpecialEntityValue.CURRENT_USER);
        /**/
        observacionesUltimaTransicion.setDefaultLabel("observaciones última transición");
        observacionesUltimaTransicion.setDefaultShortLabel("observaciones");
        observacionesUltimaTransicion.setDefaultDescription("observaciones de la última transición (cambio de condición)");
        /*
        global.setInitialValue(global.GLOBAL);
//      global.setDefaultValue(global.GLOBAL);
        global.setCalculableValueExpression(global.GLOBAL.toEntityExpression());
        //
        CharacterExpression codigoUsuarioX
            = global.tipoCodigoUsuario.isEqualTo(global.tipoCodigoUsuario.CEDULA).then(cedula).
                otherwise(global.tipoCodigoUsuario.isEqualTo(global.tipoCodigoUsuario.CORREO).then(correoElectronico).
                    otherwise(global.tipoCodigoUsuario.isEqualTo(global.tipoCodigoUsuario.NOMBRE).then(nombre.toCharString()).
                        otherwise(NULL_STRING)));
        //
        codigoUsuario.setInitialValue(codigoUsuarioX);
        codigoUsuario.setDefaultValue(codigoUsuarioX);
        /**/
    }

    Key key101;

    @Override
    protected void settleKeys() {
        super.settleKeys();
        /**/
        key101.setUnique(false);
        key101.newKeyField(cedula);
        /**/
    }

    protected State registrada, verificada, anulada, aprobada, rechazada;

    protected Check check100;

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        /**/
        registrada = condicion.isEqualTo(condicion.REGISTRADA);
        registrada.setDefaultShortLabel("Registrada");
        registrada.setDefaultErrorMessage("la solicitud no se encuentra en estado \"Registrada\"");
        registrada.setTransitionDate(fechaRegistrada);
        /**/
        verificada = condicion.isEqualTo(condicion.VERIFICADA);
        verificada.setDefaultShortLabel("Verificada");
        verificada.setDefaultErrorMessage("la solicitud no se encuentra en estado \"Verificada\"");
        verificada.setTransitionDate(fechaVerificada);
        /**/
        anulada = condicion.isEqualTo(condicion.ANULADA);
        anulada.setDefaultShortLabel("Anulada");
        anulada.setDefaultErrorMessage("la solicitud no se encuentra en estado \"Anulada\"");
        anulada.setTransitionDate(fechaAnulada);
        /**/
        aprobada = condicion.isEqualTo(condicion.APROBADA);
        aprobada.setDefaultShortLabel("Aprobada");
        aprobada.setDefaultErrorMessage("la solicitud no se encuentra en estado \"Aprobada\"");
        aprobada.setTransitionDate(fechaAprobada);
        /**/
        rechazada = condicion.isEqualTo(condicion.RECHAZADA);
        rechazada.setDefaultShortLabel("Rechazada");
        rechazada.setDefaultErrorMessage("la solicitud no se encuentra en estado \"Rechazada\"");
        rechazada.setTransitionDate(fechaRechazada);
        /**/
        setHappyPath(registrada, verificada, aprobada);
        setHappyPathDisplaySpots(HappyPathDisplaySpots.DETAIL_VIEW_AND_MASTER_HEADING);
        /**/
        check100 = or(
            correoElectronico.endsWith("@gmail.com"),
            correoElectronico.endsWith("@hotmail.com"),
            correoElectronico.endsWith("@outlook.com"),
            correoElectronico.endsWith("@yahoo.com")
        );
        check100.setDefaultErrorMessage("el dominio del correo electrónico no es válido; "
            + "debe ser gmail.com, hotmail.com, outlook.com o yahoo.com");
        /**/
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        /**/
        setUpdateFilter(verificada);
        /**/
        addSelectSegment(verificada, true);
        /**/
    }

}
