/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.cuenta;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import java.lang.reflect.Field;

/**
 * @author Jorge Campins
 */
public class Usuario extends meta.entidad.comun.control.acceso.ext.Usuario {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public Usuario(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setLinkOuterChildren(true);
        setLinkOuterCollaterals(true);
        setLinkOuterSiblings(true);
    }

    @CastingField("correoElectronico")
    @ColumnField(nullable = Kleenean.TRUE)
    @PropertyField(create = Kleenean.TRUE, table = Kleenean.FALSE, required = Kleenean.TRUE, report = Kleenean.FALSE, overlay = Kleenean.TRUE)
    public StringProperty correoElectronicoCastingField;

    @ColumnField(nullable = Kleenean.TRUE)
    @PropertyField(create = Kleenean.TRUE, table = Kleenean.FALSE, required = Kleenean.TRUE, report = Kleenean.FALSE)
    @StringField(maxLength = 10, regex = "^[0-9]{1,9}[A-Za-z]?$", letterCase = LetterCase.UPPER)
    public StringProperty cedula;

    @Override
    protected void settleProperties() {
        super.settleProperties();
        /**/
        cedula.setDefaultLabel("cédula");
        cedula.setDefaultDescription("cédula de identidad del usuario");
        /**/
        cedula.setLocalizedLabel(ENGLISH, "ID card");
        cedula.setLocalizedDescription(ENGLISH, "user identity card");
        /**/
    }

    @Override
    protected void settleInstances() {
        super.settleInstances();
        /**/
        ADMINISTRADOR.newInstanceField(correoElectronico, "administrador@gmail.com");
        AUDITOR.newInstanceField(correoElectronico, "auditor@gmail.com");
        OPERADOR.newInstanceField(correoElectronico, "operador@gmail.com");
        /**/
        ADMINISTRADOR.newInstanceField(cedula, "101");
        AUDITOR.newInstanceField(cedula, "102");
        OPERADOR.newInstanceField(cedula, "103");
        /**/
    }

    Key ix_usuario_9001;

    @Override
    protected void settleKeys() {
        super.settleKeys();
        /**/
        ix_usuario_0001.setUnique(true);
        /**/
        ix_usuario_9001.setUnique(true);
        ix_usuario_9001.newKeyField(cedula);
        /**/
    }

    protected Step step90;

    @Override
    protected void settleSteps() {
        super.settleSteps();
        /**/
        step90.setDefaultLabel("etcétera");
        step90.setDefaultShortLabel("etc");
        /**/
        step90.setLocalizedLabel(ENGLISH, "etcetera");
        step90.setLocalizedShortLabel(ENGLISH, "etc");
        /**/
        step90.newStepField(cedula);
        /**/
    }

    protected Tab tab90;

    @Override
    protected void settleTabs() {
        super.settleTabs();
        /**/
        tab90.copy(step90);
        /**/
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        correoElectronico.setRequiringFilter(TRUTH);
    }

}
