/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.cuenta.i18n;

import adalid.core.interfaces.Artifact;
import java.lang.reflect.Field;

/**
 * SolicitudCrearCuentaUsuario is a generated java file.
 * <ul>
 * <li>template: templates/meta/java/i18n/component.vm</li>
 * <li>template-author: Jorge Campins</li>
 * <li>file-encoding: UTF-8</li>
 * <li>file-preserve: false -> file will be replaced when regenerating the project</li>
 * </ul>
 *
 * @author ADALID (template by Jorge Campins)
 */
public class SolicitudCrearCuentaUsuario extends showcase.meta.entidad.cuenta.SolicitudCrearCuentaUsuario {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public SolicitudCrearCuentaUsuario(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of SolicitudCrearCuentaUsuario's attributes">
        setLocalizedLabel(ENGLISH, "user account creation request");
//      setLocalizedLabel(SPANISH, "solicitud de creación de cuenta de usuario");
        setLocalizedShortLabel(ENGLISH, "account creation request");
//      setLocalizedShortLabel(SPANISH, "solicitud de creación de cuenta");
        setLocalizedCollectionLabel(ENGLISH, "User Account Creation Requests");
//      setLocalizedCollectionLabel(SPANISH, "Solicitudes de Creación de Cuentas de Usuario");
        setLocalizedCollectionShortLabel(ENGLISH, "Account Creation Requests");
//      setLocalizedCollectionShortLabel(SPANISH, "Solicitudes de Creación de Cuentas");
        // </editor-fold>
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of SolicitudCrearCuentaUsuario's properties">
        numeroTelefonoMovil.setLocalizedLabel(ENGLISH, "cell phone");
//      numeroTelefonoMovil.setLocalizedLabel(SPANISH, "teléfono celular");
        numeroTelefonoMovil.setLocalizedDescription(ENGLISH, "cell phone number in international format");
//      numeroTelefonoMovil.setLocalizedDescription(SPANISH, "número de teléfono celular en formato internacional");
        numeroTelefonoMovil.setLocalizedRegexErrorMessage(ENGLISH, "the phone number does not meet the required pattern; This must begin with a country code, i.e. a plus sign and a group of 1 to 3 digits, followed by a global subscriber number, i.e. a group of 7 to 14 digits; the country code and global subscriber number must be separated by a single blank or hyphen; The global subscriber number can be divided into area code, a group of 1 to 4 digits, and subscriber number, a group of 6 to 10 digits; the area code and subscriber number must be separated by a single blank space or hyphen; Whatever their distribution between the groups, the total number of digits must be between 8 and 15.");
//      numeroTelefonoMovil.setLocalizedRegexErrorMessage(SPANISH, "el número de teléfono no cumple con el patrón requerido; éste debe comenzar con un código de país, es decir, un signo más y un grupo de 1 hasta 3 dígitos, seguido de un número de suscriptor global, es decir, un grupo de 7 hasta 14 dígitos; el código de país y el número de suscriptor global deben estar separados por un solo espacio en blanco o guión; el número de suscriptor global se puede dividir en código de área, un grupo de 1 hasta 4 dígitos, y número de suscriptor, un grupo de 6 a 10 dígitos; el código de área y el número de suscriptor deben estar separados por un solo espacio en blanco o guión; cualquiera que sea su distribución entre los grupos, el número total de dígitos debe estar entre 8 y 15.");
        /**/
        direccion.setLocalizedLabel(ENGLISH, "address");
//      direccion.setLocalizedLabel(SPANISH, "dirección");
        /**/
        archivoSolicitud.setLocalizedLabel(ENGLISH, "application form");
//      archivoSolicitud.setLocalizedLabel(SPANISH, "planilla de solicitud");
        archivoSolicitud.setLocalizedDescription(ENGLISH, "file containing the image of the application form");
//      archivoSolicitud.setLocalizedDescription(SPANISH, "archivo que contiene la imagen de la planilla de solicitud");
        // </editor-fold>
    }

    @Override
    protected void localizeExpressions() {
        super.localizeExpressions();
        // <editor-fold defaultstate="collapsed" desc="localization of SolicitudCrearCuentaUsuario's expressions">
        activada.setLocalizedShortLabel(ENGLISH, "Activated");
//      activada.setLocalizedShortLabel(SPANISH, "Activada");
        activada.setLocalizedDescription(ENGLISH, "activated");
        activada.setLocalizedErrorMessage(ENGLISH, "the request is not in state \"Activated\"");
//      activada.setLocalizedErrorMessage(SPANISH, "la solicitud no se encuentra en estado \"Activada\"");
        // </editor-fold>
    }

    public class Registrar extends showcase.meta.entidad.cuenta.SolicitudCrearCuentaUsuario.Registrar {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Registrar's attributes">
            setLocalizedLabel(ENGLISH, "request account creation");
//          setLocalizedLabel(SPANISH, "solicitar creación de cuenta");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Registrar's parameters">
            cedula.setLocalizedLabel(ENGLISH, "identification card");
//          cedula.setLocalizedLabel(SPANISH, "cédula");
            cedula.setLocalizedRegexErrorMessage(ENGLISH, "ID card does not meet the specified pattern; must be a sequence of up to 9 digits, optionally ending with a letter; for example, 1234567, 1235813A");
//          cedula.setLocalizedRegexErrorMessage(SPANISH, "cédula de identidad no cumple con el patrón especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            /**/
            fechaNacimiento.setLocalizedLabel(ENGLISH, "birthdate");
//          fechaNacimiento.setLocalizedLabel(SPANISH, "fecha de nacimiento");
            /**/
            nombre.setLocalizedLabel(ENGLISH, "names and surnames");
//          nombre.setLocalizedLabel(SPANISH, "nombres y apellidos");
            nombre.setLocalizedRegexErrorMessage(ENGLISH, "names and surnames does not comply with the specified pattern; can only contain letters, spaces, hyphens and single quotes");
//          nombre.setLocalizedRegexErrorMessage(SPANISH, "nombres y apellidos no cumple con el patrón especificado; solo puede contener letras, espacios, guiones y comillas sencillas");
            /**/
            correoElectronico.setLocalizedLabel(ENGLISH, "email");
//          correoElectronico.setLocalizedLabel(SPANISH, "correo electrónico");
            correoElectronico.setLocalizedRegexErrorMessage(ENGLISH, "email does not meet the specified pattern");
//          correoElectronico.setLocalizedRegexErrorMessage(SPANISH, "correo electrónico no cumple con el patrón especificado");
            /**/
            confirmacionCorreoElectronico.setLocalizedLabel(ENGLISH, "email confirmation");
//          confirmacionCorreoElectronico.setLocalizedLabel(SPANISH, "confirmación del correo");
            confirmacionCorreoElectronico.setLocalizedDescription(ENGLISH, "retype your email in this field");
//          confirmacionCorreoElectronico.setLocalizedDescription(SPANISH, "escriba nuevamante su correo electrónico en este campo");
            confirmacionCorreoElectronico.setLocalizedRegexErrorMessage(ENGLISH, "confirmation email does not match the specified pattern");
//          confirmacionCorreoElectronico.setLocalizedRegexErrorMessage(SPANISH, "confirmación del correo no cumple con el patrón especificado");
            /**/
            numeroTelefonoMovil.setLocalizedLabel(ENGLISH, "cell phone");
//          numeroTelefonoMovil.setLocalizedLabel(SPANISH, "teléfono celular");
            numeroTelefonoMovil.setLocalizedDescription(ENGLISH, "cellphone number; this is an international phone number; must begin with a country code, followed by a global subscriber number or an area code and a subscriber number; for example: +58 4121234567, +58-412-1234567");
//          numeroTelefonoMovil.setLocalizedDescription(SPANISH, "número de teléfono celular; este es un número de teléfono internacional; debe comenzar con un código de país, seguido de un número de suscriptor global o un código de área y un número de suscriptor; por ejemplo: +58 4121234567, +58-412-1234567");
            numeroTelefonoMovil.setLocalizedRegexErrorMessage(ENGLISH, "the phone number does not meet the required pattern; This must begin with a country code, i.e. a plus sign and a group of 1 to 3 digits, followed by a global subscriber number, i.e. a group of 7 to 14 digits; the country code and global subscriber number must be separated by a single blank or hyphen; The global subscriber number can be divided into area code, a group of 1 to 4 digits, and subscriber number, a group of 6 to 10 digits; the area code and subscriber number must be separated by a single blank space or hyphen; Whatever their distribution between the groups, the total number of digits must be between 8 and 15.");
//          numeroTelefonoMovil.setLocalizedRegexErrorMessage(SPANISH, "el número de teléfono no cumple con el patrón requerido; éste debe comenzar con un código de país, es decir, un signo más y un grupo de 1 hasta 3 dígitos, seguido de un número de suscriptor global, es decir, un grupo de 7 hasta 14 dígitos; el código de país y el número de suscriptor global deben estar separados por un solo espacio en blanco o guión; el número de suscriptor global se puede dividir en código de área, un grupo de 1 hasta 4 dígitos, y número de suscriptor, un grupo de 6 a 10 dígitos; el código de área y el número de suscriptor deben estar separados por un solo espacio en blanco o guión; cualquiera que sea su distribución entre los grupos, el número total de dígitos debe estar entre 8 y 15.");
            /**/
            direccion.setLocalizedLabel(ENGLISH, "address");
//          direccion.setLocalizedLabel(SPANISH, "dirección");
            /**/
            archivoSolicitud.setLocalizedLabel(ENGLISH, "application form");
//          archivoSolicitud.setLocalizedLabel(SPANISH, "planilla de solicitud");
            archivoSolicitud.setLocalizedDescription(ENGLISH, "File that contains the image of the application form, signed by the user; Its size should not exceed 1 MB.");
//          archivoSolicitud.setLocalizedDescription(SPANISH, "Archivo que contiene la imagen de la planilla de solicitud, firmada por el usuario; su tamaño no debe superar 1 MB.");
            /**/
            archivoCedula.setLocalizedLabel(ENGLISH, "image of the ID");
//          archivoCedula.setLocalizedLabel(SPANISH, "imagen de la cédula");
            archivoCedula.setLocalizedDescription(ENGLISH, "File containing the image of the identity card; Its size should not exceed 1 MB.");
//          archivoCedula.setLocalizedDescription(SPANISH, "Archivo que contiene la imagen de la cédula de identidad; su tamaño no debe superar 1 MB.");
            // </editor-fold>
        }

        @Override
        protected void localizeExpressions() {
            super.localizeExpressions();
            // <editor-fold defaultstate="collapsed" desc="localization of Registrar's expressions">
            check100.setLocalizedErrorMessage(ENGLISH, "the email domain is invalid; must be gmail.com, hotmail.com, outlook.com or yahoo.com");
//          check100.setLocalizedErrorMessage(SPANISH, "el dominio del correo electrónico no es válido; debe ser gmail.com, hotmail.com, outlook.com o yahoo.com");
            /**/
            check110.setLocalizedErrorMessage(ENGLISH, "email and email confirmation are not the same");
//          check110.setLocalizedErrorMessage(SPANISH, "el correo electrónico y la confirmación del correo no son iguales");
            // </editor-fold>
        }

    }

    public class Verificar extends showcase.meta.entidad.cuenta.SolicitudCrearCuentaUsuario.Verificar {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Verificar's attributes">
            setLocalizedLabel(ENGLISH, "verify email account");
//          setLocalizedLabel(SPANISH, "verificar cuenta de correo");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Verificar's parameters">
            solicitud.setLocalizedLabel(ENGLISH, "application");
            /**/
            cedula.setLocalizedLabel(ENGLISH, "identification card");
//          cedula.setLocalizedLabel(SPANISH, "cédula");
            cedula.setLocalizedRegexErrorMessage(ENGLISH, "ID card does not meet the specified pattern; must be a sequence of up to 9 digits, optionally ending with a letter; for example, 1234567, 1235813A");
//          cedula.setLocalizedRegexErrorMessage(SPANISH, "cédula de identidad no cumple con el patrón especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            /**/
            fechaNacimiento.setLocalizedLabel(ENGLISH, "birthdate");
//          fechaNacimiento.setLocalizedLabel(SPANISH, "fecha de nacimiento");
            // </editor-fold>
        }

        @Override
        protected void localizeExpressions() {
            super.localizeExpressions();
            // <editor-fold defaultstate="collapsed" desc="localization of Verificar's expressions">
            check100.setLocalizedErrorMessage(ENGLISH, "the ID is not the same as the applicant's ID");
//          check100.setLocalizedErrorMessage(SPANISH, "la cédula no es igual a la cédula del solicitante");
            /**/
            check110.setLocalizedErrorMessage(ENGLISH, "the date of birth is not the same as the applicant's date of birth");
//          check110.setLocalizedErrorMessage(SPANISH, "la fecha de nacimiento no es igual a la fecha de nacimiento del solicitante");
            // </editor-fold>
        }

    }

    public class Anular extends showcase.meta.entidad.cuenta.SolicitudCrearCuentaUsuario.Anular {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Anular's attributes">
            setLocalizedLabel(ENGLISH, "cancel request");
//          setLocalizedLabel(SPANISH, "anular solicitud");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Anular's parameters">
            solicitud.setLocalizedLabel(ENGLISH, "application");
            // </editor-fold>
        }

    }

    public class Aprobar extends showcase.meta.entidad.cuenta.SolicitudCrearCuentaUsuario.Aprobar {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Aprobar's attributes">
            setLocalizedLabel(ENGLISH, "approve request");
//          setLocalizedLabel(SPANISH, "aprobar solicitud");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Aprobar's parameters">
            solicitud.setLocalizedLabel(ENGLISH, "application");
            /**/
            codigoUsuario.setLocalizedLabel(ENGLISH, "user code");
            /**/
            grupo.setLocalizedLabel(ENGLISH, "user group");
//          grupo.setLocalizedLabel(SPANISH, "grupo de usuarios");
            /**/
            rol.setLocalizedLabel(ENGLISH, "role");
            rol.setLocalizedDescription(ENGLISH, "application role");
//          rol.setLocalizedDescription(SPANISH, "rol de la aplicación");
            /**/
            modulo.setLocalizedLabel(ENGLISH, "module");
//          modulo.setLocalizedLabel(SPANISH, "módulo");
            // </editor-fold>
        }

        @Override
        protected void localizeExpressions() {
            super.localizeExpressions();
            // <editor-fold defaultstate="collapsed" desc="localization of Aprobar's expressions">
            check111.setLocalizedErrorMessage(ENGLISH, "the role cannot be an inactive role");
//          check111.setLocalizedErrorMessage(SPANISH, "el rol no puede ser un rol inactivo");
            /**/
            check112.setLocalizedErrorMessage(ENGLISH, "the role cannot be a super role");
//          check112.setLocalizedErrorMessage(SPANISH, "el rol no puede ser un súper-rol");
            /**/
            query113.setLocalizedErrorMessage(ENGLISH, "the role cannot be an inactive role or a super role");
//          query113.setLocalizedErrorMessage(SPANISH, "el rol no puede ser un rol inactivo ni un súper-rol");
            // </editor-fold>
        }

    }

    public class Rechazar extends showcase.meta.entidad.cuenta.SolicitudCrearCuentaUsuario.Rechazar {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Rechazar's attributes">
            setLocalizedLabel(ENGLISH, "reject request");
//          setLocalizedLabel(SPANISH, "rechazar solicitud");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Rechazar's parameters">
            solicitud.setLocalizedLabel(ENGLISH, "application");
            /**/
            observaciones.setLocalizedLabel(ENGLISH, "reason for rejection");
//          observaciones.setLocalizedLabel(SPANISH, "motivo del rechazo");
            observaciones.setLocalizedDescription(ENGLISH, "Please describe in detail the reason why the application is being rejected.");
//          observaciones.setLocalizedDescription(SPANISH, "Describa detalladamente el motivo por el cual se rechaza la solicitud");
            // </editor-fold>
        }

    }

    public class Activar extends showcase.meta.entidad.cuenta.SolicitudCrearCuentaUsuario.Activar {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Activar's attributes">
            setLocalizedLabel(ENGLISH, "activate account");
//          setLocalizedLabel(SPANISH, "activar cuenta");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Activar's parameters">
            solicitud.setLocalizedLabel(ENGLISH, "application");
            /**/
            cedula.setLocalizedLabel(ENGLISH, "identification card");
//          cedula.setLocalizedLabel(SPANISH, "cédula");
            cedula.setLocalizedRegexErrorMessage(ENGLISH, "ID card does not meet the specified pattern; must be a sequence of up to 9 digits, optionally ending with a letter; for example, 1234567, 1235813A");
//          cedula.setLocalizedRegexErrorMessage(SPANISH, "cédula de identidad no cumple con el patrón especificado;  debe ser una secuencia de hasta 9 digitos, opcionalmente terminando con una letra; por ejemplo, 1234567, 1235813A");
            /**/
            fechaNacimiento.setLocalizedLabel(ENGLISH, "birthdate");
//          fechaNacimiento.setLocalizedLabel(SPANISH, "fecha de nacimiento");
            /**/
            password.setLocalizedLabel(ENGLISH, "password");
//          password.setLocalizedLabel(SPANISH, "contraseña");
            password.setLocalizedDescription(ENGLISH, "The password must be a sequence of up to 128 letters, numbers and other characters");
//          password.setLocalizedDescription(SPANISH, "La contraseña debe ser una secuencia de hasta 128 letras, números y otros caracteres");
            /**/
            confirmacionPassword.setLocalizedLabel(ENGLISH, "password confirmation");
//          confirmacionPassword.setLocalizedLabel(SPANISH, "confirmación de la contraseña");
            confirmacionPassword.setLocalizedDescription(ENGLISH, "Retype the password in this field");
//          confirmacionPassword.setLocalizedDescription(SPANISH, "Escriba nuevamante la contraseña en este campo");
            // </editor-fold>
        }

        @Override
        protected void localizeExpressions() {
            super.localizeExpressions();
            // <editor-fold defaultstate="collapsed" desc="localization of Activar's expressions">
            check100.setLocalizedErrorMessage(ENGLISH, "the ID is not the same as the applicant's ID");
//          check100.setLocalizedErrorMessage(SPANISH, "la cédula no es igual a la cédula del solicitante");
            /**/
            check110.setLocalizedErrorMessage(ENGLISH, "the date of birth is not the same as the applicant's date of birth");
//          check110.setLocalizedErrorMessage(SPANISH, "la fecha de nacimiento no es igual a la fecha de nacimiento del solicitante");
            /**/
            check120.setLocalizedErrorMessage(ENGLISH, "password and password confirmation are not the same");
//          check120.setLocalizedErrorMessage(SPANISH, "la contraseña y la confirmación de la contraseña no son iguales");
            // </editor-fold>
        }

    }

}
