/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.documento;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.parameters.*;
import adalid.core.properties.*;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;
import meta.entidad.comun.auditoria.ArchivoAdjunto;
import meta.entidad.comun.control.acceso.Usuario;
import showcase.meta.entidad.configuracion.fija.EstadoDocumento;
import showcase.meta.entidad.configuracion.fija.TipoDocumento;

@AbstractClass
@EntityClass(resourceType = ResourceType.OPERATION, independent = Kleenean.FALSE)
@EntityCodeGen(bws = Kleenean.TRUE, fws = Kleenean.TRUE)
@InheritanceMapping(strategy = InheritanceMappingStrategy.SINGLE_TABLE)
@EntityUpdateOperation(access = OperationAccess.PROTECTED)
@EntityInsertOperation(access = OperationAccess.PROTECTED)
@EntityDeleteOperation(access = OperationAccess.PROTECTED)
@EntitySelectOperation(access = OperationAccess.PROTECTED)
@EntityTableView(inserts = Kleenean.FALSE)
public class Documento extends PersistentEntityBase {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public Documento(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of Documento's attributes">
        setLocalizedLabel(ENGLISH, "document");
        setLocalizedCollectionLabel(ENGLISH, "Documents");
        // </editor-fold>
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of Documento's properties">
        tipo.setLocalizedLabel(ENGLISH, "document type");
        tipo.setLocalizedLabel(SPANISH, "tipo de documento");
        /**/
        codigo.setLocalizedLabel(ENGLISH, "document code");
        codigo.setLocalizedShortLabel(ENGLISH, "code");
        /**/
        nombre.setLocalizedLabel(ENGLISH, "document name");
        nombre.setLocalizedShortLabel(ENGLISH, "name");
        nombre.setLocalizedDefaultValueTag(ENGLISH, "If &lt;**attachment**&gt; is null, &lt;**code**&gt;; if not, &lt;**client file**&gt; of &lt;**attachment**&gt;");
        nombre.setLocalizedDefaultValueTag(SPANISH, "Si <**adjunto**> es nulo, <**código**>; si no, <**archivo cliente**> de <**adjunto**>");
        /**/
        archivo.setLocalizedLabel(ENGLISH, "archive");
        archivo.setLocalizedTooltip(ENGLISH, "hyperlink to open file");
        archivo.setLocalizedTooltip(SPANISH, "hipervínculo para abrir el archivo");
        /**/
        octetos.setLocalizedLabel(ENGLISH, "octets");
        /**/
        secuencia.setLocalizedLabel(ENGLISH, "document sequence");
        secuencia.setLocalizedShortLabel(ENGLISH, "sequence");
        /**/
        adjunto.setLocalizedLabel(ENGLISH, "attached file");
        adjunto.setLocalizedLabel(SPANISH, "archivo adjunto");
        /**/
        descripcion.setLocalizedLabel(ENGLISH, "file description");
        descripcion.setLocalizedLabel(SPANISH, "descripción del archivo");
        /**/
        ultimaCarga.setLocalizedLabel(ENGLISH, "last load");
        /**/
        estado.setLocalizedLabel(ENGLISH, "document status");
        estado.setLocalizedLabel(SPANISH, "estado de documento");
        /**/
        fechaEstado.setLocalizedLabel(ENGLISH, "state's date");
        /**/
        usuarioActualizacion.setLocalizedLabel(ENGLISH, "document update user");
        usuarioActualizacion.setLocalizedShortLabel(ENGLISH, "user update");
        /**/
        observaciones.setLocalizedLabel(ENGLISH, "observations");
        // </editor-fold>
    }

    @Override
    protected void localizeExpressions() {
        super.localizeExpressions();
        // <editor-fold defaultstate="collapsed" desc="localization of Documento's expressions">
        modificable.setLocalizedLabel(ENGLISH, "modifiable");
        modificable.setLocalizedDescription(ENGLISH, "modifiable");
        modificable.setLocalizedErrorMessage(ENGLISH, "The document is not Modifiable");
        modificable.setLocalizedErrorMessage(SPANISH, "el documento no está Modificable");
        /**/
        verificable.setLocalizedLabel(ENGLISH, "verifiable");
        verificable.setLocalizedDescription(ENGLISH, "verifiable");
        verificable.setLocalizedErrorMessage(ENGLISH, "the document is not Verifiable");
        verificable.setLocalizedErrorMessage(SPANISH, "el documento no está Verificable");
        /**/
        verificado.setLocalizedLabel(ENGLISH, "verified");
        verificado.setLocalizedDescription(ENGLISH, "verified");
        verificado.setLocalizedErrorMessage(ENGLISH, "the document is not Verified");
        verificado.setLocalizedErrorMessage(SPANISH, "el documento no está Verificado");
        /**/
        rechazado.setLocalizedLabel(ENGLISH, "rejected");
        rechazado.setLocalizedDescription(ENGLISH, "rejected");
        rechazado.setLocalizedErrorMessage(ENGLISH, "the document is not Rejected");
        rechazado.setLocalizedErrorMessage(SPANISH, "el documento no está Rechazado");
        // </editor-fold>
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
    }

    @DiscriminatorColumn
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    public TipoDocumento tipo;

    @BusinessKey
//  @CharacterDataGen(function = "util.string_codigo_entidad")
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, table = Kleenean.FALSE, report = Kleenean.FALSE)
    public StringProperty codigo;

    @NameProperty
//  @CharacterDataGen(function = "util.string_nombre_entidad")
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE)
    public StringProperty nombre;

    @FileReference(max = 0, joinField = "adjunto", loadField = "ultimaCarga", textField = "nombre")
    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.TRUE, report = Kleenean.FALSE)
    public StringProperty archivo;

    @ColumnField(calculable = Kleenean.TRUE)
    public BinaryProperty octetos;

    @SequenceProperty
    public LongProperty secuencia;

//  @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, table = Kleenean.TRUE)
    @EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME)
    public ArchivoAdjunto adjunto;

    @DescriptionProperty
//  @CharacterDataGen(function = "util.string_descripcion_entidad")
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.TRUE, report = Kleenean.TRUE)
    public StringProperty descripcion;

    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, table = Kleenean.FALSE, report = Kleenean.FALSE)
    public TimestampProperty ultimaCarga;

    @StateProperty(transitionDateTime = "fechaEstado")
    @ColumnField(nullable = Kleenean.FALSE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, table = Kleenean.TRUE, report = Kleenean.TRUE)
    public EstadoDocumento estado;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE)
    public DateProperty fechaEstado;

    @UserProperty
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE)
    public Usuario usuarioActualizacion;

    /*
    @SegmentProperty(entityClass = Segmento.class)
    @PropertyField(hidden = Kleenean.TRUE)
    public LongProperty segmento;

    /**/
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE)
    @StringField(maxLength = 0)
    public StringProperty observaciones;

    @Override
    protected void settleProperties() {
        super.settleProperties();
        codigo.setDefaultValue(id.toCharString().format("(RTL)XXXX-XXXX-XXXX-XXXX-XXXX"));
        nombre.setDefaultValue(adjunto.isNull().then(codigo).otherwise(adjunto.archivoCliente));
        nombre.setDefaultValueTag("Si " + b("adjunto") + " es nulo, " + b("código") + "; si no, " + b("archivo cliente") + _de_ + b("adjunto"));
        archivo.setDefaultTooltip("hipervínculo para abrir el archivo");
        octetos.setCalculableValueExpression(adjunto.octetos);
        descripcion.setDefaultLabel("descripción del archivo");
        descripcion.setDefaultValue(adjunto.tipoContenido.concat(" ").concat(adjunto.archivoCliente));
        estado.setInitialValue(estado.MODIFICABLE);
        estado.setDefaultValue(estado.MODIFICABLE);
        fechaEstado.setInitialValue(SpecialTemporalValue.CURRENT_DATE);
        fechaEstado.setDefaultValue(SpecialTemporalValue.CURRENT_DATE);
    }

    public State modificable, verificable, verificado, rechazado;

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        modificable = estado.isEqualTo(estado.MODIFICABLE);
        modificable.setDefaultErrorMessage("el documento no está Modificable");
        verificable = estado.isEqualTo(estado.VERIFICABLE);
        verificable.setDefaultErrorMessage("el documento no está Verificable");
        verificado = estado.isEqualTo(estado.VERIFICADO);
        verificado.setDefaultErrorMessage("el documento no está Verificado");
        rechazado = estado.isEqualTo(estado.RECHAZADO);
        rechazado.setDefaultErrorMessage("el documento no está Rechazado");
        /**/
        setHappyPath(modificable, verificable, verificado);
        setHappyPathDisplaySpots(HappyPathDisplaySpots.DETAIL_VIEW_AND_MASTER_HEADING);
        /**/
    }

    @Override
    protected void settleFilters() {
        setUpdateFilter(modificable);
        setDeleteFilter(modificable);
    }

    @Override
    protected void settleOperations() {
        super.settleOperations();
        insert.addTransition(null, modificable);
        solicitarVerificacion.addTransition(modificable, verificable);
        aceptar.addTransition(verificable, verificado);
        rechazar.addTransition(verificable, rechazado);
        /**/
        solicitarVerificacion.addTriggerOn(modificable);
        aceptar.addTriggerOn(verificable);
    }

    protected Cargar cargar;

    @OperationClass(access = OperationAccess.RESTRICTED)
    @ProcessOperationClass(overloading = Kleenean.TRUE)
    public class Cargar extends ProcessOperation {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Cargar's attributes">
            setLocalizedLabel(ENGLISH, "carry");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Cargar's parameters">
            documento.setLocalizedLabel(ENGLISH, "document");
            /**/
            archivo.setLocalizedLabel(ENGLISH, "archive");
            archivo.setLocalizedTooltip(ENGLISH, "hyperlink to open file");
            // </editor-fold>
        }

        @Override
        protected void localizeExpressions() {
            super.localizeExpressions();
            // <editor-fold defaultstate="collapsed" desc="localization of Cargar's expressions">
            // </editor-fold>
        }

        @InstanceReference
        protected Documento documento;

        @FileReference
        @ParameterField(required = Kleenean.TRUE, linkedField = "archivo")
        protected StringParameter archivo;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            archivo.setDefaultValue(documento.archivo);
            archivo.setInitialValue(documento.archivo);
        }

        protected Check check0101;

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            check0101 = documento.modificable.isTrue();
        }

        @Override
        protected void settleFilters() {
            super.settleFilters();
            documento.setSearchQueryFilter(check0101);
        }

    }

    protected SolicitarVerificacion solicitarVerificacion;

    @OperationClass
    @ProcessOperationClass(overloading = Kleenean.UNSPECIFIED, serviceable = Kleenean.TRUE, automaticAssumption = true)
    public class SolicitarVerificacion extends ProcessOperation {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of SolicitarVerificacion's attributes">
            setLocalizedLabel(ENGLISH, "request verification");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of SolicitarVerificacion's parameters">
            documento.setLocalizedLabel(ENGLISH, "document");
            // </editor-fold>
        }

        @InstanceReference
        protected Documento documento;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            documento.estado.setCurrentValue(estado.VERIFICABLE);
            documento.fechaEstado.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
        }

    }

    protected Aceptar aceptar;

    @OperationClass
    @ProcessOperationClass(overloading = Kleenean.UNSPECIFIED, serviceable = Kleenean.TRUE, automaticAssumption = true)
    public class Aceptar extends ProcessOperation {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Aceptar's attributes">
            setLocalizedLabel(ENGLISH, "accept");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Aceptar's parameters">
            documento.setLocalizedLabel(ENGLISH, "document");
            /**/
            observaciones.setLocalizedLabel(ENGLISH, "observations");
            // </editor-fold>
        }

        @InstanceReference
        protected Documento documento;

        @ParameterField(required = Kleenean.FALSE, linkedField = "observaciones")
        protected StringParameter observaciones;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            documento.estado.setCurrentValue(estado.VERIFICADO);
            documento.fechaEstado.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
        }

    }

    protected Rechazar rechazar;

    @OperationClass
    @ProcessOperationClass(overloading = Kleenean.UNSPECIFIED, serviceable = Kleenean.TRUE)
    public class Rechazar extends ProcessOperation {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Rechazar's attributes">
            setLocalizedLabel(ENGLISH, "decline");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Rechazar's parameters">
            documento.setLocalizedLabel(ENGLISH, "document");
            /**/
            observaciones.setLocalizedLabel(ENGLISH, "observations");
            // </editor-fold>
        }

        @InstanceReference
        protected Documento documento;

        @ParameterField(required = Kleenean.FALSE, linkedField = "observaciones")
        protected StringParameter observaciones;

        @Override
        protected void settleParameters() {
            super.settleParameters();
            documento.estado.setCurrentValue(estado.RECHAZADO);
            documento.fechaEstado.setCurrentValue(SpecialTemporalValue.CURRENT_DATE);
        }

    }

}
