/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.documento;

import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import java.lang.reflect.Field;
import showcase.meta.entidad.cliente.Cliente;

@DiscriminatorValue("1")
@EntityClass(independent = Kleenean.FALSE, resourceType = ResourceType.OPERATION)
@EntityUpdateOperation(access = OperationAccess.PROTECTED)
@EntityInsertOperation(access = OperationAccess.PROTECTED)
@EntityDeleteOperation(access = OperationAccess.PROTECTED)
@EntitySelectOperation(access = OperationAccess.PROTECTED)
public class DocumentoCliente extends Documento {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public DocumentoCliente(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of DocumentoCliente's attributes">
        setLocalizedLabel(ENGLISH, "client document");
        setLocalizedLabel(SPANISH, "documento de cliente");
        setLocalizedCollectionLabel(ENGLISH, "Client Documents");
        setLocalizedCollectionLabel(SPANISH, "Documentos de Cliente");
        // </editor-fold>
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of DocumentoCliente's properties">
        cliente.setLocalizedLabel(ENGLISH, "customer");
        // </editor-fold>
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("documento de cliente");
        setDefaultCollectionLabel("Documentos de Cliente");
    }

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.TABLE_AND_DETAIL)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, table = Kleenean.TRUE, report = Kleenean.TRUE)
    @ColumnField(nullable = Kleenean.FALSE)
    public Cliente cliente;

}
