/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.documento;

import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import java.lang.reflect.Field;
import showcase.meta.entidad.producto.Producto;

@DiscriminatorValue("2")
@EntityClass(independent = Kleenean.FALSE, resourceType = ResourceType.CONFIGURATION)
@EntityUpdateOperation(access = OperationAccess.PROTECTED)
@EntityInsertOperation(access = OperationAccess.PROTECTED)
@EntityDeleteOperation(access = OperationAccess.PROTECTED)
@EntitySelectOperation(access = OperationAccess.PROTECTED)
public class DocumentoProducto extends Documento {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public DocumentoProducto(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of DocumentoProducto's attributes">
        setLocalizedLabel(ENGLISH, "product document");
        setLocalizedLabel(SPANISH, "documento de producto");
        setLocalizedCollectionLabel(ENGLISH, "Product Documents");
        setLocalizedCollectionLabel(SPANISH, "Documentos de Producto");
        // </editor-fold>
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of DocumentoProducto's properties">
        producto.setLocalizedLabel(ENGLISH, "product");
        // </editor-fold>
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("documento de producto");
        setDefaultCollectionLabel("Documentos de Producto");
    }

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.TABLE_AND_DETAIL)
    @PropertyField(required = Kleenean.TRUE, table = Kleenean.TRUE, report = Kleenean.TRUE)
    @ColumnField(nullable = Kleenean.FALSE)
    public Producto producto;

}
