/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.documento;

import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import java.lang.reflect.Field;
import showcase.meta.entidad.servicio.Servicio;

@DiscriminatorValue("3")
@EntityClass(independent = Kleenean.FALSE, resourceType = ResourceType.CONFIGURATION)
@EntityUpdateOperation(access = OperationAccess.PROTECTED)
@EntityInsertOperation(access = OperationAccess.PROTECTED)
@EntityDeleteOperation(access = OperationAccess.PROTECTED)
@EntitySelectOperation(access = OperationAccess.PROTECTED)
public class DocumentoServicio extends Documento {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public DocumentoServicio(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of DocumentoServicio's attributes">
        setLocalizedLabel(ENGLISH, "service document");
        setLocalizedLabel(SPANISH, "documento de servicio");
        setLocalizedCollectionLabel(ENGLISH, "Service Documents");
        setLocalizedCollectionLabel(SPANISH, "Documentos de Servicio");
        // </editor-fold>
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of DocumentoServicio's properties">
        servicio.setLocalizedLabel(ENGLISH, "service");
        // </editor-fold>
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("documento de servicio");
        setDefaultCollectionLabel("Documentos de Servicio");
    }

    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.TABLE_AND_DETAIL)
    @PropertyField(required = Kleenean.TRUE, table = Kleenean.TRUE, report = Kleenean.TRUE)
    @ColumnField(nullable = Kleenean.FALSE)
    public Servicio servicio;

}
