/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.documento.i18n;

import adalid.core.interfaces.Artifact;
import java.lang.reflect.Field;

/**
 * Documento is a generated java file.
 * <ul>
 * <li>template: templates/meta/java/i18n/component.vm</li>
 * <li>template-author: Jorge Campins</li>
 * <li>file-encoding: UTF-8</li>
 * <li>file-preserve: false -> file will be replaced when regenerating the project</li>
 * </ul>
 *
 * @author ADALID (template by Jorge Campins)
 */
public class Documento extends showcase.meta.entidad.documento.Documento {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public Documento(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of Documento's attributes">
        setLocalizedLabel(ENGLISH, "document");
        setLocalizedCollectionLabel(ENGLISH, "Documents");
        // </editor-fold>
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of Documento's properties">
        tipo.setLocalizedLabel(ENGLISH, "document type");
//      tipo.setLocalizedLabel(SPANISH, "tipo de documento");
        /**/
        codigo.setLocalizedLabel(ENGLISH, "document code");
        codigo.setLocalizedShortLabel(ENGLISH, "code");
        /**/
        nombre.setLocalizedLabel(ENGLISH, "document name");
        nombre.setLocalizedShortLabel(ENGLISH, "name");
        nombre.setLocalizedDefaultValueTag(ENGLISH, "If &lt;**attachment**&gt; is null, &lt;**code**&gt;; if not, &lt;**client file**&gt; of &lt;**attachment**&gt;");
//      nombre.setLocalizedDefaultValueTag(SPANISH, "Si <**adjunto**> es nulo, <**código**>; si no, <**archivo cliente**> de <**adjunto**>");
        /**/
        archivo.setLocalizedLabel(ENGLISH, "archive");
        archivo.setLocalizedTooltip(ENGLISH, "hyperlink to open file");
//      archivo.setLocalizedTooltip(SPANISH, "hipervínculo para abrir el archivo");
        /**/
        octetos.setLocalizedLabel(ENGLISH, "octets");
        /**/
        secuencia.setLocalizedLabel(ENGLISH, "document sequence");
        secuencia.setLocalizedShortLabel(ENGLISH, "sequence");
        /**/
        adjunto.setLocalizedLabel(ENGLISH, "attached file");
//      adjunto.setLocalizedLabel(SPANISH, "archivo adjunto");
        /**/
        descripcion.setLocalizedLabel(ENGLISH, "file description");
//      descripcion.setLocalizedLabel(SPANISH, "descripción del archivo");
        /**/
        ultimaCarga.setLocalizedLabel(ENGLISH, "last load");
        /**/
        estado.setLocalizedLabel(ENGLISH, "document status");
//      estado.setLocalizedLabel(SPANISH, "estado de documento");
        /**/
        fechaEstado.setLocalizedLabel(ENGLISH, "state's date");
        /**/
        usuarioActualizacion.setLocalizedLabel(ENGLISH, "document update user");
        usuarioActualizacion.setLocalizedShortLabel(ENGLISH, "user update");
        /**/
        observaciones.setLocalizedLabel(ENGLISH, "observations");
        // </editor-fold>
    }

    @Override
    protected void localizeExpressions() {
        super.localizeExpressions();
        // <editor-fold defaultstate="collapsed" desc="localization of Documento's expressions">
        modificable.setLocalizedDescription(ENGLISH, "modifiable");
        modificable.setLocalizedErrorMessage(ENGLISH, "The document is not Modifiable");
//      modificable.setLocalizedErrorMessage(SPANISH, "el documento no está Modificable");
        /**/
        verificable.setLocalizedDescription(ENGLISH, "verifiable");
        verificable.setLocalizedErrorMessage(ENGLISH, "the document is not Verifiable");
//      verificable.setLocalizedErrorMessage(SPANISH, "el documento no está Verificable");
        /**/
        verificado.setLocalizedDescription(ENGLISH, "verified");
        verificado.setLocalizedErrorMessage(ENGLISH, "the document is not Verified");
//      verificado.setLocalizedErrorMessage(SPANISH, "el documento no está Verificado");
        /**/
        rechazado.setLocalizedDescription(ENGLISH, "refused");
        rechazado.setLocalizedErrorMessage(ENGLISH, "the document is not Rejected");
//      rechazado.setLocalizedErrorMessage(SPANISH, "el documento no está Rechazado");
        // </editor-fold>
    }

    public class Cargar extends showcase.meta.entidad.documento.Documento.Cargar {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Cargar's attributes">
            setLocalizedLabel(ENGLISH, "carry");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Cargar's parameters">
            documento.setLocalizedLabel(ENGLISH, "document");
            /**/
            archivo.setLocalizedLabel(ENGLISH, "archive");
            archivo.setLocalizedTooltip(ENGLISH, "hyperlink to open file");
            // </editor-fold>
        }

        @Override
        protected void localizeExpressions() {
            super.localizeExpressions();
            // <editor-fold defaultstate="collapsed" desc="localization of Cargar's expressions">
            // </editor-fold>
        }

    }

    public class SolicitarVerificacion extends showcase.meta.entidad.documento.Documento.SolicitarVerificacion {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of SolicitarVerificacion's attributes">
            setLocalizedLabel(ENGLISH, "request verification");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of SolicitarVerificacion's parameters">
            documento.setLocalizedLabel(ENGLISH, "document");
            // </editor-fold>
        }

    }

    public class Aceptar extends showcase.meta.entidad.documento.Documento.Aceptar {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Aceptar's attributes">
            setLocalizedLabel(ENGLISH, "accept");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Aceptar's parameters">
            documento.setLocalizedLabel(ENGLISH, "document");
            /**/
            observaciones.setLocalizedLabel(ENGLISH, "observations");
            // </editor-fold>
        }

    }

    public class Rechazar extends showcase.meta.entidad.documento.Documento.Rechazar {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Rechazar's attributes">
            setLocalizedLabel(ENGLISH, "decline");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Rechazar's parameters">
            documento.setLocalizedLabel(ENGLISH, "document");
            /**/
            observaciones.setLocalizedLabel(ENGLISH, "observations");
            // </editor-fold>
        }

    }

}
