/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.pedido;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import java.lang.reflect.Field;
import showcase.meta.entidad.producto.Producto;
import showcase.meta.propiedad.*;

@EntityClass(independent = Kleenean.FALSE)
@EntityCodeGen(bws = Kleenean.TRUE, fws = Kleenean.TRUE)
@EntityDataGen(start = 1, step = 1, stop = 5000)
public class RenglonPedido extends AbstractPersistentEntity {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public RenglonPedido(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings(
            "pedido.estado"
        );
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultCollectionLabel("Renglones de Pedido");
        setDefaultCollectionShortLabel("Renglones");
        setDefaultLabel("renglón de pedido");
        setDefaultShortLabel("renglón");
    }

    @PrimaryKey
    public LongProperty id;

    @VersionProperty
    public LongProperty version;

    @ColumnField(nullable = Kleenean.FALSE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.TABLE_AND_DETAIL)
    public Pedido pedido;

    @ColumnField(nullable = Kleenean.FALSE)
    @ForeignKey(onDelete = OnDeleteAction.NONE, onUpdate = OnUpdateAction.NONE)
    @ManyToOne(view = MasterDetailView.NONE, quickAdding = QuickAddingFilter.MISSING)
    public Producto producto;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(create = Kleenean.TRUE, table = Kleenean.TRUE)
    @NumericDataGen(type = DataGenType.RANDOM, min = "1", max = "5")
    public IntegerProperty cantidad;

    @BigDecimalField(precision = 9)
    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, table = Kleenean.TRUE,
        defaultCondition = DefaultCondition.UNCONDITIONALLY, defaultCheckpoint = Checkpoint.USER_INTERFACE)
    @NumericDataGen(factor = "0")
    public PropiedadDinero precio;

    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(create = Kleenean.FALSE, update = Kleenean.FALSE, table = Kleenean.TRUE,
        defaultCondition = DefaultCondition.UNCONDITIONALLY, defaultCheckpoint = Checkpoint.USER_INTERFACE)
    @NumericDataGen(factor = "0")
    public PropiedadDinero total;

    @Override
    protected void settleProperties() {
        super.settleProperties();
        cantidad.setInitialValue(1);
        cantidad.setDefaultValue(1);
        cantidad.setMinValue(1);
        cantidad.setMaxValue(100);
        precio.setInitialValue(producto.precio);
        precio.setDefaultValue(producto.precio);
        total.setInitialValue(producto.precio.times(cantidad));
        total.setDefaultValue(producto.precio.times(cantidad));
        total.keepSumOn(pedido.monto);
    }

    protected Key key_pedido_producto;

    @Override
    protected void settleKeys() {
        super.settleKeys();
        key_pedido_producto.setUnique(false); // debería ser true, pero la data de prueba generada podría no cumplir la restricción de unicidad
        key_pedido_producto.newKeyField(pedido, producto);
    }

    @Override
    protected void settleLinks() {
        super.settleLinks();
    }

    protected Segment modificable;

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        modificable = pedido.estado.isEqualTo(pedido.estado.RECIBIDO);
        modificable.setDefaultErrorMessage("el pedido no está recibido");
    }

    @Override
    protected void settleFilters() {
        /**/
        setInsertFilter(pedido.recibido);
        setUpdateFilter(modificable);
        setDeleteFilter(modificable);
        /*
        PredicateX predicado = evaluate("PredicadoRenglonPedido");
        setInsertFilter(pedido.predicado);
        setUpdateFilter(modificable.and(predicado));
        setDeleteFilter(modificable.and(predicado));
        /**/
    }

}
