/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.pedido.i18n;

import adalid.core.ViewField;
import adalid.core.interfaces.Artifact;
import java.lang.reflect.Field;

/**
 * Pedido is a generated java file.
 * <ul>
 * <li>template: templates/meta/java/i18n/component.vm</li>
 * <li>template-author: Jorge Campins</li>
 * <li>file-encoding: UTF-8</li>
 * <li>file-preserve: false -> file will be replaced when regenerating the project</li>
 * </ul>
 *
 * @author ADALID (template by Jorge Campins)
 */
public class Pedido extends showcase.meta.entidad.pedido.Pedido {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public Pedido(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of Pedido's attributes">
        setLocalizedLabel(ENGLISH, "order");
        setLocalizedCollectionLabel(ENGLISH, "Orders");
        // </editor-fold>
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of Pedido's properties">
        numero.setLocalizedLabel(ENGLISH, "order number");
//      numero.setLocalizedLabel(SPANISH, "número del pedido");
        numero.setLocalizedShortLabel(ENGLISH, "number");
//      numero.setLocalizedShortLabel(SPANISH, "número");
        /**/
        cliente.setLocalizedLabel(ENGLISH, "customer");
        /**/
        fecha.setLocalizedLabel(ENGLISH, "date");
        /**/
        monto.setLocalizedLabel(ENGLISH, "amount");
        /**/
        formaPago.setLocalizedLabel(ENGLISH, "payment method");
//      formaPago.setLocalizedLabel(SPANISH, "forma de pago");
        /**/
        banco.setLocalizedLabel(ENGLISH, "bank");
        banco.setLocalizedDescription(ENGLISH, "bank to which the account or card corresponds; It is only necessary if the payment method is Check or Card");
//      banco.setLocalizedDescription(SPANISH, "banco al que corresponde la cuenta o la tarjeta; solo es necesario si la forma de pago es Cheque o Tarjeta");
        /**/
        cheque.setLocalizedLabel(ENGLISH, "check");
        cheque.setLocalizedDescription(ENGLISH, "check number used for payment; It is only necessary if the payment method is Check");
//      cheque.setLocalizedDescription(SPANISH, "número de cheque utilizado para el pago; solo es necesario si la forma de pago es Cheque");
        /**/
        tarjeta.setLocalizedLabel(ENGLISH, "card");
        tarjeta.setLocalizedDescription(ENGLISH, "credit card number used for payment; It is only necessary if the payment method is Card");
//      tarjeta.setLocalizedDescription(SPANISH, "número de tarjeta de crédito utilizada para el pago; solo es necesaria si la forma de pago es Tarjeta");
        /**/
        descuento.setLocalizedLabel(ENGLISH, "discount");
        /**/
        estado.setLocalizedLabel(ENGLISH, "order status");
//      estado.setLocalizedLabel(SPANISH, "estado del pedido");
        estado.setLocalizedShortLabel(ENGLISH, "state");
        /**/
        fechaHoraTransicion.setLocalizedLabel(ENGLISH, "last transition date/time");
//      fechaHoraTransicion.setLocalizedLabel(SPANISH, "fecha/hora última transición");
        fechaHoraTransicion.setLocalizedShortLabel(ENGLISH, "date/time transition");
//      fechaHoraTransicion.setLocalizedShortLabel(SPANISH, "fecha/hora transición");
        /**/
        usuarioTransicion.setLocalizedLabel(ENGLISH, "user last transition");
//      usuarioTransicion.setLocalizedLabel(SPANISH, "usuario última transición");
        usuarioTransicion.setLocalizedShortLabel(ENGLISH, "user transition");
//      usuarioTransicion.setLocalizedShortLabel(SPANISH, "usuario transición");
        /**/
        usuarioActualizacion.setLocalizedLabel(ENGLISH, "order update user");
        usuarioActualizacion.setLocalizedShortLabel(ENGLISH, "user update");
        // </editor-fold>
    }

    @Override
    protected void localizeCollections() {
        super.localizeCollections();
        renglones.setLocalizedLabel(ENGLISH, "order lines");
        renglones.setLocalizedShortLabel(ENGLISH, "lines");
        renglones.setLocalizedDescription(ENGLISH, "order line collection");
    }

    @Override
    protected void localizeTabs() {
        super.localizeTabs();
        // <editor-fold defaultstate="collapsed" desc="localization of Pedido's tabs">
        tab001.setLocalizedLabel(ENGLISH, "Order lines");
//      tab001.setLocalizedLabel(SPANISH, "Renglones del pedido");
        tab001.setLocalizedShortLabel(ENGLISH, "lines");
//      tab001.setLocalizedShortLabel(SPANISH, "renglones");
        /**/
        tab002.setLocalizedLabel(ENGLISH, "Details of payment");
//      tab002.setLocalizedLabel(SPANISH, "Datos del pago");
        tab002.setLocalizedShortLabel(ENGLISH, "pay");
//      tab002.setLocalizedShortLabel(SPANISH, "pago");
        // </editor-fold>
    }

    @Override
    protected void localizeViews() {
        super.localizeViews();
        // <editor-fold defaultstate="collapsed" desc="localization of Pedido's views">
        v1.setLocalizedLabel(ENGLISH, "Orders by Status and Approval V1");
//      v1.setLocalizedLabel(SPANISH, "Pedidos por Estado y Aprobación V1");
        ViewField vf0001 = v1.getField(estado.codigo);
        if (vf0001 != null) {
            vf0001.setLocalizedLabel(ENGLISH, "state");
//          vf0001.setLocalizedLabel(SPANISH, "estado");
        }
        ViewField vf0002 = v1.getField(cliente.aprobado);
        if (vf0002 != null) {
            vf0002.setLocalizedLabel(ENGLISH, "approved");
        }
        ViewField vf0003 = v1.getField(numero);
        if (vf0003 != null) {
            vf0003.setLocalizedLabel(ENGLISH, "number");
        }
        ViewField vf0004 = v1.getField(fecha);
        if (vf0004 != null) {
            vf0004.setLocalizedLabel(ENGLISH, "date");
        }
        ViewField vf0005 = v1.getField(fechaHoraTransicion);
        if (vf0005 != null) {
            vf0005.setLocalizedLabel(ENGLISH, "date time transition");
        }
        ViewField vf0006 = v1.getField(cliente.nombre);
        if (vf0006 != null) {
            vf0006.setLocalizedLabel(ENGLISH, "name");
        }
        ViewField vf0007 = v1.getField(cliente.codigo);
        if (vf0007 != null) {
            vf0007.setLocalizedLabel(ENGLISH, "code");
        }
        ViewField vf0008 = v1.getField(monto);
        if (vf0008 != null) {
            vf0008.setLocalizedLabel(ENGLISH, "amount");
        }
        /**/
        v2.setLocalizedLabel(ENGLISH, "Orders by Status and Approval V2");
//      v2.setLocalizedLabel(SPANISH, "Pedidos por Estado y Aprobación V2");
        ViewField vf0009 = v2.getField(estado.codigo);
        if (vf0009 != null) {
            vf0009.setLocalizedLabel(ENGLISH, "state");
//          vf0009.setLocalizedLabel(SPANISH, "estado");
        }
        ViewField vf0010 = v2.getField(cliente.aprobado);
        if (vf0010 != null) {
            vf0010.setLocalizedLabel(ENGLISH, "approved");
        }
        ViewField vf0011 = v2.getField(numero);
        if (vf0011 != null) {
            vf0011.setLocalizedLabel(ENGLISH, "number");
        }
        ViewField vf0012 = v2.getField(fecha);
        if (vf0012 != null) {
            vf0012.setLocalizedLabel(ENGLISH, "date");
        }
        ViewField vf0013 = v2.getField(cliente.nombre);
        if (vf0013 != null) {
            vf0013.setLocalizedLabel(ENGLISH, "name");
        }
        ViewField vf0014 = v2.getField(cliente.codigo);
        if (vf0014 != null) {
            vf0014.setLocalizedLabel(ENGLISH, "code");
        }
        ViewField vf0015 = v2.getField(monto);
        if (vf0015 != null) {
            vf0015.setLocalizedLabel(ENGLISH, "amount");
        }
        /**/
        v3.setLocalizedLabel(ENGLISH, "Orders by Status and Approval V3");
//      v3.setLocalizedLabel(SPANISH, "Pedidos por Estado y Aprobación V3");
        ViewField vf0016 = v3.getField(estado.codigo);
        if (vf0016 != null) {
            vf0016.setLocalizedLabel(ENGLISH, "state");
//          vf0016.setLocalizedLabel(SPANISH, "estado");
        }
        ViewField vf0017 = v3.getField(cliente.aprobado);
        if (vf0017 != null) {
            vf0017.setLocalizedLabel(ENGLISH, "approved");
        }
        ViewField vf0018 = v3.getField(numero);
        if (vf0018 != null) {
            vf0018.setLocalizedLabel(ENGLISH, "number");
        }
        ViewField vf0019 = v3.getField(fecha);
        if (vf0019 != null) {
            vf0019.setLocalizedLabel(ENGLISH, "date");
        }
        ViewField vf0020 = v3.getField(cliente.nombre);
        if (vf0020 != null) {
            vf0020.setLocalizedLabel(ENGLISH, "name");
        }
        ViewField vf0021 = v3.getField(monto);
        if (vf0021 != null) {
            vf0021.setLocalizedLabel(ENGLISH, "amount");
        }
        // </editor-fold>
    }

    @Override
    protected void localizeExpressions() {
        super.localizeExpressions();
        // <editor-fold defaultstate="collapsed" desc="localization of Pedido's expressions">
        pagoConEfectivo.setLocalizedCollectionLabel(ENGLISH, "all orders paid in cash");
//      pagoConEfectivo.setLocalizedCollectionLabel(SPANISH, "todos los pedidos pagados con efectivo");
        pagoConEfectivo.setLocalizedCollectionShortLabel(ENGLISH, "Orders paid in cash");
//      pagoConEfectivo.setLocalizedCollectionShortLabel(SPANISH, "Pedidos pagados con efectivo");
        pagoConEfectivo.setLocalizedDescription(ENGLISH, "the order was paid in cash");
//      pagoConEfectivo.setLocalizedDescription(SPANISH, "el pedido fue pagado con efectivo");
        pagoConEfectivo.setLocalizedErrorMessage(ENGLISH, "the payment method is not cash");
//      pagoConEfectivo.setLocalizedErrorMessage(SPANISH, "la forma de pago no es efectivo");
        /**/
        pagoConCheque.setLocalizedCollectionLabel(ENGLISH, "all orders paid by check");
//      pagoConCheque.setLocalizedCollectionLabel(SPANISH, "todos los pedidos pagados con cheque");
        pagoConCheque.setLocalizedCollectionShortLabel(ENGLISH, "Orders paid by check");
//      pagoConCheque.setLocalizedCollectionShortLabel(SPANISH, "Pedidos pagados con cheque");
        pagoConCheque.setLocalizedDescription(ENGLISH, "The order was paid by check");
//      pagoConCheque.setLocalizedDescription(SPANISH, "el pedido fue pagado con cheque");
        pagoConCheque.setLocalizedErrorMessage(ENGLISH, "the payment method is not check");
//      pagoConCheque.setLocalizedErrorMessage(SPANISH, "la forma de pago no es cheque");
        /**/
        pagoConTarjeta.setLocalizedCollectionLabel(ENGLISH, "all orders paid by credit or debit card");
//      pagoConTarjeta.setLocalizedCollectionLabel(SPANISH, "todos los pedidos pagados con tarjeta de crédito o débito");
        pagoConTarjeta.setLocalizedCollectionShortLabel(ENGLISH, "Orders paid by card");
//      pagoConTarjeta.setLocalizedCollectionShortLabel(SPANISH, "Pedidos pagados con tarjeta");
        pagoConTarjeta.setLocalizedDescription(ENGLISH, "The order was paid by credit or debit card");
//      pagoConTarjeta.setLocalizedDescription(SPANISH, "el pedido fue pagado con tarjeta de crédito o débito");
        pagoConTarjeta.setLocalizedErrorMessage(ENGLISH, "the payment method is not card");
//      pagoConTarjeta.setLocalizedErrorMessage(SPANISH, "la forma de pago no es tarjeta");
        /**/
        cancelable.setLocalizedLabel(ENGLISH, "cancelable");
        cancelable.setLocalizedDescription(ENGLISH, "the order is received, processed or charged");
        cancelable.setLocalizedErrorMessage(ENGLISH, "the order is not received, processed or charged");
//      cancelable.setLocalizedErrorMessage(SPANISH, "el pedido no está recibido, procesado o cobrado");
        /**/
        recibido.setLocalizedLabel(ENGLISH, "received");
        recibido.setLocalizedDescription(ENGLISH, "received");
        recibido.setLocalizedErrorMessage(ENGLISH, "the order is not received");
//      recibido.setLocalizedErrorMessage(SPANISH, "el pedido no está recibido");
        /**/
        procesado.setLocalizedLabel(ENGLISH, "processed");
        procesado.setLocalizedDescription(ENGLISH, "processed");
        procesado.setLocalizedErrorMessage(ENGLISH, "the order is not processed");
//      procesado.setLocalizedErrorMessage(SPANISH, "el pedido no está procesado");
        /**/
        cobrado.setLocalizedLabel(ENGLISH, "charged");
        cobrado.setLocalizedDescription(ENGLISH, "charged");
        cobrado.setLocalizedErrorMessage(ENGLISH, "the order is not charged");
//      cobrado.setLocalizedErrorMessage(SPANISH, "el pedido no está cobrado");
        /**/
        enviado.setLocalizedLabel(ENGLISH, "sent");
        enviado.setLocalizedDescription(ENGLISH, "sent");
        enviado.setLocalizedErrorMessage(ENGLISH, "the order is not shipped");
//      enviado.setLocalizedErrorMessage(SPANISH, "el pedido no está enviado");
        /**/
        cancelado.setLocalizedLabel(ENGLISH, "cancelled");
        cancelado.setLocalizedDescription(ENGLISH, "cancelled");
        cancelado.setLocalizedErrorMessage(ENGLISH, "the order is not canceled");
//      cancelado.setLocalizedErrorMessage(SPANISH, "el pedido no está cancelado");
        // </editor-fold>
    }

    public class Recibir extends showcase.meta.operacion.pedido.Recibir {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Recibir's attributes">
            setLocalizedLabel(ENGLISH, "receive");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Recibir's parameters">
            cliente.setLocalizedLabel(ENGLISH, "customer");
            /**/
            producto.setLocalizedLabel(ENGLISH, "product");
            /**/
            cantidad.setLocalizedLabel(ENGLISH, "amount");
            // </editor-fold>
        }

    }

    public class Procesar extends showcase.meta.operacion.pedido.Procesar {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Procesar's attributes">
            setLocalizedLabel(ENGLISH, "process");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Procesar's parameters">
            pedido.setLocalizedLabel(ENGLISH, "order");
            // </editor-fold>
        }

        @Override
        protected void localizeExpressions() {
            super.localizeExpressions();
            // <editor-fold defaultstate="collapsed" desc="localization of Procesar's expressions">
            check101.setLocalizedErrorMessage(ENGLISH, "the order has no lines");
//          check101.setLocalizedErrorMessage(SPANISH, "el pedido no tiene renglones");
            // </editor-fold>
        }

    }

    public class Cobrar extends showcase.meta.operacion.pedido.Cobrar {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Cobrar's attributes">
            setLocalizedLabel(ENGLISH, "charge");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Cobrar's parameters">
            pedido.setLocalizedLabel(ENGLISH, "order");
            /**/
            formaPago.setLocalizedLabel(ENGLISH, "payment method");
//          formaPago.setLocalizedLabel(SPANISH, "forma de pago");
            formaPago.setLocalizedAnchoredLabel(ENGLISH, "method");
//          formaPago.setLocalizedAnchoredLabel(SPANISH, "medio de pago");
            /**/
            banco.setLocalizedLabel(ENGLISH, "bank");
            banco.setLocalizedAnchoredLabel(ENGLISH, "bank");
            banco.setLocalizedDescription(ENGLISH, "bank to which the account or card corresponds; it is only necessary if the payment method is Check or Card");
            /**/
            cheque.setLocalizedLabel(ENGLISH, "check number");
            cheque.setLocalizedAnchoredLabel(ENGLISH, "check");
            cheque.setLocalizedDescription(ENGLISH, "check number used for payment; it is only necessary if the payment method is Check");
            /**/
            tarjeta.setLocalizedLabel(ENGLISH, "card number");
            tarjeta.setLocalizedAnchoredLabel(ENGLISH, "card");
            tarjeta.setLocalizedDescription(ENGLISH, "credit or debit card number used for payment; it is only necessary if the payment method is Card");
            // </editor-fold>
        }

        @Override
        protected void localizeExpressions() {
            super.localizeExpressions();
            // <editor-fold defaultstate="collapsed" desc="localization of Cobrar's expressions">
            pagoConEfectivo.setLocalizedDescription(ENGLISH, "payment with cash");
            pagoConEfectivo.setLocalizedErrorMessage(ENGLISH, "the payment method is not cash");
//          pagoConEfectivo.setLocalizedErrorMessage(SPANISH, "la forma de pago no es efectivo");
            /**/
            pagoConCheque.setLocalizedDescription(ENGLISH, "payment by check");
            pagoConCheque.setLocalizedErrorMessage(ENGLISH, "the payment method is not check");
//          pagoConCheque.setLocalizedErrorMessage(SPANISH, "la forma de pago no es cheque");
            /**/
            pagoConTarjeta.setLocalizedDescription(ENGLISH, "card payment");
            pagoConTarjeta.setLocalizedErrorMessage(ENGLISH, "the payment method is not card");
//          pagoConTarjeta.setLocalizedErrorMessage(SPANISH, "la forma de pago no es tarjeta");
            /**/
            check100.setLocalizedErrorMessage(ENGLISH, "If the payment is in cash then the bank cannot be specified");
//          check100.setLocalizedErrorMessage(SPANISH, "si el pago es en efectivo entonces no se puede especificar el banco");
            /**/
            check102.setLocalizedErrorMessage(ENGLISH, "If the payment is in cash then the check cannot be specified");
//          check102.setLocalizedErrorMessage(SPANISH, "si el pago es en efectivo entonces no se puede especificar el cheque");
            /**/
            check103.setLocalizedErrorMessage(ENGLISH, "If the payment is in cash then the card cannot be specified");
//          check103.setLocalizedErrorMessage(SPANISH, "si el pago es en efectivo entonces no se puede especificar la tarjeta");
            /**/
            check110.setLocalizedErrorMessage(ENGLISH, "If payment is by check then the bank must be specified");
//          check110.setLocalizedErrorMessage(SPANISH, "si el pago es con cheque entonces se tiene que especificar el banco");
            /**/
            check112.setLocalizedErrorMessage(ENGLISH, "If payment is by check then the check must be specified");
//          check112.setLocalizedErrorMessage(SPANISH, "si el pago es con cheque entonces se tiene que especificar el cheque");
            /**/
            check113.setLocalizedErrorMessage(ENGLISH, "If payment is by check then the card cannot be specified");
//          check113.setLocalizedErrorMessage(SPANISH, "si el pago es con cheque entonces no se puede especificar la tarjeta");
            /**/
            check120.setLocalizedErrorMessage(ENGLISH, "If the payment is by card then the bank must be specified");
//          check120.setLocalizedErrorMessage(SPANISH, "si el pago es con tarjeta entonces se tiene que especificar el banco");
            /**/
            check122.setLocalizedErrorMessage(ENGLISH, "If the payment is by card then the check cannot be specified");
//          check122.setLocalizedErrorMessage(SPANISH, "si el pago es con tarjeta entonces no se puede especificar el cheque");
            /**/
            check123.setLocalizedErrorMessage(ENGLISH, "If the payment is by card then the card must be specified");
//          check123.setLocalizedErrorMessage(SPANISH, "si el pago es con tarjeta entonces se tiene que especificar la tarjeta");
            // </editor-fold>
        }

    }

    public class Enviar extends showcase.meta.operacion.pedido.Enviar {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Enviar's attributes">
            setLocalizedLabel(ENGLISH, "send");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Enviar's parameters">
            pedido.setLocalizedLabel(ENGLISH, "order");
            /**/
            direccion.setLocalizedLabel(ENGLISH, "address");
//          direccion.setLocalizedLabel(SPANISH, "dirección");
            // </editor-fold>
        }

    }

    public class Cancelar extends showcase.meta.operacion.pedido.Cancelar {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of Cancelar's attributes">
            setLocalizedLabel(ENGLISH, "Cancel");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of Cancelar's parameters">
            pedido.setLocalizedLabel(ENGLISH, "order");
            // </editor-fold>
        }

    }

    public class EmitirInformeDinamico extends showcase.meta.operacion.pedido.EmitirInformeDinamico {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of EmitirInformeDinamico's attributes">
            setLocalizedLabel(ENGLISH, "issue dynamic report");
//          setLocalizedLabel(SPANISH, "emitir informe dinámico");
            setLocalizedShortLabel(ENGLISH, "dynamic report");
//          setLocalizedShortLabel(SPANISH, "informe dinámico");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of EmitirInformeDinamico's parameters">
            pedido.setLocalizedLabel(ENGLISH, "order");
            // </editor-fold>
        }

    }

    public class EmitirInformeParametrizado extends showcase.meta.operacion.pedido.EmitirInformeParametrizado {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of EmitirInformeParametrizado's attributes">
            setLocalizedLabel(ENGLISH, "issue parameterized report");
//          setLocalizedLabel(SPANISH, "emitir informe parametrizado");
            setLocalizedShortLabel(ENGLISH, "parameterized report");
//          setLocalizedShortLabel(SPANISH, "informe parametrizado");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of EmitirInformeParametrizado's parameters">
            pedido.setLocalizedLabel(ENGLISH, "order");
            // </editor-fold>
        }

    }

    public class EmitirInformePorEstadoAprobacionV1 extends showcase.meta.operacion.pedido.EmitirInformePorEstadoAprobacionV1 {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of EmitirInformePorEstadoAprobacionV1's attributes">
            setLocalizedLabel(ENGLISH, "issue report by status and approval V1");
//          setLocalizedLabel(SPANISH, "emitir informe por estado y aprobación V1");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of EmitirInformePorEstadoAprobacionV1's parameters">
            cliente.setLocalizedLabel(ENGLISH, "customer");
            /**/
            desdeFecha.setLocalizedLabel(ENGLISH, "since date");
            /**/
            hastaFecha.setLocalizedLabel(ENGLISH, "to date");
            /**/
            desdeMonto.setLocalizedLabel(ENGLISH, "from amount");
            /**/
            hastaMonto.setLocalizedLabel(ENGLISH, "up to amount");
            /**/
            estado.setLocalizedLabel(ENGLISH, "order status");
//          estado.setLocalizedLabel(SPANISH, "estado de pedido");
            // </editor-fold>
        }

    }

    public class EmitirInformePorEstadoAprobacionV2 extends showcase.meta.operacion.pedido.EmitirInformePorEstadoAprobacionV2 {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of EmitirInformePorEstadoAprobacionV2's attributes">
            setLocalizedLabel(ENGLISH, "issue report by status and approval V2");
//          setLocalizedLabel(SPANISH, "emitir informe por estado y aprobación V2");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of EmitirInformePorEstadoAprobacionV2's parameters">
            cliente.setLocalizedLabel(ENGLISH, "customer");
            /**/
            desdeFecha.setLocalizedLabel(ENGLISH, "since date");
            /**/
            hastaFecha.setLocalizedLabel(ENGLISH, "to date");
            /**/
            desdeMonto.setLocalizedLabel(ENGLISH, "from amount");
            /**/
            hastaMonto.setLocalizedLabel(ENGLISH, "up to amount");
            /**/
            estado.setLocalizedLabel(ENGLISH, "order status");
//          estado.setLocalizedLabel(SPANISH, "estado de pedido");
            // </editor-fold>
        }

    }

    public class EmitirInformePorEstadoAprobacionV3 extends showcase.meta.operacion.pedido.EmitirInformePorEstadoAprobacionV3 {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of EmitirInformePorEstadoAprobacionV3's attributes">
            setLocalizedLabel(ENGLISH, "issue report by status and approval V3");
//          setLocalizedLabel(SPANISH, "emitir informe por estado y aprobación V3");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of EmitirInformePorEstadoAprobacionV3's parameters">
            cliente.setLocalizedLabel(ENGLISH, "customer");
            /**/
            desdeFecha.setLocalizedLabel(ENGLISH, "since date");
            /**/
            hastaFecha.setLocalizedLabel(ENGLISH, "to date");
            /**/
            desdeMonto.setLocalizedLabel(ENGLISH, "from amount");
            /**/
            hastaMonto.setLocalizedLabel(ENGLISH, "up to amount");
            /**/
            estado.setLocalizedLabel(ENGLISH, "order status");
//          estado.setLocalizedLabel(SPANISH, "estado de pedido");
            // </editor-fold>
        }

    }

    public class ExportarArchivoPorEstadoAprobacion extends showcase.meta.operacion.pedido.ExportarArchivoPorEstadoAprobacion {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of ExportarArchivoPorEstadoAprobacion's attributes">
            setLocalizedLabel(ENGLISH, "export file by status and approval");
//          setLocalizedLabel(SPANISH, "exportar archivo por estado y aprobación");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of ExportarArchivoPorEstadoAprobacion's parameters">
            cliente.setLocalizedLabel(ENGLISH, "customer");
            /**/
            desdeFecha.setLocalizedLabel(ENGLISH, "since date");
            /**/
            hastaFecha.setLocalizedLabel(ENGLISH, "to date");
            /**/
            desdeMonto.setLocalizedLabel(ENGLISH, "from amount");
            /**/
            hastaMonto.setLocalizedLabel(ENGLISH, "up to amount");
            /**/
            estado.setLocalizedLabel(ENGLISH, "order status");
//          estado.setLocalizedLabel(SPANISH, "estado de pedido");
            // </editor-fold>
        }

    }

}
