/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.producto;

import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;
import showcase.meta.operacion.producto.*;
import showcase.meta.propiedad.*;

@EntityClass(resourceType = ResourceType.CONFIGURATION)
@EntityCodeGen(bws = Kleenean.TRUE, fws = Kleenean.TRUE)
@EntityDataGen(start = 1, step = 1, stop = 10)
@EntitySelectOperation(onload = SelectOnloadOption.EXECUTE)
@EntityTableView(rows = 5)
public class Producto extends PersistentEntityBase {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public Producto(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
//      super.addAllocationStrings("fee", "faa", "foo");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
    }

    @BusinessKey
    @CharacterDataGen(function = "util.string_codigo_entidad")
    public StringProperty codigo;

    @NameProperty
    @CharacterDataGen(function = "util.string_nombre_entidad")
    public StringProperty nombre;

    @DescriptionProperty
//  @CharacterDataGen(function = "util.string_descripcion_entidad")
    @StringField(richTextFormat = Kleenean.TRUE)
    public StringProperty descripcion;

    @ImageProperty(displayWidth = {144, 96, 72}, displayHeight = {192, 128, 96}, avatarShape = AvatarShape.RECTANGLE, avatarDefault = AvatarDefault.UNSEEN)
    @PropertyField(table = Kleenean.TRUE)
    public BinaryProperty imagen;

    @ColumnField(calculable = Kleenean.TRUE)
    @FileReference(types = MimeType.IMAGE, blobField = "imagen")
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.FALSE, report = Kleenean.FALSE)
    public StringProperty archivoImagen;

    @ColumnField()
    @EmbeddedDocument(sourceType = EmbeddedDocumentType.BOTH, style = EmbeddedDocumentStyle.POPUP)
    @PropertyField(create = Kleenean.TRUE, table = Kleenean.TRUE)
    public StringProperty documento;

    @BigDecimalField(precision = 9)
    @ColumnField(nullable = Kleenean.FALSE)
    @PropertyField(create = Kleenean.TRUE, update = Kleenean.TRUE, table = Kleenean.TRUE)
    @NumericDataGen(type = DataGenType.RANDOM, min = "10", max = "100")
    public PropiedadDinero precio;

    @Override
    protected void settleProperties() {
        super.settleProperties();
        /**/
        codigo.setDefaultShortLabel("código");
        /**/
        imagen.setDefaultLabel("imagen");
        imagen.setDefaultTooltip("foto del producto");
        /**/
        archivoImagen.setDefaultLabel("archivo imagen");
        archivoImagen.setDefaultTooltip("URL del archivo que contiene la imagen (foto) del producto");
        archivoImagen.setCalculableValueExpression(imagen.fileReferenceCalculableValueExpression());
        /**/
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        /*
        archivoImagen.setRenderingFilter(UNTRUTH, true);
        /**/
    }

    protected AdjuntarDocumento adjuntarDocumento;

    protected CargarArchivo cargarArchivo;

    protected CargarImagen cargarImagen;

}
