/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.producto.i18n;

import adalid.core.interfaces.Artifact;
import java.lang.reflect.Field;

/**
 * Producto is a generated java file.
 * <ul>
 * <li>template: templates/meta/java/i18n/component.vm</li>
 * <li>template-author: Jorge Campins</li>
 * <li>file-encoding: UTF-8</li>
 * <li>file-preserve: false -> file will be replaced when regenerating the project</li>
 * </ul>
 *
 * @author ADALID (template by Jorge Campins)
 */
public class Producto extends showcase.meta.entidad.producto.Producto {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public Producto(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of Producto's attributes">
        setLocalizedLabel(ENGLISH, "product");
        setLocalizedCollectionLabel(ENGLISH, "Products");
        // </editor-fold>
    }

    @Override
    protected void localizeProperties() {
        super.localizeProperties();
        // <editor-fold defaultstate="collapsed" desc="localization of Producto's properties">
        codigo.setLocalizedLabel(ENGLISH, "product code");
        codigo.setLocalizedShortLabel(ENGLISH, "code");
//      codigo.setLocalizedShortLabel(SPANISH, "código");
        /**/
        nombre.setLocalizedLabel(ENGLISH, "Name of product");
        nombre.setLocalizedShortLabel(ENGLISH, "name");
        /**/
        descripcion.setLocalizedLabel(ENGLISH, "product description");
        descripcion.setLocalizedShortLabel(ENGLISH, "description");
        /**/
        imagen.setLocalizedLabel(ENGLISH, "image");
        imagen.setLocalizedTooltip(ENGLISH, "product photo");
//      imagen.setLocalizedTooltip(SPANISH, "foto del producto");
        /**/
        archivoImagen.setLocalizedLabel(ENGLISH, "image file");
//      archivoImagen.setLocalizedLabel(SPANISH, "archivo imagen");
        archivoImagen.setLocalizedTooltip(ENGLISH, "URL of the file containing the image (photo) of the product");
//      archivoImagen.setLocalizedTooltip(SPANISH, "URL del archivo que contiene la imagen (foto) del producto");
        /**/
        documento.setLocalizedLabel(ENGLISH, "document");
        /**/
        precio.setLocalizedLabel(ENGLISH, "price");
        // </editor-fold>
    }

    public class AdjuntarDocumento extends showcase.meta.operacion.producto.AdjuntarDocumento {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of AdjuntarDocumento's attributes">
            setLocalizedLabel(ENGLISH, "add and attach document");
//          setLocalizedLabel(SPANISH, "agregar y adjuntar documento");
            setLocalizedShortLabel(ENGLISH, "Attach document");
//          setLocalizedShortLabel(SPANISH, "adjuntar documento");
            setLocalizedDescription(ENGLISH, "add and attach a document to the product");
//          setLocalizedDescription(SPANISH, "agrega y adjunta un documento al producto");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of AdjuntarDocumento's parameters">
            producto.setLocalizedLabel(ENGLISH, "product");
            /**/
            archivo.setLocalizedLabel(ENGLISH, "archive");
            /**/
            descripcion.setLocalizedLabel(ENGLISH, "description");
            // </editor-fold>
        }

    }

    public class CargarArchivo extends showcase.meta.operacion.producto.CargarArchivo {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of CargarArchivo's attributes">
            setLocalizedLabel(ENGLISH, "file upload");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of CargarArchivo's parameters">
            archivo.setLocalizedLabel(ENGLISH, "archive");
            /**/
            encabezado.setLocalizedLabel(ENGLISH, "header");
            /**/
            caracterDelimitador.setLocalizedLabel(ENGLISH, "delimiting character");
            /**/
            caracterComillas.setLocalizedLabel(ENGLISH, "quotes character");
            // </editor-fold>
        }

        @Override
        protected void localizeExpressions() {
            super.localizeExpressions();
            // <editor-fold defaultstate="collapsed" desc="localization of CargarArchivo's expressions">
            checkCaracterDelimitador.setLocalizedDescription(ENGLISH, "check delimiter character");
            checkCaracterDelimitador.setLocalizedErrorMessage(ENGLISH, "invalid delimiter character; only commas and semicolons are allowed");
//          checkCaracterDelimitador.setLocalizedErrorMessage(SPANISH, "carácter delimitador inválido; solo se permiten coma y punto y coma");
            /**/
            checkCaracterComillas.setLocalizedDescription(ENGLISH, "check character quotes");
            checkCaracterComillas.setLocalizedErrorMessage(ENGLISH, "invalid quote character; only single quotes and double quotes are allowed");
//          checkCaracterComillas.setLocalizedErrorMessage(SPANISH, "carácter comillas inválido; solo se permiten comillas simples y comillas dobles");
            // </editor-fold>
        }

    }

    public class CargarImagen extends showcase.meta.operacion.producto.CargarImagen {

        @Override
        protected void localizeAttributes() {
            super.localizeAttributes();
            // <editor-fold defaultstate="collapsed" desc="localization of CargarImagen's attributes">
            setLocalizedLabel(ENGLISH, "upload image");
            // </editor-fold>
        }

        @Override
        protected void localizeParameters() {
            super.localizeParameters();
            // <editor-fold defaultstate="collapsed" desc="localization of CargarImagen's parameters">
            producto.setLocalizedLabel(ENGLISH, "product");
            /**/
            imagen.setLocalizedLabel(ENGLISH, "image");
            imagen.setLocalizedTooltip(ENGLISH, "URL of the file containing the image (photo) of the product");
            // </editor-fold>
        }

    }

}
