/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.entidad.servicio;

import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.properties.*;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;

@EntityClass(resourceType = ResourceType.CONFIGURATION)
@EntityDataGen(start = 1, step = 1, stop = 10)
@EntitySelectOperation(onload = SelectOnloadOption.EXECUTE)
public class Servicio extends PersistentEntityBase {

    // <editor-fold defaultstate="collapsed" desc="class constructors">
    public Servicio(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
    // </editor-fold>

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
//      super.addAllocationStrings("fee", "faa", "foo");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
    }

    @BusinessKey
    @CharacterDataGen(function = "util.string_codigo_entidad")
    public StringProperty codigo;

    @NameProperty
    @CharacterDataGen(function = "util.string_nombre_entidad")
    public StringProperty nombre;

    @DescriptionProperty
//  @CharacterDataGen(function = "util.string_descripcion_entidad")
    public StringProperty descripcion;

}
