/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.operacion.cliente;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.parameters.*;
import showcase.meta.entidad.cliente.Cliente;
import showcase.meta.entidad.documento.DocumentoCliente;

@OperationClass(access = OperationAccess.RESTRICTED)
@ConstructionOperationClass(type = DocumentoCliente.class)
public class AdjuntarDocumento extends ProcessOperation {

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of AdjuntarDocumento's attributes">
        setLocalizedLabel(ENGLISH, "add and attach document");
        setLocalizedLabel(SPANISH, "agregar y adjuntar documento");
        setLocalizedShortLabel(ENGLISH, "Attach document");
        setLocalizedShortLabel(SPANISH, "adjuntar documento");
        setLocalizedDescription(ENGLISH, "add and attach a document to the client");
        setLocalizedDescription(SPANISH, "agrega y adjunta un documento al cliente");
        // </editor-fold>
    }

    @Override
    protected void localizeParameters() {
        super.localizeParameters();
        // <editor-fold defaultstate="collapsed" desc="localization of AdjuntarDocumento's parameters">
        cliente.setLocalizedLabel(ENGLISH, "customer");
        /**/
        archivo.setLocalizedLabel(ENGLISH, "archive");
        /**/
        descripcion.setLocalizedLabel(ENGLISH, "description");
        // </editor-fold>
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("agregar y adjuntar documento");
        setDefaultShortLabel("adjuntar documento");
        setDefaultDescription("agrega y adjunta un documento al cliente");
        // <editor-fold defaultstate="collapsed" desc="localization of AdjuntarDocumento's attributes">
        setLocalizedLabel(ENGLISH, "agregar y adjuntar documento");
        setLocalizedLabel(SPANISH, "agregar y adjuntar documento");
        setLocalizedShortLabel(ENGLISH, "adjuntar documento");
        setLocalizedShortLabel(SPANISH, "adjuntar documento");
        setLocalizedDescription(ENGLISH, "agrega y adjunta un documento al cliente");
        setLocalizedDescription(SPANISH, "agrega y adjunta un documento al cliente");
        // </editor-fold>
    }

    @InstanceReference
    protected Cliente cliente;

    @FileReference(fileLimit = 100, max = 0)
    @ParameterField(required = Kleenean.TRUE)
    protected StringParameter archivo;

    @ParameterField(required = Kleenean.FALSE)
    protected StringParameter descripcion;

    @Override
    protected void settleParameters() {
        super.settleParameters();
        // <editor-fold defaultstate="collapsed" desc="localization of AdjuntarDocumento's parameters">
        cliente.setLocalizedLabel(ENGLISH, "cliente");
        /**/
        archivo.setLocalizedLabel(ENGLISH, "archivo");
        /**/
        descripcion.setLocalizedLabel(ENGLISH, "descripcion");
        // </editor-fold>
    }

}
