/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.operacion.cliente;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.parameters.BigDecimalParameter;
import showcase.meta.entidad.cliente.Cliente;

@OperationClass(access = OperationAccess.RESTRICTED)
public class AprobarCredito extends ProcessOperation {

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of AprobarCredito's attributes">
        setLocalizedLabel(ENGLISH, "approve credit");
        // </editor-fold>
    }

    @Override
    protected void localizeParameters() {
        super.localizeParameters();
        // <editor-fold defaultstate="collapsed" desc="localization of AprobarCredito's parameters">
        cliente.setLocalizedLabel(ENGLISH, "customer");
        /**/
        limiteCredito.setLocalizedLabel(ENGLISH, "credit limit");
        limiteCredito.setLocalizedLabel(SPANISH, "límite de crédito");
        // </editor-fold>
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of AprobarCredito's attributes">
        setLocalizedLabel(ENGLISH, "aprobar credito");
        // </editor-fold>
    }

    @InstanceReference
    protected Cliente cliente;

    @ParameterField(linkedField = "limiteCredito")
    @BigDecimalField(precision = 16, scale = 2)
    protected BigDecimalParameter limiteCredito;

    @Override
    protected void settleParameters() {
        super.settleParameters();
        /**/
        cliente.aprobado.setCurrentValue(true);
        /**/
        limiteCredito.setDefaultLabel("límite de crédito");
        limiteCredito.setMaxValue(50000);
        /**/
        // <editor-fold defaultstate="collapsed" desc="localization of AprobarCredito's parameters">
        cliente.setLocalizedLabel(ENGLISH, "cliente");
        /**/
        limiteCredito.setLocalizedLabel(ENGLISH, "límite de crédito");
        limiteCredito.setLocalizedLabel(SPANISH, "límite de crédito");
        // </editor-fold>
    }

}
