/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.operacion.cliente;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.parameters.*;
import showcase.meta.entidad.cliente.Cliente;

@ProcessOperationClass(overloading = Kleenean.UNSPECIFIED, serviceable = Kleenean.TRUE)
@OperationClass(access = OperationAccess.RESTRICTED)
public class CargarImagen extends ProcessOperation {

    @Override
    protected void localizeAttributes() {
        super.localizeAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of CargarImagen's attributes">
        setLocalizedLabel(ENGLISH, "upload image");
        // </editor-fold>
    }

    @Override
    protected void localizeParameters() {
        super.localizeParameters();
        // <editor-fold defaultstate="collapsed" desc="localization of CargarImagen's parameters">
        cliente.setLocalizedLabel(ENGLISH, "customer");
        /**/
        imagen.setLocalizedLabel(ENGLISH, "image");
        imagen.setLocalizedTooltip(ENGLISH, "URL of the file that contains the image (photo or logo) of the client");
        // </editor-fold>
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        // <editor-fold defaultstate="collapsed" desc="localization of CargarImagen's attributes">
        setLocalizedLabel(ENGLISH, "cargar imagen");
        // </editor-fold>
    }

    @InstanceReference
    protected Cliente cliente;

    @FileReference
    @ParameterField(linkedField = "archivoImagen", required = Kleenean.TRUE)
    protected StringParameter imagen;

    @Override
    protected void settleParameters() {
        super.settleParameters();
        // <editor-fold defaultstate="collapsed" desc="localization of CargarImagen's parameters">
        cliente.setLocalizedLabel(ENGLISH, "cliente");
        /**/
        imagen.setLocalizedLabel(ENGLISH, "imagen");
        imagen.setLocalizedTooltip(ENGLISH, "URL del archivo que contiene la imagen (foto o logo) del cliente");
        // </editor-fold>
    }

}
