/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.operacion.pedido;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import showcase.meta.entidad.pedido.Pedido;

@ProcessOperationClass(overloading = Kleenean.UNSPECIFIED, serviceable = Kleenean.TRUE)
@OperationClass(access = OperationAccess.RESTRICTED, confirmation = Kleenean.TRUE, asynchronous = Kleenean.TRUE, shell = Kleenean.TRUE)
public class Cancelar extends ProcessOperation {

    @InstanceReference
    protected Pedido pedido;

    @Override
    protected void settleParameters() {
        super.settleParameters();
        pedido.estado.setCurrentValue(pedido.estado.CANCELADO);
        pedido.fechaHoraCancelado.setCurrentValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        pedido.fechaHoraTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        pedido.usuarioTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
    }

}
