/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.operacion.pedido;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.parameters.*;
import showcase.meta.entidad.configuracion.Banco;
import showcase.meta.entidad.configuracion.fija.FormaPago;
import showcase.meta.entidad.pedido.Pedido;

@ProcessOperationClass(overloading = Kleenean.UNSPECIFIED, serviceable = Kleenean.TRUE,
    deadline = "2m", priority = 2,
    newTaskNotification = "1m", notifySupervisor = true, notifyAssumption = true, notifyAbandonment = true, notifyCancellation = true, notifyCompletion = true,
    unassignedTaskNotification = "2m",
    unfinishedTaskNotification = "3m",
    unassignedTaskEscalation = "4m",
    unfinishedTaskEscalation = "5m",
    nextUnassignedTaskNotification = "1m",
    nextUnfinishedTaskNotification = "1m",
    nextUnassignedTaskEscalation = "2m",
    nextUnfinishedTaskEscalation = "2m"
)
@OperationClass(access = OperationAccess.RESTRICTED, confirmation = Kleenean.TRUE)
public class Cobrar extends ProcessOperation {

    @InstanceReference
    protected Pedido pedido;

    @ParameterField(linkedField = "formaPago", required = Kleenean.TRUE)
    public FormaPago formaPago;

//  @ParameterField(linkedField = "banco")
    @ParameterField(linkedField = "banco", anchor = "formaPago", anchorType = AnchorType.INLINE)
    @EntityReferenceSearch(searchType = SearchType.LIST, listStyle = ListStyle.NAME, displayMode = DisplayMode.WRITING)
    public Banco banco;

//  @ParameterField(linkedField = "cheque")
    @ParameterField(linkedField = "cheque", anchor = "banco", anchorType = AnchorType.INLINE)
    @StringField(maxLength = 20)
    protected StringParameter cheque;

//  @ParameterField(linkedField = "tarjeta")
    @ParameterField(linkedField = "tarjeta", anchor = "banco", anchorType = AnchorType.INLINE)
    @StringField(maxLength = 20)
    protected StringParameter tarjeta;

    @Override
    protected void settleParameters() {
        super.settleParameters();
        /**/
        pedido.estado.setCurrentValue(pedido.estado.COBRADO);
        pedido.fechaHoraCobrado.setCurrentValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        pedido.fechaHoraTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        pedido.usuarioTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
        /**/
        formaPago.setInitialValue(pedido.cliente.formaPago);
        banco.setInitialValue(pedido.cliente.banco);
        tarjeta.setInitialValue(pedido.cliente.tarjeta);
        /**/
        formaPago.setDefaultAnchoredLabel("medio de pago");
        banco.setDefaultAnchoredLabel("banco");
        cheque.setDefaultAnchoredLabel("cheque");
        tarjeta.setDefaultAnchoredLabel("tarjeta");
        /**/
    }

    protected BooleanExpression pagoConEfectivo, pagoConCheque, pagoConTarjeta;

    protected Check check100, check102, check103, check110, check112, check113, check120, check122, check123;

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        /**/
        pagoConEfectivo = formaPago.isEqualTo(formaPago.EFECTIVO);
        pagoConEfectivo.setDefaultErrorMessage("la forma de pago no es efectivo");
        /**/
        pagoConCheque = formaPago.isEqualTo(formaPago.CHEQUE);
        pagoConCheque.setDefaultErrorMessage("la forma de pago no es cheque");
        /**/
        pagoConTarjeta = formaPago.isEqualTo(formaPago.TARJETA);
        pagoConTarjeta.setDefaultErrorMessage("la forma de pago no es tarjeta");
        /**/
        check100 = pagoConEfectivo.implies(banco.isNull());
        check100.setDefaultErrorMessage("si el pago es en efectivo entonces no se puede especificar el banco");
        /**/
        check102 = pagoConEfectivo.implies(cheque.isNull());
        check102.setDefaultErrorMessage("si el pago es en efectivo entonces no se puede especificar el cheque");
        /**/
        check103 = pagoConEfectivo.implies(tarjeta.isNull());
        check103.setDefaultErrorMessage("si el pago es en efectivo entonces no se puede especificar la tarjeta");
        /**/
        check110 = pagoConCheque.implies(banco.isNotNull());
        check110.setDefaultErrorMessage("si el pago es con cheque entonces se tiene que especificar el banco");
        /**/
        check112 = pagoConCheque.implies(cheque.isNotNull());
        check112.setDefaultErrorMessage("si el pago es con cheque entonces se tiene que especificar el cheque");
        /**/
        check113 = pagoConCheque.implies(tarjeta.isNull());
        check113.setDefaultErrorMessage("si el pago es con cheque entonces no se puede especificar la tarjeta");
        /**/
        check120 = pagoConTarjeta.implies(banco.isNotNull());
        check120.setDefaultErrorMessage("si el pago es con tarjeta entonces se tiene que especificar el banco");
        /**/
        check122 = pagoConTarjeta.implies(cheque.isNull());
        check122.setDefaultErrorMessage("si el pago es con tarjeta entonces no se puede especificar el cheque");
        /**/
        check123 = pagoConTarjeta.implies(tarjeta.isNotNull());
        check123.setDefaultErrorMessage("si el pago es con tarjeta entonces se tiene que especificar la tarjeta");
        /**/
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        /**/
//      banco.setModifyingFilter(pagoConCheque.or(pagoConTarjeta));
        banco.setRenderingFilter(pagoConCheque.or(pagoConTarjeta));
        banco.setRequiringFilter(pagoConCheque.or(pagoConTarjeta));
        banco.setNullifyingFilter(pagoConEfectivo);
        /**/
//      cheque.setModifyingFilter(pagoConCheque);
        cheque.setRenderingFilter(pagoConCheque);
        cheque.setRequiringFilter(pagoConCheque);
        cheque.setNullifyingFilter(pagoConEfectivo.or(pagoConTarjeta));
        /**/
//      tarjeta.setModifyingFilter(pagoConTarjeta);
        tarjeta.setRenderingFilter(pagoConTarjeta);
        tarjeta.setRequiringFilter(pagoConTarjeta);
        tarjeta.setNullifyingFilter(pagoConEfectivo.or(pagoConCheque));
    }

}
