/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.operacion.pedido;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import showcase.meta.entidad.pedido.Pedido;

import static adalid.core.enums.ReportFileType.*;

@ReportOperationClass(type = ReportQueryType.DYNAMIC, fileTypes = {PDF, RTF, ODT, ODS, HTML, DOCX, PPTX, XLSX})
@OperationClass(access = OperationAccess.RESTRICTED)
public class EmitirInformeDinamico extends ReportOperation {

    @InstanceReference
    protected Pedido pedido;

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("emitir informe dinámico");
        setDefaultShortLabel("informe dinámico");
    }

    Check check101, check102;

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        check101 = pedido.estado.isNotEqualTo(pedido.estado.RECIBIDO);
        check101.setDefaultErrorMessage("no se permite emitir el informe dinámico si el estado del pedido es \"Recibido\"");
        check102 = pedido.monto.isGreaterThan(0);
        check102.setDefaultErrorMessage("no se permite emitir el informe dinámico si el monto del pedido es 0");
    }

}
