/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.operacion.pedido;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.interfaces.*;
import adalid.core.parameters.*;
import java.awt.Color;
import showcase.meta.entidad.cliente.Cliente;
import showcase.meta.entidad.configuracion.fija.EstadoPedido;

@ReportOperationClass(viewField = "v2",
    detailRowsLimit = 5000,
    summaryRowsLimit = 5000, chartRowsLimit = 1000,
    chartTypes = {
        ReportChartType.BAR,
        ReportChartType.AREA,
        ReportChartType.LINE,
        ReportChartType.AREA_BY_GROUP,
        ReportChartType.LINE_BY_GROUP,
        ReportChartType.PIE
    }
)
@OperationClass(access = OperationAccess.RESTRICTED)
public class EmitirInformePorEstadoAprobacionV2 extends ReportOperation {

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("emitir informe por estado y aprobación V2");
        clearChartColorList();
        addChartColor(Color.RED, Color.BLUE, Color.GREEN, Color.YELLOW, Color.MAGENTA, Color.ORANGE);
    }

    @ParameterField
    protected Cliente cliente;

    @ParameterField(linkedField = "fecha", operator = StandardRelationalOp.GTEQ)
    protected DateParameter desdeFecha;

    @ParameterField(linkedField = "fecha", operator = StandardRelationalOp.LTEQ)
    protected DateParameter hastaFecha;

    @ParameterField(linkedField = "monto", operator = StandardRelationalOp.GTEQ)
    protected BigDecimalParameter desdeMonto;

    @ParameterField(linkedField = "monto", operator = StandardRelationalOp.LTEQ)
    protected BigDecimalParameter hastaMonto;

    @ParameterField
    protected EstadoPedido estado;

    Check chack201, check301;

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        /**/
        chack201 = or(desdeFecha.isNull(), hastaFecha.isNull(), desdeFecha.isLessOrEqualTo(hastaFecha));
        chack201.setDefaultErrorMessage("desde fecha es mayor que hasta fecha");
        //
        check301 = or(desdeMonto.isNull(), hastaMonto.isNull(), desdeMonto.isLessOrEqualTo(hastaMonto));
        check301.setDefaultErrorMessage("desde monto es mayor que hasta monto");
        /**/
    }

}
