/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.operacion.pedido;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.parameters.*;
import showcase.meta.entidad.pedido.Pedido;

@ProcessOperationClass(overloading = Kleenean.UNSPECIFIED, serviceable = Kleenean.TRUE,
    deadline = "3m", priority = 3,
    newTaskNotification = "1m", notifySupervisor = true, notifyAssumption = true, notifyAbandonment = true, notifyCancellation = true, notifyCompletion = true,
    unassignedTaskNotification = "2m",
    unfinishedTaskNotification = "3m",
    unassignedTaskEscalation = "4m",
    unfinishedTaskEscalation = "5m",
    nextUnassignedTaskNotification = "1m",
    nextUnfinishedTaskNotification = "1m",
    nextUnassignedTaskEscalation = "2m",
    nextUnfinishedTaskEscalation = "2m"
)
@OperationClass(access = OperationAccess.RESTRICTED, confirmation = Kleenean.TRUE)
public class Enviar extends ProcessOperation {

    @InstanceReference
    protected Pedido pedido;

    @ParameterField(required = Kleenean.FALSE)
    protected StringParameter direccion;

    @Override
    protected void settleParameters() {
        super.settleParameters();
        pedido.estado.setCurrentValue(pedido.estado.ENVIADO);
        pedido.fechaHoraEnviado.setCurrentValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        pedido.fechaHoraTransicion.setCurrentValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        pedido.usuarioTransicion.setCurrentValue(SpecialEntityValue.CURRENT_USER);
        direccion.setDefaultLabel("dirección");
        direccion.setDefaultValue(pedido.cliente.direccionPrincipal.direccion);
        direccion.setInitialValue(pedido.cliente.direccionPrincipal.direccion);
    }

}
