/*
 * Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos
 * de la licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Este programa se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA;
 * vea la licencia "GNU General Public License" para obtener mas informacion.
 */
package showcase.meta.operacion.pedido;

import adalid.core.*;
import adalid.core.annotations.*;
import adalid.core.enums.*;
import adalid.core.parameters.*;
import showcase.meta.entidad.cliente.Cliente;
import showcase.meta.entidad.configuracion.fija.EstadoPedido;

@ExportOperationClass(viewField = "v1", detailRowsLimit = 5000, summaryRowsLimit = 5000)
@OperationClass(access = OperationAccess.RESTRICTED)
public class ExportarArchivoPorEstadoAprobacion extends ExportOperation {

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        setDefaultLabel("exportar archivo por estado y aprobación");
    }

    @ParameterField
    protected Cliente cliente;

    @ParameterField(linkedField = "fecha", operator = StandardRelationalOp.GTEQ)
    protected DateParameter desdeFecha;

    @ParameterField(linkedField = "fecha", operator = StandardRelationalOp.LTEQ)
    protected DateParameter hastaFecha;

    @ParameterField(linkedField = "monto", operator = StandardRelationalOp.GTEQ)
    protected BigDecimalParameter desdeMonto;

    @ParameterField(linkedField = "monto", operator = StandardRelationalOp.LTEQ)
    protected BigDecimalParameter hastaMonto;

    @ParameterField
    protected EstadoPedido estado;

}
